/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.IOException;
import java.util.Properties;
import lj.LJPrefs;

public class Run_Macro_3D
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private static String BC_inDirectory = LJPrefs.LJ_inpDirectory;
    private static String BC_outDirectory = LJPrefs.LJ_outDirectory;
    private static String code = "var dirin = '" + BC_inDirectory.replace("\\", "\\\\") + "';\n open(dirin+'\\\\'+filename);\n";
    private static int maxX = 1;
    private static int maxY = 1;
    private static int maxZ = 1;
    private static int stepX = 1;
    private static int stepY = 1;
    private static int stepZ = 1;
    private static int haloX = 0;
    private static int haloY = 0;
    private static int haloZ = 0;
    private static float globMaxIn = -3.4028235E38f;
    private static float globMinIn = Float.MAX_VALUE;
    private static int errCount = 0;

    public void run(String command) {
        code = "var dirin = '" + BC_inDirectory.replace("\\", "\\\\") + "';\n";
        if (LJPrefs.LJ_makeMap) {
            code = code + "var dircls = '" + LJPrefs.LJ_clsDirectory.replace("\\", "\\\\") + "';\n";
            code = code + "run('Apply Weka Classifier',' filepath=['+dirin+'\\\\'+filename+'] classifier=['+dircls+'] class=[2]');\n";
        }
        if (LJPrefs.LJ_makeMask) {
            if (!LJPrefs.LJ_makeMap) {
                code = code + "open(dirin+'\\\\'+filename);\n";
                code = code + "run('Apply Binary Threshold', 'threshold=" + LJPrefs.LJ_threshold * 100.0 + "  minimum='+globMin+' maximum='+globMax+' stack');\n";
            } else {
                code = code + "run('Apply Binary Threshold', 'threshold=" + LJPrefs.LJ_threshold * 100.0 + "  minimum=0 maximum=1 stack');\n";
            }
            code = code + "run('8-bit');\n";
            code = code + "run('Multiply...', 'value=255 stack');\n";
        }
        GenericDialog gd = new GenericDialog(command + " Run macro on 3D blocks");
        gd.addStringField("Input directory", BC_inDirectory, 100);
        gd.addStringField("Output directory", BC_outDirectory, 100);
        gd.addMessage("Macrocode (provides variables filename, globMin and globMax)");
        gd.addTextAreas(code, null, 10, 100);
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        BC_inDirectory = gd.getNextString();
        BC_outDirectory = gd.getNextString();
        code = gd.getNextText();
        LJPrefs.LJ_inpDirectory = BC_inDirectory;
        LJPrefs.LJ_outDirectory = BC_outDirectory;
        LJPrefs.savePreferences();
        Properties prefs = new Properties();
        try {
            prefs = LJPrefs.readProperties(BC_inDirectory + "\\properties.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        maxX = LJPrefs.getPref(prefs, "maxX", maxX);
        maxY = LJPrefs.getPref(prefs, "maxY", maxY);
        maxZ = LJPrefs.getPref(prefs, "maxZ", maxZ);
        stepX = LJPrefs.getPref(prefs, "stepX", stepX);
        stepY = LJPrefs.getPref(prefs, "stepY", stepY);
        stepZ = LJPrefs.getPref(prefs, "stepZ", stepZ);
        haloX = LJPrefs.getPref(prefs, "haloX", haloX);
        haloY = LJPrefs.getPref(prefs, "haloY", haloY);
        haloZ = LJPrefs.getPref(prefs, "haloZ", haloZ);
        globMinIn = (float)LJPrefs.getPref(prefs, "minVal", globMinIn);
        globMaxIn = (float)LJPrefs.getPref(prefs, "maxVal", globMaxIn);
        ImagePlus imgout = null;
        float globMax = -3.4028235E38f;
        float globMin = Float.MAX_VALUE;
        errCount = 0;
        for (int z = 0; z < maxZ; z += stepZ) {
            IJ.showProgress((int)z, (int)maxZ);
            for (int x = 0; x < maxX; x += stepX) {
                for (int y = 0; y < maxY; y += stepY) {
                    String filein = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, z, y, x);
                    String filename = String.format("%1$04d_%2$04d_%3$04d.tif", z, y, x);
                    IJ.log((String)filename);
                    String fullcode = " var filename = '" + filename + "';\n var globMin = " + globMinIn + ";\n var globMax = " + globMaxIn + ";\n" + code;
                    imgout = this.process(fullcode);
                    if (imgout == null) {
                        ++errCount;
                        IJ.log((String)("failed " + filein));
                    } else {
                        float[] minmax = LJPrefs.getMinMax(imgout);
                        float curMin = minmax[0];
                        float curMax = minmax[1];
                        if (curMax > globMax) {
                            globMax = curMax;
                        }
                        if (curMin < globMin) {
                            globMin = curMin;
                        }
                        String fileout = String.format("%1$s\\%2$s", BC_outDirectory, filename);
                        IJ.saveAsTiff((ImagePlus)imgout, (String)fileout);
                        IJ.log((String)("processed " + filein));
                        imgout.close();
                    }
                    imgout = null;
                }
            }
        }
        if (errCount > 0) {
            IJ.error((String)String.format("%1$s files failed", errCount));
        }
        IJ.showProgress((int)99, (int)100);
        prefs = new Properties();
        prefs.put("maxX", Double.toString(maxX));
        prefs.put("maxY", Double.toString(maxY));
        prefs.put("maxZ", Double.toString(maxZ));
        prefs.put("stepX", Double.toString(stepX));
        prefs.put("stepY", Double.toString(stepY));
        prefs.put("stepZ", Double.toString(stepZ));
        prefs.put("haloX", Double.toString(haloX));
        prefs.put("haloY", Double.toString(haloY));
        prefs.put("haloZ", Double.toString(haloZ));
        prefs.put("minVal", Double.toString(globMin));
        prefs.put("maxVal", Double.toString(globMax));
        try {
            LJPrefs.writeProperties(prefs, BC_outDirectory + "\\properties.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IJ.showProgress((int)100, (int)100);
    }

    private ImagePlus process(String code) {
        IJ.runMacro((String)code);
        ImagePlus imgout = WindowManager.getCurrentImage();
        return imgout;
    }
}

