/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import lj.LJPrefs;

public class Set_Calibration
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";

    public void run(String command) {
        float GlobalMax;
        float GlobalMin;
        IJ.showStatus((String)"Labeling Hyperstack");
        ImagePlus image = WindowManager.getCurrentImage();
        int tSlices = image.getNSlices();
        int tWidth = image.getWidth();
        int tHeight = image.getHeight();
        float[] minmax = new float[2];
        minmax = LJPrefs.getMinMax(image);
        if (image.getProcessor().getBitDepth() == 8) {
            GlobalMin = 0.0f;
            GlobalMax = 255.0f;
        } else if (image.getProcessor().getBitDepth() == 16) {
            GlobalMin = -32768.0f;
            GlobalMax = 32767.0f;
        } else if (image.getProcessor().getBitDepth() == 24) {
            GlobalMin = 0.0f;
            GlobalMax = 255.0f;
        } else {
            GlobalMin = Float.MIN_VALUE;
            GlobalMax = Float.MAX_VALUE;
        }
        Calibration cal = image.getCalibration();
        boolean isCalibrated = cal.calibrated();
        float[] calTable = cal.getCTable();
        float cTb = 0.0f;
        float cTm = 1.0f;
        float cTvs = 0.0f;
        float cTve = 1.0f;
        if (calTable != null) {
            cTvs = calTable[0];
            cTve = calTable[calTable.length - 1];
            cTm = (cTvs - cTve) / (GlobalMin - GlobalMax);
            cTb = cTvs - GlobalMin * cTm;
        }
        GenericDialog gd = new GenericDialog(command + " Set Image Calibration");
        if (tSlices > 1) {
            gd.addMessage("Dimensions: " + tWidth + "x" + tHeight + "x" + tSlices + " px");
            gd.addNumericField("Physical_width_of_voxel", cal.pixelWidth, 5);
            gd.addNumericField("Physical_height_of_voxel", cal.pixelHeight, 5);
            gd.addNumericField("Physical_depth_of_voxel", cal.pixelDepth, 5);
            gd.addStringField("Unit_of_voxel_width", cal.getXUnit(), 5);
            gd.addStringField("Unit_of_voxel_height", cal.getYUnit(), 5);
            gd.addStringField("Unit_of_voxel_depth", cal.getZUnit(), 5);
            gd.addNumericField("X_Origin in voxel", cal.xOrigin, 5);
            gd.addNumericField("Y_Origin in voxel", cal.yOrigin, 5);
            gd.addNumericField("Z_Origin in voxel", cal.zOrigin, 5);
        } else {
            gd.addMessage("Dimensions: " + tWidth + "x" + tHeight + " px");
            gd.addNumericField("Physical_width_of_voxel", cal.pixelWidth, 5);
            gd.addNumericField("Physical_height_of_voxel", cal.pixelHeight, 5);
            gd.addStringField("Unit_of_voxel_width", cal.getXUnit(), 5);
            gd.addStringField("Unit_of_voxel_height", cal.getYUnit(), 5);
            gd.addNumericField("X_Origin in voxel", cal.xOrigin, 5);
            gd.addNumericField("Y_Origin in voxel", cal.yOrigin, 5);
        }
        gd.addMessage("Values: [" + minmax[0] + "," + minmax[1] + "]");
        gd.addCheckbox("calibrated", cal.calibrated());
        gd.addNumericField("m (rescale slope)", (double)cTm, 5);
        gd.addNumericField("b (rescale intercept)", (double)cTb, 5);
        gd.addStringField("Unit_of_values", cal.getValueUnit(), 5);
        IJ.showStatus((String)"Waiting for User Input...");
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            IJ.showProgress((int)100, (int)100);
            return;
        }
        IJ.showStatus((String)"Setting Values");
        if (tSlices > 1) {
            cal.pixelWidth = gd.getNextNumber();
            cal.pixelHeight = gd.getNextNumber();
            cal.pixelDepth = gd.getNextNumber();
            cal.setXUnit(gd.getNextString());
            cal.setYUnit(gd.getNextString());
            cal.setZUnit(gd.getNextString());
            cal.xOrigin = gd.getNextNumber();
            cal.yOrigin = gd.getNextNumber();
            cal.zOrigin = gd.getNextNumber();
        } else {
            cal.pixelWidth = gd.getNextNumber();
            cal.pixelHeight = gd.getNextNumber();
            cal.setXUnit(gd.getNextString());
            cal.setYUnit(gd.getNextString());
            cal.xOrigin = gd.getNextNumber();
            cal.yOrigin = gd.getNextNumber();
        }
        isCalibrated = gd.getNextBoolean();
        if (isCalibrated) {
            cTm = (float)gd.getNextNumber();
            cTb = (float)gd.getNextNumber();
        }
        if (image.getProcessor().getBitDepth() == 8) {
            calTable = new float[256];
        } else if (image.getProcessor().getBitDepth() == 16) {
            calTable = new float[65536];
        } else if (image.getProcessor().getBitDepth() == 24) {
            calTable = new float[256];
        }
        for (int p = 0; p < calTable.length; ++p) {
            calTable[p] = (float)p * cTm + cTb;
        }
        cal.setCTable(calTable, gd.getNextString());
        IJ.showStatus((String)"Labeled Hyperstack.");
    }
}

