/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import lj.LJPrefs;

public class Stretch_Histogram
implements ExtendedPlugInFilter,
DialogListener {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private boolean previewing = false;
    private FloatProcessor previewEdm;
    private double globMin = 0.0;
    private double globMax = 1.0;
    private double Aorig = 0.0;
    private double Anew = 0.0;
    private double Borig = 1.0;
    private double Bnew = 1.0;
    private double m = 1.0;
    private double b = 0.0;
    private int flags = 16810029;

    public int setup(String arg, ImagePlus imp) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return 4096;
        }
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        if (imp == null) {
            return 4096;
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        float[] minmax = new float[2];
        minmax = LJPrefs.getMinMax(imp);
        this.globMin = minmax[0];
        this.globMax = minmax[1];
        GenericDialog gd = new GenericDialog(command + "...");
        gd.addNumericField("A_orig", this.globMin, 4);
        gd.addNumericField("A_new", 25000.0, 4);
        gd.addNumericField("B_orig", this.globMax, 4);
        gd.addNumericField("B_new", 37000.0, 4);
        gd.addPreviewCheckbox(pfr);
        gd.addDialogListener((DialogListener)this);
        this.previewing = true;
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        this.previewing = false;
        if (gd.wasCanceled()) {
            return 4096;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog((ImagePlus)imp, (int)this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        this.Aorig = gd.getNextNumber();
        this.Anew = gd.getNextNumber();
        this.Borig = gd.getNextNumber();
        this.Bnew = gd.getNextNumber();
        this.m = (this.Bnew - this.Anew) / (this.Borig - this.Aorig);
        this.b = this.Anew - this.m * this.Aorig;
        return !gd.invalidNumber();
    }

    public void run(ImageProcessor ip) {
        block12: {
            Rectangle roiRect;
            int width;
            block13: {
                block11: {
                    FloatProcessor floatIP;
                    width = ip.getWidth();
                    int height = ip.getHeight();
                    if (this.previewing && this.previewEdm != null) {
                        floatIP = this.previewEdm;
                    } else {
                        this.previewEdm = floatIP = new FloatProcessor(width, height, (float[])ip.convertToFloat().getPixels());
                    }
                    roiRect = ip.getRoi();
                    if (ip.getBitDepth() != 8) break block11;
                    byte[] bPixels = (byte[])ip.getPixels();
                    for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                        int x = roiRect.x;
                        int p = x + y * width;
                        while (x < roiRect.x + roiRect.width) {
                            double tsum = this.b + this.m * (double)bPixels[p];
                            if ((bPixels[p] & 0xFF) < 0) {
                                tsum = 0.0;
                            }
                            if ((bPixels[p] & 0xFF) > 255) {
                                tsum = 255.0;
                            }
                            bPixels[p] = (byte)tsum;
                            ++x;
                            ++p;
                        }
                    }
                    break block12;
                }
                if (ip.getBitDepth() != 16) break block13;
                short[] bPixels = (short[])ip.getPixels();
                for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                    int x = roiRect.x;
                    int p = x + y * width;
                    while (x < roiRect.x + roiRect.width) {
                        double tsum = this.b + this.m * (double)(bPixels[p] & 0xFFFF);
                        bPixels[p] = (short)(tsum - 65536.0);
                        ++x;
                        ++p;
                    }
                }
                break block12;
            }
            if (ip.getBitDepth() != 32) break block12;
            float[] bPixels = (float[])ip.getPixels();
            for (int y = roiRect.y; y < roiRect.y + roiRect.height; ++y) {
                int x = roiRect.x;
                int p = x + y * width;
                while (x < roiRect.x + roiRect.width) {
                    double tsum = this.b + this.m * (double)bPixels[p];
                    if (bPixels[p] < 0.0f) {
                        tsum = 0.0;
                    }
                    bPixels[p] = (float)tsum;
                    ++x;
                    ++p;
                }
            }
        }
    }

    public void setNPasses(int nPasses) {
    }

    void showAbout() {
        IJ.showMessage((String)"About Stretch Histogram...", (String)"...\n");
    }
}

