/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import lj.LJPrefs;

public class Subdivide_3D
implements PlugIn,
ActionListener {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private static String BC_outDirectory = LJPrefs.LJ_inpDirectory;
    private static int stepX = 250;
    private static int stepY = 250;
    private static int stepZ = 250;
    private static int haloX = 0;
    private static int haloY = 0;
    private static int haloZ = 0;
    private static int z_offset = 0;
    private double globMin = 0.0;
    private double globMax = 1.0;
    private static boolean saveProp = true;
    JButton filebtn;
    JTextField outdirtxt;
    GenericDialog gd;

    public void run(String command) {
        IJ.showStatus((String)"Creating blocks...");
        IJ.showProgress((int)0, (int)100);
        ImagePlus image = WindowManager.getCurrentImage();
        int[] properties = image.getDimensions();
        int maxX = properties[0];
        int maxY = properties[1];
        int maxZ = properties[3];
        float[] minmax = new float[2];
        minmax = LJPrefs.getMinMax(image);
        this.globMin = minmax[0];
        this.globMax = minmax[1];
        this.gd = new GenericDialog(command + " Subdivide image and save into directory");
        Font gdFont = this.gd.getFont();
        JLabel outdirlbl = new JLabel("Output directory  ", 4);
        outdirlbl.setFont(gdFont);
        this.outdirtxt = new JTextField(BC_outDirectory, 80);
        this.outdirtxt.setFont(gdFont);
        this.filebtn = new JButton("...");
        this.filebtn.addActionListener(this);
        this.gd.add((Component)outdirlbl, -1);
        this.gd.add((Component)this.outdirtxt, -1);
        this.gd.add((Component)this.filebtn, -1);
        this.gd.addMessage("     ");
        this.gd.addMessage("filename will be 'z'_'y'_'x'.tif");
        this.gd.addMessage("Block Properties:");
        this.gd.addNumericField("width", (double)stepX, 0);
        this.gd.addNumericField("height", (double)stepY, 0);
        this.gd.addNumericField("depth", (double)stepZ, 0);
        this.gd.addMessage("Halo Size:");
        this.gd.addNumericField("halo_width", (double)haloX, 0);
        this.gd.addNumericField("halo_height", (double)haloY, 0);
        this.gd.addNumericField("halo_depth", (double)haloZ, 0);
        this.gd.addMessage("Other Settings:");
        this.gd.addNumericField("z-offset", (double)z_offset, 0, 4, "(affects filename only)");
        this.gd.addCheckbox("save LungJ header", saveProp);
        IJ.showStatus((String)"Waiting for User Input...");
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            this.gd.addHelp(PLUGIN_HELP_URL);
        }
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            IJ.showStatus((String)"Plug-In aborted...");
            IJ.showProgress((int)100, (int)100);
            return;
        }
        IJ.showStatus((String)"Creating blocks...");
        IJ.showProgress((int)1, (int)100);
        BC_outDirectory = this.outdirtxt.getText();
        Recorder.recordOption((String)"directory", (String)BC_outDirectory);
        stepX = (int)this.gd.getNextNumber();
        stepY = (int)this.gd.getNextNumber();
        stepZ = (int)this.gd.getNextNumber();
        haloX = (int)this.gd.getNextNumber();
        haloY = (int)this.gd.getNextNumber();
        haloZ = (int)this.gd.getNextNumber();
        z_offset = (int)this.gd.getNextNumber();
        saveProp = this.gd.getNextBoolean();
        LJPrefs.LJ_inpDirectory = BC_outDirectory;
        LJPrefs.savePreferences();
        ImageProcessor ip = image.getProcessor();
        Calibration cal = image.getCalibration();
        int x1 = 0;
        int y1 = 0;
        int z1 = 0;
        int xs = stepX + 2 * haloX;
        int ys = stepY + 2 * haloY;
        int zs = stepZ + 2 * haloZ;
        int x2 = x1 + xs;
        int y2 = y1 + ys;
        int z2 = z1 + zs;
        for (int z = 0; z < maxZ; z += stepZ) {
            ip.setSliceNumber(z);
            IJ.showProgress((int)z, (int)maxZ);
            for (int y = 0; y < maxY; y += stepY) {
                for (int x = 0; x < maxX; x += stepX) {
                    xs = stepX + 2 * haloX;
                    ys = stepY + 2 * haloY;
                    zs = stepZ + 2 * haloZ;
                    x1 = x - haloX;
                    if (x1 < 0) {
                        x1 = 0;
                        xs -= haloX;
                    }
                    if ((y1 = y - haloY) < 0) {
                        y1 = 0;
                        ys -= haloY;
                    }
                    if ((z1 = z - haloZ) < 0) {
                        z1 = 0;
                        zs -= haloZ;
                    }
                    if ((x2 = x1 + xs) > maxX) {
                        xs = maxX - x1;
                    }
                    if ((y2 = y1 + ys) > maxY) {
                        ys = maxY - y1;
                    }
                    if ((z2 = z1 + zs) > maxZ) {
                        zs = maxZ - z1;
                    }
                    Roi tempRoi = new Roi(x1, y1, xs, ys);
                    image.setRoi(tempRoi);
                    ip.setRoi(tempRoi);
                    ImagePlus imgblock = new Duplicator().run(image, z1 + 1, z1 + zs);
                    Calibration tempcal = cal;
                    tempcal.xOrigin = -1 * x1;
                    tempcal.yOrigin = -1 * y1;
                    tempcal.zOrigin = -1 * z1;
                    imgblock.setCalibration(tempcal);
                    String fileout = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_outDirectory, z + z_offset, y, x);
                    IJ.saveAsTiff((ImagePlus)imgblock, (String)fileout);
                    IJ.showStatus((String)"Creating blocks...");
                    IJ.showProgress((int)(y + maxY * x + maxY * maxX * z), (int)(maxY * maxX * maxZ));
                    IJ.log((String)("saved " + fileout));
                    imgblock = null;
                }
            }
        }
        if (saveProp) {
            Properties prefs = new Properties();
            prefs.put("maxX", Double.toString(maxX));
            prefs.put("maxY", Double.toString(maxY));
            prefs.put("maxZ", Double.toString(maxZ + z_offset));
            prefs.put("stepX", Double.toString(stepX));
            prefs.put("stepY", Double.toString(stepY));
            prefs.put("stepZ", Double.toString(stepZ));
            prefs.put("haloX", Double.toString(haloX));
            prefs.put("haloY", Double.toString(haloY));
            prefs.put("haloZ", Double.toString(haloZ));
            prefs.put("minVal", Double.toString(this.globMin));
            prefs.put("maxVal", Double.toString(this.globMax));
            try {
                LJPrefs.writeProperties(prefs, BC_outDirectory + "\\properties.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        IJ.showStatus((String)"Blocks have been saved!");
        IJ.showProgress((int)100, (int)100);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.filebtn) {
            JFileChooser chooser = new JFileChooser(LJPrefs.LJ_clsDirectory);
            chooser.setFileSelectionMode(1);
            chooser.setSelectedFile(new File(BC_outDirectory));
            int returnVal = chooser.showDialog((Component)this.gd, "Choose Output");
            if (returnVal == 0) {
                this.outdirtxt.setText(chooser.getSelectedFile().getPath());
            }
        }
    }
}

