/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import lj.LJPrefs;

public class Test_WEKA_Filter
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    boolean doSave = true;
    boolean doShades = false;
    boolean doEnhance = true;
    int membranesize = 20;

    public void run(String arg) {
        String[] labels = new String[]{"Gaussian blur", "Sobel", "Hessian", "Difference of gaussians", "Membrane projections", "Variance", "Mean", "Minimum", "Maximum", "Median", "Anisotropic diffusion", "Bilateral", "(Lipschitz)", "Kuwahara", "(Gabor)", "Derivatives", "Laplacian", "Structure", "Entropy", "Neighbors"};
        boolean[] defaultValues = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, true, true, true, true, true};
        GenericDialog gd = new GenericDialog("WEKA Test Settings...");
        gd.addStringField("Output Directory", LJPrefs.LJ_srcDirectory, 100);
        gd.addCheckbox("save images", true);
        gd.addCheckbox("enhance contrast", true);
        gd.addCheckbox("apply 6 shades", false);
        gd.addCheckboxGroup(10, 2, labels, defaultValues);
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String outputdirectory = gd.getNextString().replace("\\", "\\\\");
        this.doSave = gd.getNextBoolean();
        this.doEnhance = gd.getNextBoolean();
        this.doShades = gd.getNextBoolean();
        String macro = "";
        macro = macro + "var outdir = '" + outputdirectory.replace("\\", "\\\\") + "'; //name of directory and file-prefix to save results to\n";
        macro = macro + "rename('original');\n\n";
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****GAUSSIAN BLUR****/\n";
            macro = macro + this.GaussMacro(1);
            macro = macro + this.GaussMacro(2);
            macro = macro + this.GaussMacro(4);
            macro = macro + this.GaussMacro(8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****SOBEL****/\n";
            macro = macro + this.SobelMacro(0);
            macro = macro + this.SobelMacro(1);
            macro = macro + this.SobelMacro(2);
            macro = macro + this.SobelMacro(4);
            macro = macro + this.SobelMacro(8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****HESSIAN****/\n";
            macro = macro + this.HesseMacro(1);
            macro = macro + this.HesseMacro(2);
            macro = macro + this.HesseMacro(4);
            macro = macro + this.HesseMacro(8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****DIFFERENCE OF GAUSSIAN****/\n";
            macro = macro + this.GaussDifMacro(2, 1);
            macro = macro + this.GaussDifMacro(4, 2);
            macro = macro + this.GaussDifMacro(4, 1);
            macro = macro + this.GaussDifMacro(8, 1);
            macro = macro + this.GaussDifMacro(8, 2);
            macro = macro + this.GaussDifMacro(8, 4);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****MEMBRANE PROJECTIONS****/\n";
            macro = macro + this.MembraneMacro(1, 15);
            macro = macro + this.MembraneMacro(5, 15);
            macro = macro + this.MembraneMacro(9, 15);
            macro = macro + this.MembraneMacro(13, 15);
            macro = macro + this.MembraneMacro(1, 19);
            macro = macro + this.MembraneMacro(5, 19);
            macro = macro + this.MembraneMacro(9, 19);
            macro = macro + this.MembraneMacro(13, 19);
            macro = macro + this.MembraneMacro(1, 27);
            macro = macro + this.MembraneMacro(5, 27);
            macro = macro + this.MembraneMacro(9, 27);
            macro = macro + this.MembraneMacro(13, 27);
            macro = macro + this.MembraneMacro(1, 43);
            macro = macro + this.MembraneMacro(5, 43);
            macro = macro + this.MembraneMacro(9, 43);
            macro = macro + this.MembraneMacro(13, 43);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****VARIANCE****/\n";
            macro = macro + this.VarianceMacro(1);
            macro = macro + this.VarianceMacro(2);
            macro = macro + this.VarianceMacro(4);
            macro = macro + this.VarianceMacro(8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****MEAN****/\n";
            macro = macro + this.MeanMacro(1);
            macro = macro + this.MeanMacro(2);
            macro = macro + this.MeanMacro(4);
            macro = macro + this.MeanMacro(8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****MINIMUM****/\n";
            macro = macro + this.MinimumMacro(1);
            macro = macro + this.MinimumMacro(2);
            macro = macro + this.MinimumMacro(4);
            macro = macro + this.MinimumMacro(8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****MAXIMUM****/\n";
            macro = macro + this.MaximumMacro(1);
            macro = macro + this.MaximumMacro(2);
            macro = macro + this.MaximumMacro(4);
            macro = macro + this.MaximumMacro(8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****MEDIAN****/\n";
            macro = macro + this.MedianMacro(1);
            macro = macro + this.MedianMacro(2);
            macro = macro + this.MedianMacro(4);
            macro = macro + this.MedianMacro(8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****ANISOTROPIC DIFFUSION****/\n";
            macro = macro + this.AnisotropicDiffusionMacro(20, 1, 0.1, 0.9, 20, this.membranesize);
            macro = macro + this.AnisotropicDiffusionMacro(20, 1, 0.35, 0.9, 20, this.membranesize);
            macro = macro + this.AnisotropicDiffusionMacro(20, 2, 0.1, 0.9, 20, this.membranesize);
            macro = macro + this.AnisotropicDiffusionMacro(20, 2, 0.35, 0.9, 20, this.membranesize);
            macro = macro + this.AnisotropicDiffusionMacro(20, 4, 0.1, 0.9, 20, this.membranesize);
            macro = macro + this.AnisotropicDiffusionMacro(20, 4, 0.35, 0.9, 20, this.membranesize);
            macro = macro + this.AnisotropicDiffusionMacro(20, 8, 0.1, 0.9, 20, this.membranesize);
            macro = macro + this.AnisotropicDiffusionMacro(20, 8, 0.35, 0.9, 20, this.membranesize);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****BILATERAL****/\n";
            macro = macro + this.Bilateral(5, 50);
            macro = macro + this.Bilateral(5, 100);
            macro = macro + this.Bilateral(10, 50);
            macro = macro + this.Bilateral(10, 100);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****LIPSCHITZ****/\n";
            macro = macro + "\n/*(currently broken)*/\n";
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****KUWAHARA****/\n";
            macro = macro + this.KuwaharaMacro("Variance");
            macro = macro + this.KuwaharaMacro("Variance / Mean");
            macro = macro + this.KuwaharaMacro("Variance / Mean^2");
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****GABOR****/\n";
            macro = macro + "\n/*(currently broken)*/\n";
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****DERIVATIVES****/\n";
            macro = macro + this.Derivatives(2, 2, 0, 1);
            macro = macro + this.Derivatives(3, 3, 0, 1);
            macro = macro + this.Derivatives(4, 4, 0, 1);
            macro = macro + this.Derivatives(5, 5, 0, 1);
            macro = macro + this.Derivatives(2, 2, 0, 2);
            macro = macro + this.Derivatives(3, 3, 0, 2);
            macro = macro + this.Derivatives(4, 4, 0, 2);
            macro = macro + this.Derivatives(5, 5, 0, 2);
            macro = macro + this.Derivatives(2, 2, 0, 4);
            macro = macro + this.Derivatives(3, 3, 0, 4);
            macro = macro + this.Derivatives(4, 4, 0, 4);
            macro = macro + this.Derivatives(5, 5, 0, 4);
            macro = macro + this.Derivatives(2, 2, 0, 8);
            macro = macro + this.Derivatives(3, 3, 0, 8);
            macro = macro + this.Derivatives(4, 4, 0, 8);
            macro = macro + this.Derivatives(5, 5, 0, 8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****LAPLACIAN****/\n";
            macro = macro + this.LaplaceMacro(1);
            macro = macro + this.LaplaceMacro(2);
            macro = macro + this.LaplaceMacro(4);
            macro = macro + this.LaplaceMacro(8);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****STRUCTURE****/\n";
            macro = macro + this.Structure(1, 1);
            macro = macro + this.Structure(2, 1);
            macro = macro + this.Structure(4, 1);
            macro = macro + this.Structure(8, 1);
            macro = macro + this.Structure(1, 3);
            macro = macro + this.Structure(2, 3);
            macro = macro + this.Structure(4, 3);
            macro = macro + this.Structure(8, 3);
        }
        if (gd.getNextBoolean()) {
            macro = macro + "\n/****ENTROPY****/\n";
            macro = macro + this.EntropyMacro(1, 32);
            macro = macro + this.EntropyMacro(2, 32);
            macro = macro + this.EntropyMacro(4, 32);
            macro = macro + this.EntropyMacro(8, 32);
            macro = macro + this.EntropyMacro(1, 64);
            macro = macro + this.EntropyMacro(2, 64);
            macro = macro + this.EntropyMacro(4, 64);
            macro = macro + this.EntropyMacro(8, 64);
            macro = macro + this.EntropyMacro(1, 128);
            macro = macro + this.EntropyMacro(2, 128);
            macro = macro + this.EntropyMacro(4, 128);
            macro = macro + this.EntropyMacro(8, 128);
            macro = macro + this.EntropyMacro(1, 256);
            macro = macro + this.EntropyMacro(2, 256);
            macro = macro + this.EntropyMacro(4, 256);
            macro = macro + this.EntropyMacro(8, 256);
        }
        macro = macro + "\n/****NEIGHBORS****/\n";
        if (gd.getNextBoolean()) {
            macro = macro + this.NeighborMacro(1, 8);
        }
        IJ.log((String)macro);
        IJ.runMacro((String)macro);
    }

    private String LipschitzMacro(int slope, boolean topdown, boolean tophat) {
        String options = "";
        if (topdown) {
            options = options + " topdown";
        }
        if (topdown) {
            options = options + " tophat";
        }
        String macro = "/***LIPSCHITZ " + slope + options + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Lipschitz', 'slope=" + slope + options + " stack');\n";
        String fname = "lipschitz_";
        if (topdown) {
            fname = fname + "down";
        }
        if (topdown) {
            fname = fname + "tophat";
        }
        macro = macro + this.FinalMacro(fname + "_" + slope);
        macro = macro + "rename('Lipschitz " + slope + ", " + options + "');\n";
        return macro;
    }

    private String GaborMacro(int sigma, int gamma, int psi, int frequency, int nangles) {
        String macro = "/***GABOR FILTER " + sigma + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Gabor duplicate');\n";
        macro = macro + "selectWindow('Gabor');\n";
        macro = macro + "run('Gabor', 'sigma=" + sigma + " gamma=" + gamma + " psi=" + psi + " frequency=" + frequency + " nangles=" + nangles + "');\n";
        macro = macro + this.FinalMacro("gabor" + sigma);
        macro = macro + "rename('Gabor " + sigma + "');\n";
        return macro;
    }

    private String EntropyMacro(int radius, int number) {
        String macro = "/***ENTROPY " + radius + ", " + number + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Entropy duplicate');\n";
        macro = macro + "run('32-bit');";
        macro = macro + "run('Entropy', 'radius=" + radius + " number=" + number + " stack');\n";
        macro = macro + this.FinalMacro("entropy_r" + radius + "_bins" + number);
        macro = macro + "rename('Entropy " + radius + ", " + number + "');\n";
        return macro;
    }

    private String KuwaharaMacro(String criterion) {
        String macro = "/***KUWAHARA " + criterion + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Kuwahara duplicate');\n";
        macro = macro + "selectWindow('Kuwahara');\n";
        macro = macro + "run('Linear Kuwahara', 'number_of_angles=30 line_length=11 criterion=[" + criterion + "] stack');\n";
        macro = macro + this.FinalMacro("kuwahara_" + criterion.replace(" / ", "by"));
        macro = macro + "rename('Kuwahara " + criterion + "');\n";
        return macro;
    }

    private String LaplaceMacro(int smoothing) {
        String macro = "/***LAPLACIAN " + smoothing + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('FeatureJ Laplacian', 'compute smoothing=" + smoothing + "');\n";
        macro = macro + "selectWindow('original Laplacian');\n";
        macro = macro + this.FinalMacro("laplace" + smoothing);
        macro = macro + "rename('Laplacian " + smoothing + "');\n";
        return macro;
    }

    private String SobelMacro(int sigma) {
        String macro = "/***SOBEL " + sigma + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Sobel duplicate');\n";
        macro = macro + "selectWindow('Sobel');\n";
        macro = macro + "run('Gaussian Blur 3D...', 'x=" + sigma + " y=" + sigma + " z=" + sigma + "');\n";
        macro = macro + "run('Find Edges');\n";
        macro = macro + this.FinalMacro("sobel" + sigma);
        macro = macro + "rename('Sobel " + sigma + "');\n";
        return macro;
    }

    private String GaussMacro(int sigma) {
        String macro = "/***GAUSSIAN BLUR " + sigma + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Gaussian duplicate');\n";
        macro = macro + "selectWindow('Gaussian');\n";
        macro = macro + "run('Gaussian Blur 3D...', 'x=" + sigma + " y=" + sigma + " z=" + sigma + "');\n";
        macro = macro + this.FinalMacro("gauss" + sigma);
        macro = macro + "rename('Gaussian Blur " + sigma + "');\n";
        return macro;
    }

    private String GaussDifMacro(int sigma1, int sigma2) {
        String macro = "/***DIFFERENCE OF GAUSSIANS " + sigma1 + "-" + sigma2 + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=GaussianDif1 duplicate');\n";
        macro = macro + "selectWindow('GaussianDif1');\n";
        macro = macro + "run('Gaussian Blur 3D...', 'x=" + sigma1 + " y=" + sigma1 + " z=" + sigma1 + "');\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=GaussianDif2 duplicate');\n";
        macro = macro + "selectWindow('GaussianDif2');\n";
        macro = macro + "run('Gaussian Blur 3D...', 'x=" + sigma2 + " y=" + sigma2 + " z=" + sigma2 + "');\n";
        macro = macro + "imageCalculator('Subtract', 'GaussianDif1','GaussianDif2');\n";
        macro = macro + this.FinalMacro("diffgauss" + sigma1 + "_" + sigma2);
        macro = macro + "rename('Difference of Gaussian Blur " + sigma1 + " - " + sigma2 + "');\n";
        macro = macro + "selectWindow('GaussianDif2');\n";
        macro = macro + "close();\n";
        return macro;
    }

    private String HesseMacro(int sigma) {
        String macro = "/***HESSIAN " + sigma + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('FeatureJ Derivatives', 'x-order=2 y-order=0 z-order=0 smoothing=" + sigma + "');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_a");
        macro = macro + "rename('Hessian a');\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('FeatureJ Derivatives', 'x-order=1 y-order=1 z-order=0 smoothing=" + sigma + "');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_b");
        macro = macro + "rename('Hessian b');\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('FeatureJ Derivatives', 'x-order=1 y-order=1 z-order=0 smoothing=" + sigma + "');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_c");
        macro = macro + "rename('Hessian c');\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('FeatureJ Derivatives', 'x-order=0 y-order=2 z-order=0 smoothing=" + sigma + "');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_d");
        macro = macro + "rename('Hessian d');\n";
        macro = macro + "imageCalculator('Add create', 'Hessian a','Hessian d');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_trace");
        macro = macro + "run('Divide...', 'value=2');\n";
        macro = macro + "rename('Hessian (a+d)/2');\n";
        macro = macro + "imageCalculator('Multiply create', 'Hessian a','Hessian a');\n";
        macro = macro + "rename('Hessian a^2');\n";
        macro = macro + "imageCalculator('Multiply create', 'Hessian b','Hessian c');\n";
        macro = macro + "rename('Hessian bc');\n";
        macro = macro + "imageCalculator('Multiply create', 'Hessian d','Hessian d');\n";
        macro = macro + "rename('Hessian d^2');\n";
        macro = macro + "imageCalculator('Multiply create', 'Hessian b','Hessian b');\n";
        macro = macro + "rename('Hessian b^2');\n";
        macro = macro + "imageCalculator('Multiply create', 'Hessian a','Hessian d');\n";
        macro = macro + "rename('Hessian ad');\n";
        macro = macro + "imageCalculator('Subtract create', 'Hessian ad','Hessian bc');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_determinant");
        macro = macro + "rename('Hessian Determinant " + sigma + "');\n";
        macro = macro + "imageCalculator('Add create', 'Hessian a^2','Hessian bc');\n";
        macro = macro + "rename('Hessian module');\n";
        macro = macro + "imageCalculator('Add', 'Hessian module','Hessian d^2');\n";
        macro = macro + "run('Square Root');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_module");
        macro = macro + "rename('Hessian module " + sigma + "');\n";
        macro = macro + "selectWindow('Hessian b^2');\n";
        macro = macro + "run('Multiply...', 'value=4');\n";
        macro = macro + "rename('Hessian 4b^2');\n";
        macro = macro + "imageCalculator('Subtract create', 'Hessian a','Hessian d');\n";
        macro = macro + "rename('Hessian (a-d)');\n";
        macro = macro + "imageCalculator('Multiply create', 'Hessian (a-d)','Hessian (a-d)');\n";
        macro = macro + "rename('Hessian (a-d)^2');\n";
        macro = macro + "imageCalculator('Add create', 'Hessian 4b^2','Hessian (a-d)^2');\n";
        macro = macro + "rename('Hessian 4b^2 + (a-d)^2');\n";
        macro = macro + "selectWindow('Hessian 4b^2');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian 4b^2 + (a-d)^2');\n";
        macro = macro + "run('Duplicate...', 'title=hessevdif duplicate');\n";
        macro = macro + "selectWindow('hessevdif');\n";
        macro = macro + "run('Divide...', 'value=2');\n";
        macro = macro + "run('Square Root');\n";
        macro = macro + "imageCalculator('Add create', 'Hessian (a+d)/2','hessevdif');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_eig_first");
        macro = macro + "rename('Hessian First Eigenvalue " + sigma + "');\n";
        macro = macro + "imageCalculator('Subtract create', 'Hessian (a+d)/2','hessevdif');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_eig_second");
        macro = macro + "rename('Hessian Second Eigenvalue " + sigma + "');\n";
        macro = macro + "selectWindow('hessevdif');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian 4b^2 + (a-d)^2');\n";
        macro = macro + "run('Duplicate...', 'title=orientation duplicate');\n";
        macro = macro + "run('Macro...', 'code=v=0.5*acos(v)');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_orientation");
        macro = macro + "rename('Hessian Orientation " + sigma + "');\n";
        macro = macro + "selectWindow('Hessian 4b^2 + (a-d)^2');\n";
        macro = macro + "rename('Hessian Square of Gamma-normalized square eigenvalue difference??? " + sigma + "');\n";
        macro = macro + "imageCalculator('Multiply create', 'Hessian Square of Gamma-normalized square eigenvalue difference??? " + sigma + "','Hessian (a-d)^2');\n";
        macro = macro + "rename('Hessian Gamma-normalized square eigenvalue difference??? " + sigma + "');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_gnsqeigdif");
        macro = macro + "selectWindow('Hessian Square of Gamma-normalized square eigenvalue difference??? " + sigma + "');\n";
        macro = macro + this.FinalMacro("hess" + sigma + "_gnsqeigdif_sq");
        macro = macro + "selectWindow('Hessian a^2');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian d^2');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian bc');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian ad');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian (a-d)');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian (a-d)^2');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian (a+d)/2');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian a');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian b');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian c');\n";
        macro = macro + "close();\n";
        macro = macro + "selectWindow('Hessian d');\n";
        macro = macro + "close();\n";
        return macro;
    }

    private String AnisotropicDiffusionMacro(int number, int smoothings, double a1, double a2, int dt, int edge) {
        String macro = "/***ANISOTROPIC DIFFUSION " + smoothings + ", " + a1 + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=temp duplicate');\n";
        macro = macro + "run('8-bit');";
        macro = macro + "run('Anisotropic Diffusion 2D', 'number=" + number + " smoothings=" + smoothings + " a1=" + a1 + " a2=" + a2 + " dt=" + dt + " edge=" + edge + "');";
        macro = macro + this.FinalMacro("anisodiffusion_" + smoothings + "_" + a1);
        macro = macro + "rename('Anisotropic Diffusion " + smoothings + ", " + a1 + "');\n";
        macro = macro + "selectWindow('temp');\n";
        macro = macro + "close();\n";
        return macro;
    }

    private String Bilateral(int spatial, int range) {
        String macro = "/***BILATERAL FILTER " + spatial + ", " + range + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=temp duplicate');\n";
        macro = macro + "run('8-bit');";
        macro = macro + "run('Bilateral Filter', 'spatial=" + spatial + " range=" + range + "');";
        macro = macro + this.FinalMacro("bilat" + spatial + "-" + range);
        macro = macro + "rename('Bilateral Filter " + spatial + ", " + range + "');\n";
        macro = macro + "selectWindow('temp');\n";
        macro = macro + "close();\n";
        return macro;
    }

    private String Derivatives(int dx, int dy, int dz, int sigma) {
        String macro = "/***DERIVATIVES dx" + dx + ", dy" + dy + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('FeatureJ Derivatives', 'x-order=" + dx + " y-order=" + dy + " z-order=" + dz + " smoothing=" + sigma + "');\n";
        macro = dx == 0 ? macro + this.FinalMacro("diff" + sigma + "_y" + dy) : (dy == 0 ? macro + this.FinalMacro("diff" + sigma + "_x" + dx) : (dx == 1 && dy == 1 ? macro + this.FinalMacro("diff" + sigma + "_xy") : (dx == 1 ? macro + this.FinalMacro("diff" + sigma + "_xy" + dy) : (dy == 1 ? macro + this.FinalMacro("diff" + sigma + "_x" + dx + "y") : macro + this.FinalMacro("diff" + sigma + "_x" + dx + "y" + dy)))));
        macro = macro + "rename('Derivative dx" + dx + ", dy" + dy + "');\n";
        return macro;
    }

    private String Structure(int smoothing, int integration) {
        String macro = "/***STRUCTURE " + smoothing + ", " + integration + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('FeatureJ Structure', 'largest smallest smoothing=" + smoothing + " integration=" + integration + "');\n";
        macro = macro + "selectWindow('original smallest structure eigenvalues');\n";
        macro = macro + this.FinalMacro("struct_eig_smallest_i" + integration + "_s" + smoothing);
        macro = macro + "rename('Structure eigenvalues " + smoothing + ", " + integration + " (smallest)');\n";
        macro = macro + "selectWindow('original largest structure eigenvalues');\n";
        macro = macro + this.FinalMacro("struct_eig_largest_i" + integration + "_s" + smoothing);
        macro = macro + "rename('Structure eigenvalues " + smoothing + ", " + integration + " (largest)');\n";
        return macro;
    }

    private String MembraneMacro(int membrane, int patchsize) {
        String macro = "/***MEMBRANE PROJECTION " + membrane + "," + patchsize + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Membrane Projections', 'membrane=" + membrane + " patch=" + patchsize + "');\n";
        macro = macro + "selectWindow('membrane stack');\n";
        macro = macro + "run('Duplicate...', 'title=mem0');\n";
        macro = macro + "selectWindow('mem0');\n";
        macro = macro + this.FinalMacro("membrane_" + membrane + "_" + patchsize + "_av");
        macro = macro + "rename('Membrane Projection average thickness=" + membrane + " kernelsize=" + patchsize + "');\n";
        macro = macro + "selectWindow('membrane stack');\n";
        macro = macro + "run('Next Slice [>]');\n";
        macro = macro + "run('Duplicate...', 'title=mem1');\n";
        macro = macro + "selectWindow('mem1');\n";
        macro = macro + this.FinalMacro("membrane_" + membrane + "_" + patchsize + "_max");
        macro = macro + "rename('Membrane Projection maximum thickness=" + membrane + " kernelsize=" + patchsize + "');\n";
        macro = macro + "selectWindow('membrane stack');\n";
        macro = macro + "run('Next Slice [>]');\n";
        macro = macro + "run('Duplicate...', 'title=mem2');\n";
        macro = macro + "selectWindow('mem2');\n";
        macro = macro + this.FinalMacro("membrane_" + membrane + "_" + patchsize + "_min");
        macro = macro + "rename('Membrane Projection minimum thickness=" + membrane + " kernelsize=" + patchsize + "');\n";
        macro = macro + "selectWindow('membrane stack');\n";
        macro = macro + "run('Next Slice [>]');\n";
        macro = macro + "run('Duplicate...', 'title=mem3');\n";
        macro = macro + "selectWindow('mem3');\n";
        macro = macro + this.FinalMacro("membrane_" + membrane + "_" + patchsize + "_sum");
        macro = macro + "rename('Membrane Projection sum thickness=" + membrane + " kernelsize=" + patchsize + "');\n";
        macro = macro + "selectWindow('membrane stack');\n";
        macro = macro + "run('Next Slice [>]');\n";
        macro = macro + "run('Duplicate...', 'title=mem4');\n";
        macro = macro + "selectWindow('mem4');\n";
        macro = macro + this.FinalMacro("membrane_" + membrane + "_" + patchsize + "_sd");
        macro = macro + "rename('Membrane Projection standard deviation thickness=" + membrane + " kernelsize=" + patchsize + "');\n";
        macro = macro + "selectWindow('membrane stack');\n";
        macro = macro + "run('Next Slice [>]');\n";
        macro = macro + "run('Duplicate...', 'title=mem5');\n";
        macro = macro + "selectWindow('mem5');\n";
        macro = macro + this.FinalMacro("membrane_" + membrane + "_" + patchsize + "_med");
        macro = macro + "rename('Membrane Projection median thickness=" + membrane + " kernelsize=" + patchsize + "');\n";
        macro = macro + "selectWindow('membrane stack');\n";
        macro = macro + "close();\n";
        return macro;
    }

    private String NeighborMacro(int minsig, int maxsig) {
        String macro = "/***NEIGHBORS " + minsig + " to " + maxsig + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Neighbors', 'minsigma=" + minsig + " maxsigma=" + maxsig + "');\n";
        int i = 1;
        for (int s = minsig; s <= maxsig; s *= 2) {
            int k = 0;
            while (k < 8) {
                macro = macro + "selectWindow('Neighbors');\n";
                macro = macro + "setSlice(" + i + ");\n";
                macro = macro + "run('Duplicate...', 'title=n" + s + "_" + k + "');\n";
                macro = macro + "selectWindow('n" + s + "_" + k + "');\n";
                macro = macro + this.FinalMacro("neighbors_" + s + "_" + k);
                macro = macro + "rename('Neighbors sigma=" + s + " shift=" + k + "');\n";
                ++k;
                ++i;
            }
        }
        macro = macro + "selectWindow('Neighbors');\n";
        macro = macro + "close();\n";
        return macro;
    }

    private String MinimumMacro(int radius) {
        String macro = "/***MINIMUM " + radius + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Minimum duplicate');\n";
        macro = macro + "selectWindow('Minimum');\n";
        macro = macro + "run('Minimum...', 'radius=" + radius + " stack');\n";
        macro = macro + this.FinalMacro("min" + radius);
        macro = macro + "rename('Minimum " + radius + "');\n";
        return macro;
    }

    private String MaximumMacro(int radius) {
        String macro = "/***MAXIMUM " + radius + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Maximum duplicate');\n";
        macro = macro + "selectWindow('Maximum');\n";
        macro = macro + "run('Maximum...', 'radius=" + radius + " stack');\n";
        macro = macro + this.FinalMacro("max" + radius);
        macro = macro + "rename('Maximum " + radius + "');\n";
        return macro;
    }

    private String VarianceMacro(int radius) {
        String macro = "/***VARIANCE " + radius + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Variance duplicate');\n";
        macro = macro + "selectWindow('Variance');\n";
        macro = macro + "run('Variance...', 'radius=" + radius + " stack');\n";
        macro = macro + this.FinalMacro("variance" + radius);
        macro = macro + "rename('Variance " + radius + "');\n";
        return macro;
    }

    private String MeanMacro(int radius) {
        String macro = "/***MEAN " + radius + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Mean duplicate');\n";
        macro = macro + "selectWindow('Mean');\n";
        macro = macro + "run('Mean...', 'radius=" + radius + " stack');\n";
        macro = macro + this.FinalMacro("mean" + radius);
        macro = macro + "rename('Mean " + radius + "');\n";
        return macro;
    }

    private String MedianMacro(int radius) {
        String macro = "/***MEDIAN " + radius + "***/\n";
        macro = macro + "selectWindow('original');\n";
        macro = macro + "run('Duplicate...', 'title=Median duplicate');\n";
        macro = macro + "selectWindow('Median');\n";
        macro = macro + "run('Median...', 'radius=" + radius + " stack');\n";
        macro = macro + this.FinalMacro("median" + radius);
        macro = macro + "rename('Median " + radius + "');\n";
        return macro;
    }

    private String FinalMacro(String filename) {
        String macro = "";
        if (this.doShades) {
            macro = macro + "run('6 shades');\n";
        }
        if (this.doEnhance) {
            macro = macro + "run('Enhance Contrast', 'saturated=0.35');\n";
        }
        if (this.doSave) {
            macro = macro + "saveAs('PNG', outdir+'" + filename + ".png');\n";
        }
        return macro;
    }
}

