/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import trainableSegmentation.FeatureStack;

public class Weka_Gabor
implements PlugIn {
    ImagePlus originalImage = null;
    int width = 0;
    int height = 0;

    public void run(String arg) {
        ImagePlus imp;
        if (arg.equals("about")) {
            return;
        }
        this.originalImage = imp = WindowManager.getCurrentImage();
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        if (imp == null) {
            return;
        }
        GenericDialog gd = new GenericDialog("Matrix Operation");
        gd.addNumericField("sigma", 1.0, 2);
        gd.addNumericField("gamma", 8.0, 2);
        gd.addNumericField("psi", 8.0, 2);
        gd.addNumericField("frequency", 8.0, 2);
        gd.addNumericField("nAngles", 8.0, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double sigma = gd.getNextNumber();
        double gamma = gd.getNextNumber();
        double psi = gd.getNextNumber();
        double frequency = gd.getNextNumber();
        int nAngles = (int)gd.getNextNumber();
        FeatureStack WekaFeature = new FeatureStack(imp);
        WekaFeature.addGabor(this.originalImage, sigma, gamma, psi, frequency, nAngles);
        WekaFeature.show();
        imp = WindowManager.getCurrentImage();
        imp.setTitle("Gabor");
    }
}

