/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import trainableSegmentation.FeatureStack;

public class Weka_Membrane_Projections
implements PlugIn {
    int nAngles = 30;
    int width = 0;
    int height = 0;
    ImagePlus originalImage = null;

    public void run(String arg) {
        ImagePlus imp;
        if (arg.equals("about")) {
            this.showAbout();
            return;
        }
        this.originalImage = imp = WindowManager.getCurrentImage();
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        if (imp == null) {
            return;
        }
        GenericDialog gd = new GenericDialog("Matrix Operation");
        gd.addNumericField("membrane size", 1.0, 2);
        gd.addNumericField("patch size", 19.0, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int membraneSize = (int)gd.getNextNumber();
        int patchSize = (int)gd.getNextNumber();
        FeatureStack WekaFeature = new FeatureStack(imp);
        WekaFeature.addMembraneFeatures(patchSize, membraneSize);
        WekaFeature.show();
        imp = WindowManager.getCurrentImage();
        imp.setTitle("membrane stack");
    }

    void showAbout() {
        IJ.showMessage((String)"Membrane Projections filter...", (String)"modified from Trainable WEKA segmentationn\n");
    }
}

