/*
 * Decompiled with CFR 0.152.
 */
package lj;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.Plot;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class LJPrefs {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String VERSION = "0.5.1";
    public static final String PLUGIN_JAVA_VERSION = "1.8.0_40";
    public static final String PLUGIN_IJ_VERSION = "1.51d";
    public static final String PLUGIN_TWS_VERSION = "2.3.0";
    public static final String IJ_VERSION = IJ.getVersion();
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    public static final String PLUGIN_DOWNLOAD_URL = "http://sites.imagej.net/LungJ";
    public static final String PLUGIN_PUBLICATION_URL = "http://dx.doi.org/10.5258/SOTON/401280";
    public static String separator = System.getProperty("file.separator");
    public static String LJ_dir = System.getProperty("user.dir") + separator + "plugins" + separator + "LungJ";
    public static boolean LJ_isNew = true;
    public static String LJ_srcDirectory = Prefs.get((String)"LJ.OTHER_DIR", (String)LJ_dir);
    public static String LJ_clsDirectory = Prefs.get((String)"LJ.CLASSIFIER_DIR", (String)LJ_dir);
    public static String LJ_clsFilename = "";
    public static String LJ_clsName = "";
    public static String LJ_inpDirectory = Prefs.get((String)"LJ.INPUT_DIR", (String)LJ_dir);
    public static String LJ_outDirectory = Prefs.get((String)"LJ.OUTPUT_DIR", (String)LJ_dir);
    public static boolean LJ_makeMap = Prefs.get((String)"LJ.MAKEMAP", (boolean)true);
    public static boolean LJ_makeMask = Prefs.get((String)"LJ.MAKEMASK", (boolean)true);
    public static double LJ_threshold = Prefs.get((String)"LJ.THRESHOLD", (double)0.67);
    public static Color LJ_bgColor = LJPrefs.getPref("LJ.BGCOLOR", new Color(0, 0, 0));
    public static Color LJ_Color1 = LJPrefs.getPref("LJ.COLOR1", new Color(255, 255, 255));
    public static Color LJ_Color2 = LJPrefs.getPref("LJ.COLOR2", new Color(0, 153, 153));
    public static Color LJ_Color3 = LJPrefs.getPref("LJ.COLOR3", new Color(255, 102, 102));
    public static Color LJ_Color4 = LJPrefs.getPref("LJ.COLOR4", new Color(0, 0, 204));
    public static Color LJ_Color5 = LJPrefs.getPref("LJ.COLOR5", new Color(204, 0, 0));
    public static Color[] LJ_Colors = new Color[]{LJ_bgColor, LJ_Color1, LJ_Color2, LJ_Color3, LJ_Color4};
    public static List<String> LJ_classifiers = new ArrayList<String>();

    public static void savePreferences() {
        Prefs.set((String)"LJ.VERSION", (String)VERSION);
        Prefs.set((String)"LJ.CLASSIFIER_DIR", (String)LJ_clsDirectory);
        Prefs.set((String)"LJ.INPUT_DIR", (String)LJ_inpDirectory);
        Prefs.set((String)"LJ.OUTPUT_DIR", (String)LJ_outDirectory);
        Prefs.set((String)"LJ.OTHER_DIR", (String)LJ_srcDirectory);
        Prefs.set((String)"LJ.BGCOLOR", (String)Tools.c2hex((Color)LJ_Colors[0]));
        Prefs.set((String)"LJ.COLOR1", (String)Tools.c2hex((Color)LJ_Colors[1]));
        Prefs.set((String)"LJ.COLOR2", (String)Tools.c2hex((Color)LJ_Colors[2]));
        Prefs.set((String)"LJ.COLOR3", (String)Tools.c2hex((Color)LJ_Colors[3]));
        Prefs.set((String)"LJ.COLOR4", (String)Tools.c2hex((Color)LJ_Colors[4]));
        Prefs.set((String)"LJ.COLOR5", (String)Tools.c2hex((Color)LJ_Color5));
        Prefs.set((String)"LJ.MAKEMAP", (boolean)LJ_makeMap);
        Prefs.set((String)"LJ.MAKEMASK", (boolean)LJ_makeMask);
        Prefs.set((String)"LJ.THRESHOLD", (double)LJ_threshold);
        Prefs.savePreferences();
    }

    public static Color getPref(String key, Color defaultValue) {
        String s = Prefs.get((String)key, (String)"");
        Color c = null;
        if (s != null && s != "") {
            try {
                c = Color.decode(s);
            }
            catch (NumberFormatException e) {
                c = null;
            }
            if (c != null) {
                return c;
            }
        }
        return defaultValue;
    }

    public static String getPref(Properties prefs, String key, String defaultValue) {
        String value = prefs.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static int getPref(Properties prefs, String key, int defaultValue) {
        String s = prefs.getProperty(key);
        Double d = null;
        if (s != null) {
            try {
                d = new Double(s);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return d.intValue();
            }
        }
        return defaultValue;
    }

    public static double getPref(Properties prefs, String key, double defaultValue) {
        String s = prefs.getProperty(key);
        Double d = null;
        if (s != null) {
            try {
                d = new Double(s);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return d;
            }
        }
        return defaultValue;
    }

    public static boolean getPref(Properties prefs, String key, boolean defaultValue) {
        String value = prefs.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static Color getPref(Properties prefs, String key, Color defaultValue) {
        String s = prefs.getProperty(key);
        Color c = null;
        if (s != null) {
            try {
                c = Color.decode(s);
            }
            catch (NumberFormatException e) {
                c = null;
            }
            if (c != null) {
                return c;
            }
        }
        return defaultValue;
    }

    public static void writeProperties(Properties prefs, String filepath) throws IOException {
        FileOutputStream fos = new FileOutputStream(filepath);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        prefs.store(bos, "LungJ ImageInfo");
        bos.close();
    }

    public static Properties readProperties(String filepath) throws IOException {
        Properties prefs = new Properties();
        System.out.println(filepath);
        InputStream f = new FileInputStream(filepath);
        f = new BufferedInputStream(f);
        prefs.load(f);
        f.close();
        return prefs;
    }

    public static void recordRun(String command, String[] keys, String[] values) {
        String macrostr = "run(\"" + command + "\",\"";
        for (int i = 0; i < keys.length; ++i) {
            macrostr = macrostr + " " + keys[i] + "=[" + values[i] + "]";
        }
        macrostr = macrostr + "\");\n";
        if (Recorder.record) {
            Recorder.recordString((String)macrostr);
        }
    }

    public static int retrieveOption(String Options, String key, int Default) {
        int a = Options.indexOf(" " + key + "=");
        if (a < 0 && (a = Options.indexOf(key + "=")) != 0) {
            return Default;
        }
        a = Options.indexOf("[", a);
        int b = Options.indexOf("]", a);
        String s = Options.substring(a + 1, b);
        Double d = null;
        if (s != null) {
            try {
                d = new Double(s);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return d.intValue();
            }
        }
        return Default;
    }

    public static String retrieveOption(String Options, String key, String Default) {
        int a = Options.indexOf(" " + key + "=");
        if (a < 0 && (a = Options.indexOf(key + "=")) != 0) {
            return Default;
        }
        a = Options.indexOf("[", a);
        int b = Options.indexOf("]", a);
        return Options.substring(a + 1, b);
    }

    public static Color retrieveOption(String Options, String key, Color Default) {
        int a = Options.indexOf(" " + key + "=");
        if (a < 0 && (a = Options.indexOf(key + "=")) != 0) {
            return Default;
        }
        a = Options.indexOf("[", a);
        int b = Options.indexOf("]", a);
        String s = Options.substring(a + 1, b);
        System.out.println(s);
        Color c = null;
        if (s != null && s != "") {
            try {
                c = Color.decode(s);
            }
            catch (NumberFormatException e) {
                c = null;
            }
            if (c != null) {
                return c;
            }
        }
        return Default;
    }

    public static void loadClassifier() {
        LJ_classifiers.clear();
        LJ_classifiers.add("...NONE...");
        File file = new File(LJ_clsDirectory);
        File folder = file.getParentFile();
        File[] listOfFiles = folder.listFiles();
        System.out.println("Directory: " + LJ_clsDirectory);
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile()) continue;
            System.out.println("File: " + listOfFiles[i].getName());
            if (!listOfFiles[i].getName().endsWith(".model")) continue;
            System.out.println("Classifier: " + listOfFiles[i].getName());
            LJ_classifiers.add(listOfFiles[i].getName());
        }
    }

    public static Color getColor(String label, Color defaultCol) {
        Color selColor = JColorChooser.showDialog(null, label, defaultCol);
        System.out.println(selColor);
        if (selColor == null) {
            return defaultCol;
        }
        return selColor;
    }

    public static String getClassifier() {
        String cls;
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Weka Classifier", "model");
        JFileChooser chooser = new JFileChooser(LJ_clsDirectory);
        chooser.addChoosableFileFilter(filter);
        chooser.showDialog(null, "Select");
        LJ_clsDirectory = cls = chooser.getSelectedFile().getParent();
        LJPrefs.loadClassifier();
        return cls;
    }

    public static float[] getMinMax(ImagePlus imp) {
        int img;
        float max = -3.4028235E38f;
        float min = Float.MAX_VALUE;
        ImageStack stack = imp.getStack();
        int width = imp.getWidth();
        int height = imp.getHeight();
        int n = width * height;
        int images = imp.getStackSize();
        if (imp.getBitDepth() == 24) {
            for (img = 1; img <= images; ++img) {
                ImageProcessor ip = stack.getProcessor(img);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int[] pixel = new int[3];
                        ip.getPixel(x, y, pixel);
                        if ((float)pixel[0] > max) {
                            max = pixel[0];
                        }
                        if ((float)pixel[1] > max) {
                            max = pixel[1];
                        }
                        if ((float)pixel[2] > max) {
                            max = pixel[2];
                        }
                        if ((float)pixel[0] < min) {
                            min = pixel[0];
                        }
                        if ((float)pixel[1] < min) {
                            min = pixel[1];
                        }
                        if (!((float)pixel[2] < min)) continue;
                        min = pixel[2];
                    }
                }
            }
        } else {
            for (img = 1; img <= images; ++img) {
                ImageProcessor ip = stack.getProcessor(img);
                for (int i = 0; i < n; ++i) {
                    float v = ip.getf(i);
                    if (v > max) {
                        max = v;
                    }
                    if (!(v < min)) continue;
                    min = v;
                }
            }
            if (imp.getBitDepth() == 16) {
                min -= 32768.0f;
                max -= 32768.0f;
            }
        }
        float[] mm = new float[]{min, max};
        return mm;
    }

    public static Plot plotHistogram(float[] Xs, float[] YsR, float[] YsG, float[] YsB, float Xmin, float Xmax, float Ymin, float Ymax) {
        Plot plot = new Plot("Histogram", "pixel value", "pixel count");
        plot.setLimits((double)Xmin, (double)Xmax, (double)Ymin, (double)Ymax);
        plot.setColor(Color.RED);
        plot.addPoints(Xs, YsR, 2);
        plot.draw();
        plot.setColor(Color.GREEN);
        plot.addPoints(Xs, YsG, 2);
        plot.draw();
        plot.setColor(Color.BLUE);
        plot.addPoints(Xs, YsB, 2);
        plot.draw();
        return plot;
    }

    public static Plot plotHistogram(double[] Xs, double[] Ys, double Xmin, double Xmax, long Ymin, long Ymax) {
        Plot plot = new Plot("Histogram", "pixel value\n\n\n.", "pixel count");
        plot.setLimits(Xmin, Xmax, (double)Ymin, (double)Ymax);
        plot.setColor(Color.BLACK);
        plot.addPoints(Xs, Ys, 2);
        plot.draw();
        return plot;
    }

    public static Plot plotHistogram(float[] Xs, float[] YsR, float[] YsG, float[] YsB, float Ymax) {
        int n = Xs.length;
        float Ymin = 0.0f;
        float Xmin = Xs[0];
        float Xmax = Xs[n - 1];
        Plot plot = LJPrefs.plotHistogram(Xs, YsR, YsG, YsB, Xmin, Xmax, Ymin, Ymax);
        return plot;
    }

    public static Plot plotHistogram(double[] Xs, double[] Ys, long Ymax) {
        int n = Xs.length;
        long Ymin = 0L;
        double Xmin = Xs[0];
        double Xmax = Xs[n - 1];
        Plot plot = LJPrefs.plotHistogram(Xs, Ys, Xmin, Xmax, Ymin, Ymax);
        return plot;
    }
}

