/*
 * Decompiled with CFR 0.152.
 */
package lj.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Properties;
import lj.LJPrefs;

public class VirtualBlockStatistics
extends ImageStatistics {
    public VirtualBlockStatistics(String filepath, int nBins, double globMin, double globMax) {
        String filein;
        this.stackStatistics = true;
        Properties prefs = new Properties();
        try {
            prefs = LJPrefs.readProperties(filepath + "\\properties.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int maxX = LJPrefs.getPref(prefs, "maxX", 0);
        int maxY = LJPrefs.getPref(prefs, "maxY", 0);
        int maxZ = LJPrefs.getPref(prefs, "maxZ", 0);
        int stepX = LJPrefs.getPref(prefs, "stepX", 1);
        int stepY = LJPrefs.getPref(prefs, "stepY", 1);
        int stepZ = LJPrefs.getPref(prefs, "stepZ", 1);
        int haloX = LJPrefs.getPref(prefs, "haloX", 0);
        int haloY = LJPrefs.getPref(prefs, "haloY", 0);
        int haloZ = LJPrefs.getPref(prefs, "haloZ", 0);
        this.histMin = globMin;
        this.histMax = globMax;
        IJ.showStatus((String)"Reading blocks...");
        IJ.showProgress((int)0, (int)100);
        int prog = 0;
        int diffz = (int)Math.ceil((float)maxZ / (float)stepZ);
        int diffx = (int)Math.ceil((float)maxX / (float)stepX);
        int diffy = (int)Math.ceil((float)maxY / (float)stepY);
        int maxProg = diffy * diffx * diffz * 100 / 99;
        double[] Xs = new double[nBins];
        long[] Ys = new long[nBins];
        double[] YsG = new double[nBins];
        double[] YsB = new double[nBins];
        double measuredMin = Double.MAX_VALUE;
        double measuredMax = -1.7976931348623157E308;
        long plotYmax = 0L;
        for (int i = 0; i < nBins; ++i) {
            Xs[i] = (float)((double)i * (this.max - globMin) / (double)(nBins - 1) + globMin);
        }
        int testcount = 0;
        for (int z = 0; z < maxZ; z += stepZ) {
            for (int x = 0; x < maxX; x += stepX) {
                for (int y = 0; y < maxY; y += stepY) {
                    filein = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", filepath, z, y, x);
                    ImagePlus imgblock = IJ.openImage((String)filein);
                    ImageStack stack = imgblock.getStack();
                    int bWidth = imgblock.getWidth();
                    int bHeight = imgblock.getHeight();
                    int bDepth = imgblock.getNSlices();
                    int xs = stepX + 2 * haloX;
                    int ys = stepY + 2 * haloY;
                    int zs = stepZ + 2 * haloZ;
                    int x1 = haloX;
                    if (x - haloX < 0) {
                        x1 = 0;
                        xs -= haloX;
                    }
                    int y1 = haloY;
                    if (y - haloY < 0) {
                        y1 = 0;
                        ys -= haloY;
                    }
                    int z1 = haloZ;
                    if (z - haloZ < 0) {
                        z1 = 0;
                        zs -= haloZ;
                    }
                    int x2 = bWidth - haloX;
                    if (x + xs > maxX) {
                        x2 = bWidth;
                    }
                    int y2 = bHeight - haloY;
                    if (y + ys > maxY) {
                        y2 = bHeight;
                    }
                    int z2 = bDepth - haloZ;
                    if (z + zs > maxZ) {
                        z2 = bDepth;
                    }
                    if (imgblock.getBitDepth() == 24) {
                        for (int img = z1 + 1; img <= z2; ++img) {
                            ImageProcessor ip = stack.getProcessor(img);
                            for (int iy = y1; iy < y2; ++iy) {
                                for (int ix = x1; ix < x2; ++ix) {
                                    int[] pixel = new int[3];
                                    ip.getPixel(ix, iy, pixel);
                                    int[] box = new int[]{(int)Math.round(((double)pixel[0] - globMin) * (double)(nBins - 1) / (globMax - globMin)), (int)Math.round(((double)pixel[1] - globMin) * (double)(nBins - 1) / (globMax - globMin)), (int)Math.round(((double)pixel[2] - globMin) * (double)(nBins - 1) / (globMax - globMin))};
                                    if (box[0] >= nBins) {
                                        box[0] = nBins - 1;
                                    }
                                    if (box[1] >= nBins) {
                                        box[1] = nBins - 1;
                                    }
                                    if (box[2] >= nBins) {
                                        box[2] = nBins - 1;
                                    }
                                    if (box[0] < 0) {
                                        box[0] = 0;
                                    }
                                    if (box[1] < 0) {
                                        box[1] = 0;
                                    }
                                    if (box[2] < 0) {
                                        box[2] = 0;
                                    }
                                    int n = box[0];
                                    Ys[n] = Ys[n] + 1L;
                                    int n2 = box[1];
                                    YsG[n2] = YsG[n2] + 1.0;
                                    int n3 = box[2];
                                    YsB[n3] = YsB[n3] + 1.0;
                                    if (Ys[box[0]] > plotYmax) {
                                        plotYmax = Ys[box[0]];
                                    }
                                    if (YsG[box[1]] > (double)plotYmax) {
                                        plotYmax = (long)YsG[box[1]];
                                    }
                                    if (YsB[box[2]] > (double)plotYmax) {
                                        plotYmax = (long)YsB[box[2]];
                                    }
                                    pixel = null;
                                    box = null;
                                }
                            }
                            ip = null;
                        }
                    } else {
                        double v = 0.0;
                        for (int img = z1 + 1; img <= z2; ++img) {
                            ImageProcessor ip = stack.getProcessor(img);
                            for (int iy = y1; iy < y2; ++iy) {
                                for (int ix = x1; ix < x2; ++ix) {
                                    v = ip.getf(ix, iy);
                                    ++testcount;
                                    int box = (int)((v - globMin) * (double)(nBins - 1) / (globMax - globMin));
                                    if (box >= nBins) {
                                        box = nBins - 1;
                                    }
                                    if (box < 0) {
                                        box = 0;
                                    }
                                    int n = box;
                                    Ys[n] = Ys[n] + 1L;
                                    if (Ys[box] > plotYmax) {
                                        plotYmax = Ys[box];
                                    }
                                    if (v < measuredMin) {
                                        measuredMin = v;
                                    }
                                    if (!(v > measuredMax)) continue;
                                    measuredMax = v;
                                }
                            }
                            ip = null;
                        }
                    }
                    imgblock = null;
                    stack = null;
                    filein = null;
                    System.gc();
                    IJ.showStatus((String)"Reading blocks...");
                    IJ.showProgress((int)(++prog), (int)maxProg);
                }
            }
        }
        IJ.showProgress((int)99, (int)100);
        IJ.log((String)String.valueOf(testcount));
        int x = 0;
        int y = 0;
        int z = 0;
        filein = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", filepath, z, y, x);
        ImagePlus imp2 = IJ.openImage((String)filein);
        imp2.show();
        int bits = imp2.getBitDepth();
        this.min = measuredMin;
        this.max = measuredMax;
        this.stackStatistics = true;
        this.longHistogram = new long[nBins];
        this.longHistogram = Ys;
        this.longPixelCount = (long)maxX * (long)maxY * (long)maxZ;
        if ((bits == 8 || bits == 24) && nBins == 256 && globMin == 0.0 && globMax == 256.0) {
            this.sum8BitHistograms(imp2);
        } else if (bits == 16 && nBins == 256 && globMin == 0.0 && globMax == 0.0 && !imp2.getCalibration().calibrated()) {
            this.sum16BitHistograms(imp2);
        } else {
            this.doCalculationsFromHistogram(imp2, nBins, globMin, globMax, maxX, maxY, measuredMin, measuredMax);
        }
        this.longHistogram = new long[nBins];
        this.longHistogram = Ys;
        this.histYMax = (int)plotYmax;
        this.copyHistogram(nBins);
        this.longPixelCount = (long)maxX * (long)maxY * (long)maxZ;
        this.min = measuredMin;
        this.max = measuredMax;
    }

    public VirtualBlockStatistics(ImagePlus imp) {
        this(imp, 256, 0.0, 0.0);
    }

    public VirtualBlockStatistics(ImagePlus imp, int nBins, double histMin, double histMax) {
        int bits = imp.getBitDepth();
        this.stackStatistics = true;
        if ((bits == 8 || bits == 24) && nBins == 256 && histMin == 0.0 && histMax == 256.0) {
            this.sum8BitHistograms(imp);
        } else if (bits == 16 && nBins == 256 && histMin == 0.0 && histMax == 0.0 && !imp.getCalibration().calibrated()) {
            this.sum16BitHistograms(imp);
        } else {
            this.doCalculations(imp, nBins, histMin, histMax);
        }
    }

    public VirtualBlockStatistics(ImagePlus imp, int nBins, double histMin, double histMax, long[] longhist, long pixelcount, int imgwidth, int imgheight, double imgmin, double imgmax) {
        int bits = imp.getBitDepth();
        this.stackStatistics = true;
        this.longHistogram = new long[nBins];
        this.longHistogram = longhist;
        this.longPixelCount = pixelcount;
        if ((bits == 8 || bits == 24) && nBins == 256 && histMin == 0.0 && histMax == 256.0) {
            this.sum8BitHistograms(imp);
        } else if (bits == 16 && nBins == 256 && histMin == 0.0 && histMax == 0.0 && !imp.getCalibration().calibrated()) {
            this.sum16BitHistograms(imp);
        } else {
            this.doCalculationsFromHistogram(imp, nBins, histMin, histMax, imgwidth, imgheight, imgmin, imgmax);
        }
        this.longHistogram = new long[nBins];
        this.longHistogram = longhist;
    }

    void doCalculationsFromHistogram(ImagePlus imp, int bins, double histogramMin, double histogramMax, int imgwidth, int imgheight, double imgmin, double imgmax) {
        this.nBins = bins;
        this.histMin = histogramMin;
        this.histMax = histogramMax;
        double sum = 0.0;
        double sum2 = 0.0;
        int width = imgwidth;
        int height = imgheight;
        boolean rx = false;
        boolean ry = false;
        int rw = width;
        int rh = height;
        double pw = 1.0;
        double ph = 1.0;
        this.roiX = (double)rx * pw;
        this.roiY = (double)ry * ph;
        this.roiWidth = (double)rw * pw;
        this.roiHeight = (double)rh * ph;
        boolean fixedRange = this.histMin != 0.0 || this.histMax != 0.0;
        this.min = imgmin;
        this.max = imgmax;
        if (fixedRange) {
            if (this.min < this.histMin) {
                this.min = this.histMin;
            }
            if (this.max > this.histMax) {
                this.max = this.histMax;
            }
        } else {
            this.histMin = this.min;
            this.histMax = this.max;
        }
        for (int i = 0; i < this.longHistogram.length; ++i) {
            double v = (double)i / (double)this.longHistogram.length * (this.histMax - this.histMin) + this.histMin;
            sum += v * (double)this.longHistogram[i];
            sum2 += v * v * (double)this.longHistogram[i];
        }
        IJ.log((String)String.valueOf(sum));
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * pw * ph;
        this.mean = sum / (double)this.longPixelCount;
        this.calculateStdDev(this.longPixelCount, sum, sum2);
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        int bits = imp.getBitDepth();
        if (this.histMin == 0.0 && this.histMax == 256.0 && (bits == 8 || bits == 24)) {
            this.histMax = 255.0;
        }
        this.dmode = this.getMode(this.cal);
        this.copyHistogram(this.nBins);
        IJ.showStatus((String)"");
        IJ.showProgress((double)1.0);
    }

    void doCalculations(ImagePlus imp, int bins, double histogramMin, double histogramMax) {
        double v;
        int rh;
        int rw;
        int ry;
        int rx;
        ImageProcessor ip = imp.getProcessor();
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        double minThreshold = -3.4028234663852886E38;
        double maxThreshold = 3.4028234663852886E38;
        Calibration cal = imp.getCalibration();
        if (limitToThreshold && ip.getMinThreshold() != -808080.0) {
            minThreshold = cal.getCValue(ip.getMinThreshold());
            maxThreshold = cal.getCValue(ip.getMaxThreshold());
        }
        this.nBins = bins;
        this.histMin = histogramMin;
        this.histMax = histogramMax;
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        ip.setRoi(imp.getRoi());
        byte[] mask = ip.getMaskArray();
        float[] cTable = imp.getCalibration().getCTable();
        this.longHistogram = new long[this.nBins];
        double sum = 0.0;
        double sum2 = 0.0;
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        if (roi != null) {
            rx = roi.x;
            ry = roi.y;
            rw = roi.width;
            rh = roi.height;
        } else {
            rx = 0;
            ry = 0;
            rw = width;
            rh = height;
        }
        double pw = 1.0;
        double ph = 1.0;
        this.roiX = (double)rx * pw;
        this.roiY = (double)ry * ph;
        this.roiWidth = (double)rw * pw;
        this.roiHeight = (double)rh * ph;
        boolean fixedRange = this.histMin != 0.0 || this.histMax != 0.0;
        double roiMin = Double.MAX_VALUE;
        double roiMax = -1.7976931348623157E308;
        for (int slice = 1; slice <= size; ++slice) {
            IJ.showStatus((String)"Calculating stack histogram...");
            IJ.showProgress((int)(slice / 2), (int)size);
            ip = stack.getProcessor(slice);
            int y = ry;
            int my = 0;
            while (y < ry + rh) {
                int mi = my * rw;
                for (int x = rx; x < rx + rw; ++x) {
                    if (mask != null && mask[mi++] == 0 || !((v = (double)ip.getPixelValue(x, y)) >= minThreshold) || !(v <= maxThreshold)) continue;
                    if (v < roiMin) {
                        roiMin = v;
                    }
                    if (!(v > roiMax)) continue;
                    roiMax = v;
                }
                ++y;
                ++my;
            }
        }
        this.min = roiMin;
        this.max = roiMax;
        if (fixedRange) {
            if (this.min < this.histMin) {
                this.min = this.histMin;
            }
            if (this.max > this.histMax) {
                this.max = this.histMax;
            }
        } else {
            this.histMin = this.min;
            this.histMax = this.max;
        }
        double scale = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        for (int slice = 1; slice <= size; ++slice) {
            IJ.showProgress((int)(size / 2 + slice / 2), (int)size);
            ip = stack.getProcessor(slice);
            ip.setCalibrationTable(cTable);
            int y = ry;
            int my = 0;
            while (y < ry + rh) {
                int mi = my * rw;
                for (int x = rx; x < rx + rw; ++x) {
                    if (mask != null && mask[mi++] == 0 || !((v = (double)ip.getPixelValue(x, y)) >= minThreshold) || !(v <= maxThreshold) || !(v >= this.histMin) || !(v <= this.histMax)) continue;
                    ++this.longPixelCount;
                    sum += v;
                    sum2 += v * v;
                    int index = (int)(scale * (v - this.histMin));
                    if (index >= this.nBins) {
                        index = this.nBins - 1;
                    }
                    int n = index;
                    this.longHistogram[n] = this.longHistogram[n] + 1L;
                }
                ++y;
                ++my;
            }
        }
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * pw * ph;
        this.mean = sum / (double)this.longPixelCount;
        this.calculateStdDev(this.longPixelCount, sum, sum2);
        this.histMin = cal.getRawValue(this.histMin);
        this.histMax = cal.getRawValue(this.histMax);
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        int bits = imp.getBitDepth();
        if (this.histMin == 0.0 && this.histMax == 256.0 && (bits == 8 || bits == 24)) {
            this.histMax = 255.0;
        }
        this.dmode = this.getMode(cal);
        this.copyHistogram(this.nBins);
        IJ.showStatus((String)"");
        IJ.showProgress((double)1.0);
    }

    void sum8BitHistograms(ImagePlus imp) {
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        int minThreshold = 0;
        int maxThreshold = 255;
        ImageProcessor ip = imp.getProcessor();
        if (limitToThreshold && ip.getMinThreshold() != -808080.0) {
            minThreshold = (int)ip.getMinThreshold();
            maxThreshold = (int)ip.getMaxThreshold();
        }
        ImageStack stack = imp.getStack();
        Roi roi = imp.getRoi();
        this.longHistogram = new long[256];
        int n = stack.getSize();
        for (int slice = 1; slice <= n; ++slice) {
            IJ.showProgress((int)slice, (int)n);
            ip = stack.getProcessor(slice);
            if (roi != null) {
                ip.setRoi(roi);
            }
            int[] hist = ip.getHistogram();
            for (int i = 0; i < 256; ++i) {
                int n2 = i;
                this.longHistogram[n2] = this.longHistogram[n2] + (long)hist[i];
            }
        }
        this.pw = 1.0;
        this.ph = 1.0;
        this.getRawStatistics(this.longHistogram, minThreshold, maxThreshold);
        this.getRawMinAndMax(this.longHistogram, minThreshold, maxThreshold);
        this.copyHistogram(256);
        IJ.showStatus((String)"");
        IJ.showProgress((double)1.0);
    }

    private void copyHistogram(int nbins) {
        this.histogram = new int[nbins];
        for (int i = 0; i < nbins; ++i) {
            long count = this.longHistogram[i];
            this.histogram[i] = count <= Integer.MAX_VALUE ? (int)count : Integer.MAX_VALUE;
        }
    }

    void getRawStatistics(long[] histogram, int minThreshold, int maxThreshold) {
        long longMaxCount = 0L;
        double sum = 0.0;
        double sum2 = 0.0;
        this.histMin = 0.0;
        this.histMax = 255.0;
        for (int i = minThreshold; i <= maxThreshold; ++i) {
            long count = histogram[i];
            this.longPixelCount += count;
            sum += (double)i * (double)count;
            double value = i;
            sum2 += value * value * (double)count;
            if (count <= longMaxCount) continue;
            longMaxCount = count;
            this.mode = i;
        }
        this.maxCount = (int)longMaxCount;
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.longPixelCount;
        this.dmode = this.mode;
        this.calculateStdDev(this.longPixelCount, sum, sum2);
    }

    void getRawMinAndMax(long[] histogram, int minThreshold, int maxThreshold) {
        int max;
        int min;
        for (min = minThreshold; histogram[min] == 0L && min < 255; ++min) {
        }
        this.min = min;
        for (max = maxThreshold; histogram[max] == 0L && max > 0; --max) {
        }
        this.max = max;
    }

    void sum16BitHistograms(ImagePlus imp) {
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        int minThreshold = 0;
        int maxThreshold = 65535;
        ImageProcessor ip = imp.getProcessor();
        if (limitToThreshold && ip.getMinThreshold() != -808080.0) {
            minThreshold = (int)ip.getMinThreshold();
            maxThreshold = (int)ip.getMaxThreshold();
        }
        ImageStack stack = imp.getStack();
        Roi roi = imp.getRoi();
        long[] hist16 = new long[65536];
        int n = stack.getSize();
        for (int slice = 1; slice <= n; ++slice) {
            IJ.showProgress((int)slice, (int)n);
            IJ.showStatus((String)(slice + "/" + n));
            ip = stack.getProcessor(slice);
            if (roi != null) {
                ip.setRoi(roi);
            }
            int[] hist = ip.getHistogram();
            for (int i = 0; i < 65536; ++i) {
                int n2 = i;
                hist16[n2] = hist16[n2] + (long)hist[i];
            }
        }
        this.pw = 1.0;
        this.ph = 1.0;
        this.get16BitMinAndMax(hist16, minThreshold, maxThreshold);
        this.get16BitStatistics(hist16, (int)this.min, (int)this.max);
        this.histogram16 = new int[65536];
        for (int i = 0; i < 65536; ++i) {
            long count = hist16[i];
            this.histogram16[i] = count <= Integer.MAX_VALUE ? (int)count : Integer.MAX_VALUE;
        }
        IJ.showStatus((String)"");
        IJ.showProgress((double)1.0);
    }

    void get16BitMinAndMax(long[] hist, int minThreshold, int maxThreshold) {
        int max;
        int min;
        for (min = minThreshold; hist[min] == 0L && min < 65535; ++min) {
        }
        this.min = min;
        for (max = maxThreshold; hist[max] == 0L && max > 0; --max) {
        }
        this.max = max;
    }

    void get16BitStatistics(long[] hist, int min, int max) {
        double sum = 0.0;
        double sum2 = 0.0;
        this.histMin = min;
        this.histMax = max;
        this.nBins = 256;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double scale = 1.0 / this.binSize;
        int hMin = (int)this.histMin;
        this.longHistogram = new long[this.nBins];
        for (int i = min; i <= max; ++i) {
            long count = hist[i];
            this.longPixelCount += count;
            double value = i;
            sum += value * (double)count;
            sum2 += value * value * (double)count;
            int index = (int)(scale * (double)(i - hMin));
            if (index >= this.nBins) {
                index = this.nBins - 1;
            }
            int n = index;
            this.longHistogram[n] = this.longHistogram[n] + count;
        }
        this.copyHistogram(this.nBins);
        this.maxCount = 0;
        this.pixelCount = (int)this.longPixelCount;
        this.area = (double)this.longPixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.longPixelCount;
        this.dmode = this.getMode(null);
        this.calculateStdDev(this.longPixelCount, sum, sum2);
    }

    double getMode(Calibration cal) {
        long longMaxCount = 0L;
        for (int i = 0; i < this.nBins; ++i) {
            long count = this.longHistogram[i];
            if (count <= longMaxCount) continue;
            longMaxCount = count;
            this.mode = i;
        }
        this.maxCount = longMaxCount <= Integer.MAX_VALUE ? (int)longMaxCount : Integer.MAX_VALUE;
        double tmode = this.histMin + (double)this.mode * this.binSize;
        if (cal != null) {
            tmode = cal.getCValue(tmode);
        }
        return tmode;
    }

    void calculateStdDev(double n, double sum, double sum2) {
        if (n > 0.0) {
            this.stdDev = (n * sum2 - sum * sum) / n;
            this.stdDev = this.stdDev > 0.0 ? Math.sqrt(this.stdDev / (n - 1.0)) : 0.0;
        } else {
            this.stdDev = 0.0;
        }
    }
}

