/*
 * Decompiled with CFR 0.152.
 */
package lj.testing;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;
import java.util.Properties;
import lj.LJPrefs;

public class Test_Halo_Highlight
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private static String BC_inDirectory = LJPrefs.LJ_inpDirectory;
    private static String BC_outDirectory = LJPrefs.LJ_outDirectory;
    private static int maxX = 1;
    private static int maxY = 1;
    private static int maxZ = 1;
    private static int stepX = 1;
    private static int stepY = 1;
    private static int stepZ = 1;
    private static int haloX = 0;
    private static int haloY = 0;
    private static int haloZ = 0;
    private static float globMaxIn = -3.4028235E38f;
    private static float globMinIn = Float.MAX_VALUE;
    private static int errCount = 0;

    public void run(String command) {
        GenericDialog gd = new GenericDialog(command + " Run macro on 3D blocks");
        gd.addStringField("Input directory", BC_inDirectory, 100);
        gd.addStringField("Output directory", BC_outDirectory, 100);
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        LJPrefs.LJ_inpDirectory = BC_inDirectory = gd.getNextString();
        LJPrefs.LJ_outDirectory = BC_outDirectory = gd.getNextString();
        LJPrefs.savePreferences();
        Properties prefs = new Properties();
        try {
            prefs = LJPrefs.readProperties(BC_inDirectory + "\\properties.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        maxX = LJPrefs.getPref(prefs, "maxX", maxX);
        maxY = LJPrefs.getPref(prefs, "maxY", maxY);
        maxZ = LJPrefs.getPref(prefs, "maxZ", maxZ);
        stepX = LJPrefs.getPref(prefs, "stepX", stepX);
        stepY = LJPrefs.getPref(prefs, "stepY", stepY);
        stepZ = LJPrefs.getPref(prefs, "stepZ", stepZ);
        haloX = LJPrefs.getPref(prefs, "haloX", haloX);
        haloY = LJPrefs.getPref(prefs, "haloY", haloY);
        haloZ = LJPrefs.getPref(prefs, "haloZ", haloZ);
        globMinIn = (float)LJPrefs.getPref(prefs, "minVal", globMinIn);
        globMaxIn = (float)LJPrefs.getPref(prefs, "maxVal", globMaxIn);
        ImagePlus imgout = null;
        float globMax = -3.4028235E38f;
        float globMin = Float.MAX_VALUE;
        errCount = 0;
        for (int z = 0; z < maxZ; z += stepZ) {
            IJ.showProgress((int)z, (int)maxZ);
            for (int x = 0; x < maxX; x += stepX) {
                for (int y = 0; y < maxY; y += stepY) {
                    String filein = String.format("%1$s\\%2$04d_%3$04d_%4$04d.tif", BC_inDirectory, z, y, x);
                    String filename = String.format("%1$04d_%2$04d_%3$04d.tif", z, y, x);
                    IJ.log((String)filename);
                    imgout = IJ.openImage((String)filein);
                    int bWidth = imgout.getWidth();
                    int bHeight = imgout.getHeight();
                    int bDepth = imgout.getNSlices();
                    int xs = stepX + 2 * haloX;
                    int ys = stepY + 2 * haloY;
                    int zs = stepZ + 2 * haloZ;
                    int x1 = haloX;
                    if (x - haloX < 0) {
                        x1 = 0;
                        xs -= haloX;
                    }
                    int y1 = haloY;
                    if (y - haloY < 0) {
                        y1 = 0;
                        ys -= haloY;
                    }
                    int z1 = haloZ;
                    if (z - haloZ < 0) {
                        z1 = 0;
                        zs -= haloZ;
                    }
                    int x2 = bWidth - haloX;
                    if (x + xs > maxX) {
                        x2 = bWidth;
                    }
                    int y2 = bHeight - haloY;
                    if (y + ys > maxY) {
                        y2 = bHeight;
                    }
                    int z2 = bDepth - haloZ;
                    if (z + zs > maxZ) {
                        z2 = bDepth;
                    }
                    for (int zb = 1; zb <= bDepth; ++zb) {
                        ImageProcessor outputIP = imgout.getStack().getProcessor(zb);
                        short[] oPixels = (short[])outputIP.getPixels();
                        for (int yb = 0; yb < bHeight; ++yb) {
                            int xb = 0;
                            int p = xb + yb * bWidth;
                            while (xb < bWidth) {
                                if (yb < y1 || yb >= y2 || xb < x1 || xb >= x2 || zb <= z1 || zb > z2) {
                                    oPixels[p] = -5536;
                                }
                                ++xb;
                                ++p;
                            }
                        }
                        outputIP.setPixels((Object)oPixels);
                    }
                    float[] minmax = LJPrefs.getMinMax(imgout);
                    float curMin = minmax[0];
                    float curMax = minmax[1];
                    if (curMax > globMax) {
                        globMax = curMax;
                    }
                    if (curMin < globMin) {
                        globMin = curMin;
                    }
                    String fileout = String.format("%1$s\\%2$s", BC_outDirectory, filename);
                    IJ.saveAsTiff((ImagePlus)imgout, (String)fileout);
                    IJ.log((String)("processed " + filein));
                    imgout.close();
                    imgout = null;
                }
            }
        }
        if (errCount > 0) {
            IJ.error((String)String.format("%1$s files failed", errCount));
        }
        IJ.showProgress((int)99, (int)100);
        prefs = new Properties();
        prefs.put("maxX", Double.toString(maxX));
        prefs.put("maxY", Double.toString(maxY));
        prefs.put("maxZ", Double.toString(maxZ));
        prefs.put("stepX", Double.toString(stepX));
        prefs.put("stepY", Double.toString(stepY));
        prefs.put("stepZ", Double.toString(stepZ));
        prefs.put("haloX", Double.toString(haloX));
        prefs.put("haloY", Double.toString(haloY));
        prefs.put("haloZ", Double.toString(haloZ));
        prefs.put("minVal", Double.toString(globMin));
        prefs.put("maxVal", Double.toString(globMax));
        try {
            LJPrefs.writeProperties(prefs, BC_outDirectory + "\\properties.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IJ.showProgress((int)100, (int)100);
    }
}

