/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import ij3d.Content;
import ij3d.Image3DUniverse;
import isosurface.MeshExporter;
import java.io.File;
import java.util.Collection;
import lj.LJPrefs;

public class mask_to_stl
implements PlugIn {
    public static final String PLUGIN_NAME = "LungJ";
    public static final String PLUGIN_VERSION = "0.5.1";
    public static final String PLUGIN_HELP_URL = "http://imagej.net/LungJ";
    private static String BC_outDirectory = LJPrefs.LJ_srcDirectory;

    public void run(String command) {
        if (IJ.versionLessThan((String)"1.48n")) {
            return;
        }
        IJ.showStatus((String)"Select Mask...");
        int Nimg = WindowManager.getImageCount();
        String[] lstImages = WindowManager.getImageTitles();
        int[] lstImageIds = WindowManager.getIDList();
        String[] lstMasks = new String[Nimg];
        int Nmasks = Nimg;
        for (int i = 0; i < Nimg; ++i) {
            ImageProcessor temp = WindowManager.getImage((int)lstImageIds[i]).getProcessor();
            if (temp.getMin() == 0.0 && temp.getMax() == 1.0 || temp.isBinary()) {
                lstMasks[i] = lstImages[i];
                continue;
            }
            lstMasks[i] = "--not a mask--";
            --Nmasks;
        }
        if (Nmasks < 1) {
            IJ.error((String)"Could not find valid mask. (A mask needs to be binary, or only contain values between 0 and 1)");
            return;
        }
        GenericDialog gd = new GenericDialog(command + " Save mask as STL");
        gd.addChoice("Mask", lstMasks, lstMasks[0]);
        gd.addStringField("Output directory", BC_outDirectory);
        if (IJ.getVersion().compareTo("1.42p") >= 0) {
            gd.addHelp(PLUGIN_HELP_URL);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int AM_maskID = lstImageIds[gd.getNextChoiceIndex()];
        String fileoutname = gd.getNextString();
        ImagePlus mask = WindowManager.getImage((int)AM_maskID);
        new StackConverter(mask).convertToGray8();
        Image3DUniverse univ = new Image3DUniverse();
        univ.show();
        Content c = univ.addVoltex(mask);
        c.displayAs(2);
        IJ.showStatus((String)"Mask converted.");
        MeshExporter.saveAsSTL((Collection)univ.getContents(), (File)new File(fileoutname), (int)1);
        IJ.showStatus((String)"STL saved.");
    }
}

