#-- NMOS Specification
#if @[string match @Type@ "nMOS"]@
#define _Device_ nmos
#define _DG_     eQuantumPotential hQuantumPotential
#define _Sign_   1.0
#define _Vdd_    @Vdd@
#define _WF_     4.2
#-- PMOS Specfication
#else
#define _Device_ pmos  
#define _DG_     hQuantumPotential eQuantumPotential
#define _Sign_  -1.0 
#define _Vdd_   @<-1.0*Vdd>@
#define _WF_     4.8
#endif

Device MOS {

File {
  Grid      = "@tdr@"
  Parameter = "@parameter@"
  Plot      = "@tdrdat@"
  Current   = "@plot@"
  Piezo     = "@tdr@"
}

Electrode {
  { Name= "source"    Voltage= 0.0 Resistor= 40 }
  { Name= "drain"     Voltage= 0.0 Resistor= 40 }
  { Name= "gate"      Voltage= 0.0 }
  { Name= "substrate" Voltage= 0.0 }
  
  #if [string compare @Body@ "Tied"] == 0
  { Name="body"   Voltage=0.0 }
  #elseif [string compare @Body@ "Floating"] == 0
  { Name="body"   Voltage=0.0 Resistor= 1e12 }
  #endif
  
}

Physics{
  AreaFactor= 1
  EffectiveIntrinsicDensity( OldSlotboom )
}

Physics (material= "Silicon") {
  _DG_
  Mobility(
    PhuMob
    HighFieldSaturation
    Enormal( Lombardi_highk )
    )
  Recombination(
    SRH( DopingDep )
    Band2Band
    Avalanche( CarrierTempDrive )
  )
  Piezo(
    Model(
      DeformationPotential
      Mobility(
         eSubBand(Doping)
         hSixBand(Doping)
      )
    )
  )
}

Physics (MaterialInterface= "HfO2/Oxide"){
	Dipole ( Reference= "Oxide" )
}
} ** End Device MOS

File {
   Output    = "@log@"
   ACExtract = "@acplot@"
}

Plot{
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap 
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  _DG_
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  
}

Math {
   Extrapolate
   Derivatives
   Avalderivatives
   RelErrControl
   Digits= 5
   Notdamped= 50
   Iterations= 20
   DirectCurrent
   ExitOnFailure
   
   hDrForceRefDens= 1.e12
   eDrForceRefDens= 1.e12
}

System { 
   
  MOS _Device_ (drain=d source=s gate=g body=b) 
  Vsource_pset vd ( d 0 ){ dc = 0 } 
  Vsource_pset vs ( s 0 ){ dc = 0 } 
  Vsource_pset vg ( g 0 ){ dc = 0 } 
  Vsource_pset vb ( b 0 ){ dc = 0 }
  
} 

Solve {
  Coupled(Iterations= 100 LineSearchDamping= 1e-8){ Poisson } 
  Coupled(Iterations= 100 LineSearchDamping= 1e-8){ Poisson _DG_  }
  Coupled(Iterations= 100 LineSearchDamping= 1e-8){ Poisson _DG_ Electron Hole }
  Save ( FilePrefix= "n@node@_init" )

  #-- Sweep Vg
  
  Quasistationary( 
    DoZero
    InitialStep= 1e-3 Increment= 1.2 
    MinStep= 1e-6 MaxStep= 0.05 
    Goal { Parameter= vg.dc Voltage= @<-1*_Vdd_>@ } 
  ){ ACCoupled ( 
    StartFrequency= 100 EndFrequency= 100 NumberOfPoints= 1 Decade 
    Node(d s g b) Exclude(vd vs vg vb) 
    ACCompute (Time= (Range= (0 1)  Intervals= 30)) 
    ){ Poisson _DG_ Electron Hole } 
  }

  NewCurrentFile="CVg_"
  Quasistationary( 
    DoZero 
    InitialStep= 1e-2 Increment= 1.2 
    MinStep= 1e-5 MaxStep= 0.05 
    Goal { Parameter= vg.dc Voltage= _Vdd_ } 
  ){ ACCoupled ( 
    StartFrequency= 100 EndFrequency= 100 NumberOfPoints= 1 Decade 
    Node(d s g b) Exclude(vd vs vg vb) 
    ACCompute (Time= (Range = (0 1)  Intervals= 30)) 
    ){ Poisson _DG_ Electron Hole } 
  }
  
}
