#define _Device_ nmos
#define _cTemp_  eTemperature  
#define _Vdd_    @Vdd@	
#define _VdLin_  0.05
#define _VdSat_ _Vdd_  
#define _WF_     4.2

File {
  Grid      = "n671_msh.tdr"
  Parameter = "@parameter@"
  Plot      = "@tdrdat@"
  Current   = "@plot@"
  Output    = "@log@"
  Piezo     = "n671_msh.tdr"
}

Electrode {
  { Name="gate" 
  #if @SchottkyGate@ == 1
     Schottky
  #endif
  Voltage= @GateBias@ Workfunction= _WF_ }
  
  { Name="substrate" 
  #if @SchottkySub@ == 1
     Schottky
  #endif
  Voltage= @SubBias@ Workfunction= _WF_ }
}

Thermode{
  { Name="substrate" Temperature= 300 } 
  { Name="gate"      Temperature= 300 SurfaceResistance= 5.0e-5 }
  ##{ Name="source"  Temperature= 300 SurfaceResistance= 1.0e-3 }
}

Physics{
  Temperature= 300
  EffectiveIntrinsicDensity( OldSlotboom )
}

Physics (material= "Silicon") {
  ##Hydrodynamic( _cTemp_ )
  Mobility(
    PhuMob
    HighFieldSaturation
    Enormal( Lombardi_highk )
    )
  Recombination(
    SRH( DopingDep )
    Avalanche( CarrierTempDrive )
  )
  Piezo(
    Model(
      DeformationPotential
      Mobility(
         eSubBand(Doping)
         hSixBand(Doping)
      )
    )
  )
}

Physics (region= "OxideAsSemiconductor_1") {
    Radiation (
    	DoseTime=(10, @DoseTime@)
    	DoseRate=@pDoseRate@
    )
    
    EffectiveIntrinsicDensity(NoBandGapNarrowing)
    Mobility(ConstantMobility)
    
    Traps (
    (Level Donor Conc=@pTraps@ fromValBand EnergyMid=4.0 material="Oxide")
    (Level FixedCharge Conc=@pNot@)
    )
} 
  

Physics (MaterialInterface= "HfO2/Oxide"){
	Dipole ( Reference= "Oxide" )
}

Physics(MaterialInterface="OxideAsSemiconductor/Silicon") {
		Heterointerface 
		eThermionic
		hThermionic
	 }
	 
Physics(MaterialInterface="OxideAsSemiconductor/SiDG") {
		Heterointerface 
		eThermionic
		hThermionic
	 }


Plot{
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap 
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
  eBarrierTunneling hBarrierTunneling
}


CurrentPlot { eCurrentDensity(Average(RegionInterface="OxideAsSemiconductor_1/Silicon_1"))}
CurrentPlot { hCurrentDensity(Average(RegionInterface="OxideAsSemiconductor_1/Silicon_1"))}
CurrentPlot { TotalCurrentDensity(Average(RegionInterface="OxideAsSemiconductor_1/Silicon_1"))}


Math {  
  CNormPrint
  Extrapolate
  Derivatives
  Avalderivatives
  RelErrControl
  Digits= 5
  Notdamped= 50
  Iterations= 20
  DirectCurrent
  *ExitOnFailure
  Number_of_Threads= 2
  hDrForceRefDens= 1.e12
  eDrForceRefDens= 1.e12
  
}

Solve {
  Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson } 
  Coupled { Poisson Electron Hole }

  Save ( FilePrefix= "n@node@_init" )
  Plot ( FilePrefix= "n@node@_PEH" )
  
  
Transient(
   InitialTime = 0 FinalTime=@DoseTime@
   MinStep = 1e-10 MaxStep = 500
   ){
	Coupled { Poisson Electron Hole }
	Plot ( FilePrefix="n@node@" Time=( 5; 10; 15; 20; 30; 35.9; 40; 50; 60; 70; 80; 90; 100; 139.53; 200; 269.06; 300; 310; 400; 500; 1000; 1305.33; 2600.67; 5191.3; 7782; 10372.6; 12963.3; @DoseTime@ )  NoOverwrite )	
   }  
}

