## ------------------------------------
#header
## ------------------------------------
# Unified Coordinate system
math coord.ucs

fset f 2
fset debug  1
fset PolyT  0.04
fset SwOX   10e-3
fset SwNI   20e-3

fset LspSD [expr $SwOX+$SwNI]
fset LspLD 75e-4
fset Lsp   [expr $LspSD+$LspLD]
fset Lg2   @<lgate/2.0>@
fset Yspacer [expr ($Lg2+$Lsp)]
fset Type @Type@
fset Sti_width 0.18
fset Sti_depth 0.2
fset SOI_depth @pSOIdepth@
fset Tbox      0.1
fset SiGe_pocket 0.025

fset stress_sti_pa -500e6
fset stress_tens_nmos_dsl_pa  8.0e9
fset stress_comp_pmos_dsl_pa -3.0e9

fset Xjwell 0.2
fset ScreenOx 8.0e-3

fset Tox 0.00025
fset PolyReox 0.002
fset SiRecess 1.5e-3
fset SiRecess_Ang 45
fset TPoly 0.04
fset Poly_Taper_Ang 0

fset LD_sp 1.25e-3
fset NAT_ox 1.5e-3

fset XjHalo 0.4
fset XjExt  0.04
fset YjExt  0.02
fset XjSD   0.06
fset XjWell 0.20
fset XChannel 0.1

## Intialization for Selective Epitaxy 
fset epi_temp 700.0
fset epi_thick 0.04

#rem #---------------------------------------------------------------------#
#rem #   LAYOUT
#rem #---------------------------------------------------------------------#

#---------------------------------------------------------------------#
set Domain  @CUT@
#---------------------------------------------------------------------#
#rem # Loading of the "TCAD Layout" file.
icwb filename= "PDSOI_lyt.mac" scale=1e-3

#rem # Selecting the simulation domain.
icwb domain= $Domain

#rem # Define stretch marks for parametrization
icwb stretch name= "lgate" value=@<(lgate/2.0-0.050)>@

#rem # Query utility: Returns the bounding box of the simulation
set Ymin [icwb bbox left ]
set Ymax [icwb bbox right]

puts "Y domain: $Ymin $Ymax"

#rem #---------------------------------------------------------------------#
#rem #   USER-DEFINED PROCEDURES
#rem #---------------------------------------------------------------------#

proc WriteBND {} {
        global count
        if { $count < 10} {
           struct bndfile= n@node@_0${count}
        } else {
           struct bndfile= n@node@_${count}
        }
        fset count [expr $count+1]
}
#endheader

set count 1

## mesh lines
line y location= $Ymin tag= left
line y location= $Ymin+$Lg2 tag= lg
line y location= $Ymax tag= right

line x loc= -0.0005 tag= tox
line x loc= 0.0     tag= top
line x loc= 1.5e-3  tag= sirecess
line x loc= 2*1.5e-3 tag= sirecess2
line x loc= 0.04    tag= xjext
line x loc= 0.06    tag= xjsd
line x loc= 0.4     tag= xjhalo
line x loc= 0.2     tag= well
line x location= 10.0  tag= bottom
region Silicon substrate xlo= top xhi= bottom ylo= left yhi= right
init concentration= 1e15 field= Boron wafer.orient= 100  

mgoals on min.normal.size= 0.001/$f normal.growth.ratio= 2.0


math numThreads= 8


#postheader
## ---------- Advanced Calibration -----------------------------
source @calibration@
sde off
pdbSet ImplantData Extrude 1
## ------------------------------------
#endpostheader

##---------------------------------------------------------##
refinebox clear.interface.mats
refinebox name= SOI  min= "-0.12 0.001"  max= "0.12 $Ymax" interface.materials= {Silicon Oxide}  min.normal.size= $f*0.0005  all add
##---------------------------------------------------------##
etch silicon type= cmp coord= $SOI_depth+$Tbox<um> 
    
deposit material= {Oxide} type= isotropic  rate= {$Tbox} time= 1.0 type= isotropic temperature= 500<C> 
deposit material= {Silicon} type= isotropic rate= {$SOI_depth} time= 1.0 temperature= 500<C> Boron concentration= 1.0e15
  
temp_ramp name= soi time= 5 temp= 600.0 ramprate= 0.8333
temp_ramp name= soi time= 5 temp= 850.0 ramprate= -0.8333
diffuse temp_ramp= soi 

## ----------- STI --------------------------

deposit material= {Oxide} type= anisotropic rate= {1.0} time= 0.01
deposit material= {Nitride} type= anisotropic rate= {1.0} time= 0.1

## ---------------------STI---------------
icwb.create.mask layer.name= "STI" name= STI info= 1 polarity= positive
photo mask= STI thickness= 0.2

etch material= {Nitride} type= anisotropic rate= {0.1} time= 1.0 
etch material= {Oxide} type= anisotropic rate= {0.01} time= 1.0 
if { $debug } { WriteBND }

etch material= {Silicon} type= trapezoidal rate= $Sti_depth time= 1.0 angle= 86.0
if { $debug } { WriteBND }
strip Photoresist

if { $debug } { WriteBND }

doping name= Stress_STI field= Pressure depths= {0 0.01} values= {-1*$stress_sti_pa -1*$stress_sti_pa}
deposit material= {Oxide} doping= {Stress_STI} type= isotropic rate= 1.0 time= 0.03 
etch material = {Oxide}  type= cmp coord= -0.025
if { $debug } { WriteBND }
doping name= Stress_STI1 field= Pressure depths= {0 0.12} values= {-1*$stress_sti_pa -1*$stress_sti_pa}
deposit material= {Oxide} doping= {Stress_STI1} type= isotropic rate= 1.0 time= 0.12 
etch material = {Oxide}  type= cmp coord= -0.025

if { $debug } { WriteBND }
strip Nitride
etch material= {Oxide} type= anisotropic rate= {0.006} time= 1.1
etch material= {Oxide} type= isotropic rate= {0.0036} time= 1.1
if { $debug } { WriteBND }

temp_ramp name= sti time= 5 temp= 600.0 ramprate= 0.6667
temp_ramp name= sti time= 5 temp= 800.0 ramprate= -0.6667
diffuse temp_ramp= sti

refinebox name= Vt  min= "0.0  $Ymin"  max= "$XjWell/5.0  $Ymax"  xrefine= "$f*0.005  $f*0.01"  yrefine= "$f*$Lg2*0.04/0.0125" Silicon

## ---------- Vt implant and anneal -----------------------
deposit material= {Oxide} type= anisotropic rate= {$ScreenOx} time= 1.0

icwb.create.mask layer.name= "NACTIVE" name= PWELL info= 1 polarity= positive
photo mask= PWELL thickness= 1.5

#implant Boron dose= 2.0e13 energy= 30  tilt= 0.0
implant Boron dose= @WellDose@ energy= @WellEnergy@  tilt= 0.0 
 
strip Photoresist
if { $debug } { WriteBND }

temp_ramp name= vt time= 0.0300 temp= 600.0  ramprate= 250.0
temp_ramp name= vt time= 0.3333 temp= 1050.0 ramprate= 0.0
temp_ramp name= vt time= 0.0833 temp= 1050.0 ramprate= -90.0
diffuse temp_ramp= vt 
etch material= {Oxide} type= anisotropic rate= {$ScreenOx} time= 1.1 

## ------------------------------------

#split Poly

#----------------------------------------------------------------------#
refinebox name= GOX_OX1  min= {-$Tox  $Ymin}  max= {$f*$SiRecess  $Yspacer}  interface.materials= {Silicon Oxide}  min.normal.size= {$f*0.0001} Oxide add
refinebox name= GOX_OX2  min= {-$Tox  $Ymin}  max= {$f*$SiRecess  $Yspacer}  xrefine= {$f*0.0002} Oxide add
#----------------------------------------------------------------------#
refinebox remesh
## ---------- gate oxidation --------------------------------------
deposit material= {Oxide} type= isotropic rate= {$Tox} time= 1.0  temperature= 500<C>
deposit material= {Oxide} type= fill coord= -$Tox
if { $debug } { WriteBND }
gas_flow name= gasflow_gox pressure= 1.0 flowO2= 1.0
temp_ramp name= oxi time= 24 temp= 600.0 ramprate= 0.104
temp_ramp name= oxi time= 20 temp= 750.0 ramprate= 0.0000
temp_ramp name= oxi time= 5.6<s> temp= 750.0 ramprate= -44.0000
diffuse temp_ramp= oxi gas_flow= gasflow_gox
if { $debug } { WriteBND }

## ---------- High-k metal gate stack -----------------------
deposit HfO2 type= isotropic rate= {0.0015} time= 1.0 temperature= 500<C>

if { $debug } { WriteBND }
## ---------- poly silicon deposition and etching ---------------
icwb.create.mask layer.name= "GATE" name= POLY info= 1 polarity= negative
deposit material= {PolySilicon} type= anisotropic  rate= {1.0} time= $Tox+$TPoly temperature= 500<C>
photo mask= POLY thickness= 0.02
etch material= {PolySilicon} rate= {0.2} type= trapezoidal time= 1.0 angle= $Poly_Taper_Ang
strip Photoresist
if { $debug } { WriteBND }

etch material= {HfO2} type= anisotropic rate= {0.02} time= 1.01
#etch material= {HfO2} type= isotropic rate= {0.0001} time= 0.5
if { $debug } { WriteBND }

etch material= {Oxide} type= anisotropic rate= {0.01} time= 1.0 
etch material= {Silicon}  type= directional rate= {$SiRecess} time= 1 direction= { cos(3.14159*$SiRecess_Ang/180.) sin(3.14159*$SiRecess_Ang/180.) 0 }
if { $debug } { WriteBND }

## ---------- reoxidation -----------------------------------------
deposit material= {Oxide} type= isotropic  rate= {1.0} time= $PolyReox
if { $debug } { WriteBND }

temp_ramp name= polyreox time= 4.0<s> temp= 600.0 ramprate= 50.0000
temp_ramp name= polyreox time= 4.0<s> temp= 800.0 ramprate= 25.0000
temp_ramp name= polyreox time= 5.0<s> temp= 900.0 ramprate= 0.0000
temp_ramp name= polyreox time= 4.0<s> temp= 900.0 ramprate= -25.0000
temp_ramp name= polyreox time= 4.0<s> temp= 800.0 ramprate= -50.0000
diffuse temp_ramp= polyreox

if { $debug } { WriteBND }
## ---------- offset spacer deposition and etching -------------
deposit material= {Oxide} type= isotropic rate= {1.0} time= $LD_sp temperature= 500<C>
etch material= {Oxide} type= anisotropic rate= {0.0065} time= 1
etch material= {Silicon}  type= directional rate= {0.002} time=1 direction= { cos(3.14159*$SiRecess_Ang/180.) sin(3.14159*$SiRecess_Ang/180.) 0 }
if { $debug } { WriteBND }

## ---------- natural through-oxide from cleaning step ---------
deposit material= {Oxide} type= isotropic rate= {1.0} time= $NAT_ox temperature= 500<C>
if { $debug } { WriteBND }

#split Halo

##---------------------------------------------------------##
refinebox name= Channel  min= "-$Tox $Ymin"  max= "$XjSD $Lg2+$LspLD-$YjExt"\
	yrefine= "$f*0.005" xrefine= "$f*0.001 $f*0.005" Silicon add
#----------------------------------------------------------------------#
refinebox name= Halo  min= "0  $Lg2+$LspLD-$YjExt"  max= "$XjHalo/3.0  $Yspacer+$YjExt"  \
	yrefine= "$f*0.005" xrefine= "$f*0.005" Silicon add
refinebox name= Halo_poly  min= "-$TPoly 0.0"  max= "0.001 $Lg2"  \
	yrefine= "$f*$Lg2/4.0" xrefine= "$f*0.01" PolySilicon add


refinebox name= SDE_ext  min= "-$Tox  $Lg2+$LspLD-$YjExt"  max= "$XjExt/2.0  $Lg2+$LspLD+$YjExt"  \
	yrefine= "$f*0.0008" xrefine= "$f*0.0007"  Silicon add
	
refinebox name= SDE_depth  min= "0.0  $Lg2+$LspLD-$YjExt"  max= "$XjExt  $Yspacer+0.2"  \
	yrefine= "$f*0.002" xrefine= "$f*0.002"  Silicon add
#----------------------------------------------------------------------#
refinebox remesh
#----------------------------------------------------------------------#

## ---------- Halo implantation -----------------------
icwb.create.mask layer.name= "NACTIVE" name= PWELL info= 1 polarity= positive
photo mask= PWELL thickness= 1.5
#implant BF2 dose= 1.25e13 energy= 20.0 tilt= 25 rotation= 0
#implant BF2 dose= 1.25e13 energy= 20.0 tilt= 25 rotation= 90
#implant BF2 dose= 1.25e13 energy= 20.0 tilt= 25 rotation= 180
#implant BF2 dose= 1.25e13 energy= 20.0 tilt= 25 rotation= -90

implant BF2 dose= @HaloDose@ energy= @HaloEnergy@ tilt= 25 rotation= 0
implant BF2 dose= @HaloDose@ energy= @HaloEnergy@ tilt= 25 rotation= 90
implant BF2 dose= @HaloDose@ energy= @HaloEnergy@ tilt= 25 rotation= 180
implant BF2 dose= @HaloDose@ energy= @HaloEnergy@ tilt= 25 rotation= -90

strip Photoresist

## ---------- LDD implantation -----------------------
icwb.create.mask layer.name= "NACTIVE" name= PWELL info= 1 polarity= positive
photo mask= PWELL thickness= 1.5

#implant Arsenic dose= 4.0e15 energy= 2.0 tilt= 0.0

implant Arsenic dose= @LDDDose@ energy= @LDDEnergy@ tilt= 0.0

strip Photoresist

## ------------------------------------

#split SD

set SwNI 20e-3
## ---------- side wall spacer -----------------------------------
deposit material= {Oxide}   type= fill coord= 0.001 temperature= 500<C>
if { $debug } { WriteBND }
deposit material= {Nitride} type= isotropic  rate= {$SwNI} time= 1.0 temperature= 500<C>

#deposit material= {Oxide}   type= isotropic  rate= {$SwOX} time= 1.0 temperature= 500<C>
if { $debug } { WriteBND }
#etch material= {Oxide}   type= anisotropic rate= {$SwOX} time= 1.8

etch material= {Nitride} type= anisotropic rate= {$SwNI} time= 1.45
if { $debug } { WriteBND }
etch material= {Oxide}   type= anisotropic rate= 0.0016  time= 1.0
if { $debug } { WriteBND }

## ------------------------------------

deposit material= {Oxide} type= isotropic  rate= {$NAT_ox} time= 1.0 temperature= 500<C>
if { $debug } { WriteBND }

#------------------------------------------------------------#
refinebox name= HDD_lateral  min= "-0.001 $Lg2-0.015"  max= "2*$SiRecess+$XjSD+0.005  $Yspacer+0.2"  yrefine= "$f*0.004"  xrefine= "$f*0.002" Silicon add
refinebox remesh
#------------------------------------------------------------#

## ---------- HDD implantation -----------------------
icwb.create.mask layer.name= "NACTIVE" name= PWELL info= 1 polarity= positive
photo mask= PWELL thickness= 1.5

## Default HDDDose = 3.5e15

#implant Arsenic dose=1e15  energy= 13.0 tilt= 0.0 
implant Arsenic dose= @HDDDose@ energy= @HDDEnergy@ tilt= 0.0 

strip Photoresist

#split LA

##---------------SMT for nMOS-------------------
#if @[ string match "nMOS" @Type@]@
    ##Initialization for the Plasticity Model
       pdbSetDouble PolySilicon Mechanics ThExpCoeff  20e-6
       pdbSetDouble PolySilicon Mechanics FirstYield  5.0E10
       pdbSetDouble PolySilicon Mechanics Hardening.Modulus.Isotropic 1.0E10
    ## Turn on Plasticity Model
    pdbSetBoolean PolySilicon Mechanics IsPlastic 1
    
#endif

## -------Spike+laser annealing-----------------
temp_ramp name= spike time= 1.0<s> temp= 600 ramprate= 350.0
temp_ramp name= spike time= 0.2<s> temp= 950 ramprate= 0.0000
temp_ramp name= spike time= 1.5<s> temp= 950 ramprate= -233.33

diffuse stress.relax temp_ramp= spike info= 1 
struct tdr= n@node@_sd

source Laser.fps
diffuse laser temp= 600<C> time= 1.5<ms> stress.relax info= 1 write.temp.file= n@node@_LATemp

## Turn Off Plasticity Model
pdbSetBoolean PolySilicon Mechanics IsPlastic 0

#split Silicide

## ---------- Contact silicidation -----------------------
if { $debug } { WriteBND }
etch material= {Oxide} type= anisotropic rate= {$NAT_ox} time= 1.1
etch material= {Oxide} type= isotropic   rate= {0.0015}  time= 1.0
if { $debug } { WriteBND }

source Nisilicide.fps
etch material= {Silicon} type= isotropic rate= {0.0005} time= 1.01

deposit Nickel type= isotropic thickness= 0.015
if { $debug } { WriteBND }
    
    pdbSet Oxide_Silicon Arsenic TrappingRate_Silicon  {[Arr 1e-100 0.0]}
    diffuse time= 0.5<s> temp= 500<C> minT= 350<C> stress.relax
    strip Nickel
    
if { $debug } { WriteBND }

#if @[ string match "nMOS" @Type@]@
doping name= Stress_TensDSL field= Pressure depths= {-0.3 0.01} \
	values= { -1*$stress_tens_nmos_dsl_pa  -1*$stress_tens_nmos_dsl_pa }
deposit material= {Oxynitride} doping= {Stress_TensDSL} type= isotropic rate= 1.0 time= 0.08 steps= 20
#else
doping name= Stress_CompDSL field= Pressure depths= {-0.3 0.01} \
	values= { -1*$stress_comp_pmos_dsl_pa  -1*$stress_comp_pmos_dsl_pa }
deposit material= {Oxynitride} doping= {Stress_CompDSL} type= isotropic rate= 1.0 time= 0.08 steps= 20
#endif

diffuse stress.relax time= 1e-10 temp= 800

#split @DeviceMesh@

set Ymin  0.0
set SilYmax  [expr ($Ymin+0.2)]
set Xmin -0.05
set Xmax  0.6
#set Xepi  0.1
set Xepi  $SOI_depth
set Xbox  0.4
set lgate @lgate@
set Zmin -0.1
set Zmax 0.1

strip Oxynitride

## Quantum Zone :::
set Ydg [expr $Lg2-0.0039]
mater add name= SiDG new.like= Silicon alt.matername= Silicon

polygon name= DGBlock xy min= { 0.0 0.0 } max= { 0.050 $Ydg } rectangle
insert polygon= DGBlock replace.materials= { Silicon } new.material= SiDG new.region= SiDG_1

# Truncate bottom
transform !mesh.align cut location=  [expr ($Tbox+$SOI_depth+0.5)] down 

if { $debug } { WriteBND }

##------------------- Extruding to 3D --------------------##

line z location= $Zmin spac=0.01
line z location= $Zmax spac=0.01

grid 3D

mater add name = STIOxide new.like = Oxide
mater add name = OxideAsSemiconductor new.like = Silicon


polygon name= STIside_2D min= { 0.040 0.0 } max= { $Ymax $Zmin } rectangle
polyhedron name= STIside_3D polygons= STIside_2D min=-0.01 max= [expr ($Tbox+$SOI_depth)]

insert polyhedron = STIside_3D replace.materials= { "Silicon" "SiDG" "NickelSilicide"} new.material = "Gas"

if { $debug } { WriteBND }

insert polyhedron = STIside_3D replace.materials= { "Gas" } new.material = "OxideAsSemiconductor"

if { $debug } { WriteBND }

point name=pointA coord= {0.0 $Ymax $Zmin}
point name=pointB coord= {0.0 $Ymin $Zmin}
point name=pointC coord= {0.0 $Ymin 0.0043}
point name=pointD coord= {0.0 $Ymax 0.0043}
point name=pointE coord= {$SOI_depth $Ymax $Zmin}
point name=pointF coord= {$SOI_depth $Ymax 0.0}
point name=pointG coord= {$SOI_depth $Ymin 0.0}
point name=pointH coord= {$SOI_depth $Ymin $Zmin} 

polygon name=ABCD points= {pointA pointB pointC pointD}
polygon name=ADFE points= {pointA pointD pointF pointE}
polygon name=CDFG points= {pointC pointD pointF pointG}
polygon name=ABHE points= {pointA pointB pointH pointE}
polygon name=EFGH points= {pointE pointF pointG pointH}
polygon name=BCGH points= {pointB pointC pointG pointH}

polyhedron name= STIside_3D_angle polygons= {ABCD ADFE CDFG ABHE EFGH BCGH}

insert polyhedron = STIside_3D_angle replace.materials= { "STIOxide" "Silicon" "SiDG" "Oxide" } new.material = "OxideAsSemiconductor"

if { $debug } { WriteBND }

polyhedron name= BOXexpand_3D polygons= STIside_2D min=$SOI_depth max= [expr ($Tbox+$SOI_depth)]
insert polyhedron = BOXexpand_3D replace.materials= { "STIOxide" } new.material = "OxideAsSemiconductor"

if { $debug } { WriteBND }

polygon name= STIexpand_2D min= { 0.266 0.0 } max= { $Ymax $Zmax } rectangle
polyhedron name= STIexpand_3D polygons= STIexpand_2D min=-0.01 max= 0.15
insert polyhedron = STIexpand_3D replace.materials= { "Oxide" } new.material = "Gas"
insert polyhedron = STIexpand_3D replace.materials= { "Gas" } new.material = "OxideAsSemiconductor"

if { $debug } { WriteBND }

polygon name= BOXexpand_2D min= { -0.5 -0.1 } max= { 0.271 0.5 } rectangle
polyhedron name= BOXexpand_3D polygons= BOXexpand_2D min=0.0495 max= 0.15
insert polyhedron = BOXexpand_3D replace.materials= { "Oxide" } new.material = "Gas"
insert polyhedron = BOXexpand_3D replace.materials= { "Gas" } new.material = "OxideAsSemiconductor"

if { $debug } { WriteBND }

polygon name= WrapSD_2D min= { 0.0 -0.001 } max= { 0.271 0.005 } rectangle
polyhedron name= WrapSD_3D polygons= WrapSD_2D min=-0.002 max= 0.011
insert polyhedron = WrapSD_3D replace.materials= { "OxideAsSemiconductor" } new.material = "Gas"
insert polyhedron = WrapSD_3D replace.materials= { "Gas" } new.material = "Oxide"

if { $debug } { WriteBND }

## Z in sprocess is X in svisual (don't forget mirroring too)

polygon name= HfO2_2D min= { -0.039 0.00429 } max= { 0.039 -0.15 } rectangle
polyhedron name= HfO2_3D polygons= HfO2_2D min=-10 max=10 
##insert polyhedron = HfO2_3D replace.materials= { HfO2 } new.material = "Gas"
insert polyhedron = HfO2_3D replace.materials= { HfO2 Oxide } new.material = "OxideAsSemiconductor"

if { $debug } { struct bndfile= n@node@_STIOX_3 }

transform cut front loc = 0.05

if { $debug } { WriteBND }

##---------------Remeshing for device simulation--------##
# clear the process simulation mesh
refinebox clear
refinebox !keep.lines
line clear
# reset default settings for adaptive meshing
pdbSet Grid AdaptiveField Refine.Abs.Error 1e37
pdbSet Grid AdaptiveField Refine.Rel.Error 1e10
pdbSet Grid AdaptiveField Refine.Target.Length 100.0

# Set high quality delaunay meshes
pdbSet Grid sMesh 1
pdbSet Grid SnMesh DelaunayType boxmethod
pdbSet Grid SnMesh CoplanarityAngle 179
pdbSet Grid SnMesh MaxPoints 5000000
pdbSet Grid SnMesh MaxNeighborRatio 1e6

# Set the interface spacing
mgoals min.normal.size=0.01 normal.growth.ratio=8.0 max.box.angle=179.0

# Which interfaces are to have interface meshes
refinebox interface.materials= SiDG
# Doping based refinement
pdbSet Grid Adaptive 1

refinebox min.normal.size= 0.005 normal.growth.ratio= 2.5 \
interface.mat.pairs= { OxideAsSemiconductor Silicon }

##refinebox min.normal.size= 0.001 normal.growth.ratio= 1.8 \
##interface.mat.pairs= { OxideAsSemiconductor Oxide }

# adaptive meshing based on the gradient of the net active doping concentration
refinebox name= Substrate \
   min= "-0.1  $Ymin  0.0" \
   max= "$Xepi 0.3  $Zmax" \
   refine.max.edge= "0.05 0.1" \
   refine.min.edge= "0.01 0.05" \
   refine.fields= { NetActive } def.max.asinhdiff= 1.0 adaptive 

#refinements for SD
refinebox name= SD \
   min= "-0.001   $Ymin  0.0" \
   max= "$Xepi  $Ymax  $Zmax"  \
   refine.fields= { NetActive } def.max.asinhdiff= 1.0 \
   refine.max.edge= "0.025  $lgate/5.0" \
   refine.min.edge= "1.5e-3 $lgate/10.0" adaptive 

# refinements for Channel
refinebox name= LDD \
   min= "-0.001   $Ymin  0.0" \
   max= "($Xepi-$Tox)*0.55  $Lg2+0.02 $Zmax"  \
   refine.fields= { NetActive } def.max.asinhdiff= 1.0 \
   refine.max.edge= "0.025  $lgate/5.0" \
   refine.min.edge= "1.0e-3 $lgate/10.0" adaptive 

# refinements for channel-gate oxide interface
refinebox name= Interface \
   min= "-0.04  $Ymin  $Zmin" \
   max= "0.006  $Ymax  $Zmax" \
   min.normal.size= 1.0e-3 normal.growth.ratio= 1.5 \
   interface.mat.pairs= {SiDG Nitride SiDG Oxide} SiDG add
   
# refinements for BOX interface
refinebox name= BOXInterface \
   min= "0.045  $Ymin  0.0" \
   max= "0.055  $Ymax  $Zmax" \
   min.normal.size= 1e-3 normal.growth.ratio= 1.8 \
   interface.mat.pairs= {SiDG Oxide} 
   
# refinements for STI interface
refinebox name= STInterface \
   #min= "-0.01  -0.3  -0.002" \
   #max= "0.06  0.3  0.002" \
   min.normal.size= 1e-3 normal.growth.ratio= 1.8 \
   interface.mat.pairs= {OxideAsSemiconductor SiDG} 

# Refinement for Quantum Zone 
icwb.create.mask layer.name= "GATE" name= PG info= 1 polarity= positive
refinebox name= "SiDG_IF" mask= PG extend= 0.006 \
   extrusion.min= -0.004 extrusion.max= 0.006 \
   min.normal.size= 2.5e-4 normal.growth.ratio= 1.8 \
   interface.mat.pairs = {SiDG Oxide SiDG OxideAsSemiconductor} SiDG  
   
##Refinement for contact
##refinebox min = { -0.01 -1.0 -1.0 } max = { 0.01 1.0 1.0 } xrefine=0.001 OxideAsSemiconductor

refinebox remesh info= 2

transform reflect left

struct smesh= n@node@_withoutfront

transform reflect front

grid remesh

polygon name= Poly_2D min= { -$Zmax -$Ymax } max= { $Zmax $Ymax } rectangle
polyhedron name= Poly_3D polygons= Poly_2D min= $Xmin max= $Xmax
insert polyhedron = Poly_3D replace.materials= { "PolySilicon" } new.material = "Gas"

#contact name= "body"   box  Silicon adjacent.material= Oxide \
		#xlo= 0.09 xhi= 0.11 ylo= 0.01 yhi= 0.03

#contact name= "gate"   point  x= $Xmin+0.01 y= 0.0 PolySilicon
#contact name= "drain"  point  x= 0.001      y= $Ymax NickelSilicide
#contact name= "source" point  x= 0.001      y= -$Ymax NickelSilicide

##contact name= "gate"   point  region=PolySilicon_1

contact name= "gate" box HfO2 zlo=-0.2  zhi=0.2 ylo=-1.0  yhi=1.0 xlo=-0.1  xhi=0.1 adjacent.material= Gas
##contact name= "gate_2" box HfO2 zlo=0.1  zhi=0.2  ylo=-1.0  yhi=1.0 xlo=-1.0  xhi=1.0 adjacent.material= Gas
##contact name= "gate_3" box HfO2 zlo=-0.1  zhi=0.0  ylo=-1.0  yhi=1.0 xlo=-1.0  xhi=1.0 adjacent.material= Gas

contact name= "gate" box add Oxide zlo=-0.2  zhi=0.2  ylo=-0.01755  yhi=0.01755 xlo=-0.1  xhi=0.1 adjacent.material= Gas
contact name= "gate" box add OxideAsSemiconductor zlo=-0.2  zhi=0.2  ylo=-0.01755  yhi=0.01755 xlo=-0.1  xhi=0.1 adjacent.material= Gas
contact name= "gate" box add OxideAsSemiconductor zlo=-0.2  zhi=0.2  ylo=-0.01755  yhi=0.01755 xlo=-0.1  xhi=0.1 adjacent.material= Gas


contact name= "drain"  point  region=NickelSilicide_1.2
contact name= "source" point  region=NickelSilicide_1.1
contact name= "substrate" Silicon bottom
#contact add name= "substrate" STIOxide bottom		

struct smesh= n@node@
exit




