#-- NMOS Specification
#if @[string match @Type@ "nMOS"]@
#define _Device_ nmos
#define _cTemp_  eTemperature  
#define _DG_     eQuantumPotential
#define _Vdd_    @Vdd@	
#define _WF_     4.2
#define _Vg1_    0.36
#define _Vg2_    0.75
#define _Vddp_   @<Vdd+0.5>@
#-- PMOS Specfication
#else
#define _Device_ pmos
#define _cTemp_  hTemperature  
#define _DG_     hQuantumPotential
#define _WF_     4.8
#define _Vg1_    -0.5
#define _Vg2_    -1.0
#define _Vddp_   @<-1.0*Vdd-0.5>@
#endif


File {
  Grid      = "@tdr@"
  Parameter = "@parameter@"
  Plot      = "@tdrdat@"
  Current   = "@plot@"
  Output    = "@log@"
  Piezo     = "@tdr@"
}

Electrode {
  { Name= "source"    Voltage= 0.0 }
  { Name= "drain"     Voltage= 0.0 }
  { Name= "gate"      Voltage= 0.0 Workfunction= _WF_}
  { Name= "substrate" Voltage= 0.0 }
  
  ##if [string compare @Body@ "Tied"] == 0
  ##{ Name="body"   Voltage=0.0 }
  ##endif
  
}

Thermode {
  { Name="substrate" Temperature= 300 } 
  { Name="gate"      Temperature= 300 SurfaceResistance= 5.0e-5 }
  { Name="source"    Temperature= 300 SurfaceResistance= 1.0e-3 }
}

Physics{
  AreaFactor= 1
  Hydrodynamic( _cTemp_ )
  EffectiveIntrinsicDensity( OldSlotboom )
}

Physics (material="Silicon") {
  
  Mobility(
    PhuMob
    HighFieldSaturation
    Enormal( Lombardi_highk )
    )
  Recombination(
    SRH( DopingDep )
    Avalanche( CarrierTempDrive )
  )
  Piezo(
    Model(
      DeformationPotential
      Mobility(
         eSubBand(Doping)
         hSixBand(Doping)
      )
    )
  )
}

Physics( Region= "SiDG_1" ){
  _DG_           
}

Physics (MaterialInterface= "HfO2/Oxide"){
	Dipole ( Reference= "Oxide" )
}

Plot{
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap 
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  _DG_
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
}

Math {
  Extrapolate
  Derivatives
  Avalderivatives
  RelErrControl
  Digits= 5
  Notdamped= 50
  Iterations= 20
  DirectCurrent
  ExitOnFailure
  hDrForceRefDens= 1.e12
  eDrForceRefDens= 1.e12
  Number_of_Threads= 16
}

CurrentPlot{
  hQuasiFermiPotential( (@<lgate/2.0>@ 0.05) )
  eQuasiFermiPotential( (@<lgate/2.0>@ 0.05) )
} 

Solve {
  Coupled( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson _DG_ }
  Coupled{ Poisson Electron Hole }
  Coupled{ Poisson Electron Hole _cTemp_ }

  #-- Ramp gate to Vdd/2
  Quasistationary( 
    InitialStep= 1e-2 Increment= 1.2
    MinStep= 1e-6 MaxStep= 0.05 
    Goal { Name= "gate" Voltage= _Vg1_ } 
  ){ Coupled { Poisson _DG_ Electron Hole _cTemp_ } }
  Save ( FilePrefix= "n@node@_Vg1" )

  #-- Ramp gate to Vdd 
  Quasistationary( 
    InitialStep= 1e-2 Increment= 1.2
    MinStep= 1e-6 MaxStep= 0.05 
    Goal { Name= "gate" Voltage= _Vg2_ } 
  ){ Coupled { Poisson _DG_ Electron Hole _cTemp_ } }
  Save ( FilePrefix= "n@node@_Vg2" )

  #-- Vd sweep for Vg=Vdd/2
  NewCurrentFile= "IdVd_Vg1" 
  Load ( FilePrefix= "n@node@_Vg1" )
  Quasistationary( 
    DoZero 
    InitialStep= 1e-2 Increment= 1.2
    MinStep= 1e-8 MaxStep= 0.05 
    Goal { Name= "drain" Voltage= _Vddp_ } 
  ){ Coupled { Poisson _DG_ Electron Hole _cTemp_ Temperature } }

  #-- Vd sweep for Vg=Vdd
  NewCurrentFile= "IdVd_Vg2" 
  Load ( FilePrefix= "n@node@_Vg2" )
  Quasistationary( 
    DoZero 
    InitialStep= 1e-2 Increment= 1.2
    MinStep= 1e-8 MaxStep= 0.05
    Goal { Name= "drain" Voltage= _Vddp_ } 
  ){ Coupled { Poisson _DG_ Electron Hole _cTemp_ Temperature } }
}

