#setdep @previous@

#if @[string match @Type@ "nMOS"]@
  set ID NMOS
  #define SIGN   1.0
#else
  set ID PMOS
  #define SIGN  -1.0
#endif

  set STYLE dashed

if { [string match @lgate@ 1.00] } {
  set Lg 1um
} else {
  set Lg [expr int(1e3*@lgate@)]
  set Lg ${Lg}nm
}
 

puts "Gate Length: @lgate@"

#-- Id-Vd
#----------------------------------------------------------------------#
proj_load  IdVd_Vg1@plot@ Vg1(${ID}_@node@)
proj_load  IdVd_Vg2@plot@ Vg2(${ID}_@node@)

cv_createDS IdVd_Vg1(${ID}_@node@) \
 "Vg1(${ID}_@node@) drain OuterVoltage" "Vg1(${ID}_@node@) drain TotalCurrent" y
cv_abs IdVd_Vg1(${ID}_@node@) y
cv_setCurveAttr IdVd_Vg1(${ID}_@node@) "Vg = 1.2*Vt" \
  blue $STYLE 3 none 3 black 1 black

cv_createDS IdVd_Vg2(${ID}_@node@) \
 "Vg2(${ID}_@node@) drain OuterVoltage" "Vg2(${ID}_@node@) drain TotalCurrent" y
cv_abs IdVd_Vg2(${ID}_@node@) y
cv_setCurveAttr IdVd_Vg2(${ID}_@node@) "Vg = 2*Vt" \
  red $STYLE 3 none 3 black 1 black

gr_setTitleAttr "Node : @node@, $Lg $ID"
gr_setAxisAttr X  {Drain Voltage (V)}    14  {} {} black 1 14 0 5 0
gr_setAxisAttr Y  {Abs(Drain Current) (A/um)} 14  {} {} black 1 14 0 5 0

#-- Extract Ron
#----------------------------------------------------------------------#
load_library EXTRACT

set Ron [ExtractRon Ron IdVd_Vg2(${ID}_@node@) [expr @<0.6*SIGN*Vdd>@]]


