#setdep @previous@

#set Vtgm   x
#set VtiLin x
#set IdLin  x
#set SSlin  x
#set gmLin  x
#set IdSat  x
#set Ioff   x
#set VtiSat x
#set SSsat  x
#set gmSat  x
#set Ron    x
#set Cov    x
#set Con    x
#set Cj	    x

set N     @node@
set i     @node:index@
set Lg    @lgate@
set Vd    @Vdd@
set Vg    @Vgg@
if { [string match @Type@ "nMOS"] } {
  set Type nMOS
} else {
  set Type pMOS
}

puts "Gate Length: $Lg um"

set ID "$Type"
set N   ${Type}_${N}


#- INSPECT IdVg plotting
#----------------------------------------------------------------------#
# Plotting Id vs Vg curves
gr_setTitleAttr "IdVg Lg=$Lg $ID"

proj_load  IdVg_VdLin_@plot@ PLTLin($N)
proj_load  IdVg_VdSat_@plot@ PLTSat($N)

cv_createDS IdVgLin($N) \
 "PLTLin($N) gate OuterVoltage" "PLTLin($N) drain TotalCurrent" y
cv_abs IdVgLin($N) y
cv_setCurveAttr IdVgLin($N) "IdVg Vd=0.05" \
  blue solid 2 none 3 defcolor 1 defcolor


cv_createDS IdVgSat($N) \
 "PLTSat($N) gate OuterVoltage" "PLTSat($N) drain TotalCurrent" y
cv_abs IdVgSat($N) y
cv_setCurveAttr IdVgSat($N) "IdVg Vd=$Vd" \
  red solid 2 none 3 defcolor 1 defcolor

gr_setAxisAttr X  {Gate Voltage (V)}     12  {} {} black 1 10 0 5 0
gr_setAxisAttr Y  {Drain Current (A/um)} 12  {} {} black 1 10 0 5 1

#- Extraction
#----------------------------------------------------------------------#
load_library EXTRACT

#- Defining current level for Vti extraction
#----------------------------------------------------------------------#
set Io    [expr 0.1e-6/$Lg] ; # [A/um]
puts "Io= $Io"
if { $Type == "nMOS" } { set SIGN 1.0 } else { set SIGN -1.0 }


set Vtgm   [ExtractVtgmb Vtgm   IdVgLin($N) $Type]
set VtiLin [ExtractVti   VtiLin IdVgLin($N) $Io]
set IdLin  [ExtractMax   IdLin  IdVgLin($N)]
set SSlin  [ExtractSS    SSlin  IdVgLin($N) [expr $SIGN*1e-2]]
set gmLin  [ExtractGmb   gmLin  IdVgLin($N) $Type]

set VtiSat [ExtractVti   "VtiSat" IdVgSat($N) $Io]
set IdSat  [ExtractMax   "IdSat"  IdVgSat($N)]
set Ioff   [ExtractIoff  "Ioff"   IdVgSat($N) 0.0]
set SSsat  [ExtractSS    "SSsat"  IdVgSat($N) 0.0]
set gmSat  [ExtractGmb   "gmSat"  IdVgSat($N) $Type]


