#define _Device_ nmos
#define _cTemp_  eTemperature  	
#define _Vdd_    @Vdd@	
#define _VdLin_  0.05
#define _WF_     4.2


File {
  Grid      = "n@previous@_fps.tdr"
  Parameter = "@parameter@"
  Plot      = "@tdrdat@"
  Current   = "@plot@"
  Output    = "@log@"
  Piezo     = "n@previous@_fps.tdr"
}

Electrode {
  { Name="source"    Voltage= 0.0 }
  { Name="drain"     Voltage= 0.0 }
  { Name="gate"      Voltage= 0.0 Workfunction= _WF_}
  { Name="substrate" Voltage= 0.0 }
  #{ Name="body"      Voltage= 0.0 }
}

Thermode{
  { Name="substrate" Temperature= 300 } 
  { Name="gate"      Temperature= 300 SurfaceResistance= 5.0e-5 }
  { Name="source"    Temperature= 300 SurfaceResistance= 1.0e-3 }
}

Physics{
  AreaFactor= 1
  Temperature= 300
  Hydrodynamic( _cTemp_ )
  EffectiveIntrinsicDensity( OldSlotboom )
}

Physics (material= "Silicon") {
  Mobility(
    PhuMob
    HighFieldSaturation
    Enormal( Lombardi_highk )
    )
  Recombination(
    SRH( DopingDep )
    Avalanche( CarrierTempDrive )
  )
  Piezo(
    Model(
      DeformationPotential
      Mobility(
         eSubBand(Doping)
         hSixBand(Doping)
      )
    )
  )
}

Physics (region= "Oxide_1.1.1") {
	Traps(FixedCharge Conc=@pBOXCharge@)
}

Physics (region= "STIOxide_1") {
	Traps(FixedCharge Conc=@pSTICharge@)
}

Physics (MaterialInterface= "HfO2/Oxide"){
	Dipole ( Reference= "Oxide" )
}

Plot{
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap 
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
}


Math {
  CNormPrint
  Extrapolate
  Derivatives
  Avalderivatives
  RelErrControl
  Digits= 5
  Notdamped= 50
  Iterations= 20
  Method = ILS
  DirectCurrent
  *ExitOnFailure
  Number_of_Threads= 16
  hDrForceRefDens= 1.e12
  eDrForceRefDens= 1.e12
}

Solve {
  Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson } 
  Coupled { Poisson Electron Hole }
  Coupled { Poisson Electron Hole _cTemp_ }
  Save ( FilePrefix= "n@node@_init" )
  
  #-- Ramp drain to VdLin
  Quasistationary( 
    InitialStep= 1e-2 Increment= 1.35 
    MinStep= 1e-9 MaxStep= 0.5 
    Goal { Name="drain" Voltage= _VdLin_ } 
  ){ Coupled { Poisson Electron Hole _cTemp_ } }
  
  #-- Vg sweep for Vd=VdLin
  Quasistationary( 
    -DoZero 
    InitialStep= 1e-2 Increment= 1.1 
    MinStep= 1e-9 MaxStep= 0.5 
    Goal { Name= "gate" Voltage= _Vdd_ } 
  ){ Coupled { Poisson Electron Hole _cTemp_ } }
  
   Plot ( FilePrefix= "n@node@_Vdd" )
   NewCurrentFile= "IdVg_VdLin_" 
  
Quasistationary( 
    -DoZero 
    InitialStep= 1e-2 Increment= 1.1 
    MinStep= 1e-9 MaxStep= 0.5 
    Goal { Name= "gate" Voltage= 0 } 
  ){ Coupled { Poisson Electron Hole _cTemp_ } }
  
Plot ( FilePrefix= "n@node@_0V" )
  
}

