#setdep @previous@

#set Ioff   x

set i     @node:index@
set Lg    @lgate@

set Type nMOS

puts "Gate Length: $Lg um"

set N     @node@

set ID "$Type"
set N   ${Type}_${N}


#- INSPECT IdVg plotting
#----------------------------------------------------------------------#
# Plotting Id vs Vg curves
gr_setTitleAttr "IdVg Lg=$Lg $ID"

proj_load  IdVg_VdLin_@plot@ PLTLin($N)

cv_createDS IdVgLin($N) \
 "PLTLin($N) gate OuterVoltage" "PLTLin($N) drain TotalCurrent" y

gr_setAxisAttr X  {Gate Voltage (V)}     12  {} {} black 1 10 0 5 0
gr_setAxisAttr Y  {Drain Current (A/um)} 12  {} {} black 1 10 0 5 1

#- Extraction
#----------------------------------------------------------------------#
load_library EXTRACT

#- Defining current level for Vti extraction
#----------------------------------------------------------------------#

set Ioff   [ExtractIoff  "Ioff"   IdVgLin($N) 1e-4]
set Vtgm   [ExtractVtgmb "Vtgm"   IdVgLin($N) nMOS]
set IdSat  [ExtractMax   "IdSat"   IdVgLin($N)]

set SSlin  [ExtractSS    SSlin  IdVgLin($N) 1e-2]











