#setdep @previous@

#if @rolloff@ == 0
#noexec
#endif

#-- NMOS Specification
#if [string match @Type@ "nMOS"]
#define _Device_ nmos
#define _Vdd_    @Vdd@	
#define _VdLin_  0.05
#define _VdSat_ _Vdd_
set XMIN   "0.01"
set XMAX   "0.10"
set YMIN   "0.1"
set YMAX   "0.7"
#-- PMOS Specfication
#else
#define _Device_ pmos
#define _Vdd_   @<-1*Vdd>@
#define _VdLin_ -0.05
#define _VdSat_ _Vdd_
set XMIN   "0.01"
set XMAX   "0.10"
set YMIN   "-0.7"
set YMAX   "-0.1"
#endif
#----------------------------------------------------------------------#
# Plots threshold voltages (VtiLin,VtiSat), Drain induced barrier lowering (DIBL) as function of gate length
#----------------------------------------------------------------------#
#setdep @previous:all@
global CURVES
set CURVES  [list]

set N @node@
set TargetType @Type@ ;# nMOS or pMOS

set ID "$TargetType"
set Types   [list @Type:all@]
set Lgs     [list @lgate:all@]

set Vtgms   [list @Vtgm:all@]
set VtiLins [list @VtiLin:all@]


set Ions    [list @IdSat:all@]
set Ioffs   [list @Ioff:all@]

set Vdd     _VdSat_
set Vdlin   _VdLin_

#----------------------------------------------------------------------#
load_library EXTRACT
#----------------------------------------------------------------------#
set XYLists [FilterTable $Lgs $Vtgms $TargetType $Types]
set NAME  "Vtgm($N)"
set LABEL "Vtgm $TargetType"
cv_createFromScript $NAME [lindex $XYLists 0] [lindex $XYLists 1]  y
cv_display $NAME y
cv_setCurveAttr $NAME "$LABEL" \
	blue solid 2 circle 5 defcolor 1 defcolor

gr_setAxisAttr X {Gate Length (um)} {16} $XMIN $XMAX black 1 14 0 5 1
gr_setAxisAttr Y {Vt (V)}           {16} {}   {}     black 1 14 0 5 0

gr_setTitleAttr "Press Ctrl-C for next plot"
script_break
cv_delete $NAME
#----------------------------------------------------------------------#
set XYLists [FilterTable $Lgs $VtiLins $TargetType $Types]
set NAME  "VtiLin($N)"
set LABEL "VtiLin $TargetType"
cv_createFromScript $NAME [lindex $XYLists 0] [lindex $XYLists 1]  y
cv_display $NAME y
cv_setCurveAttr $NAME "$LABEL" \
	blue solid 2 circle 5 defcolor 1 defcolor

gr_setAxisAttr X  {Gate Length (um)} {16} $XMIN $XMAX black 1 14 0 5 1
gr_setAxisAttr Y  {Vt (V)}           {16} $YMIN $YMAX black 1 14 0 5 0

gr_setTitleAttr "Press Ctrl-C for next plot"
script_break
cv_delete $NAME
#----------------------------------------------------------------------#
set XYLists [FilterTable $Lgs $Ioffs $TargetType $Types]
set NAME  "Ioff($N)"
set LABEL "Ioff $TargetType"
cv_createFromScript $NAME [lindex $XYLists 0] [lindex $XYLists 1]  y
cv_display $NAME y
cv_setCurveAttr $NAME "$LABEL" \
	blue solid 2 circle 5 defcolor 1 defcolor

gr_setAxisAttr X {Gate Length (um)}     {16} $XMIN $XMAX black 1 14 0 5 1
gr_setAxisAttr Y {Drain Current (A/um)} {16} {}    {}  black 1 14 0 5 1

gr_setTitleAttr "Press Ctrl-C for next plot"
script_break
cv_delete $NAME
#----------------------------------------------------------------------#
set XYLists [FilterTable $Ions $Ioffs $TargetType $Types]
set NAME  "IoffIon($N)"
set LABEL "Ioff $TargetType"
cv_createFromScript $NAME [lindex $XYLists 0] [lindex $XYLists 1]  y
cv_display $NAME y
cv_setCurveAttr $NAME "$LABEL" \
	blue solid 2 circle 5 defcolor 1 defcolor



gr_setAxisAttr X {Ion  (A/um)} {16} {}      {} black 1 14 0 5 0
gr_setAxisAttr Y {Ioff (A/um)} {16} {1e-11} {} black 1 14 0 5 1



