#define _Device_ nmos
#define _cTemp_  eTemperature  	
#define _Vdd_    @Vdd@	
#define _VdLin_  0.05
#define _WF_     4.2

Device _Device_ {

File {
  Grid      = "n@previous@_msh.tdr"
  Parameter = "@parameter@"
  Plot      = "@tdrdat@"
  Current   = "@plot@"
  ##Output    = "@log@"
  Piezo     = "n@previous@_msh.tdr"
}

Electrode {
  { Name="source"    Voltage= 0.0 }
  { Name="drain"     Voltage= 0.0 }
  { Name="gate"      Voltage= 0.0 Workfunction= _WF_}
  { Name="substrate" Voltage= 0.0 }
  #{ Name="body"      Voltage= 0.0 }
}

Thermode{
  { Name="substrate" Temperature= 300 } 
  { Name="gate"      Temperature= 300 SurfaceResistance= 5.0e-5 }
  { Name="source"    Temperature= 300 SurfaceResistance= 1.0e-3 }
}

Physics{
  ##AreaFactor= 1
  Temperature= 300
  Hydrodynamic( _cTemp_ )
  EffectiveIntrinsicDensity( OldSlotboom )
  #if @globalIFM@ == 1
  	RandomizedVariation "var" (    Doping	)
  #endif	
}

#if @globalIFM@ == 0
Physics (region="SiDG_1") {
	  RandomizedVariation "var" ( Doping )
}
#endif

Physics (material= "Silicon") {
  Mobility(
    PhuMob
    HighFieldSaturation
    Enormal( Lombardi_highk )
    )
  Recombination(
    SRH( DopingDep )
    Avalanche( CarrierTempDrive )
  )
  Piezo(
    Model(
      DeformationPotential
      Mobility(
         eSubBand(Doping)
         hSixBand(Doping)
      )
    )
  )
}

Physics (region= "Oxide_1.1.1") {
	Traps(FixedCharge Conc=@pBOXCharge@)
}


Physics (regionInterface= "Oxide_1.1.1/Silicon_2.1") {
	Traps(Level Donor Conc=@Dpit@ fromValBand EnergyMid=@Et@ material="Silicon")
	Traps(Level Acceptor Conc=@Apit@ fromCondBand EnergyMid=@Et@ material="Silicon")
}

Physics (regionInterface= "Oxide_1.1.1/Silicon_2.2") {
	Traps(Level Donor Conc=@Dpit@ fromValBand EnergyMid=@Et@ material="Silicon")
	Traps(Level Acceptor Conc=@Apit@ fromCondBand EnergyMid=@Et@ material="Silicon")
}

Physics (regionInterface= "Oxide_1.1.1/SiDG_1") {
	Traps(Level Donor Conc=@Dpit@ fromValBand EnergyMid=@Et@ material="Silicon")
	Traps(Level Acceptor Conc=@Apit@ fromCondBand EnergyMid=@Et@ material="Silicon")
}



Physics (region= "STIOxide_1") {
	Traps(FixedCharge Conc=@pSTICharge@)
}

Physics (regionInterface= "STIOxide_1/Silicon_2.1") {
	Traps(Level Donor Conc=@Dpit@ fromValBand EnergyMid=@Et@ material="Silicon")
	Traps(Level Acceptor Conc=@Apit@ fromCondBand EnergyMid=@Et@ material="Silicon")
}

Physics (regionInterface= "STIOxide_1/Silicon_2.2") {
	Traps(Level Donor Conc=@Dpit@ fromValBand EnergyMid=@Et@ material="Silicon")
	Traps(Level Acceptor Conc=@Apit@ fromCondBand EnergyMid=@Et@ material="Silicon")
}

Physics (regionInterface= "STIOxide_1/SiDG_1") {
	Traps(Level Donor Conc=@Dpit@ fromValBand EnergyMid=@Et@ material="Silicon")
	Traps(Level Acceptor Conc=@Apit@ fromCondBand EnergyMid=@Et@ material="Silicon")
}


Physics (MaterialInterface= "HfO2/Oxide"){
	Dipole ( Reference= "Oxide" )
}

Plot{
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap 
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
  RandomizedDoping
}

}

File {
	Output=    "@log@"
	ACExtract= "@acplot@"
}

Math {
  CNormPrint
  Extrapolate
  Derivatives
  Avalderivatives
  RelErrControl
  Digits= 5
  Notdamped= 50
  Iterations= 20
  Method = ILS
  DirectCurrent
  *ExitOnFailure
  Number_of_Threads= 16
  hDrForceRefDens= 1.e12
  eDrForceRefDens= 1.e12
  
  RandomizedVariation "var" (
	NumberofSamples = @Samples@
	Randomize = 46005
	)
}

System {
	##nmos trans (gate=g source=s drain=d)
        Vsource_pset vg (ng 0) {dc=0}
	Vsource_pset vs (ns 0) {dc=0}
	Vsource_pset vd (nd 0) {dc=0}
	
	_Device_ mos ( "drain"= nd  "source"= ns "gate"= ng "substrate"= 0)
	Plot "n@node@_mos_circuit" (v(nd) v(ng) i(mos,nd) i(mos,ns))
	ACPlot (v(nd) v(ng) i(mos,nd) i(mos,ns))
}

Solve {
  Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson } 
  Coupled { Poisson Electron Hole }
  Coupled { Poisson Electron Hole _cTemp_ }
  
 #-- Ramp drain to VdLin
  Quasistationary( 
    	InitialStep= 1e-3 Increment= 1.4
	MinStep= 1e-6 MaxStep= 0.25
	Goal { Parameter= vd.dc  Voltage= 0.05 }
	Goal { Parameter= vg.dc   Voltage= -0.15 }
  ){ Coupled { Poisson Electron Hole _cTemp_ } }
  
  NewCurrentFile= "IdVg_VdLin_" 
  Plot ( FilePrefix= "n@node@_Vdd" )
  
	Quasistationary(
		DoZero
		InitialStep= 1e-3 Increment= 1.2
		MinStep= 1e-6 MaxStep= 0.1
		Goal { Parameter= vg.dc  Voltage= 1.15 }
	){ ACCoupled (
			StartFrequency= 0 EndFrequency= 0
			-VoltageGreenFunctions
			NumberOfPoints= 1 Decade
			Node(nd ng)
			ObservationNode(nd)
			Exclude(vd vg)
			ACExtract= "n@node@_mos"
			ACcompute(   Time=(Range=(0 1) Intervals= 26) )
		){ Poisson Electron Hole _cTemp_ }
		CurrentPlot( Time=(Range=(0 1) Intervals= 26) )
	}
  
Plot ( FilePrefix= "n@node@_0V" )
  
}




