#setdep @previous@

if { [string match @Type@ nMOS] } {
  set ID     NMOS
  set Vdd    @Vdd@
  set VdLin  0.05
  set VdSat  $Vdd 
  set Vg     $Vdd
  set delta  1e-4
} else {
  set ID     PMOS
  set Vdd   @<-1.0*Vdd>@
  set VdLin -0.05
  set VdSat  $Vdd 
  set Vg     $Vdd 
  set delta -1e-4
}

if { [string match @lgate@ 1.00] } {
  set Lg 1um
} else {
  set Lg [expr int(1e3*@lgate@)]
  set Lg ${Lg}nm
}

proj_load  CVg_@acplot@ CVg(${ID}_@node@)

cv_createDS Cdg(${ID}_@node@) "CVg(${ID}_@node@) NO_NODE v(g)" "CVg(${ID}_@node@) NO_NODE c(d,g)" y
cv_abs Cdg(${ID}_@node@) y

cv_createDS Csg(${ID}_@node@) "CVg(${ID}_@node@) NO_NODE v(g)" "CVg(${ID}_@node@) NO_NODE c(s,g)" y
cv_abs Csg(${ID}_@node@) y

cv_createWithFormula Ccg(${ID}_@node@) "<Csg(${ID}_@node@)>+<Cdg(${ID}_@node@)>" A A A A
cv_display Ccg(${ID}_@node@) y
cv_setCurveAttr Ccg(${ID}_@node@) "Ccg" red solid 3 none 5 black 1 black

cv_createDS Cgg(${ID}_@node@) "CVg(${ID}_@node@) NO_NODE v(g)" "CVg(${ID}_@node@) NO_NODE c(g,g)" y
cv_setCurveAttr Cgg(${ID}_@node@) "Cgg" blue solid 3 none 5 black 1 black

cv_delete Csg(${ID}_@node@)
cv_delete Cdg(${ID}_@node@)

cv_createDS Cbg(${ID}_@node@) "CVg(${ID}_@node@) NO_NODE v(g)" "CVg(${ID}_@node@) NO_NODE c(b,g)" y
cv_abs Cbg(${ID}_@node@) y
cv_setCurveAttr Cbg(${ID}_@node@) "Cbg" black solid 3 none 5 black 1 black

gr_setTitleAttr "Node : @node@, $Lg $ID"
gr_setAxisAttr X {Gate Voltage (V)} 14 {} {} black 1 14 0 5 0
gr_setAxisAttr Y {Capacitance  (F)} 14 {} {} black 1 14 0 5 0

#-- Cov
#----------------------------------------------------------------------#
set Cov [expr {0.5e15*[cv_compute "vecvaly(<Ccg(${ID}_@node@)>, 0)" A A A A ]}] 
ft_scalar Cov [format %.3f $Cov]
puts "Cov : $Cov fF/um/side\n"

#-- Con
#----------------------------------------------------------------------#
set Con [expr {1e15*[cv_compute "vecvaly(<Cgg(${ID}_@node@)>, $Vdd)" A A A A ]}] 
ft_scalar Con [format %.3f $Con]
puts "Con : $Con fF/um\n"

