#setdep @previous@

#set Ioff   x

set Lg    @lgate@
set Vg    @Vdd@

set Type nMOS

puts "Gate Length: $Lg um"

set ID "$Type"

set IVs [ list @node|-2:all@ ]


#- INSPECT IdVg plotting
#----------------------------------------------------------------------#
# Plotting Id vs Vg curves
gr_setTitleAttr "IdVg Lg=$Lg $ID"

#proj_load  IdVg_VdLin_@plot@ PLTLin($N)

foreach IV $IVs {
    if {$IV > 7524} { break }
    proj_load  IdVg_VdLin_n${IV}_des.plt PLTLin($IV)
    cv_createDS IdVgLin($IV) \
 "PLTLin($IV) gate OuterVoltage" "PLTLin($IV) drain TotalCurrent" y
   cv_abs IdVgLin($IV) y
   cv_setCurveAttr IdVgLin($IV) "Node $IV" \
  blue solid 1 none 3 defcolor 1 defcolor
  
  gr_setAxisAttr X  {Gate Voltage (V)}     12  {} {} black 1 10 0 5 0
  gr_setAxisAttr Y  {Drain Current (A/um)} 12  {} {} black 1 10 0 5 1
}

set Ioff   [ExtractIoff  "Ioff"   IdVgLin($N) 1e-4]
set Vtgm   [ExtractVtgmb "Vtgm"   IdVgLin($N) nMOS]


set SSlin  [ExtractSS    SSlin  IdVgLin($N) [expr $SIGN*1e-2]]

set VtiSat [ExtractVti   "VtiSat" IdVgSat($N) $Io]
set IdSat  [ExtractMax   "IdSat"  IdVgSat($N)]
set SSsat  [ExtractSS    "SSsat"  IdVgSat($N) [expr $SIGN*1e-2]]
set gmSat  [ExtractGmb   "gmSat"  IdVgSat($N) nMOS]







