load_library ifm
lib::SetInfoDef 1

set Nr  @Samples@
set N   @node@
set Mode lin
set nodeID n@node@NMOS

set jmin @jmin@ ;# Starting index for plotting curves
set jmax @jmax@ ;# Ending   index for plotting curves

set IVmethod  @Method@

set DCfile  IdVg_VdLin_n@previous@_mos_circuit_des.plt
set ACfile  IdVg_VdLin_n@previous@_mos_ac_des.plt
set FILE IdVg_VdLin_n@previous@_mos_var_I_nd.csv

set IoffLog10 1

set DEV   mos
set GATE  ng
set DRAIN nd

set sgn 1.0
set Vhi 1.0
set Vlo 0.0
set RANGE {0 1}

set jmin @jmin@ ;# Starting index for plotting curves
set jmax @jmax@ ;# Ending   index for plotting curves

set ID rdf

#----------------------------------------------------------------------#
# Plotting Reference IV curve
create_plot -1d -name RefIV
select_plots RefIV
set_plot_prop -plot RefIV -title "Reference IV (using \"$IVmethod\" method)" -title_font_size 16

load_file $DCfile -name DC
load_file $ACfile -name AC

create_variable -name Id -dataset DC \
	-function "-1*($sgn)*<i($DEV,$DRAIN):DC>"
create_variable -name Vg -dataset DC \
	-function "<v($GATE):DC>"
	
puts $DCfile
puts $ACfile

set adgs [get_variable_data a($DRAIN,$GATE) -dataset AC]

ifm::GetMOSWeights -out Ws -y $adgs

puts $Ws
puts $adgs

create_variable -name W -dataset DC -values $Ws


create_curve -name IVref -dataset DC \
	-axisX "Vg" -axisY "Id"
set_curve_prop IVref -label "Reference IV" \
	-color black -line_style solid  -line_width 2 -hide_markers

create_curve -name adg -dataset AC \
	-axisX "v($GATE)" -axisY "a($DRAIN,$GATE)"
set_curve_prop adg -plot RefIV -label "Transcond." \
	-color red -line_style solid  -line_width 2 -hide_markers

if { $IVmethod == "weighted" } {
	create_curve -name W -dataset DC \
		-axisX "Vg" -axisY2 "W"
	set_curve_prop W -plot RefIV -label "Weights" \
		-color green -line_style solid  -line_width 2 -hide_markers
		set_axis_prop -plot RefIV -axis y2 -title "Weight Factor (1)"
}

set_axis_prop -axis y  -title "Drain Current \[A\]" \
	-title_font_size 16 -scale_font_size 14
set_axis_prop -axis x  -title "Gate Voltage \[V\]"  -range $RANGE \
	-title_font_size 16 -scale_font_size 14

set Vgs [get_variable_data Vg -dataset DC]
set Ids [get_variable_data Id -dataset DC]

ifm::ReadsIFM -out sIFM -nrow Nrow -ncol Ncol -ids rdf -files $FILE

echo "Working on: $ID"
ifm::GetMOSIVs -out IV -sifm sIFM -nrow Nrow -ncol Ncol -method $IVmethod -sgn $sgn -v $Vgs -i $Ids -y $adgs -id $ID -smooth yes

puts "Extracting Vt and Idhig/low for randomized devices from index 0 to [expr $Nr-1] ..."
set Fou   [open ${nodeID}_${ID}_Pars.csv w]
puts $Fou "Vt,Idhig,Idlow"
set Vts [list]
set Idhigs [list]
set Idlows [list]
for {set j 0} {$j < $Nr} {incr j} {
	set FLAG 1
	ext::ExtractVti -out Vt -name noprint -v $IV(X,$j) -i $IV(Y,$j) -io 1e-7
	# puts "$j: Vt=$Vt"
	ext::ExtractValue -out Idhig -name noprint -x $IV(X,$j) -y $IV(Y,$j) -xo $Vhi
	# puts "$j: Idhig=$Idhig"
	ext::ExtractIoff -out Idlow -name noprint -v $IV(X,$j) -i $IV(Y,$j) -vo $Vlo -log10 $IoffLog10
	# puts "$j: Idlow=$Idlow"
	# echo ">$j) $ID: Vt=$Vt Idhig=$Idhig Idlow=$Idlow <"
	if { $Vt != "x" && $Idhig != "x" && $Idlow != "x" } {
		lappend Vts $Vt
		lappend Idhigs $Idhig
		lappend Idlows $Idlow
		puts $Fou "[format %.5e $Vt],[format %.5e $Idhig],[format %.5e $Idlow]"
	}
	if { [expr $j%50] == 0 } { puts $j }
}
close $Fou
puts "  ... done"

create_plot -1d -name $ID 
select_plots $ID 
set_plot_prop -plot $ID -title "[string toupper $ID]" -title_font_size 16  -hide_legend

puts "Plotting IV for randomized devices from index $jmin to $jmax ..."
for {set j $jmin} {$j < $jmax} {incr j} {
	create_variable -name V -dataset RanIV($ID,$j) -values $IV(X,$j)
	create_variable -name I -dataset RanIV($ID,$j) -values $IV(Y,$j)
	create_curve -name IV($j) -dataset RanIV($ID,$j) \
	-axisX "V" -axisY "I"
	set_curve_prop IV($j)  \
	-color blue -line_style solid  -line_width 1 -hide_markers
	if { [expr $j%10] == 0 } { puts $j }
}

create_curve -name IVref -dataset DC \
	-axisX "Vg" -axisY "Id"
set_curve_prop IVref -label "Reference IV" \
	-color black -line_style solid  -line_width 2 -hide_markers
set_axis_prop -plot $ID -axis x  -title "Gate Voltage \[V\]" \
	-range $RANGE -title_font_size 16 -scale_font_size 14
set_axis_prop -plot $ID -axis y  -title "Drain Current \[A\]" \
	-title_font_size 16 -scale_font_size 14

if { $IVmethod == "weighted" } {
	ifm::GetMoments -out Moments -rvs $Vts
	puts "DOE:  sig_Vt_${ID}_IV [format %.3f $Moments(std_dev)]"
}

if { $Mode == "lin" && $IVmethod == "weighted"} {
	ifm::GetMoments -out Moments -rvs $Idhigs
	puts "DOE:  sig_Ilin_${ID}_IV [format %.3e $Moments(std_dev)]"
} elseif { $Mode == "sat" && $IVmethod == "dI"}  {
	ifm::GetMoments -out Moments -rvs $Idhigs
	puts "DOE:  sig_Ion_${ID}_IV [format %.3e $Moments(std_dev)]"
} elseif { $Mode == "sat" && $IVmethod == "exp"}  {
	ifm::GetMoments -out Moments -rvs $Idlows
	puts "DOE:  sig_log10Ioff_${ID}_IV [format %.3e $Moments(std_dev)]"
}


puts "  ... done"



