load_library ifm
lib::SetInfoDef 0

set Nr   @Samples@
set DEV  mos
set Mode lin

set Vlo   0.0
set Sext  0.15
set Vhi   1.00
set RANGE [list 0 1]

#set Vt -1
#set sig_Vt_rdf_sIFM -1
#set sig_Vt_rdf_IV   -1

#set Ilin -1
#set sig_Ilin_rdf_sIFM -1
#set sig_Ilin_rdf_IV   -1

#set Ion -1
#set sig_Ion_rdf_sIFM -1
#set sig_Ion_rdf_IV   -1

#set log10Ioff -1
#set sig_log10Ioff_rdf_sIFM -1
#set sig_log10Ioff_rdf_IV   -1

set FileDC  IdVg_VdLin_n6376_mos_circuit_des.plt
set FileAC  IdVg_VdLin_n6376_mos_ac_des.plt

set ID   rdf
set COLORs [list red purple green blue black]
set FILE IdVg_VdLin_n6376_mos_var_I_nd.csv

set DEV   mos
set GATE  ng
set DRAIN nd

#----------------------------------------------------------------------#
load_file $FileDC -name DataDC
load_file $FileAC -name DataAC

#- Plotting the reference curves
#----------------------------------------------------------------------#
create_plot -1d -name RefIV
select_plots RefIV

create_variable -name Id -dataset DataDC \
	-function "abs(<i($DEV,$DRAIN):DataDC>)"
create_variable -name Vg -dataset DataDC \
	-function "<v($GATE):DataDC>"

create_curve -name IVref -dataset DataDC \
	-axisX "Vg" -axisY "Id"
set_curve_prop IVref  -label "Reference IV " \
	-color blue -line_style solid  -line_width 5 -hide_markers

set_plot_prop -plot RefIV -title "Reference IV"
set_axis_prop -plot RefIV -axis x  -title "Gate Voltage  \[V\]" \
	-title_font_size 16 -scale_font_size 14 -range $RANGE
set_axis_prop -plot RefIV -axis y  -title "Drain Current \[A\]" \
	-title_font_size 16 -scale_font_size 14 -type log

#- Accessing data sets: Y matrix elements and noise-spectral densities
#- and converting data to Tcl lists for procesing
#----------------------------------------------------------------------#
set Vgs         [get_variable_data Vg -dataset DataDC]
set Ids         [get_variable_data Id -dataset DataDC]
set adgs        [get_variable_data a($DRAIN,$GATE) -dataset DataAC]

#- Reference curve parameter extractions
#----------------------------------------------------------------------#
ext::ExtractVti -out Vt 	-name Vt   -v $Vgs -i $Ids -io 1e-7 -f %.3f
ext::ExtractIoff -out Ioff -name noprint -v $Vgs -i $Ids -vo $Vlo -log10 0

create_plot -1d -name Sig_Id
set_plot_prop -plot Sig_Id -hide_title

lib::SetInfoDef 1


# sIFM standard deviation computation
#----------------------------------------------------------------------#

ifm::GetsIFMStdDev -out sigIV -sIFM $FILE -y $adgs
set sigIds($ID) $sigIV(I)
	

lib::SetInfoDef 0

#- sIFM parameter extractions
#----------------------------------------------------------------------#


ext::ExtractValue -out sig_Ioff_sIFM -name noprint -x $Vgs -y $sigIds($ID)) -xo $Vlo


#- Plotting of IFM curves
#----------------------------------------------------------------------#
create_variable -name Vg -dataset sigs($ID) -values $Vgs
create_variable -name sigId($ID,stat) -dataset sigs($ID) -values $sigIds($ID,stat)
create_curve -name sigId($ID,stat) -plot Sig_Id -dataset sigs($ID) \
-axisX "Vg" -axisY "sigId($ID,stat)"
set_curve_prop sigId($ID,stat) -plot Sig_Id -label "$ID" \
-color $COLOR  -line_style solid  -line_width 5 -hide_markers


set_axis_prop -plot Sig_Id -axis x  -title "Gate Voltage \[V\]" \
	-title_font_size 16 -scale_font_size 14 -range $RANGE
set_axis_prop -plot Sig_Id -axis y  -title "Standard Deviations Drain Current \[A\]"\
	-title_font_size 16 -scale_font_size 14 -type log
set_legend_prop -plot Sig_Id -color_fg white -label_font_size 14




