set inp n@previous@_sano@pnum@_msh.tdr
set out n@node@_fps.tdr
set diff @pdiff@

TdrFileOpen $inp

# loop through geometries
  set ng [TdrFileGetNumGeometry $inp]
  puts "#geometries: $ng" 
   
  set ig 0 
  
  set ns [TdrGeometryGetNumState $inp $ig]
  set nr [TdrGeometryGetNumRegion $inp $ig]
  
  puts "#DatasetStates: $ns"
  puts "#DatasetRegions: $nr"
  
  # loop through states
    for {set is 0} {$is < $ns} {incr is} {
    # loop through regions    
      for {set ir 0} {$ir < $nr} {incr ir} {
      
      set nregion [TdrRegionGetName $inp $ig $ir]
      puts "#RegionName: $nregion"
      
      if {$nregion == "SiDG_1"} {
      
      # loop through datasets
        set nd [TdrRegionGetNumDataset $inp $ig $ir $is]
        for {set id 0} {$id < $nd} {incr id} {
        
        set name [TdrDatasetGetName $inp $ig $ir $is $id]
        puts "#DatasetName: $name"
        if {$name == "NetActive"} {     
                 
        # loop through data values
          set nv [TdrDatasetGetNumValue $inp $ig $ir $is $id]
         for {set iv 0} {$iv < $nv} {incr iv} {
          # loop through components of the data value
            set ni [TdrDataGetNumRow $inp $ig $ir $is $id $iv]
            set nj [TdrDataGetNumCol $inp $ig $ir $is $id $iv]
            for {set i 0} {$i < $ni} {incr i} {
              for {set j 0} {$j < $nj} {incr j} {
                set original [TdrDataGetComponent $inp $ig $ir $is $id $iv $i $j]
                set modified [expr $original + $diff]
                TdrDataSetComponent $inp $ig $ir $is $id $iv $i $j $modified
                }
              }
            }
          }
        }
      }
    }
  }
TdrFileSave $inp $out
TdrFileClose $inp


