set terminal pslatex 
set xlabel '$E_\mathrm{b}/N_0$ (dB)'
set ylabel 'SER' offset .5,0
set size 1,1.1
set logscale y
set format y '$10^{%L}$'
set yrange[0.000001:1]
set output 'ser-paper.tex'
eta = 0.762
capacity = 0.84
set key bottom  width 0 noautotitles  opaque
set xrange[1.5 : 4 ]
#set xrange[0.5 : 2 ]
#set arrow from capacity,0.002 to capacity,0.9 nohead
#set label 2 "Capacity bound"   at capacity-0.08,0.002 rotate left
#set title 'Title'
#set y2tics


plot 'results_data.dat' using ($1-10*log10(eta)):($2==0) ? NaN : $2 with linespoints lc rgb'black' ps 1 lt 1 pt 4 title '\footnotesize Proposed fixed point SE Max-Log-BCJR UEC scheme', \
'results_data.dat' using ($5-10*log10(eta)):($6==0) ? NaN : $6 with linespoints lc rgb'black' ps 1 lt 1 pt 1      title '\footnotesize Fixed point Max-Log-BCJR UEC benchmarker', \
'results_data.dat' using ($7-10*log10(eta)):($8==0) ? NaN : $8 with linespoints lc rgb'black' ps 1 lt 1 pt 2      title '\footnotesize Floating point SE Max-Log-BCJR UEC benchmarker', \
'results_data.dat' using ($3-10*log10(eta)):($4==0) ? NaN : $4 with linespoints lc rgb'black' ps 1 lt 1 pt 5    title '\footnotesize Floating point Log-BCJR UEC benchmarker', \
'results_data.dat' using ($11-10*log10(eta)):($12==0) ? NaN : $12 with linespoints lc rgb'black' ps 1 lt 1 pt 3      title '\footnotesize Floating point Log-BCJR EG-CC-Turbo benchmarker'
