
MY_DIR=`dirname $0`

source $MY_DIR/includeExp.sh
IS_ON_IRIDIS=1;

MAIN_DIRECTORY="experiments/optimLocalBroadcaster";
RUN_LENGTH=3600;
ROBOT_CONTROLLER_TYPE="localBroadcaster";
NUM_OF_ROBOTS=25;
WHEELS_NOIZE=1.5;


echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT optimSolitary STARTED "

#-- setup main directory
if [ -d $MAIN_DIRECTORY ]; then
    echo ""
else
    mkdir $MAIN_DIRECTORY
fi


for NEIGHBOURHOOD_SEARCH_RADIUS in 1 2 3 4
do
    for NEIGHBOURHOOD_SEARCH_TIME in 60 180 300
    do
        for ENVIRONMENT_ID in "${ENVIRONMENTS[@]}"
        do
            DEFAULT_TASK_TYPE="COLLECT";
            setupEnvironment;
            ROBOT_CONTROLLER_SUBTYPE="NR${NUM_OF_ROBOTS}_wheelsNoize${WHEELS_NOIZE}_searchRad${NEIGHBOURHOOD_SEARCH_RADIUS}_searchT${NEIGHBOURHOOD_SEARCH_TIME}"
            runExperiment50;

            wait;

        done

    done

done

echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT optimSolitary ENDED "
echo ""
