
function prepareDirectory() {
    EXPERIMENT_DIRECTORY="${DEFAULT_TASK_TYPE}_RT${MIN_ROBOTS_FOR_TASK}-${MAX_ROBOTS_FOR_TASK}_${ENVIRONMENT_NAME}_${ROBOT_CONTROLLER_TYPE}_${ROBOT_CONTROLLER_SUBTYPE}";
    if [ -d $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY ]; then
        echo ""
    else
        mkdir $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY;
    fi
}

function prepareArgosFile() {
    #-- decide on folder and extension, linux compiles .so files, but mac does .dylib
    if [ $IS_ON_IRIDIS -eq 1 ]; then
        EXECUTABLE_EXTENSION="so";
        EXECUTABLE_FOLDER="/home/lp2g12/taskDiscovery/buildExec";
    fi

    #-- create the argos config file
    OUTPUT_FILE_NAME_PREFIX="$MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/Run$RUN_NO";

    sed -e "s^\[OUTPUT_FILE_NAME_PREFIX\]^$OUTPUT_FILE_NAME_PREFIX^g;\
    s^\[RUN_LENGTH\]^$RUN_LENGTH^g;\
    s^\[RANDOM_SEED\]^$RANDOM_SEED^g;\
    s^\[EXECUTABLE_FOLDER\]^$EXECUTABLE_FOLDER^g;\
    s^\[EXECUTABLE_EXTENSION\]^$EXECUTABLE_EXTENSION^g;\
    s^\[WHEELS_NOIZE\]^$WHEELS_NOIZE^g;\
    s^\[RANGE_AND_BEARING_SENSOR_NOIZE\]^$RANGE_AND_BEARING_SENSOR_NOIZE^g;\
    s^\[STEERING_SENSOR_NOIZE\]^$STEERING_SENSOR_NOIZE^g;\
    s^\[IS_ON_IRIDIS\]^$IS_ON_IRIDIS^g;\
    s^\[CART_CAPACITY\]^$CART_CAPACITY^g;\
    s^\[LOAD_TIME_PER_VOLUME_UNIT\]^$LOAD_TIME_PER_VOLUME_UNIT^g;\
    s^\[UNLOAD_TIME_PER_VOLUME_UNIT\]^$UNLOAD_TIME_PER_VOLUME_UNIT^g;\
    s^\[DEFAULT_TASK_TYPE\]^$DEFAULT_TASK_TYPE^g;\
    s^\[TASK_GRADIENT_RADIUS\]^$TASK_GRADIENT_RADIUS^g;\
    s^\[NUM_OF_TASKS\]^$NUM_OF_TASKS^g;\
    s^\[TASK_MIN_DISTANCE_FROM_BASE\]^$TASK_MIN_DISTANCE_FROM_BASE^g;\
    s^\[TASK_MAX_DISTANCE_FROM_BASE\]^$TASK_MAX_DISTANCE_FROM_BASE^g;\
    s^\[TASK_DISAPPEAR_RATE\]^$TASK_DISAPPEAR_RATE^g;\
    s^\[TASK_RENEWABILITY_THRESHOLD\]^$TASK_RENEWABILITY_THRESHOLD^g;\
    s^\[TASK_APPEAR_RATE\]^$TASK_APPEAR_RATE^g;\
    s^\[TASK_APPEAR_TIME\]^$TASK_APPEAR_TIME^g;\
    s^\[TASK_VALUE_CHANGE_RATE\]^$TASK_VALUE_CHANGE_RATE^g;\
    s^\[EVENLY_SPACED_TASKS\]^$EVENLY_SPACED_TASKS^g;\
    s^\[ROBOT_CONTROLLER_TYPE\]^$ROBOT_CONTROLLER_TYPE^g;\
    s^\[NUM_OF_ROBOTS\]^$NUM_OF_ROBOTS^g;\
    s^\[TASK_VOLUME\]^$TASK_VOLUME^g;\
    s^\[TASK_RADIUS\]^$TASK_RADIUS^g;\
    s^\[TASK_MASS\]^$TASK_MASS^g;\
    s^\[MIN_ROBOTS_FOR_TASK\]^$MIN_ROBOTS_FOR_TASK^g;\
    s^\[MAX_ROBOTS_FOR_TASK\]^$MAX_ROBOTS_FOR_TASK^g;\
    s^\[NEIGHBOURHOOD_SEARCH_RADIUS\]^$NEIGHBOURHOOD_SEARCH_RADIUS^g;\
    s^\[NEIGHBOURHOOD_SEARCH_TIME\]^$NEIGHBOURHOOD_SEARCH_TIME^g;\
    s^\[USE_OPPORTUNISM\]^$USE_OPPORTUNISM^g;\
    s^\[OPPORTUNISM_THRESHOLD\]^$OPPORTUNISM_THRESHOLD^g;\
    s^\[USE_REL_UTILITY\]^$USE_REL_UTILITY^g;\
    s^\[S_MAX_TEAM_SIZE_UNCHANGED_TIME\]^$S_MAX_TEAM_SIZE_UNCHANGED_TIME^g;\
    s^\[LB_MAX_TEAM_SIZE_UNCHANGED_TIME\]^$LB_MAX_TEAM_SIZE_UNCHANGED_TIME^g;\
    s^\[LB_SIGNAL_DISTANCE\]^$LB_SIGNAL_DISTANCE^g;\
    s^\[BR_SIGNAL_DISTANCE\]^$BR_SIGNAL_DISTANCE^g;\
    s^\[BR_MAX_WAGGLE_DANCE_TIME\]^$BR_MAX_WAGGLE_DANCE_TIME^g;\
    s^\[BR_SCOUTING_PROB\]^$BR_SCOUTING_PROB^g;\
    s^\[BR_MAX_SCOUTING_TIME\]^$BR_MAX_SCOUTING_TIME^g;\
    s^\[BR_MAX_TEAM_SIZE_UNCHANGED_TIME\]^$BR_MAX_TEAM_SIZE_UNCHANGED_TIME^g;\
    s^\[BR_USE_REL_EE\]^$BR_USE_REL_EE^g;\
    " \
    experiments/$ARGOS_FILE_NAME > $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos
}

function runExperimentTest() {
    prepareDirectory;
    for RUN_NO in `seq 0 9`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &

        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            echo ""
        else
            if [ $RUN_NO -eq 4 ] || [ $RUN_NO -eq 9 ] ; then
                wait
            fi
        fi
    done
}

function runExperiment50() {
    prepareDirectory;
    for RUN_NO in `seq 0 49`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- iridis can execute up to 16 at a time
            if [ $RUN_NO -eq 14 ] || [ $RUN_NO -eq 29 ] || [ $RUN_NO -eq 39 ] || [ $RUN_NO -eq 49 ] ; then
#if [ $RUN_NO -eq 29 ] || [ $RUN_NO -eq 49 ] ; then
                wait
            fi
        else
            #-- not on iridis, execute 3/4 at a time
            if [ $RUN_NO -eq 3 ] || [ $RUN_NO -eq 7 ] || [ $RUN_NO -eq 11 ] || [ $RUN_NO -eq 15 ] || [ $RUN_NO -eq 19 ] || [ $RUN_NO -eq 23 ] || [ $RUN_NO -eq 27 ] || [ $RUN_NO -eq 31 ] || [ $RUN_NO -eq 35 ] || [ $RUN_NO -eq 39 ] || [ $RUN_NO -eq 42 ] || [ $RUN_NO -eq 45 ] || [ $RUN_NO -eq 49 ]; then
                wait
            fi

        fi
    done
}

function runExperiment50b() {
    prepareDirectory;
    for RUN_NO in `seq 50 99`;
    do
        prepareArgosFile;
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- run the experiment in the background
            echo "----- $OUTPUT_FILE_NAME_PREFIX";
            argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &

            #-- iridis can execute up to 16 at a time, but execute slightly more for balance
            if [ $RUN_NO -eq 66 ] || [ $RUN_NO -eq 82 ] || [ $RUN_NO -eq 99 ] ; then
                wait
            fi
        fi
    done
}

function runExperiment100() {
    prepareDirectory;
    for RUN_NO in `seq 0 99`;
    do
        prepareArgosFile;
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- run the experiment in the background
            echo "----- $OUTPUT_FILE_NAME_PREFIX";
            argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &

            #-- iridis can execute up to 16 at a time, but execute slightly more for balance
            if [ $RUN_NO -eq 16 ] || [ $RUN_NO -eq 33 ] || [ $RUN_NO -eq 48 ] || [ $RUN_NO -eq 66 ] || [ $RUN_NO -eq 82 ] || [ $RUN_NO -eq 99 ] ; then
                wait
            fi
        fi
    done
}

function runExperiment10() {
    prepareDirectory;

    for RUN_NO in `seq 0 9`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $MAIN_DIRECTORY/$EXPERIMENT_DIRECTORY/settingsRun$RUN_NO.argos &
        if [ $IS_ON_IRIDIS -eq 1 ] ; then
            #-- iridis can execute 10 at a time
            if [ $RUN_NO -eq 9 ] ; then
                wait
            fi
        else
            #-- not on iridis, execute 3/4 at a time
            if [ $RUN_NO -eq 2 ] || [ $RUN_NO -eq 5 ] || [ $RUN_NO -eq 9 ] ; then
                wait
            fi
        fi
    done
}

function setupEnvironment() {
#--------- group 1: normal
    if [ $ENVIRONMENT_ID -eq 1 ]; then
        ENVIRONMENT_NAME="group1-8";
        NUM_OF_TASKS=1;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=8;
        TASK_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 2 ]; then
        ENVIRONMENT_NAME="group1-10";
        NUM_OF_TASKS=1;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=10;
        TASK_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 3 ]; then
        ENVIRONMENT_NAME="group1-12";
        NUM_OF_TASKS=1;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=12;
        TASK_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 4 ]; then
        ENVIRONMENT_NAME="group1-14";
        NUM_OF_TASKS=1;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=14;
        TASK_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 5 ]; then
        ENVIRONMENT_NAME="group1-16";
        NUM_OF_TASKS=1;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=16;
        TASK_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 6 ]; then
        ENVIRONMENT_NAME="group1-18";
        NUM_OF_TASKS=1;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=18;
        TASK_MAX_DISTANCE_FROM_BASE=18.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 7 ]; then
        ENVIRONMENT_NAME="group1-20";
        NUM_OF_TASKS=1;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=20;
        TASK_MAX_DISTANCE_FROM_BASE=20.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 8 ]; then
        ENVIRONMENT_NAME="group1-22";
        NUM_OF_TASKS=1;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=22;
        TASK_MAX_DISTANCE_FROM_BASE=22.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 9 ]; then
        ENVIRONMENT_NAME="group1-24";
        NUM_OF_TASKS=1;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=24;
        TASK_MAX_DISTANCE_FROM_BASE=24.1;
        EVENLY_SPACED_TASKS="true";


#--------- group 2: normal
    elif [ $ENVIRONMENT_ID -eq 11 ]; then
        ENVIRONMENT_NAME="group2-8";
        NUM_OF_TASKS=2;
        TASK_VOLUME=50;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=8;
        TASK_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 12 ]; then
        ENVIRONMENT_NAME="group2-10";
        NUM_OF_TASKS=2;
        TASK_VOLUME=50;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=10;
        TASK_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 13 ]; then
        ENVIRONMENT_NAME="group2-12";
        NUM_OF_TASKS=2;
        TASK_VOLUME=50;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=12;
        TASK_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 14 ]; then
        ENVIRONMENT_NAME="group2-14";
        NUM_OF_TASKS=2;
        TASK_VOLUME=50;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=14;
        TASK_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 15 ]; then
        ENVIRONMENT_NAME="group2-16";
        NUM_OF_TASKS=2;
        TASK_VOLUME=50;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=16;
        TASK_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 16 ]; then
        ENVIRONMENT_NAME="group2-18";
        NUM_OF_TASKS=2;
        TASK_VOLUME=50;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=18;
        TASK_MAX_DISTANCE_FROM_BASE=18.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 17 ]; then
        ENVIRONMENT_NAME="group2-20";
        NUM_OF_TASKS=2;
        TASK_VOLUME=50;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=20;
        TASK_MAX_DISTANCE_FROM_BASE=20.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 18 ]; then
        ENVIRONMENT_NAME="group2-22";
        NUM_OF_TASKS=2;
        TASK_VOLUME=50;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=22;
        TASK_MAX_DISTANCE_FROM_BASE=22.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 19 ]; then
        ENVIRONMENT_NAME="group2-24";
        NUM_OF_TASKS=2;
        TASK_VOLUME=50;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=24;
        TASK_MAX_DISTANCE_FROM_BASE=24.1;
        EVENLY_SPACED_TASKS="true";

#--------- group 4: normal
    elif [ $ENVIRONMENT_ID -eq 21 ]; then
        ENVIRONMENT_NAME="group4-8";
        NUM_OF_TASKS=4;
        TASK_VOLUME=25;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=8;
        TASK_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 22 ]; then
        ENVIRONMENT_NAME="group4-10";
        NUM_OF_TASKS=4;
        TASK_VOLUME=25;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=10;
        TASK_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 23 ]; then
        ENVIRONMENT_NAME="group4-12";
        NUM_OF_TASKS=4;
        TASK_VOLUME=25;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=12;
        TASK_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 24 ]; then
        ENVIRONMENT_NAME="group4-14";
        NUM_OF_TASKS=4;
        TASK_VOLUME=25;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=14;
        TASK_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 25 ]; then
        ENVIRONMENT_NAME="group4-16";
        NUM_OF_TASKS=4;
        TASK_VOLUME=25;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=16;
        TASK_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 26 ]; then
        ENVIRONMENT_NAME="group4-18";
        NUM_OF_TASKS=4;
        TASK_VOLUME=25;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=18;
        TASK_MAX_DISTANCE_FROM_BASE=18.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 27 ]; then
        ENVIRONMENT_NAME="group4-20";
        NUM_OF_TASKS=4;
        TASK_VOLUME=25;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=20;
        TASK_MAX_DISTANCE_FROM_BASE=20.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 28 ]; then
        ENVIRONMENT_NAME="group4-22";
        NUM_OF_TASKS=4;
        TASK_VOLUME=25;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=22;
        TASK_MAX_DISTANCE_FROM_BASE=22.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 29 ]; then
        ENVIRONMENT_NAME="group4-24";
        NUM_OF_TASKS=4;
        TASK_VOLUME=25;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=24;
        TASK_MAX_DISTANCE_FROM_BASE=24.1;
        EVENLY_SPACED_TASKS="true";

#--------- rand 25: normal
    elif [ $ENVIRONMENT_ID -eq 31 ]; then
        ENVIRONMENT_NAME="rand25-8";
        NUM_OF_TASKS=25;
        TASK_VOLUME=4;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=4;
        TASK_MAX_DISTANCE_FROM_BASE=8;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 32 ]; then
        ENVIRONMENT_NAME="rand25-10";
        NUM_OF_TASKS=25;
        TASK_VOLUME=4;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=5;
        TASK_MAX_DISTANCE_FROM_BASE=10;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 33 ]; then
        ENVIRONMENT_NAME="rand25-12";
        NUM_OF_TASKS=25;
        TASK_VOLUME=4;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=7;
        TASK_MAX_DISTANCE_FROM_BASE=12;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 34 ]; then
        ENVIRONMENT_NAME="rand25-14";
        NUM_OF_TASKS=25;
        TASK_VOLUME=4;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=9;
        TASK_MAX_DISTANCE_FROM_BASE=14;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 35 ]; then
        ENVIRONMENT_NAME="rand25-16";
        NUM_OF_TASKS=25;
        TASK_VOLUME=4;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=11;
        TASK_MAX_DISTANCE_FROM_BASE=16;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 36 ]; then
        ENVIRONMENT_NAME="rand25-18";
        NUM_OF_TASKS=25;
        TASK_VOLUME=4;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=13;
        TASK_MAX_DISTANCE_FROM_BASE=18;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 37 ]; then
        ENVIRONMENT_NAME="rand25-20";
        NUM_OF_TASKS=25;
        TASK_VOLUME=4;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=15;
        TASK_MAX_DISTANCE_FROM_BASE=20;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 38 ]; then
        ENVIRONMENT_NAME="rand25-22";
        NUM_OF_TASKS=25;
        TASK_VOLUME=4;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=17;
        TASK_MAX_DISTANCE_FROM_BASE=22;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 39 ]; then
        ENVIRONMENT_NAME="rand25-24";
        NUM_OF_TASKS=25;
        TASK_VOLUME=4;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=19;
        TASK_MAX_DISTANCE_FROM_BASE=24;
        EVENLY_SPACED_TASKS="false"


    #--------- group 2: big volumes
    elif [ $ENVIRONMENT_ID -eq 41 ]; then
        ENVIRONMENT_NAME="groupBig2-8";
        NUM_OF_TASKS=2;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=8;
        TASK_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 42 ]; then
        ENVIRONMENT_NAME="groupBig2-10";
        NUM_OF_TASKS=2;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=10;
        TASK_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 43 ]; then
        ENVIRONMENT_NAME="groupBig2-12";
        NUM_OF_TASKS=2;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=12;
        TASK_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 44 ]; then
        ENVIRONMENT_NAME="groupBig2-14";
        NUM_OF_TASKS=2;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=14;
        TASK_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 45 ]; then
        ENVIRONMENT_NAME="groupBig2-16";
        NUM_OF_TASKS=2;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=16;
        TASK_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 46 ]; then
        ENVIRONMENT_NAME="groupBig2-18";
        NUM_OF_TASKS=2;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=18;
        TASK_MAX_DISTANCE_FROM_BASE=18.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 47 ]; then
        ENVIRONMENT_NAME="groupBig2-20";
        NUM_OF_TASKS=2;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=20;
        TASK_MAX_DISTANCE_FROM_BASE=20.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 48 ]; then
        ENVIRONMENT_NAME="groupBig2-22";
        NUM_OF_TASKS=2;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=22;
        TASK_MAX_DISTANCE_FROM_BASE=22.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 49 ]; then
        ENVIRONMENT_NAME="groupBig2-24";
        NUM_OF_TASKS=2;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=24;
        TASK_MAX_DISTANCE_FROM_BASE=24.1;
        EVENLY_SPACED_TASKS="true";

    #--------- group 4: big volumes
    elif [ $ENVIRONMENT_ID -eq 51 ]; then
        ENVIRONMENT_NAME="groupBig4-8";
        NUM_OF_TASKS=4;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=8;
        TASK_MAX_DISTANCE_FROM_BASE=8.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 52 ]; then
        ENVIRONMENT_NAME="groupBig4-10";
        NUM_OF_TASKS=4;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=10;
        TASK_MAX_DISTANCE_FROM_BASE=10.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 53 ]; then
        ENVIRONMENT_NAME="groupBig4-12";
        NUM_OF_TASKS=4;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=12;
        TASK_MAX_DISTANCE_FROM_BASE=12.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 54 ]; then
        ENVIRONMENT_NAME="groupBig4-14";
        NUM_OF_TASKS=4;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=14;
        TASK_MAX_DISTANCE_FROM_BASE=14.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 55 ]; then
        ENVIRONMENT_NAME="groupBig4-16";
        NUM_OF_TASKS=4;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=16;
        TASK_MAX_DISTANCE_FROM_BASE=16.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 56 ]; then
        ENVIRONMENT_NAME="groupBig4-18";
        NUM_OF_TASKS=4;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=18;
        TASK_MAX_DISTANCE_FROM_BASE=18.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 57 ]; then
        ENVIRONMENT_NAME="groupBig4-20";
        NUM_OF_TASKS=4;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=20;
        TASK_MAX_DISTANCE_FROM_BASE=20.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 58 ]; then
        ENVIRONMENT_NAME="groupBig4-22";
        NUM_OF_TASKS=4;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=22;
        TASK_MAX_DISTANCE_FROM_BASE=22.1;
        EVENLY_SPACED_TASKS="true";
    elif [ $ENVIRONMENT_ID -eq 59 ]; then
        ENVIRONMENT_NAME="groupBig4-24";
        NUM_OF_TASKS=4;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=24;
        TASK_MAX_DISTANCE_FROM_BASE=24.1;
        EVENLY_SPACED_TASKS="true";


    #--------- rand 25: big volumes
    elif [ $ENVIRONMENT_ID -eq 61 ]; then
        ENVIRONMENT_NAME="randBig25-8";
        NUM_OF_TASKS=25;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=4;
        TASK_MAX_DISTANCE_FROM_BASE=8;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 61 ]; then
        ENVIRONMENT_NAME="randBig25-10";
        NUM_OF_TASKS=25;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=5;
        TASK_MAX_DISTANCE_FROM_BASE=10;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 61 ]; then
        ENVIRONMENT_NAME="randBig25-12";
        NUM_OF_TASKS=25;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=7;
        TASK_MAX_DISTANCE_FROM_BASE=12;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 64 ]; then
        ENVIRONMENT_NAME="randBig25-14";
        NUM_OF_TASKS=25;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=9;
        TASK_MAX_DISTANCE_FROM_BASE=14;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 65 ]; then
        ENVIRONMENT_NAME="randBig25-16";
        NUM_OF_TASKS=25;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=11;
        TASK_MAX_DISTANCE_FROM_BASE=16;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 66 ]; then
        ENVIRONMENT_NAME="randBig25-18";
        NUM_OF_TASKS=25;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=13;
        TASK_MAX_DISTANCE_FROM_BASE=18;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 67 ]; then
        ENVIRONMENT_NAME="randBig25-20";
        NUM_OF_TASKS=25;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=15;
        TASK_MAX_DISTANCE_FROM_BASE=20;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 68 ]; then
        ENVIRONMENT_NAME="randBig25-22";
        NUM_OF_TASKS=25;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=17;
        TASK_MAX_DISTANCE_FROM_BASE=22;
        EVENLY_SPACED_TASKS="false"
    elif [ $ENVIRONMENT_ID -eq 69 ]; then
        ENVIRONMENT_NAME="randBig25-24";
        NUM_OF_TASKS=25;
        TASK_VOLUME=100;
        TASK_GRADIENT_RADIUS=1.0;
        TASK_RADIUS=0.1;
        TASK_MIN_DISTANCE_FROM_BASE=19;
        TASK_MAX_DISTANCE_FROM_BASE=24;
        EVENLY_SPACED_TASKS="false"

    fi

}

#==========================================================

declare ENVIRONMENT_ID ENVIRONMENT_NAME MAIN_DIRECTORY EXPERIMENT_DIRECTORY ARGOS_FILE_NAME RUN_NO OUTPUT_FILE_NAME_PREFIX RUN_LENGTH RANDOM_SEED EXECUTABLE_FOLDER EXECUTABLE_EXTENSION WHEELS_NOIZE RANGE_AND_BEARING_SENSOR_NOIZE STEERING_SENSOR_NOIZE IS_ON_IRIDIS CART_CAPACITY LOAD_TIME_PER_VOLUME_UNIT UNLOAD_TIME_PER_VOLUME_UNIT LB_SIGNAL_DISTANCE DEFAULT_TASK_TYPE TASK_GRADIENT_RADIUS TASK_MIN_DISTANCE_FROM_BASE TASK_MAX_DISTANCE_FROM_BASE TASK_DISAPPEAR_RATE TASK_RENEWABILITY_THRESHOLD TASK_APPEAR_RATE TASK_VALUE_CHANGE_RATE EVENLY_SPACED_TASKS ROBOT_CONTROLLER_TYPE ROBOT_CONTROLLER_SUBTYPE NUM_OF_ROBOTS TASK_VOLUME TASK_RADIUS TASK_MASS NUM_OF_TASKS NEIGHBOURHOOD_SEARCH_TIME NEIGHBOURHOOD_SEARCH_RADIUS OPPORTUNISM_THRESHOLD USE_OPPORTUNISM USE_REL_UTILITY S_MAX_TEAM_SIZE_UNCHANGED_TIME LB_MAX_TEAM_SIZE_UNCHANGED_TIME MIN_ROBOTS_FOR_TASK MAX_ROBOTS_FOR_TASK BR_SIGNAL_DISTANCE BR_MAX_WAGGLE_DANCE_TIME BR_SCOUTING_PROB BR_MAX_SCOUTING_TIME BR_MAX_TEAM_SIZE_UNCHANGED_TIME BR_USE_REL_EE TASK_APPEAR_TIME;

#-- default values: general
ENVIRONMENT_ID=-1;
ENVIRONMENT_NAME="!INVALID NAME";
MAIN_DIRECTORY="experiments/test";
ARGOS_FILE_NAME="experiment.argos";
RUN_NO=0;
IS_ON_IRIDIS=0;

OUTPUT_FILE_NAME_PREFIX="test"
RUN_LENGTH=3600;
RANDOM_SEED=0;
EXECUTABLE_FOLDER="buildExec";
EXECUTABLE_EXTENSION="dylib";

DEFAULT_TASK_TYPE="PERFORM";
NUM_OF_TASKS=0;
TASK_VOLUME=1;
TASK_MASS=100001.0;
TASK_GRADIENT_RADIUS=1.0;
TASK_RADIUS=0.1;
TASK_MAX_DISTANCE_FROM_BASE=0;
TASK_MIN_DISTANCE_FROM_BASE=0;
TASK_DISAPPEAR_RATE=0;
TASK_RENEWABILITY_THRESHOLD=-1;
TASK_APPEAR_RATE=0;
TASK_APPEAR_TIME=0;
TASK_VALUE_CHANGE_RATE=0;
EVENLY_SPACED_TASKS="false"
MIN_ROBOTS_FOR_TASK=1;
MAX_ROBOTS_FOR_TASK=1;

#-- default values: general robot
ROBOT_CONTROLLER_TYPE="solitary"
ROBOT_CONTROLLER_SUBTYPE="";
NUM_OF_ROBOTS=25;

WHEELS_NOIZE=0.5; #good vals for noize: 1-2
STEERING_SENSOR_NOIZE=0;
RANGE_AND_BEARING_SENSOR_NOIZE=0;

CART_CAPACITY=1;
LOAD_TIME_PER_VOLUME_UNIT=1;
UNLOAD_TIME_PER_VOLUME_UNIT=1;

NEIGHBOURHOOD_SEARCH_RADIUS=3;
NEIGHBOURHOOD_SEARCH_TIME=180;

USE_OPPORTUNISM="false";
OPPORTUNISM_THRESHOLD=0.1;
USE_REL_UTILITY="false"

#-- default values: local solitary
S_MAX_TEAM_SIZE_UNCHANGED_TIME=1080;

#-- default values: local broadcaster
LB_SIGNAL_DISTANCE=10000;
LB_MAX_TEAM_SIZE_UNCHANGED_TIME=780;

#-- default values: bee recruiter
BR_SIGNAL_DISTANCE=10000;
BR_MAX_WAGGLE_DANCE_TIME=120;
BR_MAX_TEAM_SIZE_UNCHANGED_TIME=540;
BR_SCOUTING_PROB=0.001;
BR_MAX_SCOUTING_TIME=1080;
BR_USE_REL_EE="false";


#------- get evironment ids from arguments of the command line
ENVIRONMENTS=();
argumentsArray=( "$@" )
arraylength=${#argumentsArray[@]}
for (( i=1; i<${arraylength}+1; i++ ));
do
    ENVIRONMENTS=("${ENVIRONMENTS[@]}" "${argumentsArray[$i-1]}") ;
done




