import helpers;
import constants;
import crData;
import math;
import timeit
import copy;


def getInfoEventsData(scenarioFolder_,scenarios_,extraParamStr_, numOfRobots_, endTime_):
    """
    NOTE: the infoGainSocialData is not 100% reliable, especially in expCopp,
    """

    #-- projected potential reward gain based on decreases in uncertainty
    robotPotentialRewardData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];
    #-- calculated reward based on robots doing tasks. Note that in foraging, this will not be the same as measured reward, as robots need to go back to base to get reward.
    robotCalculatedRewardData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];

    infoValueData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];
    infoValueSocialData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];
    infoGainData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];
    infoGainSocialData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];

    uncertaintyCostData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];

    infoUtilityData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];

    misplacementCostData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];
    opportunityCostData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];


    deltaCalculatedRewardAllData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];
    maxPotentialGainData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];

    misplVsUncCostData = [[[0 for r in range(constants.NUM_RUNS)] for i in range(endTime_)] for s in range(len(scenarios_))];


    print(">>> Getting info events data...");

    for sc in range(len(scenarios_)):

        print(scenarios_[sc]);
        for runNo in range(constants.NUM_RUNS):

            totalEnvReward = 0;
            numOfTasks = 0;
            numOfActiveTasks = 0;
            totalTaskValue = 0;
            totalActiveTaskValue = 0;
            totalActiveTaskReward = 0;
            infoEventsData = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/" + scenarios_[sc] + extraParamStr_ + "/Run" + str(runNo) + "_infoEvents.txt", "\t", True,maxTime_=endTime_);
            infoEventTimes = crData.columnToArray(infoEventsData,0);
            tasksCompleted = [];

            tasksSubscribedRobots = [];
            tasksSubscribedRobotsByRecruitment = [];

            tasksSubscribedRobotsOldRecords = []; #used in PERFORM, to keep track of robots that were subscribed, because they need to be automatically unsubscribed but checked later

            tasksSubscribedRobotsPrevLen = []
            tasksSubscribedRobotsByRecruitmentPrevLen = []

            #tasksReadyToProcessRobots = [];
            #tasksProcessingRobots = [];

            tasksReachedRobots = [];
            tasksLadenRobots = [];
            tasksEarningRobots = [];

            tasksRobotsToAbandon = []

            tasksVolumesForPotGains = [];
            tasksVolumesForCalcGains = [];
            taskValues = [];

            robotsTaskSubscriptions = [ [] for nr in range(numOfRobots_)]

            robotTargetValues = [0 for nr in range(numOfRobots_)];

            printEvents = False;
            printCosts = False;
            printTaskInfo =  False;
            printRewards = False;

            useRobotsEarningFromTaskId = False;
            if ("COLLECT" in scenarios_[sc]):
                useRobotsEarningFromTaskId = True;

            for t in range(endTime_):
                if (t >= 1000000):
                    printEvents = True;
                    printCosts = True;
                    printTaskInfo = True;
                if (t % 1000 == 0):
                    print 'RUN {} t={} \r'.format(runNo,t),

                #print "t={}".format(t),
                #print("----------")
                startTime = timeit.default_timer();
                if (t in infoEventTimes):
                    #print("      t={}".format(t))
                    #-- there was an event at this time
                    for loadingTimeDataIndex, timeValue in enumerate(infoEventTimes):
                        if (timeValue == t):
                            #print("      resolve t ={}".format(timeValue))
                            eventType = infoEventsData[loadingTimeDataIndex][1];
                            taskId = int(infoEventsData[loadingTimeDataIndex][3]);
                            robotId = int(infoEventsData[loadingTimeDataIndex][2]);

                            if (taskId >= 0):

                                taskValue = float(infoEventsData[loadingTimeDataIndex][4]);
                                taskVolume = int(round(infoEventsData[loadingTimeDataIndex][5]));

                                if (printEvents and robotId == 4):
                                    print(str(timeValue) + "  " + eventType + "  rob " + str(robotId) + " taskId " + str(taskId));

                                if (eventType == 'E_TASK_ADDED'):
                                    numOfTasks += 1;
                                    numOfActiveTasks += 1;
                                    totalTaskValue += taskValue;
                                    totalActiveTaskValue += taskValue;
                                    taskReward = taskValue * taskVolume;
                                    totalActiveTaskReward += taskReward;
                                    tasksSubscribedRobots.append([]);
                                    tasksSubscribedRobotsByRecruitment.append([]);
                                    tasksSubscribedRobotsOldRecords.append([])

                                    tasksSubscribedRobotsPrevLen.append(0)
                                    tasksSubscribedRobotsByRecruitmentPrevLen.append(0)

                                    tasksReachedRobots.append([]);
                                    #tasksProcessingRobots.append([]);
                                    tasksEarningRobots.append([]);
                                    #tasksReadyToGainRobots.append([]);
                                    tasksLadenRobots.append([]);
                                    tasksRobotsToAbandon.append([]);
                                    tasksVolumesForPotGains.append(taskVolume);
                                    tasksVolumesForCalcGains.append(taskVolume);
                                    taskValues.append(taskValue);

                                    totalEnvReward += taskVolume * taskValue;

                                    if (printEvents or printCosts):
                                        print("t=" + str(t) + " ==========================[]====== NEW TASK vol=" + str(taskVolume) + " val " + str(taskValue) + "  Nt=" + str(numOfTasks) + " TOTAL R " + str(totalEnvReward) + " total active reward " + str(totalActiveTaskReward));


                                if (eventType == 'E_TASK_COMPLETED' or eventType == 'E_TASK_DESTROYED'):

                                    if (taskId not in tasksCompleted): # make sure this only happens once, either when task is completed by robots or destroyed by the environment
                                        tasksCompleted.append(taskId);
                                        numOfActiveTasks -= 1;
                                        totalActiveTaskValue -= taskValue;
                                        taskReward = taskValues[taskId] * helpers.getTaskVolumeByScenario(scenarios_[sc]);
                                        totalActiveTaskReward -= taskReward;

                                        if (printEvents or printCosts):
                                            print("t=" + str(t) + " ============================[]===== TASK DONE " + str(taskId) + " total active task reward is " + str(totalActiveTaskReward));

                                    if ("PERFORM" in scenarios_[sc]):
                                        for robotId in tasksReachedRobots[taskId]:
                                            if (robotId in tasksSubscribedRobots[taskId]):
                                                tasksSubscribedRobots[taskId].remove(robotId);
                                                tasksSubscribedRobotsOldRecords[taskId].append(robotId);
                                            if (robotId in tasksSubscribedRobotsByRecruitment[taskId]):
                                                tasksSubscribedRobotsByRecruitment[taskId].remove(robotId);
                                            if (robotId in tasksRobotsToAbandon[taskId]):
                                                tasksRobotsToAbandon[taskId].remove(robotId);

                                            helpers.removeElementFromArray(taskId, robotsTaskSubscriptions[robotId])

                                            if (printEvents):
                                                print("     automatically unsibscribed robot " + str(robotId) + " from task " + str(taskId));
                                        tasksReachedRobots[taskId] = [];
                                        tasksEarningRobots[taskId] = [];
                                        tasksLadenRobots[taskId] = [];


                                #-- the task value should be read from the info that was recorded when task was created, not from the robot
                                if (taskId < len(taskValues)):
                                    taskValue = taskValues[taskId];
                                else:
                                    taskId = helpers.handleTaskValueNotRecorded(robotId, numOfTasks, taskId, runNo, eventType, tasksSubscribedRobots, tasksReachedRobots, tasksLadenRobots, tasksSubscribedRobotsOldRecords)

                                #-- keep track of robots that know about a task
                                if (eventType == 'TASK_SCOUTED' or eventType == 'ROBOT_RECRUITED'):

                                    debugMessage = "t=" + str(t) + " robot " + str(robotId) + " subscribed to task " + str(taskId) + "  ";
                                    helpers.addUniqueElementToArray(robotId, tasksSubscribedRobots[taskId], debugMessage, printEvents)

                                    if (eventType == 'ROBOT_RECRUITED'):
                                        debugMessage = "t=" + str(t) + " robot " + str(robotId) + " recruited to task " + str(taskId) + "  ";
                                        helpers.addUniqueElementToArray(robotId, tasksSubscribedRobotsByRecruitment[taskId], debugMessage, printEvents)




                                    helpers.clearAllRobotToAbandonRecords(scenarios_[sc], taskId, robotId, numOfTasks, tasksRobotsToAbandon, tasksSubscribedRobots, tasksSubscribedRobotsByRecruitment, tasksReachedRobots, tasksLadenRobots, tasksEarningRobots, robotsTaskSubscriptions, printEvents, useRobotsEarningFromTaskId);

                                    # check if robot is subscribed to other worksites
                                    helpers.cleanupRecordsAfterSubscription(taskId, robotId,  tasksSubscribedRobots, tasksSubscribedRobotsByRecruitment, tasksReachedRobots, tasksLadenRobots, tasksEarningRobots, robotsTaskSubscriptions, printTaskInfo, useRobotsEarningFromTaskId);

                                    #-- if scouted, and solitary or local broadcasters, start processing immediatelly
                                    if (eventType == 'TASK_SCOUTED' and ( ('solitary' in scenarios_[sc]) or ('localBroadc' in scenarios_[sc]))):
                                        #-- task reached
                                        helpers.addUniqueElementToArray(robotId, tasksReachedRobots[taskId]);
                                        helpers.addUniqueElementToArray(robotId, tasksLadenRobots[taskId]);
                                        #-- task started
                                        if (not taskId in tasksCompleted): # sometimes robot abandons a completed task and then restarts and ends it in the same time frame - make sure it's not counted as starting a task.
                                            helpers.addUniqueElementToArray(robotId, tasksReachedRobots[taskId]);
                                            helpers.addUniqueElementToArray(robotId, tasksLadenRobots[taskId]);

                                        if (printEvents):
                                            print("t=" + str(t) + " robot " + str(robotId) + " started task " + str(taskId) + "  ");

                                        helpers.clearAllRobotToAbandonRecords(scenarios_[sc], taskId, robotId, numOfTasks, tasksRobotsToAbandon, tasksSubscribedRobots, tasksSubscribedRobotsByRecruitment, tasksReachedRobots, tasksLadenRobots, tasksEarningRobots,  robotsTaskSubscriptions, printEvents, useRobotsEarningFromTaskId);
                                        #-- reward started
                                        if ("PERFORM" in scenarios_[sc]):
                                            outputStr = "t=" + str(t) + " rew started for robot " + str(robotId) + " task " + str(taskId);
                                            helpers.addUniqueElementToArray(robotId, tasksEarningRobots[taskId], outputStr, printEvents)



                                #-- keep track of robots that reached the task
                                if (eventType == 'TASK_REACHED'):

                                    helpers.addUniqueElementToArray(robotId, tasksReachedRobots[taskId]);
                                    helpers.addUniqueElementToArray(robotId, tasksLadenRobots[taskId]);


                                if (eventType == 'TASK_PAUSED'):
                                    pass

                                #-- keep track of robots that started doing a task
                                if (eventType == 'TASK_STARTED'):
                                    if (not taskId in tasksCompleted): # sometimes robot abandons a completed task and then restarts and ends it in the same time frame - make sure it's not counted as starting a task.

                                        helpers.addUniqueElementToArray(robotId, tasksReachedRobots[taskId]);
                                        helpers.addUniqueElementToArray(robotId, tasksLadenRobots[taskId]);

                                        if (printEvents):
                                            print("t=" + str(t) + " robot " + str(robotId) + " started task " + str(taskId) + "  ");

                                        #-- make sure counted as subscribed - e.g. robot could have started a task that meanwhile got a new ID, but did not note down a SCOUTED event
                                        helpers.addUniqueElementToArray(robotId, tasksSubscribedRobots[taskId])
                                        # check if robot is subscribed to other worksites
                                        helpers.cleanupRecordsAfterSubscription(taskId, robotId,  tasksSubscribedRobots, tasksSubscribedRobotsByRecruitment, tasksReachedRobots, tasksLadenRobots, tasksEarningRobots, robotsTaskSubscriptions, printTaskInfo, useRobotsEarningFromTaskId);

                                        #-- make sure that if it's solitary or local broadcasters, it is counted as earning (sometimes robots fail to report a scouting event in PERFORM)
                                        if ("PERFORM" in scenarios_[sc]) and ('solitary' in scenarios_[sc] or 'localBroadc' in scenarios_[sc]):
                                            outputStr = "t=" + str(t) + " rew automatically started for robot " + str(robotId) + " task " + str(taskId);
                                            helpers.addUniqueElementToArray(robotId, tasksEarningRobots[taskId], outputStr, printEvents);

                                    helpers.clearAllRobotToAbandonRecords(scenarios_[sc], taskId, robotId, numOfTasks, tasksRobotsToAbandon, tasksSubscribedRobots, tasksSubscribedRobotsByRecruitment, tasksReachedRobots, tasksLadenRobots, tasksEarningRobots, robotsTaskSubscriptions, printEvents, useRobotsEarningFromTaskId);


                                #-- robots that are earning reward
                                if (eventType == 'REWARD_STARTED'):
                                    if (not taskId in tasksCompleted or useRobotsEarningFromTaskId ): # sometimes robot abandons a completed task and then restarts and ends it in the same time frame - make sure it's not counted as starting a task.
                                        outputStr = "t=" + str(t) + " rew started for robot " + str(robotId) + " task " + str(taskId);
                                        helpers.addUniqueElementToArray(robotId, tasksLadenRobots[taskId]);
                                        helpers.addUniqueElementToArray(robotId, tasksEarningRobots[taskId], outputStr, printEvents)

                                        #-- make sure counted as subscribed - e.g. robot could have started a task that meanwhile got a new ID, but did not note down a SCOUTED event
                                        helpers.addUniqueElementToArray(robotId, tasksSubscribedRobots[taskId])
                                        # check if robot is subscribed to other worksites
                                        helpers.cleanupRecordsAfterSubscription(taskId, robotId,  tasksSubscribedRobots, tasksSubscribedRobotsByRecruitment, tasksReachedRobots, tasksLadenRobots, tasksEarningRobots, robotsTaskSubscriptions, printTaskInfo, useRobotsEarningFromTaskId);


                                if (eventType == 'REWARD_FINISHED'):
                                    debugMessage = "t=" + str(t) + " robot " + str(robotId) + " reward finished from task " + str(taskId) + "   " + str(tasksEarningRobots[taskId]);
                                    helpers.removeElementFromArray(robotId, tasksEarningRobots[taskId], debugMessage, printEvents )
                                    helpers.removeElementFromArray(robotId, tasksLadenRobots[taskId]);

                                    #-- unsubscribe the robot if it was set to abandon the worksite after it unloaded cart
                                    if (robotId in tasksRobotsToAbandon[taskId]):
                                        if (printEvents):
                                            print("t=" + str(t) + " robot " + str(robotId) + " unsubscribed from task " + str(taskId) + " AFTER EMPTYING CART ");
                                    helpers.clearRobotToAbandonRecordsForTask(robotId, taskId, tasksRobotsToAbandon, tasksSubscribedRobots, tasksSubscribedRobotsByRecruitment, tasksReachedRobots, robotsTaskSubscriptions)

                                #-- abandonment
                                if (eventType == 'TASK_ABANDONED' or eventType == 'TASK_MISSING'):
                                    if (robotId in tasksSubscribedRobots[taskId]):
                                        if not (robotId in tasksLadenRobots[taskId]):
                                            #-- robot has nothing in the card, i.e. it didn't reach the worksite yet. Abandon straight away.
                                            debugMessage = "t=" + str(t) + " robot " + str(robotId) + " unsubscribed from task " + str(taskId) + " BEFORE EMPTYING CART ";
                                            helpers.removeElementFromArray(robotId, tasksSubscribedRobots[taskId], debugMessage, printEvents);
                                            helpers.removeElementFromArray(robotId, tasksSubscribedRobotsByRecruitment[taskId]);
                                            helpers.removeElementFromArray(robotId, tasksReachedRobots[taskId]);

                                            helpers.removeElementFromArray(taskId, robotsTaskSubscriptions[robotId])

                                        else:
                                            #-- robot still needs to return the load, remember it should be counted as abandoned after it's unloaded
                                            debugMessage = "t=" + str(t) + " robot " + str(robotId) + " WILL unsubscribe from task " + str(taskId);
                                            helpers.addUniqueElementToArray(robotId,tasksRobotsToAbandon[taskId], debugMessage, printEvents )


                                if (eventType == 'TASK_SWITCHED'):
                                    raise ValueError(" ERROR: TASK SWITCHED EVENT FOUND");

                                #------ information value
                                taskInfoValue = taskValue;

                                if (eventType == 'TASK_SCOUTED' or eventType == 'ROBOT_RECRUITED'):
                                    #print(eventType + " robot " + str(robotId) + " add " + str(taskInfoValue - robotTargetValues[robotId]));
                                    infoValueData[sc][t][runNo] += (taskInfoValue - robotTargetValues[robotId]) / numOfRobots_;

                                    if (eventType == 'ROBOT_RECRUITED'):
                                        infoValueSocialData[sc][t][runNo] += (taskInfoValue - robotTargetValues[robotId]) / numOfRobots_;

                                #-- register robot task values
                                if (eventType == 'TASK_SCOUTED' or eventType == 'ROBOT_RECRUITED'):
                                    robotTargetValues[robotId] = taskInfoValue;
                                    #print("    " + eventType + " robot " + str(robotId) + " val " + str(robotTargetValues[robotId]));
                                elif (eventType == 'TASK_ABANDONED' or eventType == 'TASK_MISSING'):
                                    robotTargetValues[robotId] = 0;
                                    #print("  !!" + eventType + " robot " + str(robotId) + " val " + str(robotTargetValues[robotId]));

                    #-- finished resolving events. Since there was at least 1 info event
                    #print("finished resolving events - it took {}".format(timeit.default_timer() - startTime))
                else:
                    #-- there was no info even for this time
                    pass

                #----- finished resolving all events for this time frame
                envAdjustment = (totalEnvReward/(numOfTasks*numOfRobots_)); # adjustemnt for different types of environments, so that all costs add up to totalEnvReward (i.e, total volume of tasks * value of tasks remains the same across scenarios)

                #----------- calculate the costs for all task at this point in time
                loadTimePerVolumeUnit = helpers.getLoadTimePerVolumeUnitByTaskType(scenarios_[sc]);
                rewardIntakePerSecond = 1.0/loadTimePerVolumeUnit;


                uncertaintyCostData[sc][t][runNo] = 0
                infoUtilityData[sc][t][runNo] = 0;
                misplacementCostData[sc][t][runNo] = 0;
                opportunityCostData[sc][t][runNo] = 0;
                deltaCalculatedRewardAllData[sc][t][runNo] = 0;

                if (t>0):
                    robotPotentialRewardData[sc][t][runNo] = robotPotentialRewardData[sc][t-1][runNo]
                    robotCalculatedRewardData[sc][t][runNo] = robotCalculatedRewardData[sc][t-1][runNo]
                else:
                    robotPotentialRewardData[sc][t][runNo] = 0;
                    robotCalculatedRewardData[sc][t][runNo] = 0;



                totalCalculatedRewardGain = 0;
                totalPotentialGain = 0; #M
                totalNumOfRobotsThatCantGetReward = 0;
                totalExpectedRewardFromSubscribedToDepleted = 0;
                totalGainAdjustment = 0; # the amount of resource robots cannot get because worksite just became depleted in mid second. Used for checks later on.
                opportunityCostPaidForLastWorksite = 0; #amount of C_O paid when all worksites have been depleted. Used in the checks.

                for taskId in range(numOfTasks):

                    taskValue = taskValues[taskId];
                    #----- information gain
                    if (t>0):
                        if not (taskId in tasksCompleted):
                            subscribedRobotsDiff = len(tasksSubscribedRobots[taskId]) - tasksSubscribedRobotsPrevLen[taskId];
                            infoGainData[sc][t][runNo] += subscribedRobotsDiff / float(numOfRobots_);

                            subscribedRobotsByRecruitmentDiff = len(tasksSubscribedRobotsByRecruitment[taskId]) - tasksSubscribedRobotsByRecruitmentPrevLen[taskId];
                            infoGainSocialData[sc][t][runNo] += subscribedRobotsByRecruitmentDiff / float(numOfRobots_);

                            #if (subscribedRobotsDiff < subscribedRobotsByRecruitmentDiff):
                            #    errorStr = " t={} info gain < info gain social. Worksite {}\n".format(t,taskId);
                            #    errorStr += " S(t) = {} S(t-1) = {}    SR(t) = {} SR(t-1) = {}\n".format(len(tasksSubscribedRobots[taskId]), tasksSubscribedRobotsPrevLen[taskId], len(tasksSubscribedRobotsByRecruitment[taskId]), tasksSubscribedRo#botsByRecruitmentPrevLen[taskId]  )
                            #    errorStr += "SUBSCRIBED: {}".format(tasksSubscribedRobots[taskId])
                            #    raise ValueError(errorStr)

                        tasksSubscribedRobotsPrevLen[taskId] = len(tasksSubscribedRobots[taskId]);
                        tasksSubscribedRobotsByRecruitmentPrevLen[taskId] = len(tasksSubscribedRobotsByRecruitment[taskId]);

                    #-- calculate total potential gain
                    if (taskId in tasksCompleted):
                        potGainFromTask = len(tasksLadenRobots[taskId]) * envAdjustment;
                    else:
                        potGainFromTask = numOfRobots_ * envAdjustment;

                    totalPotentialGain += potGainFromTask;


                    #-- calculate uncertainty cost and info utility
                    if (not(taskId in tasksCompleted)):
                        uncertaintyCostData[sc][t][runNo] += (numOfRobots_ * envAdjustment) - len(tasksSubscribedRobots[taskId]) * envAdjustment
                        infoUtilityData[sc][t][runNo] += len(tasksSubscribedRobots[taskId]) * envAdjustment
                    else:
                        #if (len(tasksLadenRobots[taskId]) > 0):
                        #    print("t={} task {} removed U for {} robots (before U={}) ".format(t, taskId, len(tasksLadenRobots[taskId]), uncertaintyCostData[sc][t][runNo]))
                        infoUtilityData[sc][t][runNo] += len(tasksLadenRobots[taskId]) * envAdjustment;

                    #-- calculate misplacement cost
                    if (not(taskId in tasksCompleted)):
                        misplacementCostData[sc][t][runNo] += (len(tasksSubscribedRobots[taskId]) - len(tasksEarningRobots[taskId])) * envAdjustment
                        #print("t={} task {} ADDed MC for {} robots ".format(t, taskId, (len(tasksSubscribedRobots[taskId]) - len(tasksEarningRobots[taskId])) ))
                    else:
                        misplacementCostData[sc][t][runNo] += (len(tasksLadenRobots[taskId]) - len(tasksEarningRobots[taskId])) * envAdjustment
                        #print("t={} task {} ADDed MC for {} robots ".format(t, taskId, (len(tasksLadenRobots[taskId]) - len(tasksEarningRobots[taskId])) ))

                    #-- calculate opportunity cost
                    if ((taskId in tasksCompleted)):
                        costVal = (len(tasksSubscribedRobots[taskId]) - len(tasksLadenRobots[taskId])) * envAdjustment
                        if (len(tasksCompleted) < numOfTasks):
                            opportunityCostData[sc][t][runNo] += costVal

                        else:
                            opportunityCostPaidForLastWorksite += costVal;

                    #-- calculate reward
                    calculatedRewardGain = 0;
                    numOfRobotsThatCantGetReward = 0;
                    for r in range(len(tasksEarningRobots[taskId])):
                        if (tasksVolumesForCalcGains[taskId] > 0):
                            calculatedRewardGain += rewardIntakePerSecond*taskValue;
                            tasksVolumesForCalcGains[taskId] -= rewardIntakePerSecond;
                        else:
                            numOfRobotsThatCantGetReward += 1;
                    totalNumOfRobotsThatCantGetReward += numOfRobotsThatCantGetReward;

                    #if (numOfRobotsThatCantGetReward > 0 and printCosts):
                        #print("!!!! reward stopped mid second for {} robots".format(numOfRobotsThatCantGetReward))

                    robotCalculatedRewardData[sc][t][runNo] += calculatedRewardGain;
                    totalCalculatedRewardGain += calculatedRewardGain;

                    deltaCalculatedRewardAllData[sc][t][runNo] +=  calculatedRewardGain


                    #-- decrease the potential reward gain by robots that couldn't get it anymore because task volume has been depleted
                    totalGainAdjustment += numOfRobotsThatCantGetReward * envAdjustment


                    #-- calculate potential reward
                    if (not(taskId in tasksCompleted)):

                        #-- add potential gain if this task would still have volume
                        potentialRewardGain = 0;

                        if (tasksVolumesForPotGains[taskId] > 0):
                            if (len(tasksSubscribedRobots[taskId]) >= helpers.getTaskMinRobotsNeededByScenario(scenarios_[sc]) ):
                                for r in range(len(tasksSubscribedRobots[taskId])):
                                    if (tasksVolumesForPotGains[taskId] > 0):
                                        potentialRewardGain += rewardIntakePerSecond*taskValue;
                                        tasksVolumesForPotGains[taskId] -= rewardIntakePerSecond;

                            robotPotentialRewardData[sc][t][runNo] += potentialRewardGain;
                    else:
                        totalExpectedRewardFromSubscribedToDepleted += len(tasksSubscribedRobots[taskId]) * envAdjustment;


                    #-- check stuff for this task
                    #if ("PERFORM" in scenarios_[sc]):
                    #    if (taskId in tasksCompleted):
                    #        if (len(tasksEarningRobots[taskId]) > 0):
                    #            errorStr = "t=" + str(t) + " !!!!!!!! completed task has still robots consuming " + str(taskId) + " num of robots: " + str(len(tasksEarningRobots[taskId]));
                    #            errorStr += "\n SUB:             " + str(sorted(tasksSubscribedRobots[taskId]))
                    #            errorStr += "\n REACHED:         " + str(sorted(tasksReachedRobots[taskId]))
                    #            errorStr += "\n EARN :           " + str(sorted(tasksEarningRobots[taskId]))
                    #            errorStr += "\n IN CART :        " + str(sorted(tasksLadenRobots[taskId]))
                    #            raise ValueError(errorStr)

                #------ finished looping through task ids


                #-- misplacement cost coefficient
                if (infoUtilityData[sc][t][runNo] > 0):
                    misplVsUncCostData[sc][t][runNo] = misplacementCostData[sc][t][runNo] / infoUtilityData[sc][t][runNo];

                #------ print stuff
                if (printCosts):
                    if (t > 0 and (uncertaintyCostData[sc][t][runNo] != uncertaintyCostData[sc][t-1][runNo] or misplacementCostData[sc][t][runNo] != misplacementCostData[sc][t-1][runNo] or opportunityCostData[sc][t][runNo] != opportunityCostData[sc][t-1][runNo]) ):


                        print("---- t={} C_U={} C_M={} C_O={} dR={} U={} mispl coeff = {} max pot gain = {}    infoGain= {} ".format(
                            t, uncertaintyCostData[sc][t][runNo], misplacementCostData[sc][t][runNo], opportunityCostData[sc][t][runNo], deltaCalculatedRewardAllData[sc][t][runNo], infoUtilityData[sc][t][runNo], misplVsUncCostData[sc][t][runNo], maxPotentialGainData[sc][t][runNo], infoGainData[sc][t][runNo]));

                        if (printTaskInfo):
                            print("COMPLETED TASKS: " + str(sorted(tasksCompleted)));
                            print("SUB:             " + str(helpers.getTasksInfoForPrinting(tasksSubscribedRobots)));
                            print("REACHED:         " + str(helpers.getTasksInfoForPrinting(tasksReachedRobots)));
                            #print("PROC: " + str(tasksProcessingRobots));
                            #print("READY TO EARN : " + str(tasksReadyToGainRobots));
                            print("EARN :           " + str(helpers.getTasksInfoForPrinting(tasksEarningRobots)));
                            print("IN CART :        " + str(helpers.getTasksInfoForPrinting(tasksLadenRobots)));


                if (printRewards):
                    if (t > 0 and (robotPotentialRewardData[sc][t][runNo] != robotPotentialRewardData[sc][t-1][runNo] or robotCalculatedRewardData[sc][t][runNo] != robotCalculatedRewardData[sc][t-1][runNo])):
                        print("---- t=" + str(t) + " R'=" + str(robotPotentialRewardData[sc][t][runNo]) + " R=" + str(robotCalculatedRewardData[sc][t][runNo]) + " E_R=" + str(tasksEarningRobots));

                #------ do checks
                #-- reward remaining in the environment
                if (robotCalculatedRewardData[sc][t][runNo] - totalEnvReward > 1): #need to allow some space for minor calculation errors
                    raise ValueError("!!!!!!!! reward > totalEnvReward (rew = {} total = {})".format(robotCalculatedRewardData[sc][t][runNo], totalEnvReward))


                if (robotPotentialRewardData[sc][t][runNo] - totalEnvReward > 1): #need to allow some space for minor calculation errors
                    raise ValueError("!!!!!!!! potential reward > totalEnvReward (rew = {} total = {})".format(robotPotentialRewardData[sc][t][runNo], totalEnvReward));


                #-- various equations
                if (t > 0): #numOfActiveTasks > 0

                    #-- robots subscribed to 2 worksites at once
                    #for robotId in range(numOfRobots_):
                    #
                    #    numOfSubscriptions = 0;
                    #    for taskId in range(numOfTasks):
                    #        if (robotId in tasksSubscribedRobots[taskId]):
                    #            numOfSubscriptions +=1
                    #        if (numOfSubscriptions > 1):
                    #            errorStr = "Robot {} subscribed in > 1 worksites (RUN {})".format(robotId, runNo)
                    #            errorStr += ("\nCOMPLETED TASKS: " + str(sorted(tasksCompleted)));
                    #            errorStr += ("\nSUB:             " + str(helpers.getTasksInfoForPrinting(tasksSubscribedRobots)));
                    #            errorStr += ("\nREACHED:         " + str(helpers.getTasksInfoForPrinting(tasksReachedRobots)));
                    #            errorStr += ("\nEARN :           " + str(helpers.getTasksInfoForPrinting(tasksEarningRobots)));
                    #            errorStr += ("\nIN CART :        " + str(helpers.getTasksInfoForPrinting(tasksLadenRobots)));
                    #            raise ValueError(errorStr)



                    #-- C_U + C_M = M - (100/(N_W * NR * r))*dR
                    cuPlusCm = uncertaintyCostData[sc][t][runNo] + misplacementCostData[sc][t][runNo];
                    dRAdjusted = (envAdjustment/rewardIntakePerSecond) * deltaCalculatedRewardAllData[sc][t][runNo];
                    totalPotGainMinusRewardAdjusted = totalPotentialGain - dRAdjusted - totalGainAdjustment;

                    maxPotentialGainData[sc][t][runNo] = totalPotentialGain;
                    if (abs(cuPlusCm - totalPotGainMinusRewardAdjusted) > 0.0001):
                        errorStr = "!!!!!!!!! t={} costsAddedUp != totalPotGainMinusRewardAdjusted : costsAddedUp = {}  totalPotGainMinusRewardAdjusted = {} dRAdj={} (by factor {})".format(t,cuPlusCm, totalPotGainMinusRewardAdjusted, dRAdjusted, (envAdjustment/rewardIntakePerSecond))

                        errorStr += "\nC_U=" + str(uncertaintyCostData[sc][t][runNo]) + " C_M=" + str(misplacementCostData[sc][t][runNo]) + " C_O=" + str(opportunityCostData[sc][t][runNo]) + " dR=" + str(deltaCalculatedRewardAllData[sc][t][runNo])
                        errorStr += ("\nCOMPLETED TASKS: " + str(sorted(tasksCompleted)));
                        errorStr += ("\nSUB:             " + str(helpers.getTasksInfoForPrinting(tasksSubscribedRobots)));
                        errorStr += ("\nREACHED:         " + str(helpers.getTasksInfoForPrinting(tasksReachedRobots)));
                        errorStr += ("\nEARN :           " + str(helpers.getTasksInfoForPrinting(tasksEarningRobots)));
                        errorStr += ("\nIN CART :        " + str(helpers.getTasksInfoForPrinting(tasksLadenRobots)));
                        raise ValueError(errorStr)
                        #print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
                        #print(errorStr)
                        #print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")

                    #-- U = C_M + (100/(N_W * NR * r))*dR
                    if (abs ( infoUtilityData[sc][t][runNo] - (misplacementCostData[sc][t][runNo] +  dRAdjusted) - (totalNumOfRobotsThatCantGetReward*envAdjustment) ) > 0.0001):
                        errorStr = "t={} U != C_M + dR: U={} C_M={} dR={} ".format(t, infoUtilityData[sc][t][runNo], misplacementCostData[sc][t][runNo], dRAdjusted )
                        raise ValueError(errorStr)

                        #print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
                        #print(errorStr)
                        #print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")

                    #-- C_U + C_M + C_O = SUM_N_A(N_R*100/(N_W * NR)) + SUM_N_D(S_W*100/(N_W * NR)) - (100/(N_W * NR * r))*dR
                    cuPlusCmPlusCo = uncertaintyCostData[sc][t][runNo] + misplacementCostData[sc][t][runNo] + opportunityCostData[sc][t][runNo] + opportunityCostPaidForLastWorksite;
                    eqRightSide = totalActiveTaskReward + totalExpectedRewardFromSubscribedToDepleted - dRAdjusted - totalGainAdjustment;
                    if (abs(cuPlusCmPlusCo - eqRightSide) > 0.0001):
                        errorStr = "!!!!!!!!! RUN {} t={} C_U + C_M + C_O != SUM_N_A(N_R*100/(N_W * NR)) + SUM_N_D(S_W*100/(N_W * NR)) - (100/(N_W * NR * r))*dR : costsAddedUp = {} SUM_N_A(N_R*100/(N_W * NR)) = {} SUM_N_D(S_W*100/(N_W * NR)) = {} dRAdj={} (by factor {})".format(runNo, t,cuPlusCmPlusCo, totalActiveTaskReward, totalExpectedRewardFromSubscribedToDepleted, dRAdjusted, (envAdjustment/rewardIntakePerSecond))

                        errorStr += "\nC_U=" + str(uncertaintyCostData[sc][t][runNo]) + " C_M=" + str(misplacementCostData[sc][t][runNo]) + " C_O=" + str(opportunityCostData[sc][t][runNo]) + " dR=" + str(deltaCalculatedRewardAllData[sc][t][runNo])
                        errorStr += ("\nCOMPLETED TASKS: " + str(sorted(tasksCompleted)));
                        errorStr += ("\nSUB:             " + str(helpers.getTasksInfoForPrinting(tasksSubscribedRobots)));
                        errorStr += ("\nREACHED:         " + str(helpers.getTasksInfoForPrinting(tasksReachedRobots)));
                        errorStr += ("\nEARN :           " + str(helpers.getTasksInfoForPrinting(tasksEarningRobots)));
                        errorStr += ("\nIN CART :        " + str(helpers.getTasksInfoForPrinting(tasksLadenRobots)));
                        raise ValueError(errorStr)
                        #print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")
                        #print(errorStr)
                        #print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!")

                    #-- check m
                    if (misplVsUncCostData[sc][t][runNo] < 0):
                        errorStr = "!!!!!!!!! RUN {} t={} m < 0)".format(runNo, t);
                        errorStr += "\nC_U=" + str(uncertaintyCostData[sc][t][runNo]) + " C_M=" + str(misplacementCostData[sc][t][runNo]) + " C_O=" + str(opportunityCostData[sc][t][runNo]) + " dR=" + str(deltaCalculatedRewardAllData[sc][t][runNo])
                        errorStr += ("\nCOMPLETED TASKS: " + str(sorted(tasksCompleted)));
                        errorStr += ("\nSUB:             " + str(helpers.getTasksInfoForPrinting(tasksSubscribedRobots)));
                        errorStr += ("\nREACHED:         " + str(helpers.getTasksInfoForPrinting(tasksReachedRobots)));
                        errorStr += ("\nEARN :           " + str(helpers.getTasksInfoForPrinting(tasksEarningRobots)));
                        errorStr += ("\nIN CART :        " + str(helpers.getTasksInfoForPrinting(tasksLadenRobots)));
                        raise ValueError(errorStr)

                    #if (misplVsUncCostData[sc][t][runNo] > 0):
                    #    errorStr = "!!!!!!!!! RUN {} t={} m > 0)".format(runNo, t);
                    #    errorStr += "\nC_U=" + str(uncertaintyCostData[sc][t][runNo]) + " C_M=" + str(misplacementCostData[sc][t][runNo]) + " C_O=" + str(opportunityCostData[sc][t][runNo]) + " dR=" + str(deltaCalculatedRewardAllData[sc][t][runNo])
                    #    errorStr += ("\nCOMPLETED TASKS: " + str(sorted(tasksCompleted)));
                    #    errorStr += ("\nSUB:             " + str(helpers.getTasksInfoForPrinting(tasksSubscribedRobots)));
                    #    errorStr += ("\nREACHED:         " + str(helpers.getTasksInfoForPrinting(tasksReachedRobots)));
                    #    errorStr += ("\nEARN :           " + str(helpers.getTasksInfoForPrinting(tasksEarningRobots)));
                    #    errorStr += ("\nIN CART :        " + str(helpers.getTasksInfoForPrinting(tasksLadenRobots)));
                    #    raise ValueError(errorStr)

                    #-- check that solitary C_O >= 0
                    if (opportunityCostData[sc][t][runNo] < 0):

                        errorStr = "!!!!!!!!! RUN {} t={} C_O < 0 ({})".format(runNo, t, opportunityCostData[sc][t][runNo]);
                        opportunityCostData[sc][t][runNo] = 0;
                        errorStr += "\nC_U=" + str(uncertaintyCostData[sc][t][runNo]) + " C_M=" + str(misplacementCostData[sc][t][runNo]) + " C_O=" + str(opportunityCostData[sc][t][runNo]) + " dR=" + str(deltaCalculatedRewardAllData[sc][t][runNo])
                        errorStr += ("\nCOMPLETED TASKS: " + str(sorted(tasksCompleted)));
                        errorStr += ("\nSUB:             " + str(helpers.getTasksInfoForPrinting(tasksSubscribedRobots)));
                        errorStr += ("\nREACHED:         " + str(helpers.getTasksInfoForPrinting(tasksReachedRobots)));
                        errorStr += ("\nEARN :           " + str(helpers.getTasksInfoForPrinting(tasksEarningRobots)));
                        errorStr += ("\nIN CART :        " + str(helpers.getTasksInfoForPrinting(tasksLadenRobots)));
                        print(errorStr)
                        raise ValueError(errorStr)

                #-- finished resolving one time frame
                #print("finished resolving T - it took {} ".format(timeit.default_timer() - startTime))


    return [robotPotentialRewardData, robotCalculatedRewardData, deltaCalculatedRewardAllData, maxPotentialGainData,
            infoValueData, infoValueSocialData, infoGainData, infoGainSocialData,
            uncertaintyCostData, misplacementCostData, opportunityCostData,
            misplVsUncCostData, infoUtilityData
            ]


def getTimeWhenInfoGainStoppedData(scenarioFolder_,scenarios_,extraParamStr_):
    """
    Index 0:
    Get a 2D list of time when the last info was gained from the environment, i.e. of the last RECRUIT or SCOUT event,
    where 0th index is the scenarios, 1st index is runs.

    """
    print(">>> Get time when info gain stopped ...");

    endTimesData = [[] for j in range(len(scenarios_)) ];

    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);

        for runNo in range(constants.NUM_RUNS):
            data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/" + scenarios_[sc] + extraParamStr_ + "/Run" + str(runNo) + "_infoEvents.txt", "\t", True);
            for row in range(len(data)-1,0,-1):
                eventType = data[row][1];
                time = data[row][0];
                if (eventType == 'TASK_SCOUTED' or eventType == 'ROBOT_RECRUITED'):
                    endTimesData[sc].append(time);
                    #print(eventType + " found at t=" + str(time));
                    break;


    return [endTimesData];

def getRobotsCongestionData(scenarioFolder_,scenarios_,extraParamStr_, startTime_, endTime_, numOfRobots_):
    """
    Index 0:
    Get a 2D list of num of robots avoiding over time, where 0th index is the scenarios

    Index 1:
    Get a 2D list of average time a robot takes to reach its worksite, where 0th index is the scenarios
    """
    print(">>> Get congestion data for {} ...".format(scenarioFolder_));

    timeToReachWorksiteOverTimeData = [[] for j in range(len(scenarios_)) ];
    robotsAvoidingOverTimeData = [[] for j in range(len(scenarios_)) ];

    for sc in range(len(scenarios_)):

        print(scenarios_[sc]);

        for runNo in range(constants.NUM_RUNS):

            data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/" + scenarios_[sc] + str(extraParamStr_) + "/Run" + str(runNo) + "_global.txt", "\t", True, endTime_, startRow_=startTime_);

            #-- convert the res collected column to list
            robotsAvoidingOverTimeData[sc].append(crData.columnToArray(data, 2, 0.1)); # each value needs to be divided by 10, because the values in the file represent total over 10 update loops
            timeToReachWorksiteOverTimeData[sc].append(crData.getAverage(crData.columnToArray(data, 3, 0.1), 0, True)); # each value needs to be divided by 10 to get time in seconds

    return [robotsAvoidingOverTimeData, timeToReachWorksiteOverTimeData];

def getRewardCollectedData(scenarioFolder_,scenarios_,extraParamStr_, startTime_, endTime_, numOfRobots_):
    """
    Index 0:
    Get a 2D list of total reward collected, where 0th index is the scenarios

    Index 1:
    Get a 3D list of reward collected over time, where 0th and 1st index are like above and 2nd index is time
    """
    print(">>> Get reward collected for {} ...".format(scenarioFolder_));

    totalRewardData = [[] for j in range(len(scenarios_)) ];
    rewardOverTimeData = [[] for j in range(len(scenarios_)) ];

    for sc in range(len(scenarios_)):

        print(scenarios_[sc]);

        for runNo in range(constants.NUM_RUNS):

            data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/" + scenarios_[sc] + str(extraParamStr_) + "/Run" + str(runNo) + "_global.txt", "\t", True, endTime_, startRow_=startTime_);

            #-- if intersted in resource collected between t1 and t2, subtract amount collected at t1.
            toSubtract = data[0][1];
            if (startTime_ > 1):
                for i in range(len(data)):
                    data[i][1] -= toSubtract;

            #-- convert the res collected column to list
            rewardOverTimeData[sc].append(crData.columnToArray(data, 1));

            #-- append the final collected resource value
            totalRewardData[sc].append(data[len(data)-1][1]);

    #-- normalise all values
    for sc in range(len(scenarios_)):
        totalReward = float(helpers.getTotalRewardByScenario(scenarios_[sc], numOfRobots_));
        before = totalRewardData[sc][0]
        for runNo in range(constants.NUM_RUNS):
            totalRewardData[sc][runNo] /= totalReward;
            for t in range(len(rewardOverTimeData[sc][runNo])):
                rewardOverTimeData[sc][runNo][t] /= totalReward;
        #print("scenario: {}  total rew: {} data: {}  normalised: {}".format(scenarios_[sc], totalReward, before, totalRewardData[sc][0] ))

    return [totalRewardData, rewardOverTimeData];

def unnormaliseRewardCollectedData(scenario_,totalRewardData_, numOfRobots_):
    unnormalised = [0 for runNo in range(constants.NUM_RUNS)];

    totalReward = float(helpers.getTotalRewardByScenario(scenario_, numOfRobots_));
    for runNo in range(constants.NUM_RUNS):
        unnormalised[runNo] = totalRewardData_[runNo] * totalReward;
    return unnormalised;
        #print("scenario: {}  total rew: {} data: {}  normalised: {}".format(scenarios_[sc], totalReward, before, totalRewardData[sc][0] ))


def getTimeTillRewardCollectedData(scenarioFolder_,scenarios_,extraParamStr_, targetRewadPercentage_, numOfRobots_):
    """
    Index 0:
    Get a 2D list of time till a certain reward was collected, where 0th index is the scenarios, 1st index is runs.
    If a target reward was not collected in a run, total run time is recorded.

    """
    print(">>> Get time till " + str(targetRewadPercentage_) + " % reward collected...");

    totalTimeData = [[] for j in range(len(scenarios_)) ];

    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        totalRewardAvailable = float(helpers.getTotalRewardByScenario(scenarios_[sc], numOfRobots_));
        for runNo in range(constants.NUM_RUNS):
            data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/" + scenarios_[sc] + extraParamStr_ + "/Run" + str(runNo) + "_global.txt", "\t", True);
            for t in range(len(data)):
                if (data[t][1] >= (targetRewadPercentage_/100)*totalRewardAvailable or t == len(data)-1):
                    totalTimeData[sc].append(data[t][0]);
                    #print("reward found at t=" + str(data[t][0]));
                    break;


    return [totalTimeData];





def getScoutingSuccessData(scenarioFolder_,scenarios_,extraParamStr_, startTime_, endTime_):
    """
    Index 0:
    Get a 2D list of times of first worksite discovery, where 0th index is the scenarios. In exp C, return median of first worksite discovery of all intervals

    """
    print(">>> Get scouting success in {}...".format(scenarioFolder_));

    firstScoutingTimeData = [[] for j in range(len(scenarios_)) ];

    experimentId = scenarioFolder_[0];
    #print(endTime_)
    for sc in range(len(scenarios_)):
        print(scenarios_[sc]);
        for runNo in range(constants.NUM_RUNS):
            #print("RUN {} ".format(runNo))
            data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/" + scenarios_[sc] + extraParamStr_ + "/Run" + str(runNo) + "_infoEvents.txt", "\t", True, endTime_, startRow_=startTime_);

            firstScoutingTimes = [];
            for row in range(len(data)):
                time = data[row][0];
                eventType = data[row][1];
                taskId = data[row][3];

                if (eventType == 'TASK_SCOUTED'):
                    firstScoutingTimes.append(time);
                    #print("First scouting time append {}".format(time));

            #-- extract the actual first (median) scouting time for this run
            if (experimentId == "A"):
                if (len(firstScoutingTimes) > 0):
                    firstScoutingTimeData[sc].append(firstScoutingTimes[0])
                else:
                    firstScoutingTimeData[sc].append(endTime_)

            elif (experimentId == "C"):
                #print(firstScoutingTimes)
                changeInterval = helpers.getEnvironmentChangeInterval(scenarios_[sc]);
                numOfIntervals = endTime_ / changeInterval;

                firstScoutingTimesAjd = [changeInterval for x in range(numOfIntervals)]; # by default, if there will be no scouting event in this interval, the first scouting time will be the interval length.

                #-- change the first scouting times to be considered from beginning of each change interval
                for currentInterval in range(numOfIntervals):
                    for t in firstScoutingTimes:
                        interval = int(math.floor(t / changeInterval));
                        #print(" interval {} time {} ".format(currentInterval, t, t%changeInterval))
                        if (interval == currentInterval):
                            #-- this is the first t in this interval, add it to the list, but only consider the time it took since beginning of this interval
                            firstScoutingTimesAjd[interval] = (t % changeInterval );
                            #print(" interval {} add time {} as {} ".format(currentInterval, t, t%changeInterval))
                            break;

                #print(firstScoutingTimesAjd);
                #-- for this particular run, consider the median of first scouting times from each change interval as the final fist scouting time
                firstScoutingTimeData[sc].append(crData.getMedian(firstScoutingTimesAjd))


    return [firstScoutingTimeData];


def getTimeFirstWorksiteDepleted(scenarioFolder_,scenarios_,extraParamStr_):
    print(">>> Get time 1st worksite depleted...");

    returnData = [[] for j in range(len(scenarios_)) ];
    for sc in range(len(scenarios_)):
        returnData[sc] = getTimeTillNWorksitesDepleted(scenarioFolder_, scenarios_[sc], extraParamStr_,1)

    return returnData;

def getTimeHalfWorksitesDepleted(scenarioFolder_,scenarios_,extraParamStr_):
    print(">>> Get time half worksites depleted...");

    returnData = [[] for j in range(len(scenarios_)) ];
    for sc in range(len(scenarios_)):
        N_W = helpers.getNumOfWorksitesByScenario(scenarios_[sc])
        returnData[sc] = getTimeTillNWorksitesDepleted(scenarioFolder_, scenarios_[sc], extraParamStr_, max(1,int(math.ceil(N_W/2.0))))

    return returnData;

def getTimeTillNWorksitesDepleted(scenarioFolder_,scenario_,extraParamStr_, numOfWorksitesToDeplete_):
    """
    Return an array with length of number of runs, where each element represents time numOfWorksitesToDeplete_ were depleted in that run.
    """
    print("Get time till {} worksites depleted in scenario {} ". format(numOfWorksitesToDeplete_, scenario_));
    returnData = [];

    for runNo in range(constants.NUM_RUNS):
        data = crData.fileToArray(constants.BASE_FILE_PATH_DATA+"/"+scenarioFolder_ + "/" + scenario_ + extraParamStr_ + "/Run" + str(runNo) + "_infoEvents.txt", "\t", True);
        numOfDepletedWorksites = 0;
        for row in range(len(data)):
            time = data[row][0];
            eventType = data[row][1];
            if (eventType == 'E_TASK_COMPLETED'):
                numOfDepletedWorksites += 1;
                if (numOfDepletedWorksites == numOfWorksitesToDeplete_):
                    returnData.append(time);
                    break;

    return returnData;




def getMediansSummaryForScenarios(data_, experimentLabels_, stackLabels_):
    outp = "--------- medians per controller per scenario ---------- \n"

    mediansLabels = ["Heap1", "Heap2", "Heap4", "Scatter25"]
    mediansData = [[[], [], [], []] for s in range(len(data_))];

    #-- sort experiment data into bins, so that each bin has medians from 1 environment, all subgroups (e.g. distances)
    for stack in range(len(data_)):
        for e in range(len(experimentLabels_)):
            experiment = experimentLabels_[e];
            for m in range(len(mediansLabels)):
                if (mediansLabels[m].lower() in experiment.lower()):
                    #print("Appending to bin {} for experiment {}".format(mediansLabels[m], experiment))
                    mediansData[stack][m].append(crData.getMedian(data_[stack][e]))

        #-- the medians data now has a list of medians in each bin. Convert that to just a single median.
        for m in range(len(mediansData[stack])):
            mediansData[stack][m] = crData.getMedian(mediansData[stack][m])

        #-- output
        stackLabel = "";
        if (len(stackLabels_) > stack):
            stackLabel = stackLabels_[stack]

        outp += stackLabel + ":\n";
        for m in range(len(mediansLabels)):
            outp += "{} : median = {}\n". format(mediansLabels[m], mediansData[stack][m]);

    outp += "\n--------- medians per scenario ---------- \n"

    for m in range(len(mediansLabels)):
        meds = [];
        for stack in range(len(data_)):
            meds.append(mediansData[stack][m])

        outp += "{}: median = {}\n".format(mediansLabels[m], crData.getMedian(meds));

    print(outp)
    return outp;


