import constants;
import os;
import math;

import crGraphs;
import analysis;
import helpers;

constants.BASE_FILE_PATH_DATA = os.path.abspath(os.path.join(os.path.dirname( __file__ ) , "../_docs/results/"));

OUTPUT_DIRECTORY = "environment"
DO_REWARD_MISPLACEMENT_WORKSITE_PROB = True;

if (DO_REWARD_MISPLACEMENT_WORKSITE_PROB):


    envTypes = ['Heap1','Heap2','Heap4','Scatter25'];
    #envTypes = ['Heap1','Heap2','Heap4'];
    tasks = ['COLLECT_RT1-1', 'PERFORM_RT1-1'];
    #tasks = [];

    distances = [5,9,13,17,21];
    taskTypes = [];
    scenarioTypes = [];
    NRsUsed = [];


    for task in tasks:
        fig = None;

        scenarioInfo = helpers.getScenariosBasedOnTypes([task], envTypes, distances, "", "");
        scenarios = scenarioInfo[1];

        print(scenarios);

        scenariosStr = ""
        for sc in scenarios:
            scenariosStr += sc+"-";
        if len(distances) >= 3 and len(envTypes) >= 3:
            scenariosStr = 'all'

        for sc in range(len(scenarios)):
            scenario = scenarios[sc]
            colors = [];
            k = scenario.rfind("_")
            dataLabels = [scenario[k:]]
            #print(dataLabels)
            colors = 'k'


            marker = helpers.getMarkerShapeByEnvironmentName(scenario);

            folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + OUTPUT_DIRECTORY + "/" + "rewMisplWorksiteProb";
            helpers.createFolder(folder);
            fileName = folder + "/rewMisplWorksiteProb" + scenariosStr + ".png";

            worksiteRadius = 1;
            N_W = helpers.getNumOfWorksitesByScenario(scenario);
            p_f = math.pi*math.pow(worksiteRadius,2) / helpers.getArenaMinusBaseSizeByScenario(scenario); #prob of 1 task being at a point in space
            p_F = N_W * p_f; #prob of any task being at a point in space
            environmentMisplacement = (1-p_F) * 1/N_W;

            environmentDifficulty = 0;
            for W in range(N_W):
                N_W_adj = N_W-W;
                p_F = N_W_adj * p_f;
                val = (1-p_F) * 1/N_W_adj;
                #print("N_W_adj={} p_F={} res={}".format(N_W_adj, p_F, val ))
                environmentDifficulty += val;
            environmentDifficulty /= N_W

            misplacementCostCoeffMax = 0;
            if ('COLLECT' in scenario):
                misplacementCostCoeffMax = helpers.getTotalTaskValueByScenario(scenario) / 1.0 #Q/q_MIN

            print("scenario {} p_f={} p_F={} M_E={}".format(scenario, p_f, p_F, environmentDifficulty))

            xData = [environmentDifficulty];
            yData = [misplacementCostCoeffMax]

            xMin = crGraphs.INVALID_VALUE;
            xMax = crGraphs.INVALID_VALUE;
            yMax = 4.1
            #xMin = -constants.INFO_SPEED_FORAGE_MAX/2
            #xMax = constants.INFO_SPEED_FORAGE_MAX
            #if ("PERFORM" in scenarios[sc]):
            #    xMin = -constants.INFO_SPEED_PERFORM_MAX/2
            #    xMax = constants.INFO_SPEED_PERFORM_MAX
            #fig = crGraphs.createScatterPlot(xData, yData, xLabel_ = "Environment difficulty", yLabel_ = "Max. misplacement cost coeff", dataLabels_ = dataLabels, xLimMin_ = xMin, xLimMax_ = xMax, yLimMin_=-0.1, yLimMax_= yMax, marker_ = marker, colors_ = colors, fileName_=fileName, figure_=fig, graphId_=sc%6)




