import constants;
import os;
constants.BASE_FILE_PATH_DATA = os.path.abspath(os.path.join(os.path.dirname( __file__ ) , "../_docs/results/"));


import crGraphs;
import analysis;
import helpers;

crGraphs.DPI = 600;
crGraphs.TICK_FONT_SIZE = '27';

DO_BASIC_ALL = False;
DO_BASIC_SCOUTING_SUCCESS = False;
DO_BASIC_INFO_GAIN =  True;
DO_BASIC_COST_TOTALS = False;

DO_STATIC_COLLECT_ALL = False;
DO_STATIC_COLLECT_SCOUTING_SUCCESS = False;
DO_STATIC_COLLECT_COST_TOTALS = False;

DO_DYNAMIC_ALL = False;
DO_DYNAMIC_SCOUTING_SUCCESS = False;
DO_DYNAMIC_COST_TOTALS = False;


if (DO_BASIC_ALL):
    DO_BASIC_INFO_GAIN =  True;
    DO_BASIC_COST_TOTALS = True;
    DO_BASIC_SCOUTING_SUCCESS = True;

if (DO_STATIC_COLLECT_ALL):
    DO_STATIC_COLLECT_SCOUTING_SUCCESS = True;
    DO_STATIC_COLLECT_COST_TOTALS = True;

if (DO_DYNAMIC_ALL):
    DO_DYNAMIC_SCOUTING_SUCCESS = True;
    DO_DYNAMIC_COST_TOTALS = True;


analysisName = "";
BASE_OUTPUT_DIRECTORY = "_jp01";
markers = ['bs-','ro-','gd-'];


if __name__ == "__main__":

    if (DO_BASIC_INFO_GAIN):

        constants.resetAll();
        print("=========================== DO_BASIC_INFO_GAIN ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/staticConsume"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory);
        constants.DO_LARGE_GRAPHS = True;
        #--

        constants.NUM_RUNS = 50;
        analysisName = '';
        envTypes = ['Scatter25'];
        tasks = ['PERFORM_RT1-1'];
        scenarioFolders = ["A_solitary", 'A_beeRecruiter'];
        NRs=[25];
        distances = [9];
        constants.DO_INFO_GAIN_OVER_TIME = True;
        analysis.doAnalysis_bySwarmSize_byTask_byEnvironment(scenarioFolders, NRs, tasks, envTypes, distances, outputDirectory);


    #---------
    if (DO_BASIC_SCOUTING_SUCCESS):
        constants.resetAll();
        print("=========================== DO_BASIC_SCOUTING_SUCCESS ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/staticConsume"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory);
        constants.DO_LARGE_GRAPHS = True;
        #--

        constants.DO_SCOUTING_SUCCESS = True;
        constants.DO_ANOVA_TABLE = True;


        envTypes = ['Heap1'];
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        tasks = ['PERFORM_RT1-1']; #''
        NRs=[10,25,50];
        NRs=[50];
        distances = [5,9,13,17,21];

        analysis.doAnalysis_bySwarmSize_byTask_byEnvironment(scenarioFolders, NRs, tasks, envTypes, distances, outputDirectory, markers_=markers);



    #---------
    if (DO_BASIC_COST_TOTALS):
        constants.resetAll();
        print("=========================== DO_BASIC_COST_TOTALS ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/staticConsume"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory);
        constants.DO_LARGE_GRAPHS = True;
        #--

        #constants.NUM_RUNS = 2;
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        tasks = ['PERFORM_RT1-1'];
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        NRVals = [25];
        distances = [5,9,13,17,21];

        constants.DO_COSTS_TOTALS = True;
        constants.COST_TOTALS_C_M = False;
        constants.COST_TOTALS_SOCIAL_INFO_GAIN = False;
        constants.DO_ANOVA_TABLE=True;

        #constants.COST_TOTALS_m=False;
        #constants.COST_TOTALS_C_O=False;
        analysis.doAnalysis_bySwarmSize_byTask(scenarioFolders,NRVals,tasks,envTypes,distances,outputDirectory,markers_=markers)

        constants.resetAll();
        constants.DO_LARGE_GRAPHS = True;
        constants.NUM_RUNS = 1;
        envTypes = ['Heap2'];
        tasks = ['PERFORM_RT1-1'];
        scenarioFolders = ['A_localBroadcaster'];
        NRs=[25];
        distances = [9];
        constants.DO_COSTS_OVER_TIME = True;
        analysis.doAnalysis_bySwarmSize_byTask_byEnvironment(scenarioFolders, NRs, tasks, envTypes, distances, outputDirectory,maxTime_=2*3600,markers_=markers)

    #=========================================================================
    #
    #=========================================================================
    if (DO_STATIC_COLLECT_SCOUTING_SUCCESS):
        constants.resetAll();
        print("=========================== DO_STATIC_COLLECT_SCOUTING_SUCCESS ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/staticCollect"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory);
        constants.DO_LARGE_GRAPHS = True;
        #--

        constants.DO_SCOUTING_SUCCESS = True;

        envTypes = ['Heap1', 'Scatter25'];
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        tasks = ['COLLECT_RT1-1']; #''
        NRs=[10,25,50];
        distances = [5,9,13,17,21];

        analysis.doAnalysis_bySwarmSize_byTask_byEnvironment(scenarioFolders, NRs, tasks, envTypes, distances, outputDirectory, markers_=markers);

    #---------
    if (DO_STATIC_COLLECT_COST_TOTALS):
        constants.resetAll();
        print("=========================== DO_STATIC_COLLECT_COST_TOTALS ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/staticCollect"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory);
        constants.DO_LARGE_GRAPHS = True;
        #--

        #constants.NUM_RUNS = 2;
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        tasks = ['COLLECT_RT1-1'];
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        NRVals = [25];
        distances = [5,9,13,17,21];

        constants.DO_COSTS_TOTALS = True;
        #constants.COST_TOTALS_C_M = False;
        #constants.COST_TOTALS_SOCIAL_INFO_GAIN = False;
        analysis.doAnalysis_bySwarmSize_byTask(scenarioFolders,NRVals,tasks,envTypes,distances,outputDirectory,markers_=markers)


    #=========================================================================
    #
    #=========================================================================
    if (DO_DYNAMIC_SCOUTING_SUCCESS):
        constants.resetAll();
        print("=========================== DO_DYNAMIC_SCOUTING_SUCCESS ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/dynamic"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory);
        constants.DO_LARGE_GRAPHS = True;
        #--

        constants.DO_SCOUTING_SUCCESS = True;
        constants.DO_ANOVA_TABLE = True;

        envTypes = ['Heap1'];
        tasks = ['PERFORM_RT1-1'];
        NRs=[10,25,50];
        scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
        experimentTypes = ["C_slow"]
        distances=[5,9,13,17,21];

        constants.DO_SCOUTING_SUCCESS = True;
        analysis.doAnalysis_byExperimentType_bySwarmSize_byTask_byEnvType(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory, markers_=markers);


    #---------
    if (DO_DYNAMIC_COST_TOTALS):
        constants.resetAll();
        print("=========================== DO_DYNAMIC_COLLECT_COST_TOTALS ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/dynamic"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory);
        constants.DO_LARGE_GRAPHS = True;
        #--

        envTypes = ['Heap1', 'Heap2', 'Heap4', 'Scatter25'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        experimentTypes = ["C_fast", "C_slow"]
        NRs=[25];
        distances = [5,9,13,17,21];

        scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];

        constants.DO_COSTS_TOTALS = True;
        constants.COST_TOTALS_SOCIAL_INFO_GAIN = False;
        constants.COST_TOTALS_C_M = False;
        analysis.doAnalysis_byExperimentType_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory, markers_=markers)

