
#ifndef BEE_RECRUITER_H
#define BEE_RECRUITER_H

#include "baseRobot.h"

using namespace argos;

class BeeRecruiter : public BaseRobot {

public:


	struct Parameters {

	   uint signalDistance; // distance in cm of how far signals can be picked up
	   uint maxWaggleDanceTime; // how long a robot recruits for
	   uint maxTeamSizeUnchangedTime; // how long a robot waits by a task if it hasn't recruited any other robot to it (in seconds)
	   Real scoutingProb;
	   uint maxScoutingTime;

	   Parameters() {};
	   void Init(TConfigurationNode& t_node);
   };

public:
	BeeRecruiter();
	void Init(TConfigurationNode& t_node);
	void Reset();

	void ControlStep();

	void Scout();
	void OnTaskScouted();

	void GoToTask();
	void Observe();

	void ProcessTaskReached();
	Real ProcessTask(TASK_TYPE taskType_, int taskId_,  Real processedAmount_, Real taskValue_, Real taskTotalReward_, uint numOfRobotsRequired_);
	void ReturnToBase();
	void OnUnloadResourceDone();

	//-- communication
	void SendTaskInfoToRobot(CRadians angleToObserver_, int toId_);
	void BroadcastTask();
	void FindOtherTaskBroadcasters();
	void ReceiveTaskInfo(bool adoptWorksiteOnlyIfBetter_, bool goToWorksiteWhenReceived_);


	//-- perceptions, probabilities and times
	Real DoTaskUtilityCalculation(TASK_TYPE taskType_, Real taskValue_, Real taskVolume_, Real distanceFromBase_);
	void CalculateWaggleDaceTime();

private:
	void SetState(STATE state_, const bool& isNewState_ = true);

	void PerformWaggleDance();
	void OnTaskProcessingDone(TASK_TYPE taskType_, int taskId_,  Real processedAmount_, Real taskValue_, Real taskTotalReward_, uint numOfRobotsRequired_);
	void WaitForRecruitsInBase();
	void OnTaskReachedButDoesntExist();

	void ResetInfoExchange();
	void ResetInfoExchange(bool listeningOnly_);



private:


	Parameters parameters;

	//-- behaviour
	uint timeWaggleDancing;
	uint waggleDanceTime;
	bool isTaskNewlyScouted;
	uint timeSinceLastRobotArrivedToTask;
	uint lastNumOfRobotsAtTask;
	bool didFindEnoughRobotsAtTask;

	//-- communication
	bool isCommunicating;
	std::vector<uint>otherWorkersAtTask;
	std::vector<uint>encounteredObserverIds;

	bool taskInfoToIdSent;
	bool taskInfoAngleToTargetSent;
	bool taskInfoDistanceToTargetSent;
	bool taskInfoTaskIdSent;
	bool taskInfoUtilitySent;
	bool taskInfoRelUtilitySent;
	bool taskInfoNumOfRobotsRequiredSent;

	bool taskInfoToIdReceived;
	bool taskInfoAngleToTargetReceived;
	bool taskInfoDistanceToTargetReceived;
	bool taskInfoTaskIdReceived;
	bool taskInfoUtilityReceived;
	bool taskInfoRelUtilityReceived;
	bool taskInfoNumOfRobotsRequiredReceived;

	int taskInfoReceivingFromId;

	TaskInfo advertisedTaskInfo;


};

#endif



