import constants;
import os;


constants.BASE_FILE_PATH_DATA = os.path.abspath(os.path.join(os.path.dirname( __file__ ) , "../_docs/results/"));
constants.EXPERIMENT_CACHE_ID = "C"

import crGraphs;
import analysis;
import helpers;


crGraphs.DPI = 100;
constants.NUM_RUNS = 50;


DO_COMPARE_REWARD = False;
DO_COMPARE_REWARD_ANOVA = False;  #note that to do this, python external library from mac ports (/opt/local/...) needs to be used

DO_COMPARE_COSTS_TOTALS = True;
DO_COMPARE_COSTS_TOTALS_BY_EXPERIMENT = False;


DO_INFO_GAIN_COSTS_OVER_TIME = False;
DO_SCOUTING_SUCCESS = False;

DO_TEST_OVER_TIME = False;
DO_TEST_TOTALS = False;


analysisName = "";
outputDirectory = "C_disappearingWorksites";

if __name__ == "__main__":

    START_TIME = 0;
    TIME_BIN_LENGTH = 180;



    #--------------------------
    if (DO_COMPARE_REWARD):
        constants.resetAll();
        print("=========================== DO_COMPARE_REWARD ===========================");

        constants.DO_REWARD_COLLECTED = True;

        envTypes = ['Heap1','Heap2','Heap4','Scatter25'];
        #envTypes = ['Heap2'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['PERFORM_RT1-1'];
        NRs=[10,25,50];
        #NRs=[10];

        experimentTypes = ["C_fast", "C_slow"]
        #experimentTypes = ["C_fast"]
        scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
        distances = [5,9,13,17,21];

        analysis.doAnalysis_byExperimentType_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory)


    if (DO_COMPARE_REWARD_ANOVA):
        constants.resetAll();
        print("=========================== DO_COMPARE_REWARD_ANOVA ===========================");

        #constants.RECALC_TOTAL_REWARD_CACHE = True;
        constants.DO_REWARD_COLLECTED_ANOVA = True;

        envTypes = ['Heap1','Heap2','Heap4','Scatter25'];
        #envTypes = ['Heap1'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['COLLECT_RT1-1'];
        NRs=[10,25,50];
        #NRs=[10];

        experimentTypes = ["C_fast", "C_slow"]
        #experimentTypes = ["C_slow"]
        scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
        distances = [5,9,13,17,21];
        #distances = [9];

        analysis.doAnalysis_byExperimentType_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory)


    #--------------------------
    if (DO_COMPARE_COSTS_TOTALS):
        constants.resetAll();
        print("=========================== DO_COMPARE_COSTS_TOTALS ===========================");

        envTypes = ['Heap1', 'Heap2', 'Heap4', 'Scatter25'];
        #envTypes = ['Heap4', 'Scatter25'];

        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['PERFORM_RT1-1'];
        #tasks = ['COLLECT_RT1-1'];

        experimentTypes = ["C_fast", "C_slow"]
        #experimentTypes = ["C_slow"]

        NRs=[25,10,50];
        #NRs=[50];
        distances = [5,9,13,17,21];

        scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
        #scenarioFolders = ["C_localBroadcaster"];

        constants.DO_COSTS_TOTALS = True;
        analysis.doAnalysis_byExperimentType_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory)

    #------------
    if (DO_COMPARE_COSTS_TOTALS_BY_EXPERIMENT):
        constants.resetAll();
        print("=========================== DO_COMPARE_COSTS_TOTALS_BY_EXPERIMENT ===========================");

        scenarioFolders = ["solitary", 'localBroadcaster','beeRecruiter'];
        experimentTypes = ["A_", "C_slow", "C_fast"];
        #scenarioFolders = ['solitary'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1'];
        #tasks = ['PERFORM_RT1-1'];
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        #envTypes = ['Scatter25'];
        NRs = [10, 25, 50];
        #NRs=[25];

        distances = [5,9,13,17,21];

        constants.DO_COSTS_TOTALS = True;

        #-----
        #-- do the cost graphs, one by one, for some reason graphs get mixed up together when doing more costs at once.
        constants.COST_TOTALS_INFO_SPEED = False;
        constants.COST_TOTALS_SOCIAL_INFO_GAIN = False;
        constants.COST_TOTALS_C_M = False;
        constants.COST_TOTALS_C_O = False;
        constants.COST_TOTALS_m = False;

        constants.COST_TOTALS_INFO_SPEED = True;
        #analysis.doAnalysis_byController_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory);

        constants.COST_TOTALS_INFO_SPEED = False;
        constants.COST_TOTALS_SOCIAL_INFO_GAIN = True;
        #analysis.doAnalysis_byController_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory);

        constants.COST_TOTALS_SOCIAL_INFO_GAIN = False;
        constants.COST_TOTALS_C_M = True;
        analysis.doAnalysis_byController_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory);

        constants.COST_TOTALS_C_M = False;
        constants.COST_TOTALS_C_O = True;
        #analysis.doAnalysis_byController_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory);

        constants.COST_TOTALS_C_O = False;
        constants.COST_TOTALS_m = True;
        #analysis.doAnalysis_byController_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory);

        constants.COST_TOTALS_m = False;
        constants.DO_COSTS_TOTALS = False;
        constants.DO_SCOUTING_SUCCESS = True;
        #analysis.doAnalysis_byController_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory);


    #--------------------------
    if (DO_SCOUTING_SUCCESS):
        constants.resetAll();
        print("=========================== DO_SCOUTING_SUCCESS ===========================");

        constants.DO_SCOUTING_SUCCESS = True;

        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        #envTypes = ['Heap1'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['COLLECT_RT1-1']; #''
        NRs=[10,25,50];
        #NRs=[25];
        scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
        #scenarioFolders = ["C_beeRecruiter"];

        experimentTypes = ["C_fast", "C_slow"]
        #experimentTypes = ["C_slow"]

        distances=[5,9,13,17,21];
        #distances=[5,21];

        analysis.doAnalysis_byExperimentType_bySwarmSize_byTask_byEnvType(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory);
    #--------------------------
    if (DO_INFO_GAIN_COSTS_OVER_TIME):
        constants.resetAll();
        print("=========================== DO_INFO_GAIN_COSTS_OVER_TIME ===========================");

        envTypes = ['Heap1','Heap2','Heap4', 'Scatter25'];
        envTypes = ['Heap2','Heap4'];
        envTypes = ['Scatter25'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['PERFORM_RT1-1'];
        #tasks = ['COLLECT_RT1-1'];

        experimentTypes = ["C_fast", "C_slow"]

        for experimentType in experimentTypes:
            for j in range(len(tasks)):

                analysisName = '';

                constants.DO_COSTS_OVER_TIME = True;
                constants.DO_INFO_GAIN_OVER_TIME = True;

                #scenarioFolders = ["B_localBroadcaster", 'B_solitary'];
                #scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
                scenarioFolders = ["C_beeRecruiter"];

                distances = [];
                taskTypes = [];
                scenarioTypes = [];
                NRsUsed = [];


                for i in range(len(scenarioFolders)):
                    #distances.append([5,9,13,17]);
                    distances.append([9]);
                    scenarioTypes.append(envTypes);
                    taskTypes.append([tasks[j]]);
                    NRsUsed.append(25);


                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRsUsed,"[" + experimentType + "]"); #helpers.getMaxTimeByNR(NRsUsed[0],"C")
                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRsUsed, START_TIME,3600,TIME_BIN_LENGTH, analysisName,outputDirectory, graphLineWidth_=0, areScenarioFoldersStacked=True, outputFilePrefix_=experimentType+"_", maxResCollected_=20);

    #--------------------------
    if (DO_TEST_OVER_TIME):
        constants.resetAll();

        constants.resetAll();
        #envTypes = ['Heap1','Heap2','Heap4', 'Scatter25'];
        #envTypes = ['Heap4','Scatter25'];
        envTypes = ['Scatter25'];
        #tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        tasks = ['COLLECT_RT1-1'];
        #tasks = ['PERFORM_RT1-1'];

        constants.NUM_RUNS = 50;
        constants.DO_INFO_GAIN_OVER_TIME = True;
        constants.DO_COSTS_OVER_TIME = True;
        constants.DO_REWARD_CALC_CHECK_OVER_TIME = True;

        #experimentTypes = ["C_fast", "C_slow"]
        #experimentTypes = ["C_slow"]
        experimentTypes = ["C_fast"]

        scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
        scenarioFolders = ["C_beeRecruiter"];
        NRs=[25];
        distances = [5];
        #distances = [5,9,13,17,21];

        analysis.doAnalysis_byExperimentType_bySwarmSize_byTask(scenarioFolders,experimentTypes,NRs,tasks,envTypes,distances,outputDirectory, "TEST")

    if (DO_TEST_TOTALS):
        constants.resetAll();
        #envTypes = ['Heap1', 'Heap2', 'Heap4','Scatter25'];
        #envTypes = ['Heap1','Heap4']
        envTypes = ['Scatter25']

        #tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['PERFORM_RT1-1'];
        #tasks = ['COLLECT_RT1-1'];

        #experimentTypes = ["C_fast", "C_slow"]
        experimentTypes = ["C_fast"]

        #NRs=[25,10,50];
        NRs=[10];

        #scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
        #scenarioFolders = ["C_solitary", 'C_localBroadcaster'];
        scenarioFolders = ["C_localBroadcaster"];

        constants.NUM_RUNS = 50;
        constants.DO_COSTS_TOTALS = True;
        constants.DO_COSTS_OVER_TIME = False;
        constants.DO_REWARD_COLLECTED = False;

        for experimentType in experimentTypes:
            for NR in NRs:
                for j in range(len(tasks)):

                    analysisName = "NR" + str(NR) + "_" + tasks[j];

                    distances = [];
                    taskTypes = [];
                    scenarioTypes = [];
                    NRstoUse = [];

                    for i in range(len(scenarioFolders)):
                        #distances.append([5,9,13,17]);
                        distances.append([5,13]);
                        scenarioTypes.append(envTypes);
                        taskTypes.append([tasks[j]]);
                        NRstoUse.append(NR);

                    extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRstoUse,"[" + experimentType + "]");
                    analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, START_TIME,helpers.getMaxTimeByNR(NR, "C"),TIME_BIN_LENGTH, analysisName,outputDirectory, graphLineWidth_=0, areScenarioFoldersStacked=True, outputFilePrefix_="TEST_" + experimentType+"_");











