#ifndef FORAGING_LOOP_FUNCTIONS_H
#define FORAGING_LOOP_FUNCTIONS_H

#include <argos3/core/simulator/loop_functions.h>
#include <argos3/core/simulator/entity/floor_entity.h>
#include <argos3/core/utility/math/range.h>
#include <argos3/core/utility/math/rng.h>
#include <argos3/plugins/simulator/entities/cylinder_entity.h>
#include <controllers/baseRobot.h>
#include <argos3/plugins/simulator/entities/box_entity.h>

using namespace argos;

class MainLoopFunctions : public CLoopFunctions {

#define PREDEFINED_TASK_POSITIONS_MULTIPLIER 2
#define GROUP_SIZE 5


public:

   static const Real ZERO_WORKSITE_VOLUME;

   MainLoopFunctions();
   virtual ~MainLoopFunctions() {}

   virtual void Init(TConfigurationNode& t_tree);
   virtual void Reset();
   virtual void Destroy();
   virtual CColor GetFloorColor(const CVector2& c_position_on_plane);
   virtual void PreStep();

   void OnNewRun();
   CCylinderEntity* GetTaskByPosition(CVector3 position_);
   int GetTaskIdByPosition(CVector3 position_, Real maxDistance_);
   int GetTaskIdByPosition(CVector3 position_, Real maxDistance_, bool includeInactiveTasks_);
   int GetTaskIdByPosition(CVector3 position_);
   int GetTaskIdByPosition(CVector3 position_, bool includeInactiveTasks_);
   int GetRealTaskIdByReportedId(const int& reportedId_);
   CCylinderEntity* GetTaskById(const int& id_);
   BaseRobot& GetRobotById(const int& id_);

private:

   void UpdateTaskAfterProcessingStep(CCylinderEntity& task_, int taskId_);
   CVector2 GenerateTaskPosition(CCylinderEntity& task_);
   Real GenerateTaskMass(int taskId_);

   enum ENVIRONMENT_EVENT {
	   E_EVENT_TASK_COMPLETED=0,
	   E_EVENT_TASK_ADDED,
	   E_EVENT_TASK_DESTROYED,
   };
   std::string GetEnvironmentEventTypeDescription(ENVIRONMENT_EVENT e_) {
	   switch (e_) {
	   case E_EVENT_TASK_COMPLETED: return "E_TASK_COMPLETED";
	   case E_EVENT_TASK_ADDED: return "E_TASK_ADDED";
	   case E_EVENT_TASK_DESTROYED: return "E_TASK_DESTROYED";
	   return "E_VOID";
	   }
   }

   struct TaskInfo {
	   CVector2 position;
	   bool isActive;
	   BaseRobot::TASK_TYPE type;
	   uint numOfRobotsRequired;
	   uint reportedTaskId;

	   TaskInfo(CVector2 position_, BaseRobot::TASK_TYPE type_, uint numOfRobotsRequired_, uint reportedTaskId_) {
		   position = CVector2(position_);
		   isActive = true;
		   type = type_;
		   numOfRobotsRequired = numOfRobotsRequired_;
		   reportedTaskId = reportedTaskId_;
	   }

   };

   BaseRobot::TASK_TYPE defaultTaskType;

   Real taskGradientRadius; //size of gradient around the food item
   Real taskRadius;
   Real taskMinDistanceFromBase;
   Real workPerformed;

   uint taskDisappearRate; //rate at which a random task / group disappears and appears somewhere else fully replenished
   Real taskRenewabilityThreshold; //% of task volume at which it disappears and renews somewhere else
   uint taskAppearRate; //rate at which a new task/group is added into the environment on top of the existing ones
   uint taskAppearTime; // overrides the taskAppearRate, by taskAppearRate = taskAppearTime/ (numOfTasks - ceil(numOfTasks*taskAppearStartingPercentage))
   Real taskAppearStartingPercentage; //if taskAppearRate > 0, how many tasks (% of total task number) there are at the beginning

   uint taskValueChangeRate; // rate and which task volumes are replenished and quality is reassigned

   int timeTillNextTaskDisappears;
   int timeTillNextTaskAppears;
   int timeTillQualityReassigned;


   uint numOfActiveTasks;
   uint maxTaskId;
   uint minTaskId;

   //UInt32 numOftasks;

   CRange<Real> m_cForagingArenaSideX, m_cForagingArenaSideY;
   std::vector<CVector2> preSpecifiedTaskPositions;
   std::vector<TaskInfo> taskData;


   CFloorEntity* floor;
   CRandom::CRNG* randNumGenerator;

   std::string outputFileNamePrefix;
   std::ofstream outputFileGlobal;
   std::ofstream outputFileInfoEvents;


   Real numOfRobots;
   uint numOfScouts;
   uint numOfResters;
   uint numOfBroadcasters;
   uint numOfPerformers;
   uint numOfGoingToTask;

   uint numOfTasks;
   uint numOfPredefinedLocations;
   Real taskMaxDistanceFromBase;
   Real originalTaskHeight;
   bool evenlySpacedTasks;

   uint minRobotsForTask;
   uint maxRobotsForTask;




};

const Real MainLoopFunctions::ZERO_WORKSITE_VOLUME = 0.00001;

#endif
