import constants;
import os;
constants.BASE_FILE_PATH_DATA = os.path.abspath(os.path.join(os.path.dirname( __file__ ) , "../_docs/results/"));


import crGraphs;
import analysis;
import helpers;


crGraphs.DPI = 100;
constants.NUM_RUNS = 50;

DO_BASIC_SCOUTING_SUCCESS = False;
DO_CO = True;

DO_STATIC_COLLECT_SCOUTING_SUCCESS = False;
DO_DYNAMIC_SCOUTING_SUCCESS = False;
DO_INFO_SPEED_TIME_BIN_SENSITIVITY = False;


analysisName = "";
BASE_OUTPUT_DIRECTORY = "_jp01supplementary";


if __name__ == "__main__":

    if (DO_BASIC_SCOUTING_SUCCESS):
        constants.resetAll();
        print("=========================== DO_BASIC_SCOUTING_SUCCESS ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/basic"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory)
        #--

        constants.DO_SCOUTING_SUCCESS = True;

        envTypes = ['Heap2', 'Heap4', 'Scatter25'];
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        tasks = ['PERFORM_RT1-1']; #''
        NRs=[10,25,50];
        distances = [5,9,13,17,21];

        analysis.doAnalysis_bySwarmSize_byTask_byEnvironment(scenarioFolders, NRs, tasks, envTypes, distances, outputDirectory);

    #-----------------
    if (DO_CO):
        constants.resetAll();
        print("=========================== DO_CO ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/basic"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory)
        #--

        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        tasks = ['PERFORM_RT1-1'];
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        NRVals = [10,50];
        distances = [5,9,13,17,21];

        constants.DO_COSTS_TOTALS = True;
        constants.COST_TOTALS_C_U = False;
        constants.COST_TOTALS_C_M = False;
        constants.COST_TOTALS_m = False;
        constants.COST_TOTALS_SOCIAL_INFO_GAIN = False;
        constants.COST_TOTALS_INFO_SPEED = False;
        #analysis.doAnalysis_bySwarmSize_byTask(scenarioFolders,NRVals,tasks,envTypes,distances,outputDirectory)


        outputDirectory = BASE_OUTPUT_DIRECTORY + "/staticCollect"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory)
        tasks = ['COLLECT_RT1-1'];
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        NRVals = [10];
        #analysis.doAnalysis_bySwarmSize_byTask(scenarioFolders,NRVals,tasks,envTypes,distances,outputDirectory)

        outputDirectory = BASE_OUTPUT_DIRECTORY + "/dynamic"
        scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
        tasks = ['PERFORM_RT1-1'];
        experimentTypes = ["C_slow","C_fast"]
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        NRs = [10];
        #analysis.doAnalysis_byExperimentType_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory)


        tasks = ['COLLECT_RT1-1'];
        experimentTypes = ["C_slow","C_fast"]
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        NRs = [10,25,50];
        analysis.doAnalysis_byExperimentType_bySwarmSize_byTask(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory)



    #---------
    if (DO_STATIC_COLLECT_SCOUTING_SUCCESS):
        constants.resetAll();
        print("=========================== DO_STATIC_COLLECT_SCOUTING_SUCCESS ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/staticCollect"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory)
        #--

        envTypes = ['Heap1', 'Heap2', 'Heap4', 'Scatter25'];
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        tasks = ['COLLECT_RT1-1']; #''
        NRs=[10,25,50];
        distances = [5,9,13,17,21];

        constants.DO_SCOUTING_SUCCESS = True;
        analysis.doAnalysis_bySwarmSize_byTask_byEnvironment(scenarioFolders, NRs, tasks, envTypes, distances, outputDirectory)

    if (DO_DYNAMIC_SCOUTING_SUCCESS):
        constants.resetAll();
        print("=========================== DO_DYNAMIC_SCOUTING_SUCCESS ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/dynamic"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory)
        #--

        envTypes = ['Scatter25'];
        tasks = ['PERFORM_RT1-1','COLLECT_RT1-1']; #''
        NRs=[10,25,50];
        scenarioFolders = ["C_solitary", 'C_localBroadcaster','C_beeRecruiter'];
        experimentTypes = ["C_fast","C_slow"]
        distances=[5,9,13,17,21];

        constants.DO_SCOUTING_SUCCESS = True;
        analysis.doAnalysis_byExperimentType_bySwarmSize_byTask_byEnvType(scenarioFolders, experimentTypes, NRs, tasks, envTypes, distances, outputDirectory);

    #-----------------
    if (DO_INFO_SPEED_TIME_BIN_SENSITIVITY):
        constants.resetAll();
        print("=========================== DO_INFO_SPEED_TIME_BIN_SENSITIVITY ===========================");
        outputDirectory = BASE_OUTPUT_DIRECTORY + "/basic"
        helpers.createFolder(constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory)
        #--

        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];

        constants.resetAll();
        outputFilePrefix = "infoSpeedTimeBinSensitivity_";
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1'];
        NRs=[10,25,50];

        infoSpeedBinTimes = [30,60,120,240]

        constants.DO_COSTS_TOTALS = True;
        constants.COST_TOTALS_C_M = False;
        constants.COST_TOTALS_C_O = False;
        constants.COST_TOTALS_m = False;
        constants.COST_TOTALS_SOCIAL_INFO_GAIN = False;

        for infoSpeedBinTime in infoSpeedBinTimes:
            constants.TIME_BIN_LENGTH_INFO_SPEED = infoSpeedBinTime;

            for NR in NRs:
                for j in range(len(tasks)):

                    analysisName = "NR" + str(NR) + "_" + tasks[j];

                    distances = [];
                    taskTypes = [];
                    scenarioTypes = [];
                    NRstoUse = [];

                    for i in range(len(scenarioFolders)):
                        distances.append([9,13,17]);
                        scenarioTypes.append(envTypes);
                        taskTypes.append([tasks[j]]);
                        NRstoUse.append(NR);

                    extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRstoUse);
                    analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0, helpers.getMaxTimeByNR(NR),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory, graphLineWidth_=0, areScenarioFoldersStacked=True, outputFilePrefix_=outputFilePrefix);
