#include "antRecruiter.h"

#include <argos3/core/utility/configuration/argos_configuration.h>
#include <argos3/core/utility/math/vector2.h>
#include <argos3/core/utility/logging/argos_log.h>
#include <algorithm>

/**
 * Ant Recruiter
 * 	SCOUT		----->	(rT=RT) -----> 		LOAD
 * 						(else) ------> 		WAIR NEAR TASK
 *
 * 	LOAD 		----->	(task done) ----->	SCOUT
 *
 * 	WAIT N.T.	----->	(rT=RT)		----->	LOAD
 * 						(time up)	----->	SCOUT
 */
/**
 * Initialisation of set / explored parameters
 */
void AntRecruiter::Parameters::Init(TConfigurationNode& t_node) {
   try {
	   GetNodeAttribute(t_node, "signalDistance", signalDistance);
	   GetNodeAttribute(t_node, "maxTeamSizeUnchangedTime", maxTeamSizeUnchangedTime);

	   //-- convert times in seconds to time in ticks
	   maxTeamSizeUnchangedTime *= 10;

   } catch(CARGoSException& ex) {
      THROW_ARGOSEXCEPTION_NESTED("Error initializing parameters.", ex);
   }

}


//======================================= INITIALISATIONS
AntRecruiter::AntRecruiter() {

}

void AntRecruiter::Init(TConfigurationNode& t_node) {
	BaseRobot::Init(t_node);
	try {
		parameters.Init(GetNode(t_node, "parameters"));
	}
	catch(CARGoSException& ex) {
		THROW_ARGOSEXCEPTION_NESTED("Error initializing the foot-bot foraging controller for robot \"" << GetId() << "\"", ex);
	}

}

void AntRecruiter::Reset() {
	BaseRobot::Reset();
	SetState(STATE_SCOUTING);
}


//======================================= UPDATE LOOP


//============================================ GOING TO KNOWN TASK =======================


//============================================ TASK PROCESSING =======================


//====================================== COMMUNICATION




/****************************************/
/****************************************/

/*
 * This statement notifies ARGoS of the existence of the controller.
 * It binds the class passed as first argument to the string passed as
 * second argument.
 * The string is then usable in the XML configuration file to refer to
 * this controller.
 * When ARGoS reads that string in the XML file, it knows which controller
 * class to instantiate.
 * See also the XML configuration files for an example of how this is used.
 */
REGISTER_CONTROLLER(AntRecruiter, "antRecruiterController")


