
#ifndef LOCAL_BROADCASTER_H
#define LOCAL_BROADCASTER_H

#include "baseRobot.h"

using namespace argos;

class LocalBroadcaster : public BaseRobot {

public:


	struct Parameters {

	   uint signalDistance; // distance in cm of how far signals can be picked up
	   uint maxTeamSizeUnchangedTime; // how long a robot waits by a task if it hasn't recruited any other robot to it (in seconds)

	   Parameters() {};
	   void Init(TConfigurationNode& t_node);
   };

public:
	LocalBroadcaster();
	void Init(TConfigurationNode& t_node);
	void Reset();

	void ControlStep();

	void Scout();
	void OnTaskScouted();

	void GoToTask();
	void ProcessTaskReached();
	Real ProcessTask(TASK_TYPE taskType_, int taskId_,  Real processedAmount_, Real taskValue_, Real taskTotalReward_, uint numOfRobotsRequired_);
	void ReturnToBase();
	void OnTaskProcessingDone(TASK_TYPE taskType_, int taskId_,  Real processedAmount_, Real taskValue_, Real taskRewardLeft_, uint numOfRobotsRequired_);
	void OnUnloadResourceDone();

	//-- communication
	void SendTaskInfoToRobot(CRadians angleToObserver_, int toId_);
	void BroadcastTask();
	void FindOtherTaskBroadcasters();
	void ReceiveTaskInfo(bool adoptWorksiteOnlyIfBetter_);




private:
	void SetState(STATE state_, const bool& isNewState_ = true);
	void AbandonTask(bool reportEvent_ = true);
	void DoNeighbourhoodSearch();
	void ResetInfoExchange();
	void ResetInfoExchange(bool listeningOnly_);

private:


	Parameters parameters;

	//-- behaviour
	uint timeSinceLastRecruitment;
	uint lastNumOfRecruitedRobots;

	int timeTillRerecruitmentAllowed;
	int forbiddenTaskId;

	//-- communication
	bool isCommunicating;
	std::vector<uint>encounteredIdsAtTask;
	std::vector<uint>encounteredObserverIds;

	bool taskInfoToIdSent;
	bool taskInfoAngleToTargetSent;
	bool taskInfoDistanceToTargetSent;
	bool taskInfoTaskIdSent;
	bool taskInfoUtilitySent;
	bool taskInfoRelUtilitySent;
	bool taskInfoNumOfRobotsRequiredSent;

	bool taskInfoToIdReceived;
	bool taskInfoAngleToTargetReceived;
	bool taskInfoDistanceToTargetReceived;
	bool taskInfoTaskIdReceived;
	bool taskInfoUtilityReceived;
	bool taskInfoRelUtilityReceived;
	bool taskInfoNumOfRobotsRequiredReceived;

	int taskInfoReceivingFromId;

	TaskInfo advertisedTaskInfo;


};

#endif



