#include "qtLoopFunctions.h"
#include <controllers/baseRobot.h>
#include <argos3/core/simulator/entity/controllable_entity.h>

using namespace argos;

/****************************************/
/****************************************/

QTLoopFunctions::QTLoopFunctions() {
   RegisterUserFunction<QTLoopFunctions,CFootBotEntity>(&QTLoopFunctions::Draw);
}

/****************************************/
/****************************************/

void QTLoopFunctions::Draw(CFootBotEntity& c_entity) {
	BaseRobot& footBot = dynamic_cast<BaseRobot&>(c_entity.GetControllableEntity().GetController());
	//-- draw base odomerty location
	DrawCylinder(0.05f, 0.05f, CVector3(-footBot.GetRelativeBaseLocation().GetX(), -footBot.GetRelativeBaseLocation().GetY(), 0.1f), CColor::CYAN);
	DrawSegment(CVector3(-footBot.GetRelativeBaseLocation().GetX(), -footBot.GetRelativeBaseLocation().GetY(), 0.1f),
	    		CVector3::ZERO,
	    		CColor::GRAY50);
	//LOGERR << -footBot.GetRelativeBaseLocation().GetX() << " | " << -footBot.GetRelativeBaseLocation().GetY() << std::endl;
	//-- draw target deposit odometry location
	BaseRobot::TaskInfo taskInfo = footBot.GetTaskInfo();
    if (!taskInfo.isNull) {
    	DrawCylinder(0.05f, 0.05f, CVector3(-taskInfo.relLocation.GetX(), -taskInfo.relLocation.GetY(), 0.1f), CColor::RED);
    	DrawSegment(CVector3(-taskInfo.relLocation.GetX(), -taskInfo.relLocation.GetY(), 0.1f),
    	    		CVector3::ZERO,
    	    		CColor::RED);
    }



}

/****************************************/
/****************************************/

REGISTER_QTOPENGL_USER_FUNCTIONS(QTLoopFunctions, "qtLoopFunctions")
