import helpers;
import constants;
import crGraphs;
import crData;
import analysisData;

import math;
import copy;
import numpy as np;

from scipy import stats



def analyse(scenarioFolders_, taskTypes_, scenarioTypes_, distances_, folderExtraParamStrs_, numOfRobots_, startTime_, endTime_, timeBinLength_,
            analysisName_, outputDirectory_, outputTextFiles_ = True,

            xAxisLabels_=[], stackedParameterLabels_ = [], orderResultsByScenario_=True, showLegends_ = True, graphLineWidth_=0,
            areScenarioFoldersStacked = False, areNrsStacked = False, areDistancesStacked = False, scenarioExtraParamStrs_ = [],
            maxResCollected_=1, timeTillRewardCollectedTargetPercentage_=100,xAxisGroupSize_=0,
            outputFilePrefix_="",yTickStep_=crGraphs.INVALID_VALUE, legendLabels_ = [], legendCols_=4, markers_=[], colors_=[],
            fig_timeTillRewardCollected=None, fig_cost_totals_c_u=None, fig_cost_totals_c_m=None, fig_cost_totals_c_o=None, fig_cost_totals_m=None, fig_cost_totals_i=None, fig_cost_totals_social_info_gain=None,
            fig_scouting_success=None, markerSize_ = 0,
            yLimMin_ = 0, yLimMax_=crGraphs.INVALID_VALUE):

    """
    :param scenarioFolders_: 1D list of folders
    :param taskTypes_: 2D list of task types for each of the scenario types, 0th dimension has the same length as scenarioFolders_
    :param scenarioTypes_: 2D list of scenario types, 0th dimension has the same length as scenarioFolders_
    :param distances_:  2D list of deposit distances, 0th dimension has the same length as scenarioFolders_
    :param folderExtraParamStr_: 1D list of extra param strings, for each tested folder
    :param scenarioExtraParamStrs_ : 2D list of extra param strings per scenario, 0th dimension has the same length as scenarioFolders_, 1st dimension has length of scenarioTypes_[0]
    :param environmentChangeTimes_: 1D list of times when there was some spontaneous new information in the environment (e.g. tasks appeared)
    :param numOfRobots_: 1D list of number of robots for each tested folder
    :param startTime_:
    :param endTime_:
    :param timeBinLength_:
    :param xAxisLabels_: label for the x axis ticks on the non-time graphs. Leave empty to include full description of each scenario.
    :param stackedParameterLabels_: labels for extra parameters (e.g. for optimisation: ['TteamUnchg120','TteamUnchg300']. Settings this will cause non-time graphs on top of each other in one figure
    :param xAxisGroupSize_ set to > 1 if reduction of value should be compared for last member of each group with 1st member of each group. Groups group ticks along x axis. Also, causes spaces to be created in graph lines
    :param areDistancesStacked: if set to true, stacks on top of each other will be created for distances. Supply distances_ as a 1D list, not 2D.
    :param fig_* : figures to use for the different analyses
    :return: list of produced figures
    """
    ###

    #-- graph settings based on publication type
    doBoxPlots = True;
    doConfidenceIntervals = False;

    if (constants.PUBLICATION_TYPE == constants.PUBLICATION_TYPE_CP01):
        doConfidenceIntervals = True;
        doBoxPlots = False;

    #--
    if (yTickStep_ == crGraphs.INVALID_VALUE):
        if (endTime_ < 5):
            yTickStep_ = 1800;
        else:
            yTickStep_ = 3600;

    if (len(colors_) == 0):
        colors=['b','r','g'];
    else:
        colors = colors_;

    if (len(markers_) == 0):
        markers = ['bs-','rs-','gs-'];
    else:
        markers = markers_;

    if (constants.PUBLICATION_TYPE == constants.PUBLICATION_TYPE_CP01):
        markers_ = ['ks-','ko-','kd-'];
        markers = markers_;

    if (areNrsStacked):
            colors = ['#CF4217', '#1083DB', '#650965'];

    if (markerSize_ == 0):
        markerSize = 5;
        if (graphLineWidth_ > 1 or graphLineWidth_ == 0):
            markerSize = 8;

        if (constants.PUBLICATION_TYPE == constants.PUBLICATION_TYPE_CP01):
            markerSize = 9;
    else:
        markerSize = markerSize_;


    if (constants.DO_LARGE_GRAPHS):
        if (graphLineWidth_ > 0):
           graphLineWidth_ = max(5, graphLineWidth_);
        markerSize = max(15, markerSize);
        crGraphs.TICK_FONT_SIZE = 30;

    print(crGraphs.TICK_FONT_SIZE)
    #print(scenarioFolders_);
    #print(scenarioTypes_);
    #print(distances_);
    #print(folderExtraParamStrs_);

    if (areScenarioFoldersStacked):
        stackedParameterLabels_ = scenarioFolders_;
        includeFolderNameOnXAsix = False;
        scenarioFolders_ = [''];
    elif (areDistancesStacked):
        stackedParameterLabels_ = [];
        for d in range(len(distances_)):
            stackedParameterLabels_.append("D=" + str(distances_[d]) + "m");

    if (len(legendLabels_) == 0):
        legendLabels_ = stackedParameterLabels_;


    #-- create time label
    timeLabels = [];
    detailTimeLabels = [];
    infoGainTimeLabels = [];

    for x in range(startTime_,startTime_+endTime_,timeBinLength_):
        endTime = x+timeBinLength_;
        if (endTime % 1800 == 0):
            timeLabels.append(str(endTime/3600.0));
        else:
            timeLabels.append('');

    counter = 0;
    for x in range(startTime_,startTime_+endTime_,constants.TIME_BIN_LENGTH_DETAIL):
        endTime = x+timeBinLength_;
        if (counter % 10 == 0):
            detailTimeLabels.append(endTime);
        else:
            detailTimeLabels.append('')
        counter += 1;

    counter = 0;
    for x in range(startTime_,startTime_+endTime_,constants.TIME_BIN_LENGTH_INFO_SPEED):
        endTime = x+timeBinLength_;
        if (counter % 10 == 0):
            infoGainTimeLabels.append(endTime);
        else:
            infoGainTimeLabels.append('')
        counter += 1;

    #-- create overall model+scenario labels
    includeFolderNameOnXAsix = (len(scenarioFolders_) > 1);
    modelsScenariosLabels = [];

    for sf in range(len(scenarioFolders_)):
        distances = distances_[sf];
        if (areDistancesStacked):
            distances = distances_;

        folderExtraParamStr = folderExtraParamStrs_[sf];

        scenarioExtraParamStrs = [];
        if (len(scenarioExtraParamStrs_) > sf):
            scenarioExtraParamStrs = scenarioExtraParamStrs_[sf];

        numOfRobots = numOfRobots_[sf];
        if (type(numOfRobots_[sf]) == list and areNrsStacked):
            numOfRobots = numOfRobots_[sf][0]
        scenarioInfo = helpers.getScenariosBasedOnTypes(numOfRobots, taskTypes_[sf], scenarioTypes_[sf], distances, folderExtraParamStr, scenarioExtraParamStrs);

        scenarios = scenarioInfo[1];
        #print("ANALYSIS 146:" + str(scenarios));

        for sc in range(len(scenarios)):
            if (includeFolderNameOnXAsix):
                modelsScenariosLabels.append(scenarioFolders_[sf] + "\n" + scenarioInfo[2][sc]);
            else:
                modelsScenariosLabels.append(scenarioInfo[2][sc]);

    modelsScenariosLabelsByScenario = ["" for q in range(len(modelsScenariosLabels))];
    for sf in range(len(scenarioFolders_)):
        for sc in range(len(scenarios)):
            modelsScenariosIndex = sf*len(scenarios) + sc; #ordered by folder
            modelsScenariosIndexByScenario = sc*len(scenarioFolders_) + int(math.floor(modelsScenariosIndex / len(scenarios))); #ordered by scenario
            #print(sc, modelsScenariosIndex, modelsScenariosIndexByScenario);
            modelsScenariosLabelsByScenario[modelsScenariosIndexByScenario] = modelsScenariosLabels[modelsScenariosIndex];

    if (len(xAxisLabels_) == 0):
        if (orderResultsByScenario_):
            xAxisLabels_ = modelsScenariosLabelsByScenario;
        else:
            xAxisLabels_ = modelsScenariosLabels;

    figs = [];
    #-- create clear data
    uncertaintyCostTotals = [[[0 for r in range(constants.NUM_RUNS)] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))] ;

    misplacementCostTotals = [[[0 for r in range(constants.NUM_RUNS)] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    opportunityCostTotals = [[[0 for r in range(constants.NUM_RUNS)] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    misplVsUncCostTotals = [[[0 for r in range(constants.NUM_RUNS)] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    infoSpeedTotals = [[[0 for r in range(constants.NUM_RUNS)] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    numOfRobotsPayingCosts = [[[0 for r in range(constants.NUM_RUNS)] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];


    socialInfoGainCoefficientTotals = [[[0 for r in range(constants.NUM_RUNS)] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    socialInfoGainCoefficientTotals_med = [[[0 for r in range(constants.NUM_RUNS)] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];

    rewardTotals = [[[] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    rewardTotals_nonNorm = [[[] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    scoutingSuccessTotals = [[[] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    timeRewardCollectedTotals = [[[] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    timeInfoStoppedTotals = [[[] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    timeToReachWorksite = [[[] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];

    timeFirstWorksiteDepletedTotals = [[[] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];
    timeHalfWorksitesDepletedTotals = [[[] for sc in range(len(modelsScenariosLabels))] for stack in range(max(1,len(stackedParameterLabels_)))];


    for stack in range(max(1,len(stackedParameterLabels_))):

        print("-------------------------------------------------------------------------------------------------- STACK: " + stackedParameterLabels_[stack])

        if (areScenarioFoldersStacked):
            scenarioFolders_ = [stackedParameterLabels_[stack]];

        misplVsUncCostCoeffData = [];
        infoFlowSpeedDataMed = [];
        infoFlowSpeedDataMax = [];

        for sf in range(len(scenarioFolders_)):
            print("--------------------------------------------------------------------------------------------------")
            print("------------------------------------------------- scenario folder: " + scenarioFolders_[sf]);
            print("--------------------------------------------------------------------------------------------------")
            scenarioFolder = scenarioFolders_[sf];

            distances = distances_[sf];
            if (areDistancesStacked):
                distances = [distances_[stack]];

            scenarioTypes = scenarioTypes_[sf];

            if (areScenarioFoldersStacked):
                folderExtraParamStr = folderExtraParamStrs_[stack];

            else:
                folderExtraParamStr = folderExtraParamStrs_[sf];

            numOfRobots = numOfRobots_[sf];
            if (areScenarioFoldersStacked):
                numOfRobots = numOfRobots_[stack];
            if (type(numOfRobots_[sf]) == list and areNrsStacked):
                numOfRobots = numOfRobots_[sf][stack];

            isCustomEndTimeUsed = False;
            expIdForMaxTime = "C"
            if ("A_" in scenarioFolder):
                expIdForMaxTime = "A"
            properEndTime = helpers.getMaxTimeByNR(numOfRobots,expIdForMaxTime)
            if (endTime_ != properEndTime):
                isCustomEndTimeUsed = True;
                print("!!! CUSTOM END TIME USED. RESULTS WILL NOT BE CACHED !!!")
                print(" End time used {} proper end time {} ".format(endTime_, properEndTime))
                print("--------------------------------------------------------")

            #print("--- {}: {} - {} {} ".format(numOfRobots_, numOfRobots,sf, stack))



            #-- get scenario data
            scenarioExtraParamStrs = [];
            if (len(scenarioExtraParamStrs_) > sf):
                scenarioExtraParamStrs = scenarioExtraParamStrs_[sf];

            scenarioInfo = helpers.getScenariosBasedOnTypes(numOfRobots, taskTypes_[sf],scenarioTypes, distances, folderExtraParamStr, scenarioExtraParamStrs);

            scenarios = scenarioInfo[1];

            taskInfo = helpers.getTaskInfo(scenarios);
            taskUtilities = taskInfo[0];
            scenarioTypeNames = taskInfo[1];

            extraParamStr = '';
            if (len(stackedParameterLabels_) > 0 and areScenarioFoldersStacked == False and areDistancesStacked == False):
                extraParamStr = stackedParameterLabels_[stack];

            print("processing for extra param string '" + str(extraParamStr) + "'");

            #-- create clear data
            uncertaintyCostDataSampledDown = [];
            infoMisplacementCostDataSampledDown = [];
            coordinationCostDataSampledDown = [];

            infoValueDataSampledDown = [];
            infoValueSocialDataSampledDown = [];
            infoGainDataSampledDown = [];

            infoGainSocialDataSampledDown = [];
            deltaCalculatedRewardDataSampleDown = [];

            potentialRewardDataSampledDown = [];
            calculatedRewardDataSampledDown = [];
            maxPotentialGainDataSampledDown = [];

            rewardOverTimeDataSampledDown = [];

            misplVsUncCostDataSampleDown = [];

            infoFlowSpeedDataMed.append([np.NaN for i in range(len(scenarios))]);
            infoFlowSpeedDataMax.append([np.NaN for i in range(len(scenarios))]);
            misplVsUncCostCoeffData.append([np.NaN for i in range(len(scenarios))]);


            #========================================================= get data

            #----------------------------- info events and costs
            if (constants.DO_COSTS_OVER_TIME or constants.DO_VOLUME_PER_FORAGER_OVER_TIME or constants.DO_VOLUME_PER_FORAGER or constants.DO_INFO_VALUE_OVER_TIME
                or constants.DO_SWARM_STATS_ENV_STATS_CORRELATION or constants.DO_INFO_GAIN_OVER_TIME or constants.DO_COSTS_TOTALS or constants.DO_ROBOTS_PAYING_COSTS):

                for sc in range(len(scenarios)):

                    if (type(numOfRobots_[sf]) == list and areNrsStacked == False):
                        numOfRobots = helpers.getNumOfRobotsFromListByScenario(numOfRobots_[sf], sc)

                    modelsScenariosIndex = sf*len(scenarios) + sc; #ordered by folder
                    modelsScenariosIndexByScenario = sc*len(scenarioFolders_) + int(math.floor(modelsScenariosIndex / len(scenarios))); #ordered by scenario
                    if (orderResultsByScenario_):
                        index = modelsScenariosIndexByScenario;
                    else:
                        index = modelsScenariosIndex;

                    needsToRecalculateCosts = True;

                    if (constants.DO_COSTS_TOTALS or constants.DO_SWARM_STATS_ENV_STATS_CORRELATION or constants.DO_ROBOTS_PAYING_COSTS):
                        #-- check if cache file exists, try to get the data from the cache
                        cachedData = helpers.loadCachedCostTotals(scenarioFolder, scenarios[sc], numOfRobots);
                        if (cachedData):
                            needsToRecalculateCosts = False;
                            uncertaintyCostTotals[stack][index] = cachedData[1];
                            misplacementCostTotals[stack][index] = cachedData[2];
                            opportunityCostTotals[stack][index] = cachedData[3];
                            #cooperationCostTotals[stack][index] = cachedData[4];
                            misplVsUncCostTotals[stack][index] = cachedData[5];
                            infoSpeedTotals[stack][index] = cachedData[6];
                            socialInfoGainCoefficientTotals[stack][index] = cachedData[7];


                    if (constants.RECALC_COST_TOTALS or constants.DO_COSTS_OVER_TIME or constants.DO_VOLUME_PER_FORAGER_OVER_TIME or constants.DO_VOLUME_PER_FORAGER or constants.DO_INFO_VALUE_OVER_TIME or constants.DO_INFO_GAIN_OVER_TIME):
                        #-- any analysis for data over time needs costs recalculation, as it's not cached
                        needsToRecalculateCosts = True

                    if (needsToRecalculateCosts):

                        #-- reset the costs
                        uncertaintyCostTotals[stack][index] = [0 for r in range(constants.NUM_RUNS)];
                        misplacementCostTotals[stack][index] = [0 for r in range(constants.NUM_RUNS)];
                        opportunityCostTotals[stack][index] = [0 for r in range(constants.NUM_RUNS)];
                        #cooperationCostTotals[stack][index] = [0 for r in range(constants.NUM_RUNS)];
                        misplVsUncCostTotals[stack][index] = [0 for r in range(constants.NUM_RUNS)];
                        infoSpeedTotals[stack][index] = [0 for r in range(constants.NUM_RUNS)];
                        socialInfoGainCoefficientTotals[stack][index] = [0 for r in range(constants.NUM_RUNS)];

                        #-- get new data
                        data = analysisData.getInfoEventsData(scenarioFolder, [scenarios[sc]], extraParamStr, numOfRobots, endTime_);

                        potentialRewardData = data[0];
                        calculatedRewardData = data[1];
                        deltaCalculatedRewardData = data[2];
                        maxPotentialGainData = data[3];

                        infoValueData = data[4];
                        infoValueSocialData = data[5];
                        infoGainData = data[6];
                        infoGainSocialData = data[7];

                        uncertaintyCostData = data[8];
                        infoMisplacementCostData = data[9];
                        coordinationCostData = data[10];

                        misplVsUncCostData = data[11];
                        uncertaintyCostRemovedData = data[12];

                        #-- find info flow speed based on positive regions of information gain
                        infoGainDataSampledDownForInfoSpeedCalc = crData.sampleDown2DData(infoGainData[0],constants.TIME_BIN_LENGTH_INFO_SPEED,endTime_, useAverages_=False, discardZerosFromAverages_=True, debug_=False);
                        infoSpeedsMed = [];
                        infoSpeedsMax = [];
                        for runNo in range(len(infoGainDataSampledDownForInfoSpeedCalc[0])):
                            #print("---- run " + str(runNo));
                            positiveRegionStartTime = -1;
                            positiveRegionStartVal = -1;
                            positiveRegionMaxVal = -1;
                            positiveRegionMaxValTime = -1;
                            regionInfoSpeeds = [];
                            positiveRegionTotalVal = 0;

                            for timeBin in range(1,len(infoGainDataSampledDownForInfoSpeedCalc)):
                                currentInfoGain = infoGainDataSampledDownForInfoSpeedCalc[timeBin][runNo];
                                time = timeBin * constants.TIME_BIN_LENGTH_INFO_SPEED;


                                #-- positive region boundaries
                                if (currentInfoGain > 0):
                                    if (positiveRegionStartTime < 0):
                                        positiveRegionStartTime = time;
                                        positiveRegionStartVal = infoGainDataSampledDownForInfoSpeedCalc[timeBin-1][runNo];
                                        #print("Positive region started at " + str(time) + " with prev info gain " + str(positiveRegionStartVal))
                                        positiveRegionMaxVal = currentInfoGain;
                                        positiveRegionMaxValTime = time;
                                        positiveRegionTotalVal = 0;

                                #-- max value of a current positive region
                                if (positiveRegionStartTime > 0):
                                    positiveRegionTotalVal += currentInfoGain;
                                    #print("t={}   adding {} ".format(time, currentInfoGain))
                                    #if (currentInfoGain > positiveRegionMaxVal):
                                    #    positiveRegionMaxVal = currentInfoGain;
                                    #    positiveRegionMaxValTime = time;
                                        #print("Max region value " + str(positiveRegionMaxVal) + " found at " + str(time))

                                #if (currentInfoGain <= positiveRegionMaxVal):
                                if (currentInfoGain <= 0 and positiveRegionStartTime > 0):
                                    endBin = timeBin-1;
                                    endTime = endBin * constants.TIME_BIN_LENGTH_INFO_SPEED;
                                    #print("-- Positive region end at " + str(endTime))

                                    #-- calculate the info speed in this region as a tangent of the line that links region start & region max value


                                    #dx = positiveRegionMaxValTime - positiveRegionStartTime
                                    dx = endTime - positiveRegionStartTime
                                    duration = dx + constants.TIME_BIN_LENGTH_INFO_SPEED # if start and end at the same time, duration of that positive region is 1 time bin interval
                                    dy = positiveRegionMaxVal - positiveRegionStartVal
                                    rads = math.atan2(dy,dx)
                                    degs = math.degrees(rads);
                                    hypotenuse = math.hypot(dx,dy)

                                    infoSpeed = positiveRegionTotalVal / duration
                                    #infoSpeedNorm = infoSpeed / helpers.getRewardIntakePerSecond(scenarios[sc]) * 1 * numOfRobots; #i' = i/(g*q*N_R)


                                    #print("   Start: [{},{}] Max: [{},{}] duration: {}, total={}, speed={} ".format(positiveRegionStartTime,positiveRegionStartVal,positiveRegionMaxValTime,positiveRegionMaxVal, duration, positiveRegionTotalVal, infoSpeed))

                                    regionInfoSpeeds.append(infoSpeed);

                                    positiveRegionStartTime = -1;
                                    positiveRegionMaxVal = -1;
                                    positiveRegionMaxValTime = -1;


                            #-- get max info speed for this run
                            if (len(regionInfoSpeeds) > 0):
                                infoSpeedsMax.append(max(regionInfoSpeeds));
                                infoSpeedsMed.append(crData.getMedian(regionInfoSpeeds));
                                infoSpeedTotals[stack][index][runNo] = max(regionInfoSpeeds)
                            else:
                                infoSpeedsMax.append(0);
                                infoSpeedsMed.append(0);
                                infoSpeedTotals[stack][index][runNo] = 0;

                            #print("Run {} max info speed {} from list {}".format(runNo, infoSpeeds[runNo], regionInfoSpeeds))

                        #-- find social info gain coefficient
                        infoGainSampledDown = crData.sampleDown2DData(infoGainData[0],timeBinLength_,endTime_, useAverages_=False, discardZerosFromAverages_=True, debug_=False);
                        infoGainSocialSampledDown = crData.sampleDown2DData(infoGainSocialData[0],timeBinLength_,endTime_, useAverages_=False, discardZerosFromAverages_=True, debug_=False);

                        for runNo in range(len(infoGainSampledDown[0])):
                            #print("---- run " + str(runNo));
                            runSocialCoeffs = [];
                            for timeBin in range(1,len(infoGainSampledDown)):
                                socialGain = infoGainSocialSampledDown[timeBin][runNo];
                                totalGain = infoGainSampledDown[timeBin][runNo]

                                if (totalGain > 0 and socialGain >= 0): #only count instances when there was information gain
                                    coeff = socialGain/totalGain;
                                    runSocialCoeffs.append(coeff);
                                    #print(" social {}  total {} coeff {}".format(socialGain, totalGain, coeff));

                            if (len(runSocialCoeffs) > 0):
                                socialInfoGainCoefficientTotals[stack][index][runNo] = crData.getAverage(runSocialCoeffs);
                                socialInfoGainCoefficientTotals_med[stack][index][runNo] = crData.getMedian(runSocialCoeffs);

                        #-- get median of maxes across runs
                        infoFlowSpeedDataMed[sf][sc] = crData.getMedian(infoSpeedsMed)
                        infoFlowSpeedDataMax[sf][sc] = crData.getMedian(infoSpeedsMax)
                        #print("info flow speed for scenario {} = {}".format(scenarios[sc], infoFlowSpeedDataMax[sf][sc]))

                        #-- misplacement coefficient, as median across runs of median(C_M/C_U_removed)
                        misplCoefficients = [];
                        transformed = crData.columnsToRows(misplVsUncCostData[0]);

                        for runNo in range(constants.NUM_RUNS):
                            medianOfTheRun = crData.getMedian(transformed[runNo], ignoreZeros_=True);
                            misplCoefficients.append(medianOfTheRun);
                            misplVsUncCostTotals[stack][index][runNo] = medianOfTheRun;

                        misplVsUncCostCoeffData[sf][sc] = crData.getMedian(misplCoefficients);
                        #print("mispl cost coeff for scenario {} = {}".format(scenarios[sc], misplVsUncCostCoeffData[sf][sc]))

                        #----------------------------- cost totals, do this even if cost totals were not requested, so that the results from this scenario can be cached
                        #print(">>> Calculating cost totals for scenario {} ... ".format(scenarios[sc]));

                        for runNo in range(constants.NUM_RUNS):
                            for t in range(endTime_):
                                #uncertaintyCostRemovedTotals[stack][index][runNo] +=  uncertaintyCostRemovedData[sc][t][runNo];
                                uncertaintyCostTotals[stack][index][runNo] +=  uncertaintyCostData[0][t][runNo];

                                misplacementCostTotals[stack][index][runNo] += infoMisplacementCostData[0][t][runNo];
                                opportunityCostTotals[stack][index][runNo] += coordinationCostData[0][t][runNo];

                        if (not isCustomEndTimeUsed):
                            helpers.cacheCostTotals(uncertaintyCostTotals[stack][index], misplacementCostTotals[stack][index], opportunityCostTotals[stack][index],[],
                                misplVsUncCostTotals[stack][index], infoSpeedTotals[stack][index], socialInfoGainCoefficientTotals[stack][index],
                                scenarioFolder, scenarios[sc], numOfRobots)

                        #-- sample down data for graphs over time
                        if (constants.DO_COSTS_OVER_TIME or constants.DO_INFO_GAIN_OVER_TIME):
                            print(">>> Sampling down for scenario {} ... standard bin length {}  info speed bin length {}".format(scenarios[sc], timeBinLength_, constants.TIME_BIN_LENGTH_INFO_SPEED));
                            uncertaintyCostDataSampledDown.append(crData.sampleDown2DData(uncertaintyCostData[0],timeBinLength_,endTime_));
                            infoMisplacementCostDataSampledDown.append(crData.sampleDown2DData(infoMisplacementCostData[0],timeBinLength_,endTime_));
                            coordinationCostDataSampledDown.append(crData.sampleDown2DData(coordinationCostData[0],timeBinLength_,endTime_));
                            potentialRewardDataSampledDown.append(crData.sampleDown2DData(potentialRewardData[0],timeBinLength_,endTime_));
                            calculatedRewardDataSampledDown.append(crData.sampleDown2DData(calculatedRewardData[0],timeBinLength_,endTime_));

                            infoValueDataSampledDown.append(crData.sampleDown2DData(infoValueData[0],timeBinLength_,endTime_, True, False));
                            infoValueSocialDataSampledDown.append(crData.sampleDown2DData(infoValueSocialData[0],timeBinLength_,endTime_, True, False));

                            deltaCalculatedRewardDataSampleDown.append(crData.sampleDown2DData(deltaCalculatedRewardData[0],timeBinLength_,endTime_));
                            maxPotentialGainDataSampledDown.append(crData.sampleDown2DData(maxPotentialGainData[0],timeBinLength_,endTime_));

                            misplVsUncCostDataSampleDown.append(crData.sampleDown2DData(misplVsUncCostData[0],constants.TIME_BIN_LENGTH_DETAIL,endTime_));

                            infoGainDataSampledDown.append(infoGainSampledDown);
                            infoGainSocialDataSampledDown.append(infoGainSocialSampledDown);

                    #-- calculate number of robots based on costs
                    if (constants.DO_ROBOTS_PAYING_COSTS):
                        numOfWorksites = helpers.getNumOfWorksitesByScenario(scenarios[sc])
                        print(">>> CALCULATING NUMBER OF ROBOTS PAYING COSTS FOR R_T=100, N_R={}, N_W={}, time length={}".format(numOfRobots, numOfWorksites, endTime_));

                        for runNo in range(constants.NUM_RUNS):
                            numOfRobotsPayingCosts[stack][index][runNo] = (opportunityCostTotals[stack][index][runNo] * numOfRobots * numOfWorksites)/ (100.0*endTime_);
                            #numOfRobotsPayingCosts[stack][index][runNo] += (misplacementCostTotals[stack][index][runNo] * numOfRobots * numOfWorksites)/ (100.0*endTime_);
                            if (runNo == 0):
                                print("CM={} CO={} N={}".format(misplacementCostTotals[stack][index][runNo], opportunityCostTotals[stack][index][runNo], numOfRobotsPayingCosts[stack][index][runNo]))

                    #-- normalise the total costs per change interval, if applicable
                    if (scenarioFolder[0] == "C"):
                        changeInterval = helpers.getEnvironmentChangeInterval(scenarios[sc]);
                        numOfIntervals = endTime_ / changeInterval;
                        print(">>> RECALCULATING COSTS FOR NUM OF INTERVALS {}".format(numOfIntervals));
                        for runNo in range(constants.NUM_RUNS):
                            opportunityCostTotals[stack][index][runNo] *= 1.0/numOfIntervals
                            misplacementCostTotals[stack][index][runNo] *= 1.0/numOfIntervals
                            uncertaintyCostTotals[stack][index][runNo] *= 1.0/numOfIntervals


                        print("CO per change int {}".format(crData.getMedian(opportunityCostTotals[stack][index])))


            #----------------------------- reward collected

            if (constants.DO_REWARD_COLLECTED or constants.DO_REWARD_COLLECTED_OVER_TIME or constants.DO_REWARD_CALC_CHECK_OVER_TIME or constants.DO_REWARD_COLLECTED_ANOVA):

                for sc in range(len(scenarios)):

                    if (type(numOfRobots_[sf]) == list and areNrsStacked == False):
                        numOfRobots = helpers.getNumOfRobotsFromListByScenario(numOfRobots_[sf], sc)

                    modelsScenariosIndex = sf*len(scenarios) + sc;
                    modelsScenariosIndexByScenario = sc*len(scenarioFolders_) + int(math.floor(modelsScenariosIndex / len(scenarios))); #ordered by scenario
                    if (orderResultsByScenario_):
                        index = modelsScenariosIndexByScenario;
                    else:
                        index = modelsScenariosIndex;

                    needsToRecalculateReward = True;
                    if ((constants.DO_REWARD_COLLECTED or constants.DO_REWARD_COLLECTED_ANOVA) and constants.RECALC_TOTAL_REWARD_CACHE == False):
                        cachedData = helpers.loadCachedRewardTotals(scenarioFolder, scenarios[sc], numOfRobots);
                        if (cachedData):
                            needsToRecalculateReward = False;
                            rewardTotals[stack][index] = cachedData[1];

                    if (constants.DO_REWARD_COLLECTED_OVER_TIME or constants.DO_REWARD_CALC_CHECK_OVER_TIME or constants.RECALC_TOTAL_REWARD_CACHE):
                        needsToRecalculateReward = True;

                    if (needsToRecalculateReward):
                        data = analysisData.getRewardCollectedData(scenarioFolder,[scenarios[sc]],extraParamStr,startTime_,endTime_, numOfRobots);
                        totalRewardData = data[0];
                        rewardOverTimeData = data[1];

                        rewardTotals[stack][index] =  totalRewardData[0];
                        if (not isCustomEndTimeUsed):
                            helpers.cacheRewardTotals(rewardTotals[stack][index], scenarioFolder, scenarios[sc], numOfRobots);
                        rewardOverTimeDataSampledDown.append(crData.sampleDown2DData(rewardOverTimeData[0],timeBinLength_,endTime_, False));

                    if (constants.DO_REWARD_COLLECTED_ANOVA):
                        #-- need to unnormalise the reward from range 0;1 to aboslute values, otherwise the anova test won't work
                        rewardTotals_nonNorm[stack][index] = analysisData.unnormaliseRewardCollectedData(scenarios[sc], rewardTotals[stack][index], numOfRobots);

            #----------------------------- robots avoiding

            if (constants.DO_ROBOTS_AVOIDING or constants.DO_ROBOTS_TIME_TO_REACH_WORKSITE):
                for sc in range(len(scenarios)):

                    if (type(numOfRobots_[sf]) == list and areNrsStacked == False):
                        numOfRobots = helpers.getNumOfRobotsFromListByScenario(numOfRobots_[sf], sc)

                    modelsScenariosIndex = sf*len(scenarios) + sc;
                    modelsScenariosIndexByScenario = sc*len(scenarioFolders_) + int(math.floor(modelsScenariosIndex / len(scenarios))); #ordered by scenario
                    if (orderResultsByScenario_):
                        index = modelsScenariosIndexByScenario;
                    else:
                        index = modelsScenariosIndex;

                    needsToRecalculateRobotsAvoiding = True;

                    cachedData = helpers.loadCachedCongestion(scenarioFolder, scenarios[sc], numOfRobots);
                    if (cachedData):
                        needsToRecalculateRobotsAvoiding = False;
                        timeToReachWorksite[stack][index] = cachedData[1];

                    if (needsToRecalculateRobotsAvoiding):
                        data = analysisData.getRobotsCongestionData(scenarioFolder,[scenarios[sc]],extraParamStr,startTime_,endTime_, numOfRobots);

                        timeToReachWorksite[stack][index] =  data[1][0];
                        #print(len(numOfRobotsAvoiding[stack][index]));
                        if (not isCustomEndTimeUsed):
                            helpers.cacheCongestion(timeToReachWorksite[stack][index], scenarioFolder, scenarios[sc], numOfRobots);


            #-----------------------------
            if (constants.DO_TIME_TILL_REWARD_COLLECTED or constants.DO_TIME_TILL_REWARD_COLLECTED_ANOVA):

                for sc in range(len(scenarios)):

                    if (type(numOfRobots_[sf]) == list and areNrsStacked == False):
                        numOfRobots = helpers.getNumOfRobotsFromListByScenario(numOfRobots_[sf], sc)

                    modelsScenariosIndex = sf*len(scenarios) + sc;
                    modelsScenariosIndexByScenario = sc*len(scenarioFolders_) + int(math.floor(modelsScenariosIndex / len(scenarios))); #ordered by scenario
                    if (orderResultsByScenario_):
                        index = modelsScenariosIndexByScenario;
                    else:
                        index = modelsScenariosIndex;

                    needsToRecalculateReward = True;

                    if (timeTillRewardCollectedTargetPercentage_ == 100 and constants.RECALC_TILL_REWARD_CACHE == False):
                        cachedData = helpers.loadCachedRewardTime(scenarioFolder, scenarios[sc], numOfRobots);
                        if (cachedData):
                            needsToRecalculateReward = False;
                            timeRewardCollectedTotals[stack][index] = cachedData[1];

                    if (needsToRecalculateReward):
                        data = analysisData.getTimeTillRewardCollectedData(scenarioFolder,[scenarios[sc]],extraParamStr,timeTillRewardCollectedTargetPercentage_, numOfRobots);

                        timeRewardCollectedTotals[stack][index] =  data[0][0];
                        if (timeTillRewardCollectedTargetPercentage_ == 100):
                            if (not isCustomEndTimeUsed):
                                helpers.cacheRewardTime(timeRewardCollectedTotals[stack][index], scenarioFolder, scenarios[sc], numOfRobots);


            #----------------------------- worksites depleted
            if (constants.DO_TIME_TILL_FIRST_WORKSITE_DEPLETED):
                data = analysisData.getTimeFirstWorksiteDepleted(scenarioFolder,scenarios,extraParamStr);
                for sc in range(len(scenarios)):
                    modelsScenariosIndex = sf*len(scenarios) + sc;
                    modelsScenariosIndexByScenario = sc*len(scenarioFolders_) + int(math.floor(modelsScenariosIndex / len(scenarios))); #ordered by scenario
                    if (orderResultsByScenario_):
                        index = modelsScenariosIndexByScenario;
                    else:
                        index = modelsScenariosIndex;
                    timeFirstWorksiteDepletedTotals[stack][index] =  data[sc];

            if (constants.DO_TIME_TILL_HALF_WORKSITES_DEPLETED):
                data = analysisData.getTimeHalfWorksitesDepleted(scenarioFolder,scenarios,extraParamStr)
                for sc in range(len(scenarios)):
                    modelsScenariosIndex = sf*len(scenarios) + sc;
                    modelsScenariosIndexByScenario = sc*len(scenarioFolders_) + int(math.floor(modelsScenariosIndex / len(scenarios))); #ordered by scenario
                    if (orderResultsByScenario_):
                        index = modelsScenariosIndexByScenario;
                    else:
                        index = modelsScenariosIndex;
                    timeHalfWorksitesDepletedTotals[stack][index] =  data[sc];

            #----------------------------- information stopped time
            if (constants.DO_INFO_GAIN_END_TIME):
                data = analysisData.getTimeWhenInfoGainStoppedData(scenarioFolder,scenarios,extraParamStr);
                for sc in range(len(scenarios)):
                    modelsScenariosIndex = sf*len(scenarios) + sc;
                    modelsScenariosIndexByScenario = sc*len(scenarioFolders_) + int(math.floor(modelsScenariosIndex / len(scenarios))); #ordered by scenario
                    if (orderResultsByScenario_):
                        index = modelsScenariosIndexByScenario;
                    else:
                        index = modelsScenariosIndex;
                    timeInfoStoppedTotals[stack][index] =  data[0][sc];



            #----------------------------- scouting success
            if (constants.DO_SCOUTING_SUCCESS):
                data = analysisData.getScoutingSuccessData(scenarioFolder,scenarios,extraParamStr,startTime_,endTime_);
                for sc in range(len(scenarios)):
                    modelsScenariosIndex = sf*len(scenarios) + sc;
                    modelsScenariosIndexByScenario = sc*len(scenarioFolders_) + int(math.floor(modelsScenariosIndex / len(scenarios))); #ordered by scenario
                    if (orderResultsByScenario_):
                        index = modelsScenariosIndexByScenario;
                    else:
                        index = modelsScenariosIndex;
                    scoutingSuccessTotals[stack][index] =  data[0][sc];

            #========================================================= print data


            #------------------------------- DO_REWARD_COLLECTED_OVER_TIME
            if (constants.DO_REWARD_COLLECTED_OVER_TIME):
                for sc in range(len(scenarios)):
                    #print(">>> Sampling down reward over time...");


                    if (constants.DO_REWARD_COLLECTED_OVER_TIME):
                        folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "rewardOverTime";
                        helpers.createFolder(folder);
                        fileName = folder + "/rewardOverTime_" + analysisName_ + "_" + taskTypes_[sf][sc] + "_" +scenarioTypeNames[sc] + ".png";
                        size = helpers.getTimeSeriesGraphSize(timeBinLength_,endTime_,False);
                        markers = ['bo-'];
                        crGraphs.createPlot(range(len(timeLabels)), [rewardOverTimeDataSampledDown[sc]], "Time [hours]", "Reward", yLimMin_ = 0, yLimMax_ = 1.0, boxPlots_=True, markers_ = markers, markerSize_=4, boxPlotWidth_=0.1, xTickLabels_=timeLabels, fileName_=fileName, size_=size,tickFontSize_=crGraphs.TICK_FONT_SIZE);

            #------------------------------- DO_COSTS_OVER_TIME
            if (constants.DO_COSTS_OVER_TIME):
                for sc in range(len(scenarios)):
                    folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "costsOverTime";
                    helpers.createFolder(folder);
                    fileName = folder + "/costsOverTime_" + analysisName_ + scenarios[sc] + ".png";
                    size = helpers.getTimeSeriesGraphSize(timeBinLength_,endTime_,False);



                    if (markers_ == [] ):
                        markers = ['rs-','gs-','ms-', 'c.-','bs-','r.-'];
                    else:
                        markers = markers_;

                    colors = ['r','g','m','c','b','#FF5555']
                    legendLabels = ['Uncertainty cost', 'Misplacement cost', 'Opporunity cost'];

                    if (constants.DO_LARGE_GRAPHS):
                        size = (max(24, size[0]), size[1])
                    crGraphs.createPlot(range(len(timeLabels)),[uncertaintyCostDataSampledDown[sc], infoMisplacementCostDataSampledDown[sc], coordinationCostDataSampledDown[sc]], "Time", "", legendLabels_=legendLabels, yLimMin_ = 0, yLimMax_ = 100, boxPlots_=True, markers_ = markers, markerSize_=markerSize, boxPlotWidth_=0.1, xTickLabels_=timeLabels, colors_ = colors, fileName_=fileName, size_=size, lineWidth_=3,tickFontSize_=crGraphs.TICK_FONT_SIZE);

                    #-- cost comparison
                    #folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "CMvsCU";
                    #helpers.createFolder(folder);
                    #markers = ['ks-'];
                    #fileName = folder + "/CMvsCU_" + analysisName_ + scenarios[sc] + ".png";
                    #size = helpers.getTimeSeriesGraphSize(timeBinLength_,endTime_,False);
                    #crGraphs.createPlot(range(len(misplVsUncCostDataSampleDown[sc])), [misplVsUncCostDataSampleDown[sc]], "Time [seconds]", "C_M / I_V", legendLabels_=legendLabels, boxPlots_=True, markers_ = markers, markerSize_=4, xTickLabels_=detailTimeLabels, yLimMin_=0, yLimMax_=2.0, boxPlotWidth_=0.1, fileName_=fileName, size_=size);


                    #potentialRewardLossDataSampledDown = [[0 for r in range(constants.NUM_RUNS)] for i in range(len(uncertaintyRemovedDataSampledDown[0]))];
                    #reverseInfoMisplacementCostDataSampledDown = [[0 for r in range(constants.NUM_RUNS)] for i in range(len(uncertaintyRemovedDataSampledDown[0]))];
                    #-- calculate the trade off between uncertainty cost and reward change
                    #for runNo in range(constants.NUM_RUNS):
                    #    for timeBin in range(1,len(uncertaintyRemovedDataSampledDown[sc])):
                    #        potentialRewardLossDataSampledDown [timeBin][runNo] = potentialRewardDataSampledDown[sc][timeBin][runNo] - rewardOverTimeDataSampledDown[sc][timeBin][runNo];
                    #        reverseInfoMisplacementCostDataSampledDown[timeBin][runNo] = -infoMisplacementCostDataSampledDown[sc][timeBin][runNo];

                    #fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "rewardUncertaintyTradeoffOverTime_" + analysisName_ + scenarios[sc] + ".png";
                    #size = helpers.getTimeSeriesGraphSize(timeBinLength_,endTime_,False);
                    #markers = ['yd-','g.-','k.-','md-'];
                    #legendLabels = ["R'-R", "Mc", "Cc"];
                    #crGraphs.createPlot(range(len(timeLabels)), [potentialRewardLossDataSampledDown, infoMisplacementCostDataSampledDown[sc], coordinationCostDataSampledDown[sc]], "Time [hours]", "", legendLabels_=legendLabels, boxPlots_=True, yLimMin_=0, yLimMax_=1, markers_ = markers, markerSize_=4, boxPlotWidth_=0.1, xTickLabels_=timeLabels, fileName_=fileName, size_=size);
            #------------------------------- DO_REWARD_CALC_CHECK_OVER_TIME
            if (constants.DO_REWARD_CALC_CHECK_OVER_TIME):
                    #-- get reward over time in actual reward values, not percentages

                    rewardOverTimeDataSampledDown_absolute = copy.deepcopy(rewardOverTimeDataSampledDown[sc])
                    totalReward = float(helpers.getTotalRewardByScenario(scenarios[sc], numOfRobots));
                    for t in range(len(rewardOverTimeDataSampledDown_absolute)):
                        for runNo in range(constants.NUM_RUNS):
                            rewardOverTimeDataSampledDown_absolute[t][runNo] *= totalReward;

                    folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "rewardTradeoffOverTime";
                    helpers.createFolder(folder);
                    fileName = folder + "/rewardTradeoffOverTime_" + analysisName_ + scenarios[sc] + ".png";
                    size = helpers.getTimeSeriesGraphSize(timeBinLength_,endTime_,False);
                    markers = ['bs-', 'cx-', 'rs-'];
                    legendLabels = ["R (calc)", "R (measured)", "R'"];
                    crGraphs.createPlot(range(len(timeLabels)), [calculatedRewardDataSampledDown[sc], rewardOverTimeDataSampledDown_absolute, potentialRewardDataSampledDown[sc]], "Time [hours]", "", legendLabels_=legendLabels, boxPlots_=True, yLimMin_=0, yLimMax_=totalReward, markers_ = markers, markerSize_=5, boxPlotWidth_=0.1, xTickLabels_=timeLabels, fileName_=fileName, size_=size,tickFontSize_=crGraphs.TICK_FONT_SIZE);



            #------------------------------- DO_VOLUME_PER_FORAGER_OVER_TIME
            if (constants.DO_VOLUME_PER_FORAGER_OVER_TIME):
                 #for sc in range(len(scenarios)):
                 #   fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "volumePerForagerOverTime_" + analysisName_ + scenarios[sc] + ".png";
                 #   size = helpers.getTimeSeriesGraphSize(timeBinLength_,endTime_,False);
                 #   markers = ['b.-'];
                 #   legendLabels = ['Vol per subscribed'];
                 #   crGraphs.createPlot(range(len(timeLabels)), [volumePerSubscribedRobotDataSampledDown[sc]], "Time [hours]", "", legendLabels_=legendLabels, boxPlots_=True, markers_ = markers, markerSize_=4, boxPlotWidth_=0.1, xTickLabels_=timeLabels, fileName_=fileName, size_=size);
                print("!!!!! DO_VOLUME_PER_FORAGER_OVER_TIME NOT IMPLEMENTED ")

            #------------------------------- DO_INFO_VALUE_OVER_TIME
            if (constants.DO_INFO_VALUE_OVER_TIME):
                #maxVal = numOfRobots_[sf];
                for sc in range(len(scenarios)):
                    folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "infoVal";
                    helpers.createFolder(folder);
                    fileName = folder + "/infoVal_" + analysisName_ + scenarios[sc] + ".png";
                    size = (helpers.getTimeSeriesGraphSize(timeBinLength_,endTime_,False)[0],4.5);

                    if (constants.SHOW_SOCIAL_INFO_VALUE):
                        markers = ['g.-','r.-'];
                        legendLabels = ["Information value - social only", "Information value"]
                        crGraphs.createPlot(range(len(timeLabels)), [infoValueSocialDataSampledDown[sc], infoValueDataSampledDown[sc]], "Time [hours]", "Information value", boxPlots_=True, legendLabels_ = legendLabels, markers_ = markers, markerSize_=4, boxPlotWidth_=0.1, xTickLabels_=timeLabels, fileName_=fileName, size_=size,  yLimMin_=-1.0, yLimMax_=1);
                    else:
                        markers = ['r.-'];
                        legendLabels = ["Information value"]
                        crGraphs.createPlot(range(len(timeLabels)), [infoValueDataSampledDown[sc]], "Time [hours]", "Information value", boxPlots_=True, legendLabels_ = legendLabels, markers_ = markers, markerSize_=4, boxPlotWidth_=0.1, xTickLabels_=timeLabels, fileName_=fileName, size_=size,  yLimMin_=-1.0, yLimMax_=1,tickFontSize_=crGraphs.TICK_FONT_SIZE);

            #------------------------------- DO_INFO_GAIN_OVER_TIME
            if (constants.DO_INFO_GAIN_OVER_TIME):
                for sc in range(len(scenarios)):
                    folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "infoGain";
                    helpers.createFolder(folder);
                    fileName = folder + "/infoGain_" + analysisName_ + scenarios[sc] + ".png";
                    size = (helpers.getTimeSeriesGraphSize(timeBinLength_,endTime_,False)[0],4.5);

                    markers = ['g--', 'm.-'];
                    lineStyles = ['--','-']
                    legendLabels = ["Social only", "Total"]

                    lineWidth = 2;
                    boxplotWidth = 0.1;
                    yMin = -1.0;
                    yMax = 1.0;
                    if (constants.DO_LARGE_GRAPHS):
                        lineWidth = 4;
                        size = (30,10);
                        boxplotWidth = 0.3;
                        yMin = -0.2;

                    crGraphs.createPlot(range(len(infoGainDataSampledDown[sc])), [infoGainSocialDataSampledDown[sc], infoGainDataSampledDown[sc]], "Time [hours]", "Information gain", boxPlots_=True, legendLabels_ = legendLabels, markers_ = markers, markerSize_=4, boxPlotWidth_=boxplotWidth, xTickLabels_=timeLabels, fileName_=fileName, size_=size, yLimMin_= yMin, yLimMax_=yMax, lineWidth_=lineWidth, lineStyles_=lineStyles,tickFontSize_=crGraphs.TICK_FONT_SIZE);

    if (constants.DO_SWARM_STATS_ENV_STATS_CORRELATION):
        print("=========================");
        scenariosStr = ""
        for sc in scenarios:
            scenariosStr += helpers.removeControllerNameFromString(sc)+"-";
        print("for scenarios: " + str(scenariosStr))

        output = "mispl cost vs unc cost coefficients: \n";
        for sf in range(len(scenarioFolders_)):
            output += (scenarioFolders_[sf] + " = " + str(misplVsUncCostCoeffData[sf]) + "\n");
        output += "\n";
        output += "information flow speed [max]:\n"
        for sf in range(len(scenarioFolders_)):
            output += (scenarioFolders_[sf] + " = " + str(infoFlowSpeedDataMax[sf]) + "\n");

        output += "\n";
        output += "information flow speed [med]:\n"
        for sf in range(len(scenarioFolders_)):
            output += (scenarioFolders_[sf] + " = " + str(infoFlowSpeedDataMed[sf]) + "\n");

        print(output)

        figMax = None;
        for sf in range(len(scenarioFolders_)):

            for sc in range(len(scenarios)):
                dataLabels = [];
                colors = [];
                dataLabel = scenarioFolders_[sf] + "\n" + helpers.removeControllerNameFromString(scenarios[sc])
                dataLabels.append(dataLabel);
                #print(scenarioFolders_[sf])
                #print(helpers.getColorByControllerName(scenarioFolders_[sf]))
                colors.append(helpers.getColorByControllerName(scenarioFolders_[sf]))


                yData = [misplVsUncCostCoeffData[sf][sc]]

                marker = helpers.getMarkerShapeByEnvironmentName(scenarios[sc]);

                folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "swarmEnvStatsCorrelation";
                helpers.createFolder(folder);
                fileName = folder + "/swarmEnvStatsCorrelation_" + analysisName_ + scenariosStr + "_igBin" + str(constants.TIME_BIN_LENGTH_INFO_SPEED);

                xMax = 0.01;
                xMin = -0.001;

                figMax = crGraphs.createScatterPlot([infoFlowSpeedDataMax[sf][sc]], yData, xLabel_ = "Max achieved information speed", yLabel_ = "Cost coeff", dataLabels_ = dataLabels, xLimMin_ = xMin, xLimMax_ = xMax, yLimMin_=-0.1, yLimMax_= 1.0, marker_ = marker, colors_ = colors, fileName_=fileName+".png", figure_=figMax, graphId_=sc+sf, valueLabelsDecimalPlaces_=4)

        figs.append(figMax);

    #========================================================= further adjust data, comparing across folders

    if (constants.DO_REWARD_COLLECTED and constants.COMPARE_STACK_PAIRS):
        #-- create a new data set where each stack is data points of the percentage difference between 2 stacks (e.g. stack0 = stack1-stack0)
        rewardTotals_compLength = int(len(rewardTotals)/2);
        rewardTotals_comp = [[[] for sc in range(len(modelsScenariosLabels))] for stack in range(rewardTotals_compLength)];
        rewardTotalsIndex = 0
        for compStack in range(rewardTotals_compLength):
            #print("comp stack " + str(compStack) + "  index " + str(rewardTotalsIndex));
            for compX in range(len(rewardTotals[compStack])):
                for compY in range(len(rewardTotals[compStack][compX])):
                    #rewardTotals_comp[compStack][compX].append((rewardTotals[rewardTotalsIndex+1][compX][compY] / rewardTotals[rewardTotalsIndex][compX][compY]) - 1.0);
                    rewardTotals_comp[compStack][compX].append((rewardTotals[rewardTotalsIndex+1][compX][compY] - rewardTotals[rewardTotalsIndex][compX][compY]));

            rewardTotalsIndex += 2;

        rewardTotals = rewardTotals_comp;

    #========================================================= print data, comparing accross folders
    if (constants.DO_COSTS_TOTALS):
        folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "costTotals";
        helpers.createFolder(folder);

        size = helpers.getPlotGraphSize(len(modelsScenariosLabels));

        if (constants.COST_TOTALS_INFO_SPEED):
            fileName = folder + "/info_speed_" + analysisName_ + "_T" + str(endTime_) + "_binSize" + str(constants.TIME_BIN_LENGTH_INFO_SPEED) + ".png";
            if (len(markers_) == 0):
                markers = ['bs','rs','gs'];
            else:
                markers = markers_;


            actualSize = (size[0], size[1])
            if ("A_" in folder or "basic" in folder): #or "C_" in folder
                actualSize = (size[0], size[1]*1.5)

            print(actualSize);
            yMax = crGraphs.INVALID_VALUE;
            yMin = 0;

            brokenLineYMax = crGraphs.INVALID_VALUE;
            yTickStep = 0;
            if ("A_" in folder):
                yMax=0.0175;

            if ("staticConsume" in folder):
                brokenLinePlotParams = helpers.getBrokenLinePlotParams(0,0.005,0.02,60);
                brokenLineYMax = brokenLinePlotParams[1];
                yMin = brokenLinePlotParams[2];
                yMax = brokenLinePlotParams[3];
                yTickStep = 0;

            if ("infoSpeedTimeBinSensitivity" in folder):
                actualSize = (16, 4.8);
                if (constants.TIME_BIN_LENGTH_INFO_SPEED == 30):
                    if ("NR10" in analysisName_):
                        yMax = 0.018;
                    elif ("NR25" in analysisName_):
                        yMax = 0.012;
                    elif ("NR50" in analysisName_):
                        yMax = 0.012;
                elif (constants.TIME_BIN_LENGTH_INFO_SPEED == 60):
                    if ("NR10" in analysisName_):
                        yMax = 0.012;
                    elif ("NR25" in analysisName_):
                        yMax = 0.010;
                    elif ("NR50" in analysisName_):
                        yMax = 0.008;
                elif (constants.TIME_BIN_LENGTH_INFO_SPEED == 120):
                    if ("NR10" in analysisName_):
                        yMax = 0.008;
                    elif ("NR25" in analysisName_ or "NR50" in analysisName_):
                        yMax = 0.005;
                elif (constants.TIME_BIN_LENGTH_INFO_SPEED == 240):
                    if ("NR10" in analysisName_):
                        yMax = 0.004;
                    elif ("NR25" in analysisName_):
                        yMax = 0.0025;
                    elif ("NR50" in analysisName_):
                        yMax = 0.002;

            figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), infoSpeedTotals, "Scenario", "Max info speed (sbs: {}s".format(constants.TIME_BIN_LENGTH_INFO_SPEED), legendLabels_, boxPlots_=True, yTicksStep_=yTickStep, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName, size_=actualSize, yLimMax_=yMax, yLimMin_=yMin, xAxisGroupSize_=xAxisGroupSize_,markerSize_=markerSize, colors_=colors, figure_=fig_cost_totals_i,tickFontSize_=crGraphs.TICK_FONT_SIZE));

            if (brokenLineYMax != crGraphs.INVALID_VALUE):
                fileName = folder + "/info_speed_" + analysisName_ + "_T" + str(endTime_) + "_binSize" + str(constants.TIME_BIN_LENGTH_INFO_SPEED) + "_zoomedIn.png";
                figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), infoSpeedTotals, "Scenario", "Max info speed (sbs: {}s".format(constants.TIME_BIN_LENGTH_INFO_SPEED), legendLabels_, boxPlots_=True, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName, size_=actualSize, yLimMax_=brokenLineYMax, yLimMin_=0, xAxisGroupSize_=xAxisGroupSize_,markerSize_=markerSize, colors_=colors, figure_=fig_cost_totals_i,tickFontSize_=crGraphs.TICK_FONT_SIZE));

            if (constants.DO_ANOVA_TABLE):
                fileName=folder+"/info_speed_"+analysisName_+"_T"+str(endTime_)+"_binSize"+str(constants.TIME_BIN_LENGTH_INFO_SPEED)+"_anovaTable";
                crGraphs.createAnovaTable(infoSpeedTotals,legendLabels_,xAxisLabels_,fileName_=fileName);

        if (constants.COST_TOTALS_SOCIAL_INFO_GAIN):
            fileName = folder + "/socialInfoGain_coeff_" + analysisName_ + "_T" + str(endTime_) + ".png";
            if (len(markers_) == 0):
                markers = ['bs','rs','gs'];
            else:
                markers = markers_;
            figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), socialInfoGainCoefficientTotals, "Scenario", "Social info gain coeff (avg)", legendLabels_, boxPlots_=True, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName, size_=size, yLimMax_=1.2, yLimMin_=0, xAxisGroupSize_=xAxisGroupSize_, markerSize_=markerSize, colors_=colors, figure_=fig_cost_totals_social_info_gain,tickFontSize_=crGraphs.TICK_FONT_SIZE));


        if (constants.COST_TOTALS_m):
            fileName = folder + "/C_M_coeff_" + analysisName_ + "_T" + str(endTime_) + ".png";
            if (len(markers_) == 0):
                markers = ['bs','rs','gs'];
            else:
                markers = markers_;
            figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), misplVsUncCostTotals, "Scenario", "Median misplacement cost coeff", legendLabels_, boxPlots_=True, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName, size_=size, yLimMax_=1.1, yLimMin_=-0.1, xAxisGroupSize_=xAxisGroupSize_,markerSize_=markerSize, colors_=colors, figure_=fig_cost_totals_m,tickFontSize_=crGraphs.TICK_FONT_SIZE));

            if (constants.DO_ANOVA_TABLE):
                fileName=folder+"/C_M_coeff_"+analysisName_+"_T"+str(endTime_)+"_anovaTable"
                crGraphs.createAnovaTable(misplVsUncCostTotals,legendLabels_,xAxisLabels_,fileName_=fileName);

        if (constants.COST_TOTALS_C_M):
            yMax = 350;
            yMin = 0;
            if ("Forage" in xAxisLabels_[0]):
                yMax = 120000;

            fileName = folder + "/C_M_total_" + analysisName_ + "_T" + str(endTime_) + ".png";
            if (len(markers_) == 0):
                markers = ['bs','rs','gs'];
            else:
                markers = markers_;
            figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), misplacementCostTotals, "Scenario", "Total misplacement cost paid", legendLabels_, boxPlots_=True, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName, size_=size , yLimMax_=crGraphs.INVALID_VALUE, yLimMin_=yMin, xAxisGroupSize_=xAxisGroupSize_, markerSize_=markerSize, colors_=colors, figure_=fig_cost_totals_c_m,tickFontSize_=crGraphs.TICK_FONT_SIZE));

        if (constants.COST_TOTALS_C_O):
            yMin, yMax = helpers.getYmaxYmin_forCO(folder, analysisName_);
            fileName = folder + "/C_O_total_" + analysisName_ + "_T" + str(endTime_);
            if (len(markers_) == 0):
                markers = ['bs','rs','gs'];
            else:
                markers = markers_;
            yTickStep = 0
            if (yMax != crGraphs.INVALID_VALUE):
                if (yMax >= 100000):
                    yTickStep = 20000;
                elif (yMax > 20000):
                    yTickStep = 10000;
                elif (yMax > 5000):
                    yTickStep = 2000;
                elif (yMax > 2000):
                    yTickStep = 1000;


            if ("jp01" in folder and not ("dynamic" in folder and "COLLECT" in analysisName_)):

                if ("staticConsume" in folder or "basic" in folder):
                    if ("NR10" in analysisName_):
                        brokenLineY = 12000
                        brokenLineYTickStep = 3000;
                    elif ("NR25" in analysisName_):
                        brokenLineY = 10000
                        brokenLineYTickStep = 2000;
                    elif ("NR50" in analysisName_):
                        brokenLineY = 4000
                        brokenLineYTickStep = 1000;
                elif ("staticCollect" in folder):
                    if ("NR10" in analysisName_):
                        brokenLineY = 18000
                        brokenLineYTickStep = 5000;
                elif ("dynamic" in folder):
                    if ("NR10" in analysisName_):
                        if ("slow" in folder):
                            brokenLineY = 15000
                            brokenLineYTickStep = 5000;
                        elif ("fast" in folder):
                            brokenLineY = 10000
                            brokenLineYTickStep = 2000;

                yMin = -brokenLineY* 0.1
                brokenLineYMin, brokenLineYMax, yMin, yMax = helpers.getBrokenLinePlotParams(yMin,brokenLineY,yMax,60);

                figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), opportunityCostTotals, "Scenario", "Total opportunity cost paid", legendLabels_, boxPlots_=True, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName+"_zoomedIn.png", size_=size, yLimMax_=brokenLineYMax, yLimMin_=brokenLineYMin, yTicksStep_=brokenLineYTickStep, xAxisGroupSize_=xAxisGroupSize_, markerSize_=markerSize, colors_=colors, figure_=fig_cost_totals_c_o,tickFontSize_=crGraphs.TICK_FONT_SIZE));

            figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), opportunityCostTotals, "Scenario", "Total opportunity cost paid", legendLabels_, boxPlots_=True, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName+".png", size_=size, yLimMax_=yMax, yLimMin_=yMin, yTicksStep_=yTickStep, xAxisGroupSize_=xAxisGroupSize_, markerSize_=markerSize, colors_=colors, figure_=fig_cost_totals_c_o,tickFontSize_=crGraphs.TICK_FONT_SIZE));


            if (constants.DO_ANOVA_TABLE):
                fileName=folder+"/C_O_total_"+analysisName_+"_T"+str(endTime_)+"_anovaTable";
                crGraphs.createAnovaTable(opportunityCostTotals,legendLabels_,xAxisLabels_,fileName_=fileName,valueMultiplier_=1.0/1000);

        if (constants.COST_TOTALS_C_U):
            yMin, yMax = helpers.getYmaxYmin_forCU(folder, analysisName_);
            fileName = folder + "/C_U_total_" + analysisName_ + "_T" + str(endTime_) + ".png";

            yTickStep = 0
            if (yMax != crGraphs.INVALID_VALUE):
                if (yMax >= 500000):
                    yTickStep = 100000;
                elif (yMax >= 300000):
                    yTickStep = 50000;
                elif (yMax >= 100000):
                    yTickStep = 20000;



            if (len(markers_) == 0):
                markers = ['bs','rs','gs'];
            else:
                markers = markers_;
            figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), uncertaintyCostTotals, "Scenario", "Total uncertainty cost paid", legendLabels_, boxPlots_=True, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName, size_=size, yLimMax_=yMax, yLimMin_=yMin, yTicksStep_=yTickStep, xAxisGroupSize_=xAxisGroupSize_, markerSize_=markerSize, colors_=colors, figure_=fig_cost_totals_c_u,tickFontSize_=crGraphs.TICK_FONT_SIZE));


    #-----------------------------
    if (constants.DO_ROBOTS_PAYING_COSTS):
        fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ + "robotsPayingCosts_" + analysisName_ + "_T" + str(endTime_) + ".png";
        size = helpers.getPlotGraphSize(len(modelsScenariosLabels));

        figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), numOfRobotsPayingCosts, "Scenario", "Num robots paying costs", legendLabels_, confidenceIntervals_=doConfidenceIntervals, boxPlots_=doBoxPlots, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, yLimMin_=0, yLimMax_=25, fileName_=fileName, size_=size, xAxisGroupSize_=xAxisGroupSize_, markerSize_=markerSize, colors_=colors, tickFontSize_=crGraphs.TICK_FONT_SIZE));


    #-----------------------------
    if (constants.DO_ROBOTS_TIME_TO_REACH_WORKSITE):
        fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ + "robotsTimeToReachWorksite_" + analysisName_ + "_T" + str(endTime_) + ".png";
        size = helpers.getPlotGraphSize(len(modelsScenariosLabels));

        if (constants.PUBLICATION_TYPE == constants.PUBLICATION_TYPE_CP01):
            size = (5.2,size[1]);

        yMax = 35;
        if ('PERFORM' in analysisName_):
            yMax = 220;

        figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), timeToReachWorksite, "Scenario", "Avg. t to reach worksite [s]", legendLabels_, confidenceIntervals_=doConfidenceIntervals, boxPlots_=doBoxPlots, markers_=markers, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, yLimMin_=0, yLimMax_=yMax, fileName_=fileName, size_=size, xAxisGroupSize_=xAxisGroupSize_, markerSize_=markerSize, colors_=colors, tickFontSize_=crGraphs.TICK_FONT_SIZE));


    #-----------------------------
    if (constants.DO_REWARD_COLLECTED):
        if (len(markers_) == 0):
            markers = ['bs','rs','gs'];
        else:
            markers = markers_;
        fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ + "collectedRewardTotal_" + analysisName_ + "_T" + str(endTime_) + ".png";
        size = helpers.getPlotGraphSize(len(modelsScenariosLabels));

        if (yLimMax_ == crGraphs.INVALID_VALUE):
            yLimMax_ = maxResCollected_*1.05;

        figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), rewardTotals, "Scenario", "Reward", stackedParameterLabels_, confidenceIntervals_=doConfidenceIntervals, boxPlots_=doBoxPlots, markers_=markers,lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, xAxisGroupSize_= xAxisGroupSize_, fileName_=fileName, size_=size, yLimMin_=yLimMin_, yLimMax_=yLimMax_, legendCols_=legendCols_, colors_=colors, markerSize_=markerSize,tickFontSize_=crGraphs.TICK_FONT_SIZE));

        if (constants.DO_ANOVA_TABLE):
            fileName=constants.BASE_FILE_PATH_OUTPUT_IMAGES+"/"+outputDirectory_+"/"+outputFilePrefix_+"collectedRewardTotal_"+analysisName_+"_T"+str(endTime_)+"_anovaTable";
            crGraphs.createAnovaTable(rewardTotals,legendLabels_,xAxisLabels_,fileName_=fileName,valueMultiplier_=100);
    #-----------------------------
    if (constants.DO_TIME_TILL_REWARD_COLLECTED):

        fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ + "timeTillRewardCollected_" + str(timeTillRewardCollectedTargetPercentage_) + "_" + analysisName_;

        if (xAxisGroupSize_ > 1):
            #-- calculate and print the percentagees of how a last median in a group differs from 1st in the group
            outp = "------ reductions ------\n"
            for r in range(len(timeRewardCollectedTotals[0])):
                groupId = math.floor(r/xAxisGroupSize_);
                groupStartId = int(groupId * xAxisGroupSize_);
                if (r != groupStartId):
                    outp += xAxisLabels_[r].replace('\n',' ') + " vs " + xAxisLabels_[groupStartId].replace('\n',' ');
                    for stack in range(len(timeRewardCollectedTotals)):

                        reduction = (1 - crData.getMedian(timeRewardCollectedTotals[stack][r]) / crData.getMedian(timeRewardCollectedTotals[stack][groupStartId])) * 100;

                        stackLabel = "";

                        if (len(stackedParameterLabels_) > stack):
                            stackLabel = stackedParameterLabels_[stack]
                        outp += "  " + stackLabel + ":" + str(reduction) + " (" + str(round(crData.getMedian(timeRewardCollectedTotals[stack][groupStartId]))) + "->" + str(round(crData.getMedian(timeRewardCollectedTotals[stack][r]))) + ")";
                    outp += "\n"
            outp += "------------------------";

            print(outp)
            if (outputTextFiles_):
                with open(fileName + ".txt", "w") as text_file:
                    text_file.write(outp)

        maxTimeYaxis = endTime_ * 1.1;
        size = helpers.getPlotGraphSize(len(modelsScenariosLabels));

        figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), timeRewardCollectedTotals, "Scenario", "Time till " + str(timeTillRewardCollectedTargetPercentage_) + "% reward collected [hours]", legendLabels_, xAxisGroupSize_= xAxisGroupSize_, yTicksStep_=yTickStep_, yTicksStepMultiplier_=1.0/3600, boxPlots_=True, markers_=markers, markerSize_=markerSize, lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName + ".png", size_=size, yLimMin_=0, yLimMax_=maxTimeYaxis, legendCols_=legendCols_, figure_=fig_timeTillRewardCollected, colors_=colors, tickFontSize_=crGraphs.TICK_FONT_SIZE));

        fileName=constants.BASE_FILE_PATH_OUTPUT_IMAGES+"/"+outputDirectory_+"/"+outputFilePrefix_+"timeTillRewardCollected_"+str(timeTillRewardCollectedTargetPercentage_)+"_"+analysisName_ + "_anovaTable";
        if (constants.DO_ANOVA_TABLE):
            crGraphs.createAnovaTable(timeRewardCollectedTotals,legendLabels_,xAxisLabels_,fileName_=fileName,valueMultiplier_=1.0/3600);

    #-----------------------------
    if (constants.DO_TIME_TILL_FIRST_WORKSITE_DEPLETED):
        folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "worksiteDepletion";
        helpers.createFolder(folder);
        fileName = folder + "/timeTillFirstWorksiteDepleted_" + analysisName_;

        outp = analysisData.getMediansSummaryForScenarios(timeFirstWorksiteDepletedTotals, xAxisLabels_, stackedParameterLabels_)
        if (outputTextFiles_):
                with open(fileName + "_summary.txt", "w") as text_file:
                    text_file.write(outp)
        size = helpers.getPlotGraphSize(len(modelsScenariosLabels));
        figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), timeFirstWorksiteDepletedTotals, "Scenario", "1st worksite depleted at [hours]", legendLabels_, xAxisGroupSize_= xAxisGroupSize_, yTicksStep_=yTickStep_, yTicksStepMultiplier_=1.0/3600, boxPlots_=True, markers_=markers,lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName + ".png", size_=size, yLimMin_=0, yLimMax_=endTime_, legendCols_=legendCols_, colors_=colors));

    if (constants.DO_TIME_TILL_HALF_WORKSITES_DEPLETED):
        folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ +  "worksiteDepletion";
        helpers.createFolder(folder);
        fileName = folder + "/timeTillHalfWorksitesDepleted_" + analysisName_;

        outp = analysisData.getMediansSummaryForScenarios(timeHalfWorksitesDepletedTotals, xAxisLabels_, stackedParameterLabels_)
        if (outputTextFiles_):
                with open(fileName + "_summary.txt", "w") as text_file:
                    text_file.write(outp)

        size = helpers.getPlotGraphSize(len(modelsScenariosLabels));
        figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), timeHalfWorksitesDepletedTotals, "Scenario", "Half worksites depleted at [hours]", legendLabels_, xAxisGroupSize_= xAxisGroupSize_, yTicksStep_=yTickStep_, yTicksStepMultiplier_=1.0/3600, boxPlots_=True, markers_=markers,lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName + ".png", size_=size, yLimMin_=0, yLimMax_=endTime_, legendCols_=legendCols_, colors_=colors,tickFontSize_=crGraphs.TICK_FONT_SIZE));


    #-----------------------------
    if (constants.DO_SCOUTING_SUCCESS):
        #-- bar charts
        # stackNumOfWins = [[0 for sc in range(len(scoutingSuccessTotals[0]))] for x in range(len(stackedParameterLabels_))];
        # for sc in range(len(scoutingSuccessTotals[0])):
        #     #print("-- scenario {} ".format(sc))
        #
        #     for runNo in range(constants.NUM_RUNS):
        #         bestTime = 99999999;
        #         bestTimeStackId = -1;
        #
        #         for stackId in range(len(stackedParameterLabels_)):
        #             #print("stack {} time {} ".format(stackId, scoutingSuccessTotals[stackId][sc][runNo] ))
        #             if (scoutingSuccessTotals[stackId][sc][runNo] < bestTime):
        #                 bestTimeStackId = stackId;
        #                 bestTime = scoutingSuccessTotals[stackId][sc][runNo];
        #                 #print("   new best time ")
        #         stackNumOfWins[bestTimeStackId][sc] += 1;
        #
        # fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ + "firstScoutingSuccess_bars_" + analysisName_ + "_T" + str(endTime_) + ".png";
        # figs.append(crGraphs.createStackedBar(stackNumOfWins, groupLabels_=stackedParameterLabels_, groupColors_=['b','r','g'], fileName_=fileName))

        #-- box plots
        folder = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_;
        yMin, yMax = helpers.getYmaxYmin_forScoutingAbility(folder, analysisName_, outputFilePrefix_);
        yTickStep = helpers.getYTickStep_forScoutingAbility(folder, analysisName_);

        fileName = folder +  "/" + outputFilePrefix_ + "firstScoutingSuccess_" + analysisName_ + "_T" + str(endTime_);
        size = helpers.getPlotGraphSize(len(modelsScenariosLabels));

        if (constants.DO_LARGE_GRAPHS):
            size = (size[0], max(8,size[1]));

        print(folder)
        print(analysisName_)
        if ("jp01" in folder):
            yMaxTemp, yTickStepTemp, brokenLineY, yTickStepBrokenLine = helpers.getBrokenLineParams_forScoutingAbility(folder, analysisName_, outputFilePrefix_);
            if (yMaxTemp > 0):
                yMax = yMaxTemp;
                yTickStep = yTickStepTemp;
                brokenLineYMin, brokenLineYMax, yMin, yMax = helpers.getBrokenLinePlotParams(yMin,brokenLineY,yMax,60);
                figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), scoutingSuccessTotals, "Scenario", "First scouting time", legendLabels_, boxPlots_=True, markers_=markers,lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName+"_zoomedIn.png", size_=size, yLimMin_=brokenLineYMin, yLimMax_= brokenLineYMax, yTicksStep_=yTickStepBrokenLine, yTicksStepMultiplier_=1.0/3600, legendCols_=legendCols_, colors_=colors, markerSize_=markerSize, figure_=fig_scouting_success,tickFontSize_=crGraphs.TICK_FONT_SIZE));
        print(yMin, yMax, yTickStep);
        figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), scoutingSuccessTotals, "Scenario", "First scouting time", legendLabels_, boxPlots_=True, markers_=markers,lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName+".png", size_=size, yLimMin_=yMin, yLimMax_= yMax, yTicksStep_=yTickStep, yTicksStepMultiplier_=1.0/3600, legendCols_=legendCols_, colors_=colors, markerSize_=markerSize, figure_=fig_scouting_success,tickFontSize_=crGraphs.TICK_FONT_SIZE));

        if (constants.DO_ANOVA_TABLE):
            fileName=folder+"/"+outputFilePrefix_+"firstScoutingSuccess_"+analysisName_+"_T"+str(endTime_)+"_anovaTable";
            crGraphs.createAnovaTable(scoutingSuccessTotals,legendLabels_,xAxisLabels_,fileName_=fileName,valueMultiplier_=1.0/3600);
    #-----------------------------
    #if (constants.DO_VOLUME_PER_FORAGER):
    #    markers = ['bs','rs','gs'];
    #    fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ + "volumePerForagerTotal_" + analysisName_ + "_T" + str(endTime_) + ".png";
    #    size = helpers.getPlotGraphSize(len(modelsScenariosLabels));
    #    figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), volumePerSubscribedRobotTotals, "Scenario", "Vol per forager", stackedParameterLabels_, boxPlots_=True, markers_=markers,lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName, size_=size, legendCols_=legendCols_));


    #-----------------------------
    if (constants.DO_INFO_GAIN_END_TIME):
        maxTimeYaxis = endTime_ + 1600;
        markers = ['bs','rs','gs'];
        fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ + "infoValEndTime_" + analysisName_ + "_T" + str(endTime_) + ".png";
        size = helpers.getPlotGraphSize(len(modelsScenariosLabels));
        figs.append(crGraphs.createPlot(range(len(xAxisLabels_)), timeInfoStoppedTotals, "Scenario", "Time info gain stopped [hours]", stackedParameterLabels_, yTicksStep_=1800, yTicksStepMultiplier_=1.0/3600, boxPlots_=True, markers_=markers,lineWidth_=graphLineWidth_, xTickLabels_=xAxisLabels_, fileName_=fileName, size_=size, yLimMin_=0, yLimMax_=maxTimeYaxis, legendCols_=legendCols_,tickFontSize_=crGraphs.TICK_FONT_SIZE));


    #------------------------------
    #----- ANOVA -----
    #------------------------------
    if (constants.DO_TIME_TILL_REWARD_COLLECTED_ANOVA):

        outputStr = doAnova(timeRewardCollectedTotals, stackedParameterLabels_, xAxisLabels_, False);
        fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ + "anova_timeTillRewardCollected_" + str(timeTillRewardCollectedTargetPercentage_) + "_" + analysisName_ + ".txt";

        print(outputStr);
        with open(fileName, "w") as text_file:
            text_file.write(outputStr)

    if (constants.DO_REWARD_COLLECTED_ANOVA):

        outputStr = doAnova(rewardTotals_nonNorm, stackedParameterLabels_, xAxisLabels_);
        fileName = constants.BASE_FILE_PATH_OUTPUT_IMAGES + "/" + outputDirectory_ + "/" + outputFilePrefix_ + "anova_collectedRewardTotal_" + str(timeTillRewardCollectedTargetPercentage_) + "_" + analysisName_ + ".txt";
        print(outputStr);
        with open(fileName, "w") as text_file:
            text_file.write(outputStr)



    return figs;


#===================== ==================== ==================== ==================== ==================== ==================== ==================== ====================
#===================== ==================== ==================== ==================== ==================== ==================== ==================== ====================
#===================== ==================== ==================== ==================== ==================== ==================== ==================== ====================

def doAnova(dataArray_, groupNames_, envNames_, groupBetterIfLargerValue_ = True, debug_ = False):
    """
    Take one of the totals arrays from the main analysis function and find out whether any group (of the groups that are identified by lines of different colors
    on the graphs) is significantly better than another.


    Assumes that number of groups = 2 or 3.

    :param groupBetterIfLargerValue_: if True, a group is considered to be 'better' if it has a higher mean
    :return: string output that can be saved into file or printed
    """
    outputStr = ""
    #

    from statsmodels.stats.multicomp import pairwise_tukeyhsd
    from statsmodels.stats.multicomp import MultiComparison

    if (len(dataArray_) > 3 or len(dataArray_) < 2):
        raise ValueError(" The data array must have 2 or 3 groups on dimension 1. Num of groups is {}".format(len(dataArray_)))

    for envId in range(len(dataArray_[0])):
        counter = 0;
        outputStr += "-----------------------\n"
        outputStr += envNames_[envId].replace("\n", " ") + "\n"
        outputStr += "-----------------------\n"

        medians = [];

        #-- preallocate empty array
        data = np.zeros(len(groupNames_) * constants.NUM_RUNS,dtype=[('Group','|U20'),('Score', '<i8')]);

        #-- fill it with data
        for groupId in range(len(groupNames_)):
            groupName = groupNames_[groupId];
            medians.append(crData.getMedian(dataArray_[groupId][envId]));
            for runNo in range(constants.NUM_RUNS):
                #data = np.append(data,np.array([(groupName,dataArray_[groupId][envId][runNo])], dtype=[('Group','|U20'),('Score', '<i8')]))
                data[counter] = (groupName,dataArray_[groupId][envId][runNo]);
                counter += 1;


        mc = MultiComparison(data['Score'], data['Group'])
        result = mc.tukeyhsd(alpha=0.01)

        #---- make sense of results
        groupScores = [0 for x in range(len(groupNames_))];

        #-- go through the pairways comparison of the tukey test. Each time a group is a winner in a comparison, add to its score.
        #-- this generates a list of group scores, where the highest score(s) are winners.
        for rejectResultId in range(len(result.reject)): # the reject results contain booleans to reject null hypothesis that 2 groups are the same.
            if (len(dataArray_) == 3): #Comparison is done in order: 0-1, 0-2, 1-2, but the mc.tukeyhsd groups are in reverse order. So real comparison group ids are: 2-1,2-0,1-0
                groupId = len(groupNames_) -1 ; # the
                if (rejectResultId > 1):
                    groupId = 1;
                groupId2 = 0; #group compared TO
                if (rejectResultId == 0):
                    groupId2 = 1;
            else: #Comparison is done in real group order: 0-1
                groupId = 0;
                groupId2 = 1;


            if (debug_):
                print("checking group {} against {} ".format(groupNames_[groupId], groupNames_[groupId2]))
            comparisonWinner = '';
            if (result.reject[rejectResultId]):
                if (debug_):
                    print("    yes diff. medians: {} , {}".format(medians[groupId], medians[groupId2]))
                #-- the two groups ARE statistically different.
                if (medians[groupId] > medians[groupId2]):
                    if (groupBetterIfLargerValue_):
                        groupScores[groupId] += 1;
                    else:
                        groupScores[groupId2] += 1;
                else:
                    if (groupBetterIfLargerValue_):
                        groupScores[groupId2] += 1;
                    else:
                        groupScores[groupId] += 1;

            else:
                #-- the two are the same
                groupScores[groupId] += 1;
                groupScores[groupId2] += 1;
                if (debug_):
                    print("     no diff")
            if (debug_):
                print(groupScores);

        #-- find all groups with the highest score
        highestScore = max(groupScores);
        outputStr += "Winners: ";
        for groupId in range(len(groupNames_)):
            if (groupScores[groupId] == highestScore):
                outputStr += groupNames_[groupId] + " ";
        outputStr += "\n"
        outputStr += "\n"

        #-- add some debug info:
        outputStr += str(result);
        outputStr += "\n"
        outputStr += "groups in table: " + str(mc.groupsunique) + "\n\n"
        outputStr += "real groups: {}\n".format(groupNames_);
        outputStr += "medians: {} \n".format(medians)
        outputStr += "group scores: {}\n".format(groupScores);
        outputStr += "\n"

    return outputStr;



#===================== ==================== ==================== ==================== ==================== ==================== ==================== ====================
#===================== ==================== ==================== ==================== ==================== ==================== ==================== ====================
#===================== ==================== ==================== ==================== ==================== ==================== ==================== ====================

def doAnalysis_byController_byExperimentType_bySwarmSize_byTask(controllerTypes_, scenarioFolderPrefixes_, experimentTypes_, NRs_, tasks_, envTypes_, distances_, outputDirectory_, colors_ = [], xAxisGroupSize_=4):
    """
    Creates analysis, with one output file per controller type (each can have prefixes, results of which will be stacked on top of each other), per experiment type.
    Total of len(controllerTypes) x len(experimentTypes_) x len(NRs_) x len(tasks_) analyses.
    """
    for controllerType in controllerTypes_:
        scenarioFolders = [];
        for prefix in scenarioFolderPrefixes_:
            scenarioFolders.append(prefix + controllerType)

        for experimentType in experimentTypes_:
            for NR in NRs_:
                for j in range(len(tasks_)):

                    analysisName = controllerType + "_NR" + str(NR) + "_" + tasks_[j];

                    distances = [];
                    taskTypes = [];
                    scenarioTypes = [];
                    NRsNow = [];

                    for i in range(len(scenarioFolders)):
                        distances.append(distances_);
                        scenarioTypes.append(envTypes_);
                        taskTypes.append([tasks_[j]]);
                        NRsNow.append(NR);


                    extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRsNow, experimentType);
                    analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRsNow, 0,helpers.getMaxTimeByNR(NR,"C"),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=xAxisGroupSize_, areScenarioFoldersStacked=True, outputFilePrefix_=experimentType + "_", colors_=colors_);

def doAnalysis_byController_byExperimentType_byTask(controllerTypes_, scenarioFolderPrefixes_, experimentTypes_, NRs_, tasks_, envTypes_, distances_, outputDirectory_, colors_ = [],
                                                    xAxisGroupSize_=4, yLimMin_=0, yLimMax_=crGraphs.INVALID_VALUE):
    """
    Creates analysis, with one output file per controller type (each can have prefixes, results of which will be stacked on top of each other), per experiment type.
    Total of len(controllerTypes) x len(experimentTypes_) x len(NRs_) x len(tasks_) analyses.
    """
    for controllerType in controllerTypes_:
        scenarioFolders = [];
        NRsNow = [];
        for NR in NRs_:
            for prefix in scenarioFolderPrefixes_:
                scenarioFolders.append(prefix + controllerType)
                NRsNow.append(NR);

        for experimentType in experimentTypes_:
            for a in range(1):
                for j in range(len(tasks_)):

                    analysisName = controllerType + "_" + tasks_[j];

                    distances = [];
                    taskTypes = [];
                    scenarioTypes = [];


                    for i in range(len(scenarioFolders)):
                        distances.append(distances_);
                        scenarioTypes.append(envTypes_);
                        taskTypes.append([tasks_[j]]);

                    extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRsNow, experimentType);
                    analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRsNow, 0,helpers.getMaxTimeByNR(NR,"C"),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=xAxisGroupSize_, areScenarioFoldersStacked=True, outputFilePrefix_=experimentType + "_", colors_=colors_, yLimMin_=yLimMin_, yLimMax_=yLimMax_);


def doAnalysis_byExperimentType_bySwarmSize_byTask_byEnvType(scenarioFolders_, experimentTypes_, NRs_, tasks_, envTypes_, distances_, outputDirectory_, markers_=[]):
    """
    Creates analysis, with one output file per experiment type, per environment type.
    Total of len(experimentTypes_) x len(NRs_) x len(tasks_) x len(envTypes_) analyses.
    """
    for experimentType in experimentTypes_:
        experimentId = helpers.getExperimentCacheId(scenarioFolders_[-1]);
        for NR in NRs_:
            for j in range(len(tasks_)):

                for envType in envTypes_:
                    analysisName = "NR" + str(NR) + "_" + tasks_[j] + "_" + envType;

                    distances = [];
                    taskTypes = [];
                    scenarioTypes = [];
                    NRsNow = [];

                    for i in range(len(scenarioFolders_)):
                        distances.append(distances_);
                        scenarioTypes.append([envType]);
                        taskTypes.append([tasks_[j]]);
                        NRsNow.append(NR);

                    extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders_, NRsNow, experimentType);
                    analyse(scenarioFolders_,taskTypes,scenarioTypes,distances,extraParamStrings, NRsNow, 0,helpers.getMaxTimeByNR(NR, experimentId),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, areScenarioFoldersStacked=True, outputFilePrefix_=experimentType + "_", markers_=markers_);

def doAnalysis_byExperimentType_bySwarmSize_byTask(scenarioFolders_, experimentTypes_, NRs_, tasks_, envTypes_, distances_, outputDirectory_, outputFilePrefix_ = "", maxTime_=0, markers_=[]):
    """
    Creates analysis, with one output file per experiment type, per swarm size, per task. Data points for different controllers (scenarioFolders_) are stacked on top of each other.
    Total of len(experimentTypes_) x len(NRs_) x len(tasks_) analyses.
    """
    for experimentType in experimentTypes_:
        for NR in NRs_:
            for j in range(len(tasks_)):

                analysisName = "NR" + str(NR) + "_" + tasks_[j];

                distances = [];
                taskTypes = [];
                scenarioTypes = [];
                NRstoUse = [];

                for i in range(len(scenarioFolders_)):
                    distances.append(distances_);
                    scenarioTypes.append(envTypes_);
                    taskTypes.append([tasks_[j]]);
                    NRstoUse.append(NR);

                if (maxTime_ == 0):
                    maxTime = helpers.getMaxTimeByNR(NR,"C")
                else:
                    maxTime = maxTime_

                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders_, NRstoUse,experimentType);
                analyse(scenarioFolders_,taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,maxTime,constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=True, outputFilePrefix_=outputFilePrefix_+ experimentType+"_", markers_=markers_);


def doAnalysis_byExperimentType_byController_byTask(scenarioFolders_, experimentTypes_, NRs_, tasks_, envTypes_, distances_, outputDirectory_, outputFilePrefix_ = "", maxTime_=0, markers_=[]):
    """
    Creates analysis, with one output file per experiment type, per controller type, per task. Data points for different NRs are stacked on top of each other.
    Total of len(experimentTypes_) x len(scenarioFolders_) x len(tasks_) analyses.
    """
    stackedParameterLabels = [];
    for nr in range(len(NRs_)):
        stackedParameterLabels.append("_NR" + str(NRs_[nr]));

    for experimentType in experimentTypes_:
        for scenarioFolder in scenarioFolders_:
            for j in range(len(tasks_)):

                analysisName = "_" + str(scenarioFolder) + "_" + tasks_[j];

                distances = [distances_];
                taskTypes = [[tasks_[j]]];
                scenarioTypes = [envTypes_];
                NRs = [NRs_];

                if (maxTime_ == 0):
                    maxTime = helpers.getMaxTimeByNR(50,"C")
                else:
                    maxTime = maxTime_

                extraScenarioParamStrings = [];

                temp2 = [];
                for e in range(len(envTypes_)):
                    temp2.append("");
                extraScenarioParamStrings.append(temp2);

                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings([scenarioFolder], experimentType_=experimentType);

                analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRs, 0,maxTime,constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_,
                    stackedParameterLabels_ = stackedParameterLabels, scenarioExtraParamStrs_=extraScenarioParamStrings, areScenarioFoldersStacked=False, areNrsStacked=True,
                    graphLineWidth_=2, xAxisGroupSize_=len(envTypes_), outputFilePrefix_=outputFilePrefix_+ experimentType+"_", markers_=markers_);

def doAnalysis_bySwarmSize_byTask(scenarioFolders_, NRs_, tasks_, envTypes_, distances_, outputDirectory_, outputTextFiles_ = True, markers_=[]):
    for NR in NRs_:
        for j in range(len(tasks_)):

            analysisName = "NR" + str(NR) + "_" + tasks_[j];

            distances = [];
            taskTypes = [];
            scenarioTypes = [];
            NRsNow = [];

            for i in range(len(scenarioFolders_)):
                distances.append(distances_);
                scenarioTypes.append(envTypes_);
                taskTypes.append([tasks_[j]]);
                NRsNow.append(NR);


            extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders_, NRsNow);
            analyse(scenarioFolders_,taskTypes,scenarioTypes,distances,extraParamStrings, NRsNow, 0,helpers.getMaxTimeByNR(NR),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, areScenarioFoldersStacked=True, xAxisGroupSize_=4, yTickStep_=3600, outputTextFiles_=outputTextFiles_, markers_=markers_);

def doAnalysis_bySwarmSize_byTask_byEnvironment(scenarioFolders_, NRs_, tasks_, envTypes_, distances_, outputDirectory_, maxTime_=0, markers_=[]):

    for NR in NRs_:
        for j in range(len(tasks_)):
            for envType in envTypes_:

                analysisName = "NR" + str(NR) + "_" + tasks_[j] + "_" + envType;

                distances = [];
                taskTypes = [];
                scenarioTypes = [];
                NRsNow = [];

                for i in range(len(scenarioFolders_)):
                    distances.append(distances_);
                    scenarioTypes.append([envType]);
                    taskTypes.append([tasks_[j]]);
                    NRsNow.append(NR);

                if (maxTime_ == 0):
                    maxTime = helpers.getMaxTimeByNR(NR)
                else:
                    maxTime = maxTime_

                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders_, NRsNow);
                analyse(scenarioFolders_,taskTypes,scenarioTypes,distances,extraParamStrings, NRsNow, 0,maxTime,constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, areScenarioFoldersStacked=True, xAxisGroupSize_=4, yTickStep_=3600, markers_=markers_);


def doAnalysis_byController_bySwarmSize_byTask(scenarioFolders_, experimentTypes_, NRs_, tasks_, envTypes_, distances_, outputDirectory_ ):
    """
    Perform analysis where multiple experiment types (e.g. 'A', 'C_fast', etc.) are show on one graph.
    """

    envGroups = [envTypes_];
    if (constants.DO_SCOUTING_SUCCESS):
        #-- if doing scouting success, create separate graphs for each environment type.
        envGroups = envTypes_;

    hasExpC = False;
    for exp in range(len(experimentTypes_)):
        experimentId =  experimentTypes_[exp][0];
        if (experimentId == "C"):
            hasExpC = True;
            break;

    for envGroup in envGroups:

        for sf in range(len(scenarioFolders_)):

            for NR in NRs_:

                experimentCols = ['#CF4217', '#1083DB', '#650965'];

                for j in range(len(tasks_)):
                    fig = None;
                    for exp in range(len(experimentTypes_)):
                        experimentId =  experimentTypes_[exp][0];
                        scenarioFolder = experimentId + "_" + scenarioFolders_[sf];

                        if (type(envGroup) == list):
                            analysisName = scenarioFolders_[sf] + "_NR" + str(NR) + "_" + tasks_[j];
                        else:
                            analysisName = scenarioFolders_[sf] + "_NR" + str(NR) + "_" + tasks_[j] + "_" + str(envGroup);


                        distances = [];
                        taskTypes = [];
                        scenarioTypes = [];
                        NRstoUse = [];

                        for i in range(len(scenarioFolders_)):
                            distances.append(distances_);
                            if (type(envGroup) == list):
                                scenarioTypes.append(envGroup);
                            else:
                                scenarioTypes.append([envGroup]);
                            taskTypes.append([tasks_[j]]);
                            NRstoUse.append(NR);

                        #-- do special things for each experiment id
                        if (experimentId == "A" or experimentId == "Anew"):
                            extraParamStrings = helpers.getScenarioFolderExtraParameterStrings([scenarioFolder], NRstoUse);
                        else:
                            extraParamStrings = helpers.getScenarioFolderExtraParameterStrings([scenarioFolder], NRstoUse,experimentTypes_[exp]);
                        #--

                        expIdForMaxTime = "A";
                        if (hasExpC):
                            expIdForMaxTime = "C";
                        #print("Exp id for max time {}".format(expIdForMaxTime))

                        if (constants.COST_TOTALS_INFO_SPEED):
                            fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=experimentTypes_, colors_=[experimentCols[exp]],fig_cost_totals_i=fig)[0];
                        elif (constants.COST_TOTALS_SOCIAL_INFO_GAIN):
                            fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=experimentTypes_, colors_=[experimentCols[exp]],fig_cost_totals_social_info_gain=fig)[0];
                        elif (constants.COST_TOTALS_C_M):
                            fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=experimentTypes_, colors_=[experimentCols[exp]],fig_cost_totals_c_m=fig)[0];
                        elif (constants.COST_TOTALS_C_O):
                            fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=experimentTypes_, colors_=[experimentCols[exp]],fig_cost_totals_c_o=fig)[0];
                        elif (constants.COST_TOTALS_m):
                            fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=experimentTypes_, colors_=[experimentCols[exp]],fig_cost_totals_m=fig)[0];
                        elif (constants.DO_SCOUTING_SUCCESS):
                            fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=experimentTypes_, colors_=[experimentCols[exp]],fig_scouting_success=fig)[0];


def doAnalysis_byController_byExperimentType_bySwarmSize_byTask_foldersTogether(controllerTypes_, scenarioFolderPrefixes_, experimentTypes_, NRs_, tasks_, envTypes_, distances_, outputDirectory_, groupExperimentTypesIntoOneFig_ = False ):
    """
    Create graphs where one graph compares different folders (e.g. C_, C_rel) for the same controller type, experiment type, etc.
    """
    for controllerType in controllerTypes_:
        scenarioFolders = [];
        for prefix in scenarioFolderPrefixes_:
            scenarioFolders.append(prefix + controllerType)


        envGroups = [envTypes_];
        if (constants.DO_SCOUTING_SUCCESS):
            #-- if doing scouting success, create separate graphs for each environment type.
            envGroups = envTypes_;

        for envGroup in envGroups:

            for j in range(len(tasks_)):



                for NR in NRs_:
                    experimentCols = ['#CF4217', '#1083DB', '#650965'];
                    #experimentCols = ['#1083DB', '#650965'];
                    addOnBehMarkers = ['s','x'];

                    fig = None;

                    for exp in range(len(experimentTypes_)):
                        experimentType = experimentTypes_[exp];
                        experimentId =  experimentTypes_[exp][0];
                        hasExpC = False;
                        if (experimentId == "C"):
                            hasExpC = True;

                        if (groupExperimentTypesIntoOneFig_ == False):
                            fig = None;

                        legendLabels = scenarioFolders;

                        for scenarioFolderId in range(len(scenarioFolders)):
                            scenarioFolder = scenarioFolders[scenarioFolderId];

                            if (type(envGroup) == list):
                                analysisName = controllerType + "_NR" + str(NR) + "_" + tasks_[j];
                            else:
                                analysisName = controllerType + "_NR" + str(NR) + "_" + tasks_[j] + "_" + str(envGroup);

                            if (groupExperimentTypesIntoOneFig_ == False):
                                analysisName = experimentType + "_" + analysisName

                            distances = [];
                            taskTypes = [];
                            scenarioTypes = [];
                            NRstoUse = [];

                            for i in range(len(experimentTypes_)):
                                distances.append(distances_);
                                if (type(envGroup) == list):
                                    scenarioTypes.append(envGroup);
                                else:
                                    scenarioTypes.append([envGroup]);
                                taskTypes.append([tasks_[j]]);
                                NRstoUse.append(NR);

                            #-- do special things for each experiment id
                            if (experimentId == "A" or experimentId == "Anew"):
                                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings([scenarioFolder], NRstoUse);
                            else:
                                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings([scenarioFolder], NRstoUse,experimentTypes_[exp]);
                            #--

                            expIdForMaxTime = "A";
                            if (hasExpC):
                                expIdForMaxTime = "C";
                            #print("Exp id for max time {}".format(expIdForMaxTime))


                            color = experimentCols[scenarioFolderId];
                            if (groupExperimentTypesIntoOneFig_):
                                marker = addOnBehMarkers[scenarioFolderId];
                            else:
                                marker = 's';



                            if (constants.DO_COSTS_TOTALS and constants.COST_TOTALS_INFO_SPEED):
                                fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=legendLabels, colors_=[color], markers_=[marker],fig_cost_totals_i=fig)[0];
                            elif (constants.DO_COSTS_TOTALS and constants.COST_TOTALS_SOCIAL_INFO_GAIN):
                                fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=legendLabels, colors_=[color], markers_=[marker],fig_cost_totals_social_info_gain=fig)[0];
                            elif (constants.DO_COSTS_TOTALS and constants.COST_TOTALS_C_M):
                                fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=legendLabels, colors_=[color], markers_=[marker],fig_cost_totals_c_m=fig)[0];
                            elif (constants.DO_COSTS_TOTALS and constants.COST_TOTALS_C_O):
                                fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=legendLabels, colors_=[color], markers_=[marker],fig_cost_totals_c_o=fig)[0];
                            elif (constants.DO_COSTS_TOTALS and constants.COST_TOTALS_C_U):
                                fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=legendLabels, colors_=[color], markers_=[marker],fig_cost_totals_c_u=fig)[0];
                            elif (constants.DO_COSTS_TOTALS and constants.COST_TOTALS_m):
                                fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", legendLabels_=legendLabels, colors_=[color], markers_=[marker],fig_cost_totals_m=fig)[0];
                            elif (constants.DO_SCOUTING_SUCCESS):
                                fig = analyse([scenarioFolder],taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, 0,helpers.getMaxTimeByNR(NR,expIdForMaxTime),constants.TIME_BIN_LENGTH_NORMAL, analysisName,outputDirectory_, graphLineWidth_=2, xAxisGroupSize_=4, areScenarioFoldersStacked=False, outputFilePrefix_="byExperiment_", colors_=[color], markers_=[marker],fig_scouting_success=fig, legendLabels_=legendLabels)[0];

