
#ifndef SOLITARY_H
#define SOLITARY_H

#include "baseRobot.h"

using namespace argos;

class Solitary : public BaseRobot {

public:
	struct Parameters {
	   uint maxTeamSizeUnchangedTime; // how long a robot waits by a task if it hasn't recruited any other robot to it (in seconds)

	   Parameters() {};
	   void Init(TConfigurationNode& t_node);
   };

	Solitary();
	void Init(TConfigurationNode& t_node);
	void Reset();

	void ControlStep();
	void ProcessTaskReached();
	Real ProcessTask(TASK_TYPE taskType_, int taskId_,  Real processedAmount_, Real taskValue_, Real taskTotalReward_, uint numOfRobotsRequired_);
	void OnUnloadResourceDone();


private:
	void OnTaskScouted();

	void BroadcastTaskCommitment();
	void FindOtherTaskBroadcasters();
	void ReturnToBase();
	void GoToTask();


	Parameters parameters;

	//-- behaviour
	uint timeSinceLastRobotArrivedToTask;
	uint lastNumOfRobotsAtTask;

	//-- communication
	std::vector<uint>encounteredIdsAtTask;
};

#endif



