
MY_DIR=`dirname $0`

source $MY_DIR/includeExp.sh
IS_ON_IRIDIS=1;

MAIN_DIRECTORY="experiments/optimLocalBroadcaster";
RUN_LENGTH=3600;
ROBOT_CONTROLLER_TYPE="localBroadcaster";



echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT optimSolitary STARTED "

#-- setup main directory
if [ -d $MAIN_DIRECTORY ]; then
    echo ""
else
    mkdir $MAIN_DIRECTORY
fi


for NUM_OF_ROBOTS in 25
do
#for S_MAX_TEAM_SIZE_UNCHANGED_TIME in 180 300 420 540 660 780
    for S_MAX_TEAM_SIZE_UNCHANGED_TIME in 900 1020 1140
    do
        for ENVIRONMENT_ID in "${ENVIRONMENTS[@]}"
        do
            DEFAULT_TASK_TYPE="COLLECT";
            MIN_ROBOTS_FOR_TASK=5;
            MAX_ROBOTS_FOR_TASK=5;
            setupEnvironment;
            ROBOT_CONTROLLER_SUBTYPE="NR${NUM_OF_ROBOTS}_TteamUnchg${S_MAX_TEAM_SIZE_UNCHANGED_TIME}"
            runExperiment50;

            wait;

            DEFAULT_TASK_TYPE="COLLECT";
            MIN_ROBOTS_FOR_TASK=2;
            MAX_ROBOTS_FOR_TASK=2;
            setupEnvironment;
            ROBOT_CONTROLLER_SUBTYPE="NR${NUM_OF_ROBOTS}_TteamUnchg${S_MAX_TEAM_SIZE_UNCHANGED_TIME}"
            runExperiment50;

            wait;
        done

    done

done

echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT optimSolitary ENDED "
echo ""
