import constants;
import os;

constants.BASE_FILE_PATH_DATA = os.path.abspath(os.path.join(os.path.dirname( __file__ ) , "../_docs/results/"));
constants.EXPERIMENT_CACHE_ID = "A"

import crGraphs;
import analysis;
import helpers;


crGraphs.DPI = 100;
constants.NUM_RUNS = 50;


DO_COMPARE_REWARD_TIME = True;
DO_COMPARE_REWARD_TIME_ANOVA = False; #note that to do this, python external library from mac ports (/opt/local/...) needs to be used

DO_COMPARE_COSTS_OVER_TIME = False;
DO_COMPARE_COSTS_TOTALS = False;
DO_COMPARE_COSTS_TOTALS_BY_CONTROLLER = False;

DO_COMPARE_DETAIL = False;
DO_COMPARE_INFO_GAIN = False;
DO_INFO_GAIN_STOPPED_TIME = False;
DO_COMPARE_INFO_TIME = False;
DO_COMPARE_CONSUME_VS_COLLECT = False;

DO_EVALUATE_NR_EFFECT_BY_SCENARIO = False;
DO_EVALUATE_NR_EFFECT_BY_CONTROLLER = False;
DO_COMPARE_INFO_TIME_REWARD_TIME = False;

DO_INFO_SPEED_TIME_BIN_SENSITIVIY = False;

DO_COSTS_INFO_OVERAL = False;
DO_INFO_GAIN_COSTS_OVER_TIME = False;

DO_SECONDARY_MEASUREMENTS = False # scouting success, when 1st worksite depleted

DO_TEST_OVER_TIME = False;
DO_TEST_TOTALS = False;


analysisName = "";
outputDirectory = "A_staticNonCooperative";

if __name__ == "__main__":

    START_TIME = 0;
    TIME_BIN_LENGTH = 180;


    distances = [];
    taskTypes = [];
    scenarioTypes = [];
    NRs = [];

    #--------------------------
    if (DO_COMPARE_REWARD_TIME):
        constants.resetAll();
        print("=========================== DO_COMPARE_REWARD_TIME ===========================");

        constants.DO_TIME_TILL_REWARD_COLLECTED = True;

        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        NRs=[10,25,50];
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        distances = [5,9,13,17,21];
        analysis.doAnalysis_bySwarmSize_byTask(scenarioFolders,NRs,tasks,envTypes,distances,outputDirectory, False)


    #--------------------------
    if (DO_COMPARE_REWARD_TIME_ANOVA):
        constants.resetAll();
        print("=========================== DO_COMPARE_REWARD_TIME_ANOVA ===========================");

        constants.DO_TIME_TILL_REWARD_COLLECTED_ANOVA = True;

        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        #envTypes = ['Heap2'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['PERFORM_RT1-1']; #''
        NRs=[10,25,50];
        #NRs=[50];
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        distances = [5,9,13,17,21];
        #distances = [5];
        analysis.doAnalysis_bySwarmSize_byTask(scenarioFolders,NRs,tasks,envTypes,distances,outputDirectory, False)


    if (DO_INFO_GAIN_STOPPED_TIME):
        constants.resetAll();
        constants.DO_INFO_GAIN_END_TIME = True;

        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        NRs=[10,50,25];

        for NR in NRs:
            for j in range(len(tasks)):

                analysisName = "NR" + str(NR) + "_" + tasks[j];


                #scenarioFolders = ["A_beeRecruiter"];
                scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];

                distances = [];
                taskTypes = [];
                scenarioTypes = [];
                NRsToUse = [];

                for i in range(len(scenarioFolders)):
                    distances.append([5,9,13,17,21]);
                    #distances.append([5]);
                    scenarioTypes.append(envTypes);
                    taskTypes.append([tasks[j]]);
                    NRsToUse.append(NR);


                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRsToUse);
                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(NR),TIME_BIN_LENGTH, analysisName,outputDirectory, graphLineWidth_=0, areScenarioFoldersStacked=True);

    #--------------------------
    if (DO_SECONDARY_MEASUREMENTS):
        constants.resetAll();
        print("=========================== DO_SECONDARY_MEASUREMENTS ===========================");

        constants.NUM_RUNS = 50;
        constants.DO_SCOUTING_SUCCESS = True;
        #constants.DO_TIME_TILL_FIRST_WORKSITE_DEPLETED = True;
        #constants.DO_TIME_TILL_HALF_WORKSITES_DEPLETED = True;

        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        #envTypes = ['Heap1'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        tasks = ['COLLECT_RT1-1'];
        #tasks = ['PERFORM_RT1-1'];
        NRs=[10,25,50];
        #NRs=[25]

        for NR in NRs:

            for j in range(len(tasks)):

                for envType in envTypes:

                    analysisName = "NR" + str(NR) + "_" + tasks[j] + "_" + envType;
                    scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];

                    distances = [];
                    taskTypes = [];
                    scenarioTypes = [];
                    NRsNow = [];

                    for i in range(len(scenarioFolders)):
                        distances.append([5,9,13,17,21]);
                        #distances.append([21]);
                        scenarioTypes.append([envType]);
                        taskTypes.append([tasks[j]]);
                        NRsNow.append(NR);


                    extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRsNow);
                    analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRsNow, START_TIME,helpers.getMaxTimeByNR(NR),TIME_BIN_LENGTH, analysisName,outputDirectory, graphLineWidth_=2, areScenarioFoldersStacked=True);

    #--------------------------
    if (DO_COMPARE_INFO_GAIN):
        constants.resetAll();
        print("=========================== DO_COMPARE_INFO_GAIN ===========================");

        #----
        analysisName = '_';
        envTypes = ['Heap1','Heap2','Heap4','Scatter25'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1'];
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        NR=25;

        #tasks = ['COLLECT_RT1-1'];
        constants.DO_INFO_GAIN_OVER_TIME = True;

        for j in range(len(tasks)):
            distances = [];
            taskTypes = [];
            scenarioTypes = [];
            NRs = [];
            for i in range(len(scenarioFolders)):
                distances.append([9]);
                scenarioTypes.append(envTypes);
                taskTypes.append([tasks[j]]);
                NRs.append(NR);

            extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
            analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(NR),TIME_BIN_LENGTH,analysisName,outputDirectory);

        #----
        analysisName = "BR_detail";
        dist = [5,9,17];
        sc = ['Heap4','Heap1','Scatter25'];
        scenarioFolders = [     'A_beeRecruiter',       'A_beeRecruiter',       'A_beeRecruiter' ];
        taskTypes = [           ['COLLECT_RT1-1'],      ['COLLECT_RT1-1'],      ['COLLECT_RT1-1']];
        distances = [           dist,                   dist,                   dist          ];
        scenarioTypes = [       sc,                     sc,                     sc   ];
        NRs = [                 10,                     25,                     50];
        extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
        analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(25),TIME_BIN_LENGTH,analysisName,outputDirectory);

        #----
        analysisName = "S_detail";
        dist = [17];
        sc = ['Scatter25'];
        scenarioFolders = [     'A_solitary',           'A_solitary',           'A_solitary',       'A_solitary',       ];
        taskTypes = [           ['COLLECT_RT1-1'],      ['PERFORM_RT1-1'],      ['PERFORM_RT1-1'],  ['PERFORM_RT1-1']       ];
        distances = [           [17],                   [17],                   [9] ,               [9]      ];
        scenarioTypes = [       sc,                     sc,                     sc,                 sc   ];
        NRs = [                 25,                     25,                     50,                 10];
        extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
        analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(25),TIME_BIN_LENGTH, analysisName,outputDirectory);


        #----
        analysisName = "LB_detail";
        dist = [5,9];
        sc = ['Heap1','Scatter25'];

        scenarioFolders = [     'A_localBroadcaster',   'A_localBroadcaster',   'A_localBroadcaster',    'A_localBroadcaster',  'A_localBroadcaster', 'A_localBroadcaster'          ];
        taskTypes = [           ['PERFORM_RT1-1'],      ['PERFORM_RT1-1'],      ['PERFORM_RT1-1'],       ['COLLECT_RT1-1'],     ['COLLECT_RT1-1'],     ['COLLECT_RT1-1']];
        distances = [           dist,                   dist,                   dist,                     dist,                 dist,                   dist          ];
        scenarioTypes = [       sc,                     sc,                     sc,                       sc,                   sc,                     sc   ];
        NRs = [                 10,                     50,                     25,                       25,                   50,                     10 ];
        extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
        analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(25),TIME_BIN_LENGTH,analysisName,outputDirectory);

        #----
        analysisName = "LB_ndIncrease";
        dist = [9,17];
        sc = ['Heap1','Heap2','Heap4'];

        scenarioFolders = [     'A_localBroadcaster',   'A_localBroadcaster',   'A_localBroadcaster'];
        taskTypes = [           ['PERFORM_RT1-1'],      ['PERFORM_RT1-1'],      ['COLLECT_RT1-1']];
        distances = [           dist,                   dist,                   dist ];
        scenarioTypes = [       sc,                     sc,                     sc ];
        NRs = [                 10,                     25,                     10];
        extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
        analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(25),TIME_BIN_LENGTH,analysisName,outputDirectory);

        analysisName = "LB_ndIncrease";
        dist = [5];
        sc = ['Heap4'];

        scenarioFolders = [     'A_localBroadcaster'];
        taskTypes = [           ['COLLECT_RT1-1']];
        distances = [           dist  ];
        scenarioTypes = [       sc];
        NRs = [                 10];
        extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
        analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(25),TIME_BIN_LENGTH,analysisName,outputDirectory);


    #--------------------------
    if (DO_INFO_GAIN_COSTS_OVER_TIME):
        constants.resetAll();
        print("=========================== DO_INFO_GAIN_COSTS_OVER_TIME ===========================");

        envTypes = ['Heap1','Heap2','Heap4', 'Scatter25'];
        #envTypes = ['Heap2','Heap4'];
        #envTypes = ['Scatter25'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['PERFORM_RT1-1'];
        #tasks = ['COLLECT_RT1-1'];

        constants.NUM_RUNS = 50;
        TIME_BIN_LENGTH = 180;
        MAX_TIME = 14400;
        constants.TIME_BIN_LENGTH_INFO_SPEED = 60;


        #NRs = [10,25];

        for j in range(len(tasks)):

            analysisName = '';

            constants.DO_COSTS_OVER_TIME = True;
            constants.DO_INFO_GAIN_OVER_TIME = True;

            scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];


            distances = [];
            taskTypes = [];
            scenarioTypes = [];
            NRsUsed = [];


            for i in range(len(scenarioFolders)):
                #distances.append([5,9,13,17]);
                distances.append([5,9]);
                scenarioTypes.append(envTypes);
                taskTypes.append([tasks[j]]);
                NRsUsed.append(25);


            extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRsUsed);

            analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRsUsed, START_TIME,helpers.getMaxTimeByNR(NRsUsed[0]),TIME_BIN_LENGTH,
                analysisName,outputDirectory,
                graphLineWidth_=1, areScenarioFoldersStacked=False, timeTillRewardCollectedTargetPercentage_=100);

    #--------------------------
    if (DO_COMPARE_INFO_TIME):
        constants.resetAll();
        print("=========================== DO_COMPARE_INFO_TIME ===========================");

        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        NR=50;
        #envTypes = ['Heap1'];
        #tasks = ['COLLECT_RT1-1'];


        for j in range(len(tasks)):

            analysisName = "NR" + str(NR) + "_" + tasks[j];
            constants.DO_INFO_GAIN_END_TIME = True;

            #scenarioFolders = ["A_beeRecruiter"];
            scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];

            distances = [];
            taskTypes = [];
            scenarioTypes = [];
            NRs = [];

            for i in range(len(scenarioFolders)):
                distances.append([5,9,13,17]);
                #distances.append([5]);
                scenarioTypes.append(envTypes);
                taskTypes.append([tasks[j]]);
                NRs.append(NR);


            extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
            analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(NR),TIME_BIN_LENGTH,
                analysisName,outputDirectory,
                graphLineWidth_=0, areScenarioFoldersStacked=True);



    #--------------------------
    if (DO_EVALUATE_NR_EFFECT_BY_SCENARIO):
        constants.resetAll();
        print("=========================== DO_EVALUATE_NR_EFFECT ===========================");

        scenarioFolder = 'A_localBroadcaster'; #A_solitary A_localBroadcaster  A_beeRecruiter

        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1'];
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        NRVals = [10,25,50];

        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];

        constants.DO_TIME_TILL_REWARD_COLLECTED = True;

        for j in range(len(tasks)):
            for e in range(len(envTypes)):

                #analysisName = scenarioFolder + "_" + tasks[j];
                analysisName = envTypes[e] + "_" + tasks[j];

                distances = [];
                taskTypes = [];
                scenarioTypes = [];
                NRs = [];
                stackedParameterLabels = [];
                extraScenarioParamStrings = [];

                for i in range(len(scenarioFolders)):
                    distances.append([5,9,13,17]);
                    temp1 = [];
                    temp2 = [];
                    for nr in range(len(NRVals)):
                        temp1.append(envTypes[e]);
                        temp2.append("_NR" + str(NRVals[nr]));

                    scenarioTypes.append(temp1);
                    taskTypes.append([tasks[j]]);
                    extraScenarioParamStrings.append(temp2);
                    NRs.append(NRVals);

                extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders);

                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(10),TIME_BIN_LENGTH,
                        analysisName,outputDirectory,
                        stackedParameterLabels_ = stackedParameterLabels,scenarioExtraParamStrs_ = extraScenarioParamStrings,
                        graphLineWidth_=1, areScenarioFoldersStacked=True, timeTillRewardCollectedTargetPercentage_=100, xAxisGroupSize_=3,yTickStep_=3600);

    #--------------------------
    if (DO_EVALUATE_NR_EFFECT_BY_CONTROLLER):
        constants.resetAll();
        print("=========================== DO_EVALUATE_NR_EFFECT_BY_CONTROLLER ===========================");

        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        #scenarioFolders = ['A_beeRecruiter'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1'];
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        NRVals = [10,25,50];

        constants.DO_TIME_TILL_REWARD_COLLECTED = True;

        for sf in range(len(scenarioFolders)):
            stackedParameterLabels = [];
            for nr in range(len(NRVals)):
                stackedParameterLabels.append("_NR" + str(NRVals[nr]));

            for j in range(len(tasks)):

                analysisName = scenarioFolders[sf] + "_" + tasks[j];

                distances = [[5,9,13,17,21]];
                taskTypes = [[tasks[j]]];
                scenarioTypes = [envTypes];
                NRs = [NRVals];

                extraScenarioParamStrings = [];

                temp2 = [];
                for e in range(len(envTypes)):
                    temp2.append("");

                extraScenarioParamStrings.append(temp2);

                extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings([scenarioFolders[sf]]); #do not pass nrs as extra param for scenario, NRs are other parameter now

                analysis.analyse([scenarioFolders[sf]],taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(10),TIME_BIN_LENGTH,
                    analysisName,outputDirectory,
                    stackedParameterLabels_ = stackedParameterLabels,scenarioExtraParamStrs_ = extraScenarioParamStrings,
                    graphLineWidth_=1, areScenarioFoldersStacked=False, areNrsStacked=True, timeTillRewardCollectedTargetPercentage_=100, xAxisGroupSize_=4,yTickStep_=3600, outputTextFiles_=True);

    #--------------------------
    if (DO_COMPARE_COSTS_OVER_TIME):
        constants.resetAll();
        print("=========================== DO_COMPARE_COSTS_OVER_TIME ===========================");

        envTypes = ['Heap1', 'Heap2', 'Heap4', 'Scatter25'];
        #envTypes = ['Scatter25'];

        #tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['PERFORM_RT2-2','PERFORM_RT4-4']; #''
        #envTypes = ['Heap1'];
        tasks = ['COLLECT_RT1-1'];
        #tasks = ['PERFORM_RT1-1'];
        NR=25;

        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        #scenarioFolders = ["A_beeRecruiter"];
        constants.NUM_RUNS = 1;
        constants.DO_COSTS_OVER_TIME = True;
        constants.DO_INFO_VALUE_OVER_TIME = False;

        for j in range(len(tasks)):

            analysisName = '';

            distances = [];
            taskTypes = [];
            scenarioTypes = [];
            NRs = [];

            for i in range(len(scenarioFolders)):
                distances.append([5,9,17]);
                #distances.append([13]);
                scenarioTypes.append(envTypes);
                taskTypes.append([tasks[j]]);
                NRs.append(NR);


            extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
            analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(NR),TIME_BIN_LENGTH,
                analysisName,outputDirectory,
                graphLineWidth_=1, areScenarioFoldersStacked=False, timeTillRewardCollectedTargetPercentage_=100);

    #--------------------------
    if (DO_COMPARE_COSTS_TOTALS):
        constants.resetAll();
        print("=========================== DO_COMPARE_COSTS_TOTALS ===========================");

        envTypes = ['Heap1', 'Heap2', 'Heap4', 'Scatter25'];
        #envTypes = ['Heap1', 'Heap4', 'Scatter25'];

        outputFilePrefix = "";

        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''

        #envTypes = ['Heap1'];
        #tasks = ['COLLECT_RT1-1'];
        #tasks = ['PERFORM_RT1-1'];
        NRs=[25,10,50];
        #NRs=[50];

        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        #scenarioFolders = ["A_localBroadcaster"];

        constants.DO_COSTS_TOTALS = True;

        for NR in NRs:
            for j in range(len(tasks)):

                analysisName = "NR" + str(NR) + "_" + tasks[j];

                distances = [];
                taskTypes = [];
                scenarioTypes = [];
                NRstoUse = [];

                for i in range(len(scenarioFolders)):
                    distances.append([5,9,13,17,21]);
                    #distances.append([5,9,17]);
                    scenarioTypes.append(envTypes);
                    taskTypes.append([tasks[j]]);
                    NRstoUse.append(NR);


                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRstoUse);
                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, START_TIME,helpers.getMaxTimeByNR(NR),TIME_BIN_LENGTH, analysisName,outputDirectory, graphLineWidth_=0, areScenarioFoldersStacked=True, outputFilePrefix_=outputFilePrefix);

    if (DO_COMPARE_COSTS_TOTALS_BY_CONTROLLER):
        constants.resetAll();
        print("=========================== DO_COMPARE_COSTS_TOTALS_BY_CONTROLLER ===========================");

        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        #scenarioFolders = ['A_beeRecruiter'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1'];
        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        NRVals = [10,25,50];

        constants.DO_COSTS_TOTALS = True;

        for sf in range(len(scenarioFolders)):
            stackedParameterLabels = [];
            for nr in range(len(NRVals)):
                stackedParameterLabels.append("_NR" + str(NRVals[nr]));

            for j in range(len(tasks)):

                analysisName = scenarioFolders[sf] + "_" + tasks[j];

                distances = [[5,9,13,17,21]];
                taskTypes = [[tasks[j]]];
                scenarioTypes = [envTypes];
                NRs = [NRVals];

                extraScenarioParamStrings = [];

                temp2 = [];
                for e in range(len(envTypes)):
                    temp2.append("");

                extraScenarioParamStrings.append(temp2);

                extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings([scenarioFolders[sf]]); #do not pass nrs as extra param for scenario, NRs are other parameter now

                analysis.analyse([scenarioFolders[sf]],taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME, helpers.getMaxTimeByNR(50),TIME_BIN_LENGTH,
                    analysisName,outputDirectory,
                    stackedParameterLabels_ = stackedParameterLabels,scenarioExtraParamStrs_ = extraScenarioParamStrings,
                    graphLineWidth_=1, areScenarioFoldersStacked=False, areNrsStacked=True, timeTillRewardCollectedTargetPercentage_=100, xAxisGroupSize_=4,yTickStep_=3600, outputFilePrefix_="byController_");

    #--------------------------
    if (DO_INFO_SPEED_TIME_BIN_SENSITIVIY):
        constants.resetAll();
        print("=========================== DO_INFO_SPEED_TIME_BIN_SENSITIVIY ===========================");

        envTypes = ['Heap1', 'Heap2', 'Heap4', 'Scatter25'];
        #envTypes = ['Heap1', 'Heap4', 'Scatter25'];

        outputFilePrefix = "infoSpeedTimeBinSensitivity_";

        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''

        #NRs=[25,10,50];
        NRs=[50,10];

        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        #scenarioFolders = ["A_localBroadcaster"];

        infoSpeedBinTimes = [30,60,120,180,240,300]

        constants.DO_COSTS_TOTALS = True;

        for infoSpeedBinTime in infoSpeedBinTimes:
            constants.TIME_BIN_LENGTH_INFO_SPEED = infoSpeedBinTime;

            for NR in NRs:
                for j in range(len(tasks)):

                    analysisName = "NR" + str(NR) + "_" + tasks[j];

                    distances = [];
                    taskTypes = [];
                    scenarioTypes = [];
                    NRstoUse = [];

                    for i in range(len(scenarioFolders)):
                        distances.append([9,13,17]);
                        #distances.append([5,9,17]);
                        scenarioTypes.append(envTypes);
                        taskTypes.append([tasks[j]]);
                        NRstoUse.append(NR);


                    extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRstoUse);
                    analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRstoUse, START_TIME,helpers.getMaxTimeByNR(NR),TIME_BIN_LENGTH, analysisName,outputDirectory, graphLineWidth_=0, areScenarioFoldersStacked=True, outputFilePrefix_=outputFilePrefix);

    #--------------------------
    if (DO_COMPARE_CONSUME_VS_COLLECT):
        constants.resetAll();
        scenarioFolders = ['A_localBroadcaster','A_solitary','A_beeRecruiter']
        distances = [5,9,13,17,21];
        scenarioTypes = ['Heap1', 'Heap2','Heap4','Scatter25']
        #scenarioTypes = ['Heap1']
        #taskTypes =
        NRs = [10,25,50];

        constants.DO_TIME_TILL_REWARD_COLLECTED = True;

        for NR in NRs:
            for sc in scenarioTypes:
                fig = None;
                for scenarioFolder in scenarioFolders:
                    analysisName = "consVsCol_" + sc + "_NR" + str(NR);

                    sfs = [                 scenarioFolder,         scenarioFolder ];
                    taskTypes = [           ['PERFORM_RT1-1'],      ['COLLECT_RT1-1']];
                    dist = [           distances,              distances ];
                    scTypes = [       [sc],                     [sc] ];
                    NRs = [                 NR,                     NR];
                    extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(sfs, NRs);
                    marker = helpers.getMarkerColorByController(scenarioFolder) + "s-";
                    figs = analysis.analyse(sfs,taskTypes,scTypes,dist,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(max(NRs)),TIME_BIN_LENGTH,analysisName,outputDirectory,
                        markers_=[marker], graphLineWidth_=1, xAxisGroupSize_=2, outputTextFiles_=False, fig_timeTillRewardCollected=fig);
                    fig = figs[0];
    #--------------------------
    if (DO_COSTS_INFO_OVERAL):
        constants.resetAll();
        #envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        envTypes = ['Heap1','Heap2','Heap4'];
        #envTypes = ['Heap1'];
        #tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['COLLECT_RT1-1'];
        tasks = ['PERFORM_RT1-1'];

        constants.NUM_RUNS = 50;
        #constants.TIME_BIN_LENGTH_INFO_SPEED = 180;

        #NRs = [10,25];

        for j in range(len(tasks)):

            analysisName = '';

            constants.DO_COSTS_OVER_TIME = False;
            constants.DO_INFO_VALUE_OVER_TIME = False;
            constants.DO_INFO_GAIN_OVER_TIME = True;
            constants.DO_SWARM_STATS_ENV_STATS_CORRELATION = True;

            #scenarioFolders = ["A_beeRecruiter"];
            #scenarioFolders = ["A_solitary", 'A_beeRecruiter'];
            scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];

            distances = [];
            taskTypes = [];
            scenarioTypes = [];
            NRsUsed = [];


            for i in range(len(scenarioFolders)):
                #distances.append([5,9,13,17]);
                distances.append([9]);
                scenarioTypes.append(envTypes);
                taskTypes.append([tasks[j]]);
                NRsUsed.append(25);


            extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRsUsed);

            analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRsUsed, START_TIME,helpers.getMaxTimeByNR(NRsUsed[0]),TIME_BIN_LENGTH,
                analysisName,outputDirectory,
                graphLineWidth_=1, areScenarioFoldersStacked=False, timeTillRewardCollectedTargetPercentage_=100);
    #--------------------------
    if (DO_COMPARE_INFO_TIME_REWARD_TIME):
        constants.resetAll();
        constants.DO_INFO_GAIN_END_TIME = True;
        constants.DO_TIME_TILL_REWARD_COLLECTED = True;
        outputFilePrefix = "infoVsRewTime_"

        envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        NRs=[10,25,50];

        for NR in NRs:
            for j in range(len(tasks)):

                analysisName = "NR" + str(NR) + "_" + tasks[j];


                #scenarioFolders = ["A_beeRecruiter"];
                scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];

                distances = [];
                taskTypes = [];
                scenarioTypes = [];
                NRs = [];

                for i in range(len(scenarioFolders)):
                    distances.append([5,9,13,17,21]);
                    #distances.append([5]);
                    scenarioTypes.append(envTypes);
                    taskTypes.append([tasks[j]]);
                    NRs.append(NR);


                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(NR),TIME_BIN_LENGTH, analysisName,outputDirectory, graphLineWidth_=0, areScenarioFoldersStacked=True, outputFilePrefix_=outputFilePrefix);


    #------------------------
    if (DO_COMPARE_DETAIL):
        constants.resetAll();
        print("=========================== DO_COMPARE_DETAIL ===========================");
        constants.DO_COSTS_OVER_TIME = True;

        analysisName = '';
        scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
        #scenarioFolders = ["A_localBroadcaster","A_beeRecruiter"];

        distances = [];
        taskTypes = [];
        scenarioTypes = [];
        NRs = [];

        for i in range(len(scenarioFolders)):
            distances.append([9]);
            scenarioTypes.append(['Heap1', 'Heap1', 'Heap2', 'Heap2', 'Heap4', 'Heap4', 'Scatter25','Scatter25']);
            taskTypes.append(['COLLECT_RT1-1','PERFORM_RT1-1']);
            NRs.append(25);


        extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
        analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
            analysisName,outputDirectory);


    #--------------------------
    if (DO_TEST_OVER_TIME):
        outputFilePrefix = "TEST"
        constants.resetAll();
        #envTypes = ['Heap1', 'Heap2','Heap4', 'Scatter25'];
        #envTypes = ['Heap2','Heap4', 'Scatter25'];
        envTypes = ['Heap4'];
        #tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['PERFORM_RT1-1'];
        tasks = ['COLLECT_RT1-1'];

        constants.NUM_RUNS = 1;
        TIME_BIN_LENGTH = 180;
        MAX_TIME = 14400;
        constants.TIME_BIN_LENGTH_INFO_SPEED = 60;

        NR=25;

        for j in range(len(tasks)):

            analysisName = '';
            constants.DO_REWARD_COLLECTED = False;
            constants.DO_SWARM_UNCERTAINTY_COST = False;
            constants.DO_TIME_TILL_REWARD_COLLECTED = False;
            constants.DO_VOLUME_PER_FORAGER = False;

            constants.DO_COSTS_OVER_TIME = True;
            constants.DO_INFO_GAIN_OVER_TIME = True;
            constants.DO_SWARM_STATS_ENV_STATS_CORRELATION = False;


            #scenarioFolders = ["A_solitary", 'A_beeRecruiter'];
            #scenarioFolders = ["A_solitary", 'A_localBroadcaster','A_beeRecruiter'];
            scenarioFolders = ["A_solitary"];

            distances = [];
            taskTypes = [];
            scenarioTypes = [];
            NRsUsed = [];


            for i in range(len(scenarioFolders)):
                #distances.append([5,9,13,17]);
                distances.append([5]);
                scenarioTypes.append(envTypes);
                taskTypes.append([tasks[j]]);
                NRsUsed.append(NR);


            extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRsUsed);

            analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRsUsed, START_TIME,helpers.getMaxTimeByNR(NRsUsed[0]),TIME_BIN_LENGTH,
                analysisName,outputDirectory,
                graphLineWidth_=1, areScenarioFoldersStacked=False, timeTillRewardCollectedTargetPercentage_=100, outputFilePrefix_ = outputFilePrefix);

    if (DO_TEST_TOTALS):
        constants.resetAll();


        scenarioFolders = ['A_solitary','A_localBroadcaster', 'A_beeRecruiter']
        #scenarioFolders = ['A_beeRecruiter'];
        envTypes = ['Heap1', 'Heap2','Heap4']
        #envTypes = ['Heap2'];


        NRs = [25];

        outputFilePrefix = "TEST"

        #tasks = ['COLLECT_RT1-1','PERFORM_RT1-1']; #''
        #tasks = ['PERFORM_RT1-1'];
        tasks = ['COLLECT_RT1-1'];

        constants.NUM_RUNS = 2;
        constants.DO_COSTS_TOTALS = True;
        constants.DO_COSTS_OVER_TIME = False;
        constants.DO_TIME_TILL_REWARD_COLLECTED = False;

        for NR in NRs:
            for j in range(len(tasks)):

                analysisName = "NR" + str(NR) + "_" + tasks[j];

                distances = [];
                taskTypes = [];
                scenarioTypes = [];
                NRs = [];

                for i in range(len(scenarioFolders)):
                    #distances.append([5,9,13,17]);
                    distances.append([5,9]);
                    scenarioTypes.append(envTypes);
                    taskTypes.append([tasks[j]]);
                    NRs.append(NR);


                extraParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs);
                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,helpers.getMaxTimeByNR(NR),TIME_BIN_LENGTH, analysisName,outputDirectory, graphLineWidth_=0, areScenarioFoldersStacked=True, outputFilePrefix_=outputFilePrefix);











