
#ifndef LOCAL_BROADCASTER_H
#define LOCAL_BROADCASTER_H

#include "baseRobot.h"

using namespace argos;

class AntRecruiter : public BaseRobot {

public:


	struct Parameters {

	   uint signalDistance; // distance in cm of how far signals can be picked up
	   uint maxTeamSizeUnchangedTime; // how long a robot waits by a task if it hasn't recruited any other robot to it (in seconds)

	   Parameters() {};
	   void Init(TConfigurationNode& t_node);
   };

public:
	AntRecruiter();
	void Init(TConfigurationNode& t_node);
	void Reset();


private:


private:


	Parameters parameters;

	//-- behaviour
	uint timeSinceLastRecruitment;
	uint lastNumOfRecruitedRobots;

	//-- communication
	bool isCommunicating;
	std::vector<uint>encounteredIdsAtTask;

	bool taskInfoToIdSent;
	bool taskInfoAngleToTargetSent;
	bool taskInfoDistanceToTargetSent;
	bool taskInfoTaskIdSent;

	bool taskInfoToIdReceived;
	bool taskInfoAngleToTargetReceived;
	bool taskInfoDistanceToTargetReceived;
	bool taskInfoTaskIdReceived;



};

#endif



