import constants;
import os;
constants.BASE_FILE_PATH_DATA = os.path.abspath(os.path.join(os.path.dirname( __file__ ) , "../_docs/results/"));


import crGraphs;
import analysis;
import helpers;

def getRobotParameterStrings(environmentExtraParamStrings_, scenarioFolders_):
    for sf in range(len(scenarioFolders_)):
        if ('Solitary' in scenarioFolders_[sf]):
            environmentExtraParamStrings_[sf] += "_TteamUnchg600";
        elif ('LocalBroadcaster' in scenarioFolders_[sf]):
            environmentExtraParamStrings_[sf] += "_TteamUnchg420";
        elif ('BeeRecruiter' in scenarioFolders_[sf]):
            environmentExtraParamStrings_[sf] += "_TteamUnchg300";
    return environmentExtraParamStrings_;



crGraphs.DPI = 100;
constants.NUM_RUNS = 50;

DO_SOLITARY_NEIGHB_SEARCH = False;
DO_SOLITARY_TEAM_UNCH_TIME = False;


DO_LOCAL_BROADCASTER_NEIGHB_SEARCH = False;
DO_LOCAL_BROADCASTER_TEAM_UNCH_TIME = False;

DO_BEE_RECRUITER_SCOUT_VS_RECRUIT = False;
DO_BEE_RECRUITER_SCOUT_TIME = False;
DO_BEE_RECRUITER_NEIGHB_SEARCH = True;
DO_BEE_RECRUITER_TEAM_UNCH_TIME = False;

DO_COMPARE_OPTIMISED = False;


analysisName = "";
outputDirectory = "0_optim";


if __name__ == "__main__":

    MAX_TIME=3600;
    START_TIME = 0;
    TIME_BIN_LENGTH = 50;

    distances = [];
    taskTypes = [];
    scenarioTypes = [];
    NRs = [];

    #--------------------------
    if (DO_SOLITARY_NEIGHB_SEARCH):
        wheelsNoizeVals = ["0.5","1.5"];
        searchRadVals = ["1","2","3","4"];
        searchTVals = ["60","180","300"];

        tasks = ['COLLECT_RT1-1'];
        envTypes = ['Heap1', 'Heap4', 'Scatter25'];
        distances = [9,13,17];

        scenarioFolders = ['0_optimSolitary'];


        constants.DO_REWARD_COLLECTED = True;


        for j in range(len(tasks)):
            for e in range(len(envTypes)):
                for n in range(len(wheelsNoizeVals)):

                    analysisName = "solitary_neighbSearch_" + envTypes[e] + "_wheelsNoize" + wheelsNoizeVals[n] + "_" + tasks[j];
                    taskTypes = [];
                    scenarioTypes = [];
                    NRs = [];

                    extraScenarioParamStrings = [];
                    xAxisLabels = [];
                    temp1 = [];
                    temp2 = [];

                    for r in range(len(searchRadVals)):
                        for t in range(len(searchTVals)):
                            temp1.append(envTypes[e]);
                            temp2.append("_NR25_wheelsNoize" + wheelsNoizeVals[n] + "_searchRad" + searchRadVals[r] + "_searchT" + searchTVals[t]);
                            xAxisLabels.append("_searchRad" + searchRadVals[r] + "\nsearchT" + searchTVals[t])

                        scenarioTypes.append(temp1);
                        taskTypes.append([tasks[j]]);
                        extraScenarioParamStrings.append(temp2);
                        NRs.append(25);

                    extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders);

                    analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
                            analysisName,outputDirectory,
                            xAxisLabels_ = xAxisLabels, scenarioExtraParamStrs_ = extraScenarioParamStrings,
                            graphLineWidth_=1, areDistancesStacked=True, xAxisGroupSize_=3);

    #--------------------------
    if (DO_SOLITARY_TEAM_UNCH_TIME):

        teamUnchTVals = ["180","300","420","540","660","780","900","1020","1140"];

        tasks = ['COLLECT_RT2-2','COLLECT_RT5-5','PERFORM_RT2-2','PERFORM_RT5-5'];
        envTypes = ['Heap4', 'Scatter25'];
        distances = [9,13,17];

        scenarioFolders = ['0_optimSolitary'];
        constants.DO_REWARD_COLLECTED = True;

        for j in range(len(tasks)):
            for e in range(len(envTypes)):
                analysisName = "solitary_teamUnchT" + envTypes[e] + "_" + tasks[j];

                taskTypes = [];
                scenarioTypes = [];
                NRs = [];

                extraScenarioParamStrings = [];
                xAxisLabels = [];
                temp1 = [];
                temp2 = [];

                for t in range(len(teamUnchTVals)):
                    temp1.append(envTypes[e]);
                    temp2.append("_NR25_TteamUnchg" + teamUnchTVals[t]);
                    xAxisLabels.append("teamUnchT=" + teamUnchTVals[t]);

                    scenarioTypes.append(temp1);
                    taskTypes.append([tasks[j]]);
                    extraScenarioParamStrings.append(temp2);
                    NRs.append(25);

                extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders);

                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
                        analysisName,outputDirectory,
                        xAxisLabels_ = xAxisLabels, scenarioExtraParamStrs_ = extraScenarioParamStrings,
                        graphLineWidth_=1, areDistancesStacked=True);



    #--------------------------
    if (DO_LOCAL_BROADCASTER_NEIGHB_SEARCH):
        wheelsNoizeVals = ["0.5","1.5"];
        searchRadVals = ["1","2","3","4"];
        searchTVals = ["60","180","300"];

        tasks = ['COLLECT_RT1-1'];
        envTypes = ['Heap1', 'Heap4', 'Scatter25'];
        distances = [9,13,17];

        scenarioFolders = ['0_optimLocalBroadcaster'];


        constants.DO_REWARD_COLLECTED = True;


        for j in range(len(tasks)):
            for e in range(len(envTypes)):

                for n in range(len(wheelsNoizeVals)):

                    analysisName = "localBroadcaster_neighbSearch_" + envTypes[e] + "_wheelsNoize" + wheelsNoizeVals[n] + "_" + tasks[j];
                    taskTypes = [];
                    scenarioTypes = [];
                    NRs = [];

                    extraScenarioParamStrings = [];
                    xAxisLabels = [];
                    temp1 = [];
                    temp2 = [];

                    for r in range(len(searchRadVals)):
                        for t in range(len(searchTVals)):
                            temp1.append(envTypes[e]);
                            temp2.append("_NR25_wheelsNoize" + wheelsNoizeVals[n] + "_searchRad" + searchRadVals[r] + "_searchT" + searchTVals[t]);
                            xAxisLabels.append("_searchRad" + searchRadVals[r] + "\nsearchT" + searchTVals[t])

                        scenarioTypes.append(temp1);
                        taskTypes.append([tasks[j]]);
                        extraScenarioParamStrings.append(temp2);
                        NRs.append(25);

                    extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders);

                    analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
                            analysisName,outputDirectory,
                            xAxisLabels_ = xAxisLabels, scenarioExtraParamStrs_ = extraScenarioParamStrings,
                            graphLineWidth_=1, areDistancesStacked=True, xAxisGroupSize_=3);

    #--------------------------
    if (DO_LOCAL_BROADCASTER_TEAM_UNCH_TIME):

        teamUnchTVals = ["180","300","420","540","660","780","900","1020","1140"];

        tasks = ['COLLECT_RT2-2','COLLECT_RT5-5','PERFORM_RT2-2','PERFORM_RT5-5'];
        envTypes = ['Heap4', 'Scatter25'];
        distances = [9,13,17];

        scenarioFolders = ['0_optimLocalBroadcaster'];
        constants.DO_REWARD_COLLECTED = True;

        for j in range(len(tasks)):
            for e in range(len(envTypes)):
                analysisName = "localBroadcaster_teamUnchT" + envTypes[e] + "_" + tasks[j];
                taskTypes = [];
                scenarioTypes = [];
                NRs = [];

                extraScenarioParamStrings = [];
                xAxisLabels = [];
                temp1 = [];
                temp2 = [];

                for t in range(len(teamUnchTVals)):
                    temp1.append(envTypes[e]);
                    temp2.append("_NR25_TteamUnchg" + teamUnchTVals[t]);
                    xAxisLabels.append("teamUnchT=" + teamUnchTVals[t]);

                    scenarioTypes.append(temp1);
                    taskTypes.append([tasks[j]]);
                    extraScenarioParamStrings.append(temp2);
                    NRs.append(25);

                extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders);

                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
                        analysisName,outputDirectory,
                        xAxisLabels_ = xAxisLabels, scenarioExtraParamStrs_ = extraScenarioParamStrings,
                        graphLineWidth_=1, areDistancesStacked=True);


    #--------------------------
    if (DO_BEE_RECRUITER_SCOUT_VS_RECRUIT):

        pSVals = ["0.1","0.01","0.001","0.0001"];
        TRVals = ["60","120","180"];

        tasks = ['COLLECT_RT1-1', 'PERFORM_RT1-1'];
        envTypes = ['Heap1', 'Heap4', 'Scatter25'];
        distances = [9,13,17];

        scenarioFolders = ['0_optimBeeRecruiter'];


        constants.DO_REWARD_COLLECTED = True;


        for j in range(len(tasks)):
            for e in range(len(envTypes)):

                analysisName = "beeRec_scoutVsRecruit_" + envTypes[e] + "_" + tasks[j];

                taskTypes = [];
                scenarioTypes = [];
                NRs = [];

                extraScenarioParamStrings = [];
                xAxisLabels = [];
                temp1 = [];
                temp2 = [];

                for p in range(len(pSVals)):
                    for t in range(len(TRVals)):
                        temp1.append(envTypes[e]);
                        temp2.append("_NR25_pS" + pSVals[p] + "_TR" + TRVals[t]);
                        xAxisLabels.append("pS=" + pSVals[p] + "\nTR=" + TRVals[t])

                    scenarioTypes.append(temp1);
                    taskTypes.append([tasks[j]]);
                    extraScenarioParamStrings.append(temp2);
                    NRs.append(25);

                extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders);

                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
                        analysisName,outputDirectory,
                        xAxisLabels_ = xAxisLabels, scenarioExtraParamStrs_ = extraScenarioParamStrings,
                        graphLineWidth_=1, areDistancesStacked=True, xAxisGroupSize_=3);


    #--------------------------
    if (DO_BEE_RECRUITER_SCOUT_TIME):

        DO_REWARD_COLLECTED = True;
        soutTimeVals = ["480","600","720","840","960","1080","1200","1320"];
        #soutTimeVals = ["720","840","1080"];

        tasks = ['COLLECT_RT1-1', 'PERFORM_RT1-1'];
        envTypes = ['Heap1', 'Heap4', 'Scatter25'];
        #envTypes = ['Heap4'];
        distances = [9,13,17];

        scenarioFolders = ['0_optimBeeRecruiter'];
        constants.DO_REWARD_COLLECTED = True;
        constants.DO_SCOUTING_SUCCESS = True;

        for j in range(len(tasks)):
            for e in range(len(envTypes)):
                analysisName = "beeRecruiter_scoutT" + envTypes[e] + "_" + tasks[j];

                taskTypes = [];
                scenarioTypes = [];
                NRs = [];

                extraScenarioParamStrings = [];
                xAxisLabels = [];
                temp1 = [];
                temp2 = [];

                for t in range(len(soutTimeVals)):
                    temp1.append(envTypes[e]);
                    temp2.append("_NR25_TS" + soutTimeVals[t]);
                    xAxisLabels.append("scoutT=" + soutTimeVals[t]);

                    scenarioTypes.append(temp1);
                    taskTypes.append([tasks[j]]);
                    extraScenarioParamStrings.append(temp2);
                    NRs.append(25);

                extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders);

                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
                        analysisName,outputDirectory,
                        xAxisLabels_ = xAxisLabels, scenarioExtraParamStrs_ = extraScenarioParamStrings,
                        graphLineWidth_=1, areScenarioFoldersStacked=False, areDistancesStacked=True);

    #--------------------------
    if (DO_BEE_RECRUITER_NEIGHB_SEARCH):
        wheelsNoizeVals = ["0.5","1.5"];
        searchRadVals = ["1","2","3","4"];
        searchTVals = ["60","180","300"];

        tasks = ['COLLECT_RT1-1', 'PERFORM_RT1-1'];
        envTypes = ['Heap1', 'Heap4', 'Scatter25'];
        distances = [9,13,17];

        scenarioFolders = ['0_optimBeeRecruiter'];


        constants.DO_REWARD_COLLECTED = True;


        for j in range(len(tasks)):
            for e in range(len(envTypes)):

                for n in range(len(wheelsNoizeVals)):

                    analysisName = "beeRecruiter_neighbSearch_" + envTypes[e] + "_wheelsNoize" + wheelsNoizeVals[n] + "_" + tasks[j];
                    taskTypes = [];
                    scenarioTypes = [];
                    NRs = [];

                    extraScenarioParamStrings = [];
                    xAxisLabels = [];
                    temp1 = [];
                    temp2 = [];

                    for r in range(len(searchRadVals)):
                        for t in range(len(searchTVals)):
                            temp1.append(envTypes[e]);
                            temp2.append("_NR25_wheelsNoize" + wheelsNoizeVals[n] + "_searchRad" + searchRadVals[r] + "_searchT" + searchTVals[t]);
                            xAxisLabels.append("_searchRad" + searchRadVals[r] + "\nsearchT" + searchTVals[t])

                        scenarioTypes.append(temp1);
                        taskTypes.append([tasks[j]]);
                        extraScenarioParamStrings.append(temp2);
                        NRs.append(25);

                    extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders);

                    analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
                            analysisName,outputDirectory,
                            xAxisLabels_ = xAxisLabels, scenarioExtraParamStrs_ = extraScenarioParamStrings,
                            graphLineWidth_=1, areDistancesStacked=True, xAxisGroupSize_=3);

    #--------------------------
    if (DO_BEE_RECRUITER_TEAM_UNCH_TIME):

        teamUnchTVals = ["180","300","420","540","660","780","900","1020","1140"];

        tasks = ['COLLECT_RT2-2','COLLECT_RT5-5','PERFORM_RT2-2','PERFORM_RT5-5'];
        envTypes = ['Heap4', 'Scatter25'];
        distances = [9,13,17];

        scenarioFolders = ['0_optimBeeRecruiter'];
        constants.DO_REWARD_COLLECTED = True;

        for j in range(len(tasks)):
            for e in range(len(envTypes)):
                analysisName = "beeRecruiter_teamUnchT" + envTypes[e] + "_" + tasks[j];

                taskTypes = [];
                scenarioTypes = [];
                NRs = [];

                extraScenarioParamStrings = [];
                xAxisLabels = [];
                temp1 = [];
                temp2 = [];

                for t in range(len(teamUnchTVals)):
                    temp1.append(envTypes[e]);
                    temp2.append("_NR25_TteamUnchg" + teamUnchTVals[t]);
                    xAxisLabels.append("teamUnchT=" + teamUnchTVals[t]);

                    scenarioTypes.append(temp1);
                    taskTypes.append([tasks[j]]);
                    extraScenarioParamStrings.append(temp2);
                    NRs.append(25);

                extraControllerParamStrings = helpers.getScenarioFolderExtraParameterStrings(scenarioFolders);

                analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraControllerParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
                        analysisName,outputDirectory,
                        xAxisLabels_ = xAxisLabels, scenarioExtraParamStrs_ = extraScenarioParamStrings,
                        graphLineWidth_=1, areDistancesStacked=True);

    #--------------------------
    if (DO_COMPARE_OPTIMISED):
        pass
        # envTypes = ['Heap4', 'Scatter25'];
        # tasks = ['PERFORM_RT2-2', 'PERFORM_RT5-5'];
        #
        # for e in range(len(envTypes)):
        #     for j in range(len(tasks)):
        #
        #         analysisName = "0_compareOptimised_" + envTypes[e] + "_" + tasks[j];
        #         DO_REWARD_COLLECTED = True;
        #         DO_SWARM_UNCERTAINTY_COST = True;
        #
        #         teamUnchLabels=[];
        #         scenarioFolders = ["0_optimSolitary", '0_optimLocalBroadcaster', '0_optimBeeRecruiter'];
        #         scenarioLabels = [];
        #
        #         distances = [];
        #         taskTypes = [];
        #         scenarioTypes = [];
        #         NRs = [];
        #
        #         for i in range(len(scenarioFolders)):
        #             distances.append([7,9,11]);
        #             scenarioTypes.append([envTypes[e]]);
        #             taskTypes.append([tasks[j]]);
        #             NRs.append(25);
        #
        #         extraParamStrings = getRobotParameterStrings(helpers.getScenarioFolderExtraParameterStrings(scenarioFolders, NRs), scenarioFolders);
        #         analysis.analyse(scenarioFolders,taskTypes,scenarioTypes,distances,extraParamStrings, NRs, START_TIME,MAX_TIME,TIME_BIN_LENGTH,
        #                 analysisName,outputDirectory,
        #                 xAxisLabels_=scenarioLabels, stackedParameterLabels_=teamUnchLabels, graphLineWidth_=1);














