function [] = PlotXYZ(data)

figure(3)

mintime = 10;
maxtime = 15;

xminvolt = 2.2;
xmaxvolt = 3.2;

yminvolt = 1;
ymaxvolt = 3;

zminvolt = 2.2;
zmaxvolt = 3.2;

subplot(3,1,1)
plot(data(1:35000,1),data(1:35000,2));
xlim([mintime maxtime]);
ylim([xminvolt xmaxvolt]);
xlabel('Time (s)');
ylabel('X signal (V)');

subplot(3,1,2)
plot(data(1:35000,1),data(1:35000,3));
xlim([mintime maxtime]);
ylim([yminvolt ymaxvolt]);
xlabel('Time (s)');
ylabel('Y signal (V)');

subplot(3,1,3)
plot(data(1:35000,1),data(1:35000,4));
xlim([mintime maxtime]);
ylim([zminvolt zmaxvolt]);
xlabel('Time (s)');
ylabel('Z signal (V)');

end

