Device pcap {

Electrode {
	{ Name="gate" Voltage=0.0 
		Schottky
	workfunction=4.28 }
	{ Name="substrate" Voltage=0.0 }
}

File{
	Grid = "n53_fps.tdr"
    	Parameter = "pp856_des.par"
	Plot = "n856_des.tdr"
	Current = "n856_des.plt"
}



Physics (region="Silicon_1") {
	Recombination(
    SRH( DopingDep )
  )
}

Physics (region="Oxide_1") {
    EffectiveIntrinsicDensity(NoBandGapNarrowing)
    Mobility(ConstantMobility)
    
    Traps (
    (Level Donor Conc=8.2e17 fromValBand EnergyMid=1.0 material="Oxide")  
    (Level FixedCharge Conc=6e15)   
    )
           
       Radiation (
    	DoseRate=0.0
    )	
	
}

    Physics(MaterialInterface = "Aluminum/Oxide") {Schottky}

   

Physics(MaterialInterface="Oxide/Silicon") {
		Heterointerface 
		eThermionic
		hThermionic
	 }



Plot{
  RadiationGeneration
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap EffectiveBandGap
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  eQuantumPotential
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
  InsulatorElectricField SemiconductorElectricField
   Nonlocal
}
}


Math {

  
  CNormPrint
  Extrapolate
  Derivatives
  Avalderivatives
  RelErrControl
  Digits= 5
  Notdamped= 1000
  Iterations= 2000
  DirectCurrent
  ExitOnFailure
  CheckUndefinedModels
  Number_of_Threads= 32
}


File {
	Output = "n856_des.log"
	ACExtract = "n856"
}

System {
	pcap trans (gate=g substrate=s)
        Vsource_pset vg (g 0) {dc=0}
	Vsource_pset vs (s 0) {dc=0}
}


CurrentPlot {eTrappedCharge(Integrate(Material="Oxide"))}
CurrentPlot {hTrappedCharge(Integrate(Material="Oxide"))}




CurrentPlot {eGapStatesRecombination(Integrate(Material="Oxide"))}
CurrentPlot {eAugerRecombination(Integrate(Material="Oxide"))}
CurrentPlot {eSRHRecombination(Integrate(Material="Oxide"))}
CurrentPlot {PMIeNonLocalRecombination(Integrate(Material="Oxide"))}

CurrentPlot {hGapStatesRecombination(Integrate(Material="Oxide"))}
CurrentPlot {hAugerRecombination(Integrate(Material="Oxide"))}
CurrentPlot {hSRHRecombination(Integrate(Material="Oxide"))}
CurrentPlot {PMIhNonLocalRecombination(Integrate(Material="Oxide"))}

CurrentPlot {TotalRecombination(Integrate(Material="Oxide"))}
CurrentPlot {AugerRecombination(Integrate(Material="Oxide"))}
CurrentPlot {CDL1Recombination(Integrate(Material="Oxide"))}
CurrentPlot {CDL2Recombination(Integrate(Material="Oxide"))}
CurrentPlot {CDLcRecombination(Integrate(Material="Oxide"))}
CurrentPlot {CDLRecombination(Integrate(Material="Oxide"))}
CurrentPlot {PMIRecombination(Integrate(Material="Oxide"))}
CurrentPlot {RadiativeRecombination(Integrate(Material="Oxide"))}
CurrentPlot {SurfaceRecombination(Integrate(Material="Oxide"))}
CurrentPlot {tSRHRecombination(Integrate(Material="Oxide"))}




CurrentPlot {eQuasiFermi(Average(Material="Oxide"))}
CurrentPlot {hQuasiFermi(Average(Material="Oxide"))}

CurrentPlot {hDensity(Integrate(Material="Oxide"))}
CurrentPlot {eDensity(Integrate(Material="Oxide"))}

CurrentPlot {hCurrentDensity(Integrate(Material="Oxide"))}
CurrentPlot {eCurrentDensity(Integrate(Material="Oxide"))}

CurrentPlot {hCurrentDensity(Integrate(RegionInterface="Oxide_1/Silicon_1"))}
CurrentPlot {eCurrentDensity(Integrate(RegionInterface="Oxide_1/Silicon_1"))}

CurrentPlot {hDensity(Integrate(RegionInterface="Oxide_1/Silicon_1"))}
CurrentPlot {eDensity(Integrate(RegionInterface="Oxide_1/Silicon_1"))}


CurrentPlot {eTrappedCharge(Average(Material="Oxide"))}
CurrentPlot {hTrappedCharge(Average(Material="Oxide"))}

CurrentPlot {RadiationGeneration(Average(Material="Oxide"))}

CurrentPlot {eGapStatesRecombination(Average(Material="Oxide"))}
CurrentPlot {hGapStatesRecombination(Average(Material="Oxide"))}



Solve {
  Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson } 
  Coupled { Poisson Electron Hole }

  Save ( FilePrefix= "n856_init" )
  Plot ( FilePrefix= "n856_PEH" )
  
  Transient(
	InitialTime = 0 FinalTime=310.51
	MinStep = 1e-10 MaxStep = 500
	Bias{ region = "Oxide_1"
	Model = "RadiationBeam" Parameter = "DoseRate"
	Value = (38.6 at 10)
     }
   ){
   	
   	Coupled { Poisson Electron Hole  }
	Plot ( FilePrefix="n856" Time=( 1; 5; 10; 20; 30; 40; 50; 100; 200; 300; 310; 310.51; 500; 750; 1000; 1500; 2000; 310.51 )  NoOverwrite )
	
   } 
   
   Set (Traps(Frozen))
   
 }
   
 Solve {  
 
   Quasistationary (
	-DoZero
	InitialStep = 1e-9 MinStep = 1e-60 MaxStep = 1
	Decrement = 1.4
	Goal { Model = "RadiationBeam" Parameter = "DoseRate" Value = 0 }
	)
	{ Coupled {Poisson Electron Hole } } 
 
Quasistationary (
			MaxStep=0.01 InitialStep=0.001 MinStep=0.000001
			Goal{ Parameter=vg.dc Voltage=-12.0 }
		) 
		{
			ACCoupled(
			StartFrequency=1e6 EndFrequency=1e6
			NumberOfPoints=1 Decade
			Node(g s)
			ACMethod=Blocked ACSubMethod("1d")=ParDiSo
			)
			{Poisson Electron Hole Circuit Contact}
	                 } 
	                 
Quasistationary (
			MaxStep=0.01 InitialStep=0.001 MinStep=0.000001
			Goal{ Parameter=vg.dc Voltage=4.0 }
		) 
		{
			ACCoupled(
			StartFrequency=1e6 EndFrequency=1e6
			NumberOfPoints=1 Decade
			Node(g s)
			ACMethod=Blocked ACSubMethod("1d")=ParDiSo
			)
			{Poisson Electron Hole Circuit Contact}
	                 } 
}




