Device pcap {

Electrode {
	{ Name="gate" Voltage=0.0 
		Schottky
	workfunction=4.28 }
	{ Name="substrate" Voltage=0.0 }
}

File{
	Grid = "n1315_msh.tdr"
    	Parameter = "pp2452_des.par"
	Plot = "n2452_des.tdr"
	Current = "n2452_des.plt"
}

Physics (region="Silicon_1") {
	Recombination(
    SRH( DopingDep )
  )
}

Physics (region="Oxide_1") {
    EffectiveIntrinsicDensity(NoBandGapNarrowing)
    Mobility(ConstantMobility)
    
    Traps (
    (Level Donor Conc=0 fromValBand EnergyMid=4.0 material="Oxide")  
    (Level FixedCharge Conc=4.5e15) 
    (Level FixedCharge Conc=8.33e15) 
	 )	
}


    Physics(MaterialInterface = "Aluminum/Oxide") {Schottky}

Physics {
    Radiation (
    	DoseRate=0
    )
}
   

Physics(MaterialInterface="Oxide/Silicon") {
		Heterointerface 
		eThermionic
		hThermionic

    Traps (
    	(Level Donor Conc=2e13 fromValBand EnergyMid=0.15 material="Silicon")  
        (Level Acceptor Conc=3.5e10 fromCondBand EnergyMid=0.65 material="Silicon")
	 )
	 }



Plot{
  RadiationGeneration
  eDensity hDensity
  TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
  eMobility hMobility
  eVelocity hVelocity
  eQuasiFermi hQuasiFermi
  eTemperature Temperature * hTemperature
  ElectricField/Vector Potential SpaceCharge
  Doping DonorConcentration AcceptorConcentration
  SRH Band2Band * Auger
  AvalancheGeneration eAvalancheGeneration hAvalancheGeneration
  eGradQuasiFermi/Vector hGradQuasiFermi/Vector
  eEparallel hEparallel eENormal hENormal
  BandGap EffectiveBandGap
  BandGapNarrowing
  Affinity
  ConductionBand ValenceBand
  eQuantumPotential
  eBarrierTunneling hBarrierTunneling * BarrierTunneling
  eTrappedCharge  hTrappedCharge
  eGapStatesRecombination hGapStatesRecombination
  eDirectTunnel hDirectTunnel
  InsulatorElectricField SemiconductorElectricField
   Nonlocal
}
}

Math {

  
  CNormPrint
  Extrapolate
  Derivatives
  Avalderivatives
  RelErrControl
  Digits= 5
  Notdamped= 1000
  Iterations= 2000
  DirectCurrent
  ExitOnFailure
  CheckUndefinedModels
}

File {
	Output = "n2452_des.log"
	ACExtract = "n2452"
}

System {
	pcap trans (gate=g substrate=s)
        Vsource_pset vg (g 0) {dc=-12}
	Vsource_pset vs (s 0) {dc=0}
}

CurrentPlot { RadiationGeneration(Integrate(Material="Oxide")) }
CurrentPlot { Potential(Average(Material="Oxide")) }
CurrentPlot { DopingConcentration(Average(Material="Oxide")) }
CurrentPlot {SpaceCharge(Average(Material="Oxide"))}

CurrentPlot {eTrappedCharge(Maximum(Material="Oxide"))}
CurrentPlot {hTrappedCharge(Maximum(Material="Oxide"))}
CurrentPlot {eTrappedCharge(Integrate(Material="Oxide"))}
CurrentPlot {hTrappedCharge(Integrate(Material="Oxide"))}

CurrentPlot {eGapStatesRecombination(Integrate(Material="Oxide"))}
CurrentPlot {hGapStatesRecombination(Integrate(Material="Oxide"))}
CurrentPlot {eAugerRecombination(Integrate(Material="Oxide"))}
CurrentPlot {hAugerRecombination(Integrate(Material="Oxide"))}
CurrentPlot {eSRHRecombination(Integrate(Material="Oxide"))}
CurrentPlot {hSRHRecombination(Integrate(Material="Oxide"))}

CurrentPlot {eQuasiFermi(Average(Material="Oxide"))}
CurrentPlot {hQuasiFermi(Average(Material="Oxide"))}

CurrentPlot {hDensity(Integrate(Material="Oxide"))}
CurrentPlot {eDensity(Integrate(Material="Oxide"))}

CurrentPlot {hCurrentDensity(Integrate(Material="Oxide"))}
CurrentPlot {eCurrentDensity(Integrate(Material="Oxide"))}

CurrentPlot {hTrappedCharge(Average(RegionInterface="Oxide_1/Silicon_1"))}
CurrentPlot {eTrappedCharge(Average(RegionInterface="Oxide_1/Silicon_1"))}
CurrentPlot {hAmorphousRecombination(Average(RegionInterface="Oxide_1/Silicon_1"))}
CurrentPlot {eAmorphousRecombination(Average(RegionInterface="Oxide_1/Silicon_1"))}

Solve {

  Coupled ( Iterations= 100 LineSearchDamping= 1e-8 ){ Poisson } 

  Coupled { Poisson Electron Hole }

Plot ( FilePrefix= "n2452_PEH" )

Quasistationary (
			MaxStep=0.01 InitialStep=0.001 MinStep=0.000001
			Goal{ Parameter=vg.dc Voltage= -4.5}
		) 
		{
			ACCoupled(
			StartFrequency=1e6 EndFrequency=1e6
			NumberOfPoints=1 Decade
			Node(g s)
			ACMethod=Blocked ACSubMethod("1d")=ParDiSo
			)
			{Poisson Electron Hole Circuit Contact}
	}

Plot ( FilePrefix= "n2452_-45V" )

Quasistationary (
			MaxStep=0.01 InitialStep=0.001 MinStep=0.000001
			Goal{ Parameter=vg.dc Voltage= 4.0}
		) 
		{
			ACCoupled(
			StartFrequency=1e6 EndFrequency=1e6
			NumberOfPoints=1 Decade
			Node(g s)
			ACMethod=Blocked ACSubMethod("1d")=ParDiSo
			)
			{Poisson Electron Hole Circuit Contact}
	}

Plot ( FilePrefix= "n2452_4V" )

}


