Figure1=figure(1);
clf;
F_in=0.98:0.001:1;
F = F_in;
%%%%%%%%%%%%%%% 
N =4;% Number of hops
M =2; % Number of pairs
%QNC still calculate for M=2
number_of_pairs_QNC =3*2 + (2*N)/2;
% AB 1
% CD 2
% EF 3 
% GH 4
% KL 5
% MN 6
% I1J1 7
% I2J2 8
% I3J3 9
% I4J4 10
% value(i)=0 means no-error
order_QNC=zeros(1,number_of_pairs_QNC+1);% the order of fidelity, says order(4)=2, meaning 2*F^3, order ranging from 0-->7
for i =1:pow2(number_of_pairs_QNC);
    value = de2bi(i-1,number_of_pairs_QNC,'left-msb');
    termAF=power(-1,value(1))*power(-1,value(2));
    termBE=power(-1,value(3))*power(-1,value(4));
    for j=5:number_of_pairs_QNC
        termAF=termAF*power(-1,value(j));
        termBE=termBE*power(-1,value(j));
    end
    termcommon= power(-1,value(1))*power(-1,value(2))*power(-1,value(3))*power(-1,value(4));
    if ((termAF+termBE+termcommon)==3)
        temp=number_of_pairs_QNC;% for calculating the order of particular NO error pattern
        for j=1:number_of_pairs_QNC
             temp = temp - value(j);
        end
        order_QNC(temp+1)=order_QNC(temp+1)+1; % add up
    end
end
% Calculate F_QNC for N hops 2 pairs
F_QNC =0;
for i =1:length(order_QNC)
    F_QNC= F_QNC + order_QNC(i)*F_in.^(i-1).*(1-F_in).^(number_of_pairs_QNC+1-i);
end
% Calculate F_QNC for M pairs
F_QNC_in=F_QNC;
F_QNC_out=F_QNC;% in case M=2
index = log2(M);
while index > 1 % > 0 for QNC
    F_QNC_out = F_QNC_in.*F_QNC_in;
    F_QNC_in = F_QNC_out;
    index=index - 1;
end
F_QNC=F_QNC_out;
plot(F_in,F_QNC,'b-o','LineWidth',1,'MarkerSize', 22);
set(gca,'FontSize',22);
hold on;
%%%%%%%%%%%%%%% ES N=4 hops 6 pairs involved
number_of_pairs_ES =N+2;
number_of_states_ES = pow2(number_of_pairs_ES);
order_ES=zeros(1,number_of_pairs_ES+1);% the order of fidelity, says order(4)=2, meaning 2*F^3, order ranging from 0-->7
for i =1:number_of_states_ES
    value = de2bi(i-1,number_of_pairs_ES,'left-msb');
    single_term = power(-1,value(1));
    for j=2:number_of_pairs_ES
        single_term=single_term*power(-1,value(j));
    end
    if (single_term==1)
        temp=number_of_pairs_ES;% for calculating the order of particular NO error pattern
        for j=1:number_of_pairs_ES
             temp = temp - value(j);
        end
        order_ES(temp+1)=1 + order_ES(temp+1); % add up
    end
end
F_ES=0;
for i =1:length(order_ES)
    F_ES = F_ES + order_ES(i)*F_in.^(i-1).*(1-F_in).^(number_of_pairs_ES+1-i);
end
%Calculate for different M
F_ES_in=F_ES;
index = log2(M);
while index > 0 % > 0 for ES
    F_ES_out = F_ES_in.*F_ES_in;
    F_ES_in = F_ES_out;
    index=index - 1;
end
F_ES=F_ES_out;
plot(F_in,F_ES,'b-+','LineWidth',1,'MarkerSize', 22);
hold on;
%grid on
set(Figure1,'defaulttextinterpreter','latex');
title(['Fidelity Performance: $N$=' num2str(N) ' hops and $M$=' num2str(M) ' pairs'],'fontsize',22)
xlabel('Input Fidelity ($F_{in}$)','fontsize',22) % x-axis label
ylabel('Ouput Fidelity ($F_{out}$)','fontsize',22) % y-axis label
% set(Figure1,'defaulttextinterpreter','latex');
h_legend=legend('LQNC','ES'); 
set(h_legend,'FontSize',22);
ylim ([0.9 1]);
xlim ([0.986 1]);