close all
clear all
clc
d = 10:1:1000;
d_lognormal = logspace( 1,3, 150 );
f_c = 2.5;
sigma = 9.6;

lambda = 3e8/28e9;

%% PL reference model 2.5GHz and 28 GHz
PL_3GPP = 22.7 + 36.7*log10(d) + 26*log10(f_c);
PL_mmWaves_UWB_28 = 61.4+34*log10(d);%*4*pi/lambda); % No shadowing
PL_mmWaves_UWB_28_s = 61.4+34*log10(d_lognormal)+ sqrt(sigma)*randn(size (d_lognormal));

%% intercept
alpha = 72;
beta = 2.92;
sigma = 8.7;
PL_mmWaves_UWB_intercept = alpha + 10*beta*log10(d_lognormal);


%% 38 GHz
sigma = 14.6;
PL_mmWaves_UWB_38 = 61.4+38.8*log10(d);%*4*pi/lambda); % No shadowing
PL_mmWaves_UWB_38_s = 61.4+38.8*log10(d_lognormal)+ sqrt(sigma)*randn(size (d_lognormal));

%%
% close all
set(gca,'FontSize',12)
semilogx(d, PL_3GPP,'--k')
hold on
semilogx(d, PL_mmWaves_UWB_28,'k')

semilogx(d_lognormal, PL_mmWaves_UWB_intercept,'b')
semilogx(d_lognormal, PL_mmWaves_UWB_28_s,'ok')
% semilogx(d, PL_mmWaves_UWB_38,'r-')
% semilogx(d_lognormal, PL_mmWaves_UWB_38_s,'ok')
xlabel('Separation Distance (m)')
ylabel('Path loss [dB]')
legend('3GPP, Fc = 2.5GHz','mmWave, Fc = 28GHz*','mmWave, Fc = 28GHz**','Shadowing Effect')
% legend('boxoff')
% grid on